/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.css.HTML;
import com.inet.html.utils.Logger;
import com.inet.html.views.ControlView;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectView
extends ControlView
implements ContainerListener {
    private HashMap<String, String> cacheParams;
    private JComponent control = null;
    private boolean initialized = false;

    public ObjectView(Element element) {
        super(element);
    }

    public boolean canLoad() {
        return this.getComponentClass() != null;
    }

    private Class<?> getComponentClass() {
        block6: {
            AttributeSet attributeSet = this.getElement().getAttributes();
            if (attributeSet.isDefined((Object)HTML.Attribute.CLASSID)) {
                try {
                    Class<?> clazz;
                    URI uRI = new URI(attributeSet.getAttribute((Object)HTML.Attribute.CLASSID).toString());
                    if ("java".equalsIgnoreCase(uRI.getScheme()) && JComponent.class.isAssignableFrom(clazz = this.loadClass(uRI.getSchemeSpecificPart()))) {
                        return clazz;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (Logger.doesLog(1)) {
                        Logger.error(uRISyntaxException);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!Logger.doesLog(1)) break block6;
                    Logger.error(classNotFoundException);
                }
            }
        }
        return null;
    }

    @Override
    protected JComponent createControl() {
        if (this.control == null && !this.initialized) {
            Class<?> clazz = this.getComponentClass();
            if (clazz != null) {
                this.control = this.createControlFromClass(clazz);
                if (this.control != null) {
                    this.setParametersToComponent(this.control);
                    this.persistSize(this.control);
                    this.control.addContainerListener(this);
                }
            }
            this.initialized = true;
        }
        return this.control;
    }

    private HashMap<String, String> getParameters() {
        if (this.cacheParams != null) {
            return this.cacheParams;
        }
        this.cacheParams = new HashMap();
        Element element = this.getElement();
        for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
            Element element2 = element.getElement(i2);
            if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.PARAM) continue;
            Object object = element2.getAttributes().getAttribute((Object)HTML.Attribute.NAME);
            Object object2 = element2.getAttributes().getAttribute((Object)HTML.Attribute.VALUE);
            Object object3 = element2.getAttributes().getAttribute((Object)HTML.Attribute.VALUETYPE);
            if (object == null || object2 == null || object3 != null && !"data".equalsIgnoreCase(object3.toString())) continue;
            this.cacheParams.put(object.toString().toLowerCase(), object2.toString());
        }
        return this.cacheParams;
    }

    private void setParametersToComponent(JComponent jComponent) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(jComponent.getClass());
        }
        catch (IntrospectionException introspectionException) {
            if (Logger.doesLog(1)) {
                Logger.error(introspectionException);
            }
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        HashMap<String, String> hashMap = this.getParameters();
        for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
            String string = propertyDescriptorArray[i2].getName().toLowerCase();
            String string2 = hashMap.get(string);
            if (string2 == null || !(string2 instanceof String)) continue;
            String string3 = string2;
            Method method = propertyDescriptorArray[i2].getWriteMethod();
            if (method == null) {
                return;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return;
            }
            Object[] objectArray = new Object[]{string3};
            try {
                method.invoke((Object)jComponent, objectArray);
                continue;
            }
            catch (Exception exception) {
                if (!Logger.doesLog(1)) continue;
                Logger.error(exception);
            }
        }
    }

    private JComponent createControlFromClass(Class<?> clazz) {
        block5: {
            if (clazz != null && JComponent.class.isAssignableFrom(clazz)) {
                try {
                    return (JComponent)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    if (Logger.doesLog(1)) {
                        Logger.error(instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!Logger.doesLog(1)) break block5;
                    Logger.error(illegalAccessException);
                }
            }
        }
        return null;
    }

    private Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.getDocument().getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?> clazz2 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        return clazz2;
    }

    @Override
    public boolean isSubmit() {
        return false;
    }

    @Override
    public boolean isSuccessful(ControlView controlView) {
        return false;
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.setStatus(2);
        this.forceLayout(300L);
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.setStatus(2);
        this.forceLayout(300L);
    }
}

