/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlFontFactory;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.utils.Logger;
import com.inet.html.views.BlankBoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import com.inet.html.views.ControlView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.form.FormRegistry;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;

public class RenderContext {
    public static final int DEVICE_TYPE_UNDEFINED = -1;
    public static final int BIDI_LTR = 0;
    public static final int BIDI_RTL = 1;
    public static final int BIDI_MIXED = 2;
    public static final int BREAK_MODE_OVERFLOW = 0;
    public static final int BREAK_MODE_WORDBREAK = 1;
    public static final int BREAK_MODE_WORDBREAKINLINE = 2;
    private final Document document;
    private boolean blockOnImageLoad = false;
    private FormRegistry formReg;
    private int selectionStart;
    private int selectionEnd;
    private JEditorPane textContainer;
    private Object renderHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    private FontRenderContext frc = new FontRenderContext(null, false, false);
    private final InetHtmlFontFactory fontFactory;
    private boolean requiresFontRefreshOnSplit = false;
    private InetHtmlConfiguration config = InetHtmlConfiguration.getMailEditorConfig();
    private int bidiMode = 0;
    private Set<Object> pendingImages = Collections.synchronizedSet(new HashSet());
    private int imageLoadTimeout = 30000;
    private Thread imageLoadTimeoutThread;
    private Timeout imageLoadTimeoutRunnable;
    private Object media;
    private static final IBoxPainter EMPTY_PAINTER = new BlankBoxPainter();
    private int tabSize = -1;
    private int breakMode = 0;
    private boolean allowesFontFallback = true;
    private AtomicInteger heightAutoCounter = new AtomicInteger();
    private boolean isBodyHeightFixed = false;
    private int deviceType = -1;
    private static final SSLSocketFactory JWEBENGINE_SSL_FACTORY;

    public RenderContext(Document document, FormRegistry formRegistry, InetHtmlFontFactory inetHtmlFontFactory) {
        this.document = document;
        this.fontFactory = inetHtmlFontFactory;
        if (inetHtmlFontFactory != null && inetHtmlFontFactory.requiresText()) {
            this.requiresFontRefreshOnSplit = true;
        }
        if (formRegistry == null) {
            formRegistry = new FormRegistry();
        }
        this.formReg = formRegistry;
        this.getPropertiesFromDocument();
    }

    private void getPropertiesFromDocument() {
        Object object;
        Object object2;
        if (this.document == null) {
            return;
        }
        Object object3 = this.document.getProperty(InetHtmlDocument.PROPERTY_CONFIGURATION);
        if (object3 instanceof InetHtmlConfiguration) {
            this.config = (InetHtmlConfiguration)object3;
        }
        this.media = this.document.getProperty(InetHtmlDocument.PROPERTY_MEDIA);
        if (this.media != null && this.media == "print") {
            this.blockOnImageLoad = true;
        }
        if ((object2 = this.document.getProperty(InetHtmlDocument.PROPERTY_BREAK_MODE)) != null) {
            if (object2 == InetHtmlDocument.BREAK_MODE_WORDBREAK) {
                this.breakMode = 1;
            }
            if (object2 == InetHtmlDocument.BREAK_MODE_WORDBREAKINLINE) {
                this.breakMode = 2;
            }
        }
        if ((object = this.document.getProperty(InetHtmlDocument.PROPERTY_TAB_WIDTH)) instanceof Number) {
            this.tabSize = ((Number)object).intValue();
        }
        this.allowesFontFallback = !Boolean.FALSE.equals(this.document.getProperty(InetHtmlDocument.PROPERTY_USE_FONT_FALLBACK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkImageLoading() {
        this.media = this.deviceType != -1 ? (this.deviceType == 0 ? "screen" : (this.deviceType == 1 ? "print" : this.document.getProperty(InetHtmlDocument.PROPERTY_MEDIA))) : this.document.getProperty(InetHtmlDocument.PROPERTY_MEDIA);
        if (this.media == "print") {
            this.blockOnImageLoad = true;
            try {
                RenderContext renderContext = this;
                synchronized (renderContext) {
                    if (this.pendingImages.size() > 0 && (this.imageLoadTimeoutThread == null || this.imageLoadTimeoutThread.isAlive())) {
                        this.startTimeout();
                        this.wait(this.imageLoadTimeout * 2);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public boolean isBlockOnImageLoad() {
        return this.blockOnImageLoad;
    }

    public void setFraction(boolean bl2) {
        this.frc = new FontRenderContext(this.frc.getTransform(), this.frc.isAntiAliased(), bl2);
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void setAntiAlias(boolean bl2) {
        this.frc = new FontRenderContext(this.frc.getTransform(), bl2, this.frc.usesFractionalMetrics());
    }

    public void setFontRenderContext(FontRenderContext fontRenderContext) {
        this.frc = fontRenderContext;
    }

    public void registerControl(ControlView controlView) {
        this.formReg.addControl(controlView);
    }

    public void deregisterControl(ControlView controlView) {
        this.formReg.removeControl(controlView);
    }

    public void clearForms() {
        this.formReg.clear();
    }

    public void setTextContainer(JEditorPane jEditorPane) {
        this.textContainer = jEditorPane;
        if (jEditorPane == null) {
            this.selectionStart = 0;
            this.selectionEnd = 0;
            return;
        }
        this.selectionStart = this.textContainer.getSelectionStart();
        this.selectionEnd = this.textContainer.getSelectionEnd();
    }

    public Document getTextContainerDocument() {
        return this.textContainer != null ? this.textContainer.getDocument() : null;
    }

    public EditorKit getTextContainerKit() {
        return this.textContainer != null ? this.textContainer.getEditorKit() : null;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public JEditorPane getTextContainer() {
        return this.textContainer;
    }

    public int getViewportHeight() {
        if (this.textContainer != null) {
            Insets insets = this.textContainer.getInsets();
            Container container = this.textContainer.getParent();
            if (container instanceof JViewport) {
                Border border;
                int n2 = 0;
                if (container.getParent() instanceof JScrollPane && (border = ((JComponent)(container = container.getParent())).getBorder()) != null) {
                    Insets insets2 = border.getBorderInsets(container);
                    n2 += insets2.top + insets2.bottom;
                }
                return container.getHeight() - insets.top - insets.bottom - n2;
            }
            return this.textContainer.getHeight() - insets.top - insets.bottom;
        }
        return 1;
    }

    public void registerRelativeHeight(boolean bl2) {
        if (bl2) {
            this.heightAutoCounter.incrementAndGet();
        } else {
            this.heightAutoCounter.decrementAndGet();
        }
    }

    public void setBodyHeightFixed(boolean bl2) {
        this.isBodyHeightFixed = bl2;
    }

    public boolean isLayoutOnHeightChange() {
        return !this.isBodyHeightFixed && this.heightAutoCounter.get() > 0;
    }

    public boolean paintSelection() {
        Caret caret;
        if (this.textContainer != null && (caret = this.textContainer.getCaret()) != null) {
            return caret.isSelectionVisible();
        }
        return false;
    }

    public void setTextAntiAlias(boolean bl2) {
        this.renderHint = bl2 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
    }

    public Object getTextAntiAliasHint() {
        return this.renderHint;
    }

    public Font getFont(BoxView boxView) {
        float f2 = boxView.getFontSize();
        SingleAttributeValue singleAttributeValue = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.FONT_FAMILY);
        String string = singleAttributeValue.getFamily();
        int n2 = 0;
        singleAttributeValue = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.FONT_STYLE);
        if (singleAttributeValue instanceof FontStyle && ((FontStyle)singleAttributeValue).isItalic()) {
            n2 |= 2;
        }
        if ((singleAttributeValue = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.FONT_WEIGHT)) instanceof FontWeight && ((FontWeight)singleAttributeValue).isBold()) {
            n2 |= 1;
        }
        if (this.fontFactory != null) {
            if (this.fontFactory.requiresText()) {
                String string2 = " ";
                if (boxView instanceof ContentView) {
                    try {
                        string2 = ((ContentView)boxView).getText();
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.error(badLocationException);
                    }
                }
                return this.fontFactory.getFont(string, n2, f2, string2);
            }
            return this.fontFactory.getFont(string, n2, f2, null);
        }
        Font font = new Font(string, n2, (int)f2);
        if (f2 != (float)((int)f2)) {
            font = font.deriveFont(f2);
        }
        return font;
    }

    public boolean isRefreshFontRequiredOnSplit() {
        return this.requiresFontRefreshOnSplit;
    }

    public static float getFontSize(Element element) {
        return ((Float)element.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)).floatValue();
    }

    public boolean collapseEmptyBlocks() {
        return !this.config.isTransformEmptyBlocks();
    }

    public boolean collapseTailingBreak() {
        return !this.config.isDoAlwaysBreak();
    }

    public void notifiyBidi(int n2, boolean bl2) {
        if (bl2) {
            this.bidiMode = n2;
        } else if (n2 != this.bidiMode) {
            this.bidiMode = 2;
        }
    }

    public boolean requiresBidiCheck() {
        return this.bidiMode == 2;
    }

    public synchronized void notifyImageLoad(RemoteImage remoteImage) {
        if (remoteImage != null && (remoteImage.getStatus() == 0 || remoteImage.getStatus() == 1)) {
            this.pendingImages.add(remoteImage);
        }
        this.updateTimeout();
    }

    public synchronized void notifyImageLoadDone(RemoteImage remoteImage) {
        this.pendingImages.remove(remoteImage);
        if (this.pendingImages.size() == 0) {
            this.resetImageTimeout();
            this.notifyAll();
        }
    }

    @Deprecated
    public int countBlockingImages() {
        return this.blockOnImageLoad ? this.pendingImages.size() : 0;
    }

    @Deprecated
    public Object getMedia() {
        return this.media;
    }

    public IBoxPainter getEmptyBoxPainter() {
        return EMPTY_PAINTER;
    }

    public int getTabSize(int n2, int n3) {
        if (this.tabSize > 0) {
            return this.tabSize - n2 % this.tabSize;
        }
        return n3;
    }

    public boolean allowTabs() {
        return this.tabSize > 0;
    }

    public int getBreakMode() {
        return this.breakMode;
    }

    public boolean isFontFallbackAllowed() {
        return this.allowesFontFallback;
    }

    public void updateTargetDevice(GraphicsDevice graphicsDevice) {
        this.deviceType = graphicsDevice != null ? graphicsDevice.getType() : 0;
    }

    public static void setSSLSocketFactory(final URLConnection uRLConnection) {
        if (JWEBENGINE_SSL_FACTORY != null && uRLConnection instanceof HttpsURLConnection) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(JWEBENGINE_SSL_FACTORY);
                    ((HttpsURLConnection)uRLConnection).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String string, SSLSession sSLSession) {
                            return true;
                        }
                    });
                    ((HttpsURLConnection)uRLConnection).setInstanceFollowRedirects(true);
                    return null;
                }
            });
        }
    }

    public synchronized void resetImageTimeout() {
        if (this.imageLoadTimeoutThread != null) {
            this.imageLoadTimeoutThread.interrupt();
            try {
                this.imageLoadTimeoutThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.imageLoadTimeoutThread = null;
            this.imageLoadTimeoutRunnable = null;
        }
    }

    private synchronized void startTimeout() {
        if (this.imageLoadTimeoutThread == null) {
            this.imageLoadTimeoutRunnable = new Timeout();
            this.imageLoadTimeoutThread = new Thread((Runnable)this.imageLoadTimeoutRunnable, "Image Load Timeout");
            this.imageLoadTimeoutThread.start();
        }
    }

    private synchronized void updateTimeout() {
        if (this.imageLoadTimeoutThread != null && this.imageLoadTimeoutThread.isAlive()) {
            this.imageLoadTimeoutRunnable.updateTimeout();
        }
    }

    public void setImageLoadTimeout(int n2) {
        this.imageLoadTimeout = Math.max(0, n2);
    }

    static {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            sSLSocketFactory = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
        JWEBENGINE_SSL_FACTORY = sSLSocketFactory;
    }

    private class Timeout
    implements Runnable {
        private long endTime;

        public Timeout() {
            this.updateTimeout();
        }

        public void updateTimeout() {
            this.endTime = System.currentTimeMillis() + (long)RenderContext.this.imageLoadTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (System.currentTimeMillis() < this.endTime) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            RenderContext renderContext = RenderContext.this;
            synchronized (renderContext) {
                RenderContext.this.notifyAll();
            }
        }
    }
}

