/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.views.ContentPainter;
import com.inet.html.views.ContentView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;

public class RotationPainter
extends ContentPainter {
    private static final double NINETY_DEGREES = Math.toRadians(90.0);
    private static final double ONE_EIGHTY_DEGREES = Math.toRadians(180.0);
    public static final int GLYPH_RIGHT = 1;
    public static final int GLYPH_LEFT = 2;
    public static final int GLYPH_DOWN = 3;
    public static final int GLYPH_UP = 4;
    private final int glyphOrientation;
    private ContentView view;
    private float[] charWidth;

    public RotationPainter(int n2, ContentView contentView) {
        super(contentView);
        this.glyphOrientation = n2;
        this.view = contentView;
    }

    public void setView(ContentView contentView) {
        super.setView(contentView);
        this.view = contentView;
    }

    private int getRotationCharWidth(char c2) {
        return this.getAscent() + this.getDescent();
    }

    protected float calculateWidth() {
        try {
            switch (this.glyphOrientation) {
                case 1: 
                case 2: {
                    return this.getRotationCharWidth(' ') * this.view.getSegment().count;
                }
            }
            return super.calculateWidth();
        }
        catch (BadLocationException badLocationException) {
            return 1.0f;
        }
    }

    public void paint(Graphics graphics, Shape shape, int n2, int n3, int n4) {
        try {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            int n5 = rectangle.x;
            int n6 = rectangle.y + n4;
            Segment segment = this.view.getSegment();
            if (this.glyphOrientation != 4) {
                this.drawTabbedText(segment, n5, n6, graphics, n2, n3);
            } else {
                graphics.drawString(segment.toString().substring(n2, n2 + n3), n5, n6);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private final int drawTabbedText(Segment segment, int n2, int n3, Graphics graphics, int n4, int n5) {
        int n6 = n2;
        char[] cArray = segment.array;
        int n7 = segment.offset + n4;
        int n8 = segment.offset + Math.max(n4 + n5, segment.count);
        for (int i2 = n7; i2 < n8; ++i2) {
            int n9 = 0;
            if (this.charWidth != null) {
                int n10 = i2 - n7 + n4;
                n9 = Math.round(this.charWidth[n10 + 1] - this.charWidth[n10]);
            } else {
                n9 = this.getFontMetrics().charWidth(cArray[i2]);
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            switch (this.glyphOrientation) {
                case 1: {
                    graphics2D.rotate(NINETY_DEGREES, n2, n3);
                    graphics2D.translate(-(n9 + this.getAscent() - this.getDescent()) / 2, -this.getDescent());
                    n6 += this.getRotationCharWidth(cArray[i2]);
                    break;
                }
                case 2: {
                    graphics2D.rotate(-NINETY_DEGREES, n2, n3);
                    graphics2D.translate((this.getAscent() - this.getDescent() - n9) / 2, this.getAscent());
                    n6 += this.getRotationCharWidth(cArray[i2]);
                    break;
                }
                case 3: {
                    graphics2D.rotate(ONE_EIGHTY_DEGREES, n2, n3);
                    graphics2D.translate(-n9, this.getAscent() - this.getDescent());
                    n6 += n9;
                    break;
                }
                default: {
                    n6 += n9;
                }
            }
            graphics2D.drawChars(cArray, i2, 1, n2, n3);
            graphics2D.dispose();
            n2 = n6;
        }
        return n6;
    }

    protected void calculateCharOffsets(Segment segment) {
        super.calculateCharOffsets(segment);
        if (this.glyphOrientation <= 2) {
            this.charWidth = this.getCharOffsets();
            float[] fArray = new float[segment.count + 1];
            fArray[0] = 0.0f;
            for (int i2 = 1; i2 <= segment.count; ++i2) {
                fArray[i2] = fArray[i2 - 1] + (float)this.getRotationCharWidth(segment.array[segment.offset + i2 - 1]);
            }
            this.setCharOffsets(fArray);
        }
    }

    public int getGlyphOrientation() {
        return this.glyphOrientation;
    }

    public ContentPainter copy(ContentView contentView) {
        return new RotationPainter(this.glyphOrientation, contentView);
    }
}

