/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.MultiIntegerValue;
import com.inet.html.utils.ColorUtils;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.TableView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.List;
import javax.swing.text.Element;

public class TableBoxPainter
extends BoxPainter {
    private boolean isCollapseMode = false;
    private boolean leftIsTableBorder = false;
    private boolean rightIsTableBorder = false;
    private boolean topIsTableBorder = false;
    private boolean bottomIsTableBorder = false;
    private Insets paddingDefined = new Insets(StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_TOP) != null ? 1 : 0, StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_LEFT) != null ? 1 : 0, StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_BOTTOM) != null ? 1 : 0, StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_RIGHT) != null ? 1 : 0);
    private Insets paintInsets = (Insets)this.getBorderInsets().clone();

    public TableBoxPainter(BoxView boxView) {
        super(boxView);
        if (boxView.getParent() instanceof TableView) {
            TableView tableView = (TableView)boxView.getParent();
            Element element = boxView.getParent().getElement();
            MultiIntegerValue multiIntegerValue = StyleResolver.getAttributeValue(element, AttributeFinder.CELL_PADDING);
            if (multiIntegerValue != null) {
                List<IntegerValue> list = multiIntegerValue.getValues();
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                switch (list.size()) {
                    case 1: {
                        n4 = n5 = list.get(0).getInt();
                        n3 = n5;
                        n2 = n5;
                        break;
                    }
                    case 2: {
                        n2 = n3 = list.get(0).getInt();
                        n4 = n5 = list.get(1).getInt();
                        break;
                    }
                    case 4: {
                        n2 = list.get(0).getInt();
                        n3 = list.get(1).getInt();
                        n4 = list.get(2).getInt();
                        n5 = list.get(3).getInt();
                    }
                }
                if (this.paddingDefined.left != 0) {
                    this.setPadding().left = n2;
                }
                if (this.paddingDefined.right != 0) {
                    this.setPadding().right = n3;
                }
                if (this.paddingDefined.top != 0) {
                    this.setPadding().top = n4;
                }
                if (this.paddingDefined.bottom != 0) {
                    this.setPadding().bottom = n5;
                }
            }
            if (tableView.getHTMLBorderValue() > 0 && this.paintInsets.left == 0 && this.paintInsets.right == 0 && this.paintInsets.top == 0 && this.paintInsets.bottom == 0) {
                this.paintInsets.set(1, 1, 1, 1);
                this.setBorderInsets(new Insets(1, 1, 1, 1));
                this.setBorderStyles(new Insets(7, 7, 7, 7));
                if (this.getBorderTopColor() == null) {
                    this.setBorderTopColor(new ColorValue(ColorUtils.get3DDark()));
                }
                if (this.getBorderLeftColor() == null) {
                    this.setBorderLeftColor(new ColorValue(ColorUtils.get3DDark()));
                }
                if (this.getBorderBottomColor() == null) {
                    this.setBorderBottomColor(new ColorValue(ColorUtils.get3DLight()));
                }
                if (this.getBorderRightColor() == null) {
                    this.setBorderRightColor(new ColorValue(ColorUtils.get3DLight()));
                }
            }
        }
    }

    public Insets getPaintInsets() {
        return this.paintInsets;
    }

    public void paintBorders(Graphics graphics, int n2, int n3, int n4, int n5) {
        Area area;
        Shape shape;
        int n6;
        int n7;
        Element element = this.getView().getElement();
        Shape shape2 = graphics.getClip();
        Area area2 = null;
        boolean bl2 = false;
        if (this.isCollapseMode) {
            int n8 = this.topIsTableBorder ? 0 : (int)Math.ceil((float)this.paintInsets.top / 2.0f);
            n7 = this.bottomIsTableBorder ? 0 : this.paintInsets.bottom / 2;
            n6 = this.leftIsTableBorder ? 0 : (int)Math.ceil((float)this.paintInsets.left / 2.0f);
            int n9 = this.rightIsTableBorder ? 0 : this.paintInsets.right / 2;
            n2 -= n6;
            n3 -= n8;
            n4 += n6 + n9;
            n5 += n8 + n7;
            if (shape2 != null) {
                shape = new Rectangle(n2, n3, n4, n5).intersection(shape2.getBounds());
                area2 = new Area(shape);
            }
        } else if (shape2 != null) {
            area2 = new Area(shape2);
        }
        if (this.paintInsets.top > 0 && !this.isInVisibleStyle(this.getBorderStyles().top)) {
            ColorValue colorValue = this.getBorderTopColor();
            if (colorValue == null) {
                colorValue = AttributeFinder.COLOR.getAttributeValue(this.getView());
            }
            graphics.setColor(colorValue.getValue());
            n7 = this.getBorderStyles().top;
            n6 = this.paintInsets.top;
            float f2 = n6;
            shape = new Polygon();
            ((Polygon)shape).addPoint(n2, n3);
            ((Polygon)shape).addPoint(n2 + n4, n3);
            ((Polygon)shape).addPoint(n2 + n4 - this.paintInsets.right, n3 + n6);
            ((Polygon)shape).addPoint(n2 + this.paintInsets.left, n3 + n6);
            area = new Area(shape);
            if (area2 != null) {
                area.intersect(area2);
            }
            graphics.setClip(area);
            bl2 = true;
            if (n7 == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)n3 + (f2 /= 3.0f) * 2.5f, n4, 0.0f, n7, f2 * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)n3 + f2 * 0.5f, n4, 0.0f, n7, f2 * 1.01f);
        }
        if (this.paintInsets.left > 0 && !this.isInVisibleStyle(this.getBorderStyles().left)) {
            ColorValue colorValue = this.getBorderLeftColor();
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(element, AttributeFinder.COLOR);
            }
            graphics.setColor(colorValue.getValue());
            n7 = this.getBorderStyles().left;
            n6 = this.paintInsets.left;
            float f3 = n6;
            shape = new Polygon();
            ((Polygon)shape).addPoint(n2, n3);
            ((Polygon)shape).addPoint(n2, n3 + n5);
            ((Polygon)shape).addPoint(n2 + n6, n3 + n5 - this.paintInsets.bottom);
            ((Polygon)shape).addPoint(n2 + n6, n3 + this.paintInsets.top);
            area = new Area(shape);
            if (area2 != null) {
                area.intersect(area2);
            }
            graphics.setClip(area);
            bl2 = true;
            if (n7 == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)graphics, (float)n2 + (f3 /= 3.0f) * 2.5f, n3, 0.0f, n5, n7, f3 * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)graphics, (float)n2 + f3 * 0.5f, n3, 0.0f, n5, n7, f3 * 1.01f);
        }
        if (this.paintInsets.bottom > 0 && !this.isInVisibleStyle(this.getBorderStyles().bottom)) {
            ColorValue colorValue = this.getBorderBottomColor();
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(element, AttributeFinder.COLOR);
            }
            graphics.setColor(colorValue.getValue());
            n7 = this.getBorderStyles().bottom;
            n6 = this.paintInsets.bottom;
            float f4 = n6;
            shape = new Polygon();
            ((Polygon)shape).addPoint(n2, n3 + n5);
            ((Polygon)shape).addPoint(n2 + n4, n3 + n5);
            ((Polygon)shape).addPoint(n2 + n4 - this.paintInsets.right, n3 + n5 - n6);
            ((Polygon)shape).addPoint(n2 + this.paintInsets.left, n3 + n5 - n6);
            area = new Area(shape);
            if (area2 != null) {
                area.intersect(area2);
            }
            graphics.setClip(area);
            bl2 = true;
            if (n7 == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)(n3 + n5) - (f4 /= 3.0f) * 2.5f, n4, 0.0f, n7, f4 * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)(n3 + n5) - f4 * 0.5f, n4, 0.0f, n7, f4 * 1.01f);
        }
        if (this.paintInsets.right > 0 && !this.isInVisibleStyle(this.getBorderStyles().right)) {
            ColorValue colorValue = this.getView().getBorderRightColor();
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(element, AttributeFinder.COLOR);
            }
            graphics.setColor(colorValue.getValue());
            n7 = this.getBorderStyles().right;
            n6 = this.paintInsets.right;
            float f5 = n6;
            shape = new Polygon();
            ((Polygon)shape).addPoint(n2 + n4, n3);
            ((Polygon)shape).addPoint(n2 + n4, n3 + n5);
            ((Polygon)shape).addPoint(n2 + n4 - n6, n3 + n5 - this.paintInsets.bottom);
            ((Polygon)shape).addPoint(n2 + n4 - n6, n3 + this.paintInsets.top);
            area = new Area(shape);
            if (area2 != null) {
                area.intersect(area2);
            }
            graphics.setClip(area);
            bl2 = true;
            if (n7 == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)graphics, (float)(n2 + n4) - (f5 /= 3.0f) * 2.5f, n3, 0.0f, n5, n7, f5 * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)graphics, (float)(n2 + n4) - f5 * 0.5f, n3, 0.0f, n5, n7, f5 * 1.01f);
        }
        if (bl2) {
            graphics.setClip(shape2);
        }
    }

    public void paint(Graphics graphics, int n2, int n3, int n4, int n5, int n6, BoxView boxView) {
    }

    public void setCollapseMode(boolean bl2) {
        this.isCollapseMode = bl2;
    }

    public Insets getPaddingDefined() {
        return this.paddingDefined;
    }

    public void setLeftIsTableBorder(boolean bl2) {
        this.leftIsTableBorder = bl2;
    }

    public void setRightIsTableBorder(boolean bl2) {
        this.rightIsTableBorder = bl2;
    }

    public void setTopIsTableBorder(boolean bl2) {
        this.topIsTableBorder = bl2;
    }

    public void setBottomIsTableBorder(boolean bl2) {
        this.bottomIsTableBorder = bl2;
    }
}

