/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.utils.ColorUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.InlineView;
import com.inet.html.views.TableBoxPainter;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import com.inet.html.views.layouts.TableLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class TableView
extends BoxView
implements ILayouted {
    private BoxView caption;
    private TableLayout layout = new TableLayout(this);
    private TableContainer container;
    private Appendable insertPosition;
    private int borderValue = -1;
    private boolean hardLayout;
    private Rectangle p;

    public TableView(Element element) {
        super(element);
        this.container = new TableContainer(element);
    }

    public TableView(Element element, ViewPainter viewPainter) {
        super(element, viewPainter);
        this.container = new TableContainer(element);
    }

    public void setParent(View view) {
        if (this.getParent() != null && this.getParent() == view) {
            return;
        }
        if (view == null) {
            if (this.layout != null && this.layout.getChildren() != null) {
                List<Layout.PositionInfo> list = this.layout.getChildren();
                for (Layout.PositionInfo positionInfo : list) {
                    if (positionInfo.view == null) continue;
                    positionInfo.view.setParent(null);
                }
                this.layout.getChildren().clear();
            }
            super.setParent(null);
            return;
        }
        super.setParent(view);
        this.insertPosition = this.container;
        this.appendChildElements(this.getElement());
    }

    protected void setPropertiesFromAttributes(boolean bl2) {
        IntegerValue integerValue;
        super.setPropertiesFromAttributes(bl2);
        FloatValue floatValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FLOAT_ALIGN);
        if (floatValue != null && floatValue.getFloat() == 1) {
            this.setJustification((byte)1);
        }
        if ((integerValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.BORDER)) == null && this.getElement().getAttributes().isDefined((Object)HTML.Attribute.BORDER)) {
            integerValue = new IntegerValue(1);
        }
        if (integerValue != null) {
            this.borderValue = integerValue.getInt();
            Insets insets = this.getBox().getBorderInsets();
            if (insets.left == 0) {
                this.getBox().setBorderStyles().left = 7;
                this.getBox().setBorderInsets().left = this.borderValue;
            }
            if (insets.right == 0) {
                this.getBox().setBorderStyles().right = 7;
                this.getBox().setBorderInsets().right = this.borderValue;
            }
            if (insets.top == 0) {
                this.getBox().setBorderStyles().top = 7;
                this.getBox().setBorderInsets().top = this.borderValue;
            }
            if (insets.bottom == 0) {
                this.getBox().setBorderStyles().bottom = 7;
                this.getBox().setBorderInsets().bottom = this.borderValue;
            }
            if (this.getBorderTopColor() == null) {
                this.setBorderTopColor(new ColorValue(ColorUtils.get3DLight()));
            }
            if (this.getBorderLeftColor() == null) {
                this.setBorderLeftColor(new ColorValue(ColorUtils.get3DLight()));
            }
            if (this.getBorderBottomColor() == null) {
                this.setBorderBottomColor(new ColorValue(ColorUtils.get3DDark()));
            }
            if (this.getBorderRightColor() == null) {
                this.setBorderRightColor(new ColorValue(ColorUtils.get3DDark()));
            }
            this.getBox().updateRelevance();
        }
    }

    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    private void appendChildElements(Element element) {
        int n2 = element.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = element.getElement(i2);
            if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.FORM) {
                this.appendChildElements(element2);
                continue;
            }
            Appendable appendable = this.insertPosition.append(element2);
            if (appendable == null) {
                appendable = this.appendFallBack(this.insertPosition, element2);
                if (appendable != null) {
                    this.insertPosition = appendable;
                }
            } else {
                this.insertPosition = appendable;
            }
            if (!TableView.isTableContainerElement(element2)) continue;
            this.appendChildElements(element2);
        }
        if (this.insertPosition.getParent() != null) {
            this.insertPosition = this.insertPosition.getParent();
        }
    }

    private Appendable appendFallBack(Appendable appendable, Element element) {
        List<TableRowInfo> list;
        if (element.getAttributes().isDefined("CR")) {
            return null;
        }
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object != null && !(object instanceof HTML.Tag) && object.toString().startsWith("![")) {
            return null;
        }
        TableRowInfo tableRowInfo = null;
        if (appendable instanceof TableColumnInfo) {
            appendable = appendable.getParent();
        }
        if (appendable instanceof TableColumnGroupInfo) {
            if (object == HTML.Tag.CONTENT) {
                return null;
            }
            if (object == HTML.Tag.TABLE) {
                return appendable.getParent();
            }
            appendable = appendable.getParent();
        }
        if (appendable instanceof TableRowInfo) {
            tableRowInfo = (TableRowInfo)appendable;
        }
        if (appendable instanceof TableRowGroup && (list = ((TableRowGroup)appendable).getRows()) != null && list.size() > 0) {
            tableRowInfo = list.get(list.size() - 1);
        }
        if (tableRowInfo != null) {
            tableRowInfo.forcedAdd(element);
        } else {
            int n2 = element.getStartOffset();
            try {
                String string = this.getDocument().getText(n2, element.getEndOffset() - n2);
                Logger.error("Unable to display malformed table content part: '" + string + "'");
            }
            catch (BadLocationException badLocationException) {
                Logger.error("Unable to display malformed table content part: '" + element.toString() + "'");
            }
        }
        return null;
    }

    public void appendElement(Element element) {
        this.container.append(element);
    }

    public static boolean isTableContainerElement(Element element) {
        if (element.isLeaf()) {
            return false;
        }
        int n2 = TableView.getDisplayType(element);
        switch (n2) {
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static int getDisplayType(Element element) {
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        if (displayValue != null) {
            return displayValue.getDisplay();
        }
        return 3;
    }

    public Rectangle performLayout(boolean bl2) {
        if (this.layout != null) {
            if (bl2 || this.getStatus() != 0) {
                this.p = this.layout.layout(this.hardLayout || bl2);
            }
            this.hardLayout = false;
            this.setStatusLocal(0);
        }
        return this.p != null ? this.p : new Rectangle();
    }

    public void performLayoutWidth() {
        int n2 = this.layout.getCurrentWidth();
        if (this.layout != null) {
            this.layout.layoutWidth();
        }
        if (n2 != this.layout.getCurrentWidth()) {
            this.setStatus(1);
            this.hardLayout = true;
        }
    }

    public float getPreferredSpan(int n2) {
        if (this.layout != null) {
            return this.layout.getPreferredSpan(n2);
        }
        return 0.0f;
    }

    public float getMinimumSpan(int n2) {
        if (this.layout != null) {
            return this.layout.getMinimumSpan(n2);
        }
        return 0.0f;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        return this.layout.modelToView(n2, shape, bias);
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        return this.layout.viewToModel(f2, f3, shape, biasArray);
    }

    public void paint(Graphics graphics, Shape shape) {
        IBoxPainter iBoxPainter;
        Object object;
        if (this.layout == null) {
            return;
        }
        if (this.getVisibility() != 0) {
            return;
        }
        super.paint(graphics, shape);
        Rectangle rectangle = shape.getBounds();
        int n2 = rectangle.x + this.getLeftInset();
        int n3 = rectangle.y + this.getTopInset() + this.getContentVerticalOffset();
        Rectangle rectangle2 = graphics.getClipBounds();
        for (Layout.PositionInfo positionInfo : this.layout.getChildren()) {
            if (positionInfo.view == null) continue;
            object = (TableLayout.CellPositionInfo)positionInfo;
            rectangle.setBounds(positionInfo.x + n2, positionInfo.y + n3, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
            if (((TableLayout.CellPositionInfo)object).getColumnPainter() != null) {
                ((TableLayout.CellPositionInfo)object).getColumnPainter().paintBackground(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, positionInfo.view);
            }
            if (((TableLayout.CellPositionInfo)object).getRowPainter() != null) {
                ((TableLayout.CellPositionInfo)object).getRowPainter().paintBackground(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, positionInfo.view);
            }
            if (!((iBoxPainter = positionInfo.view.getBox()) instanceof TableBoxPainter) || rectangle2 != null && !rectangle.intersects(rectangle2)) continue;
            ((TableBoxPainter)iBoxPainter).paintBackground(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, positionInfo.view);
        }
        for (Layout.PositionInfo positionInfo : this.layout.getChildren()) {
            if (positionInfo.view == null) continue;
            rectangle.setBounds(positionInfo.x + n2, positionInfo.y + n3, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
            object = positionInfo.view.getBox();
            if (!(object instanceof TableBoxPainter) || rectangle2 != null && !rectangle.intersects(rectangle2)) continue;
            iBoxPainter = (TableBoxPainter)object;
            ((TableBoxPainter)iBoxPainter).setCollapseMode(this.layout.isBorderCollapse());
            ((TableBoxPainter)iBoxPainter).paintBorders(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        for (Layout.PositionInfo positionInfo : this.layout.getChildren()) {
            if (positionInfo.view == null) continue;
            rectangle.setBounds(positionInfo.x + n2, positionInfo.y + n3, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
            positionInfo.view.paint(graphics, rectangle);
        }
    }

    public TableContainer getTableContainer() {
        return this.container;
    }

    public void performPreLayout() {
        if (this.layout != null && this.getStatus() != 0) {
            this.hardLayout = true;
            this.layout.preLayout();
            this.setStatusLocal(1);
            this.setStatus(1);
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void predictWidth(int n2) {
        if (this.layout != null) {
            this.layout.predictWidth(n2);
        }
    }

    public String toString() {
        return "Table " + this.getElement();
    }

    public void performLayoutVAlign(int n2) {
        this.layout.layoutVerticalAlign((int)this.getAlignment(1), n2);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int n2 = documentEvent.getOffset();
        int n3 = n2 + documentEvent.getLength();
        if (Logger.doesLog(4)) {
            Logger.debug("TableView:insertUpdate");
        }
        if (n2 <= this.getEndOffset() && n3 >= this.getStartOffset()) {
            for (Layout.PositionInfo positionInfo : this.layout.getChildren()) {
                int n4 = positionInfo.view.getStartOffset();
                int n5 = positionInfo.view.getEndOffset();
                if (n2 >= n5 || n3 < n4) continue;
                positionInfo.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int n2 = documentEvent.getOffset();
        int n3 = n2 + documentEvent.getLength();
        if (Logger.doesLog(4)) {
            Logger.debug("TableView:insertUpdate");
        }
        if (n2 <= this.getEndOffset() && n3 >= this.getStartOffset()) {
            for (Layout.PositionInfo positionInfo : this.layout.getChildren()) {
                int n4 = positionInfo.view.getStartOffset();
                int n5 = positionInfo.view.getEndOffset();
                if (n2 >= n5 || n3 < n4) continue;
                positionInfo.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int n2 = documentEvent.getOffset();
        int n3 = n2 + documentEvent.getLength();
        if (Logger.doesLog(4)) {
            Logger.debug("TableView:insertUpdate");
        }
        if (n2 <= this.getEndOffset() && n3 >= this.getStartOffset()) {
            for (Layout.PositionInfo positionInfo : this.layout.getChildren()) {
                int n4 = positionInfo.view.getStartOffset();
                int n5 = positionInfo.view.getEndOffset();
                if (n2 >= n5 || n3 < n4) continue;
                positionInfo.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }
    }

    public int getHTMLBorderValue() {
        return this.borderValue;
    }

    protected boolean isCanceledByPainter(Graphics graphics, Shape shape) {
        return false;
    }

    public int getViewCount() {
        if (this.layout != null) {
            return this.layout.getViewCount();
        }
        return super.getViewCount();
    }

    public View getView(int n2) {
        if (this.layout != null) {
            return this.layout.getChildren().get((int)n2).view;
        }
        return super.getView(n2);
    }

    public Rectangle getSpan() {
        return this.layout.getSpan();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableRowGroup
    extends Appendable {
        public static final int TYPE_THEAD = 1;
        public static final int TYPE_TBODY = 2;
        public static final int TYPE_TFOOT = 3;
        private List<TableRowInfo> rows;
        private int type;

        public TableRowGroup(Element element, TableContainer tableContainer, int n2) {
            super(tableContainer);
            this.rows = new ArrayList<TableRowInfo>();
            this.type = n2;
        }

        public List<TableRowInfo> getRows() {
            return this.rows;
        }

        @Override
        Appendable appendHere(Element element) {
            int n2 = TableView.getDisplayType(element);
            switch (n2) {
                case 1: {
                    Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (object != HTML.Tag.TR) break;
                }
                case 10: {
                    TableRowInfo tableRowInfo = new TableRowInfo(element, this);
                    this.rows.add(tableRowInfo);
                    return tableRowInfo;
                }
                case 12: {
                    TableRowInfo tableRowInfo;
                    if (this.rows.size() > 0) {
                        tableRowInfo = this.rows.get(this.rows.size() - 1);
                    } else {
                        tableRowInfo = new TableRowInfo(element, this);
                        this.rows.add(tableRowInfo);
                    }
                    return tableRowInfo.append(element);
                }
            }
            return null;
        }

        public String toString() {
            String string = "";
            switch (this.type) {
                case 1: {
                    string = "THEAD";
                    break;
                }
                case 2: {
                    string = "TBODY";
                    break;
                }
                case 3: {
                    string = "TFOOT";
                }
            }
            return string + " with " + this.rows.size() + " rows";
        }
    }

    public class TableCellInfo
    extends Appendable {
        private int rowspan;
        private int colspan;
        private BoxView content;

        public TableCellInfo(Element element, TableRowInfo tableRowInfo) {
            Object object;
            Object object2;
            super(tableRowInfo);
            this.rowspan = 1;
            this.colspan = 1;
            this.content = (BoxView)TableView.this.getViewFactory().create(element);
            if (this.content != null) {
                if (this.content instanceof InlineView && element.getDocument() instanceof InetHtmlDocument) {
                    Object object3 = object2 = (InetHtmlDocument)element.getDocument();
                    object3.getClass();
                    object = (InetHtmlDocument)object3.new InetHtmlDocument.ImpliedElement(element.getParentElement());
                    ((InetHtmlDocument.ImpliedElement)object).replace(0, 0, new Element[]{element});
                    this.content = (BoxView)TableView.this.getViewFactory().create((Element)object);
                }
                this.content.setParent(TableView.this);
            }
            if (this.content != null) {
                TableView.this.replace(TableView.this.getViewCount(), 0, new View[]{this.content});
            }
            if ((object2 = StyleResolver.getAttributeValue(element, AttributeFinder.ROW_SPAN)) != null) {
                this.rowspan = Math.max(((IntegerValue)object2).getInt(), 1);
            }
            if ((object = StyleResolver.getAttributeValue(element, AttributeFinder.COL_SPAN)) != null) {
                this.colspan = Math.max(((IntegerValue)object).getInt(), 1);
            }
        }

        Appendable appendHere(Element element) {
            return null;
        }

        public int getColspan() {
            return this.colspan;
        }

        public void setColspan(int n2) {
            this.colspan = n2;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public BoxView getContent() {
            return this.content;
        }

        public String toString() {
            return "CellInfo for " + this.content;
        }
    }

    public class TableColumnInfo
    extends Appendable {
        private Element source;

        public TableColumnInfo(Element element, TableColumnGroupInfo tableColumnGroupInfo) {
            super(tableColumnGroupInfo);
            this.source = element;
        }

        Appendable appendHere(Element element) {
            return null;
        }

        public Element getSource() {
            return this.source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableColumnGroupInfo
    extends Appendable {
        private List<TableColumnInfo> columns;
        private Element source;

        public TableColumnGroupInfo(Element element, TableContainer tableContainer) {
            super(tableContainer);
            this.source = element;
            this.columns = new ArrayList<TableColumnInfo>();
        }

        @Override
        Appendable appendHere(Element element) {
            int n2 = TableView.getDisplayType(element);
            switch (n2) {
                case 11: {
                    TableColumnInfo tableColumnInfo = new TableColumnInfo(element, this);
                    this.columns.add(tableColumnInfo);
                    return this;
                }
            }
            return null;
        }

        public Element getSource() {
            return this.source;
        }

        public List<TableColumnInfo> getColumns() {
            return this.columns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableRowInfo
    extends Appendable {
        private List<TableCellInfo> cells;
        private List<TableCellInfo> errorCells;
        private Element elem;

        public TableRowInfo(Element element, TableRowGroup tableRowGroup) {
            super(tableRowGroup);
            this.elem = element;
            this.cells = new ArrayList<TableCellInfo>();
        }

        public List<TableCellInfo> getCells() {
            if (this.errorCells != null) {
                ArrayList<TableCellInfo> arrayList = new ArrayList<TableCellInfo>(this.cells);
                arrayList.addAll(this.errorCells);
                return arrayList;
            }
            return this.cells;
        }

        public int countValidCells() {
            return this.cells.size();
        }

        public int countErrorCells() {
            return this.errorCells != null ? this.errorCells.size() : 0;
        }

        @Override
        Appendable appendHere(Element element) {
            int n2 = TableView.getDisplayType(element);
            switch (n2) {
                case 1: {
                    Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (object != HTML.Tag.TD && object != HTML.Tag.TH) break;
                }
                case 12: {
                    TableCellInfo tableCellInfo = new TableCellInfo(element, this);
                    this.cells.add(tableCellInfo);
                    return this;
                }
            }
            return null;
        }

        void forcedAdd(Element element) {
            if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
                int n2 = element.getStartOffset();
                try {
                    if (" ".equals(TableView.this.getDocument().getText(n2, element.getEndOffset() - n2))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (this.errorCells == null) {
                this.errorCells = new ArrayList<TableCellInfo>();
            }
            this.errorCells.add(new TableCellInfo(element, this));
        }

        public String toString() {
            return "Table row with " + this.cells.size() + " cells: " + this.cells.toString();
        }

        public Element getSource() {
            return this.elem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableContainer
    extends Appendable {
        private TableRowGroup header;
        private TableRowGroup footer;
        private TableRowGroup body;
        private List<TableColumnGroupInfo> colDescriptions;

        public TableContainer(Element element) {
            super(null);
        }

        @Override
        Appendable appendHere(Element element) {
            int n2 = TableView.getDisplayType(element);
            switch (n2) {
                case 15: {
                    if (this.footer == null) {
                        this.footer = new TableRowGroup(element, this, n2);
                    }
                    return this.footer;
                }
                case 14: {
                    if (this.header == null) {
                        this.header = new TableRowGroup(element, this, n2);
                    }
                    return this.header;
                }
                case 13: {
                    if (this.body == null) {
                        this.body = new TableRowGroup(element, this, n2);
                    }
                    return this.body;
                }
                case 17: {
                    TableView.this.caption = (BoxView)TableView.this.getViewFactory().create(element);
                    return this;
                }
                case 10: {
                    if (this.body == null) {
                        this.body = new TableRowGroup(element, this, n2);
                    }
                    return this.body.append(element);
                }
                case 12: {
                    if (this.body == null) {
                        this.body = new TableRowGroup(null, this, n2);
                    }
                    this.body.append(element);
                    return this;
                }
                case 11: {
                    if (this.colDescriptions == null) {
                        this.colDescriptions = new ArrayList<TableColumnGroupInfo>();
                    }
                    TableColumnGroupInfo tableColumnGroupInfo = new TableColumnGroupInfo(element, this);
                    this.colDescriptions.add(tableColumnGroupInfo);
                    tableColumnGroupInfo.appendHere(element);
                    return tableColumnGroupInfo;
                }
                case 16: {
                    if (this.colDescriptions == null) {
                        this.colDescriptions = new ArrayList<TableColumnGroupInfo>();
                    }
                    this.colDescriptions.add(new TableColumnGroupInfo(element, this));
                    return this.colDescriptions.get(this.colDescriptions.size() - 1);
                }
            }
            return null;
        }

        public TableRowGroup getHeader() {
            return this.header;
        }

        public TableRowGroup getFooter() {
            return this.footer;
        }

        public TableRowGroup getBody() {
            return this.body;
        }

        public List<TableColumnGroupInfo> getColDescription() {
            return this.colDescriptions;
        }
    }

    private abstract class Appendable {
        private Appendable parent;

        public Appendable(Appendable appendable) {
            this.parent = appendable;
        }

        abstract Appendable appendHere(Element var1);

        public Appendable getParent() {
            return this.parent;
        }

        Appendable append(Element element) {
            Appendable appendable = this.appendHere(element);
            if (appendable == null) {
                if (this.getParent() != null) {
                    return this.getParent().append(element);
                }
                return null;
            }
            return appendable;
        }
    }
}

