/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.ViewPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentPainter;
import com.inet.html.views.ContentView;
import com.inet.html.views.IBoxPainter;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;

public class VariableSpaceView
extends ContentView {
    private static final Segment SPACE_SEGMENT = new Segment(new char[]{' '}, 0, 1);
    private int predictedWidth = -1;
    private int predictedHeight = -1;
    private byte type = (byte)2;
    private boolean isFixed = false;
    private boolean isBreakChar = false;
    private boolean isPre = false;
    private boolean isBorderPart = false;
    private boolean breakable = true;
    private boolean isCRmarker = false;
    private boolean isTab = false;

    public VariableSpaceView(Element element) {
        super(element);
    }

    public VariableSpaceView(Element element, boolean bl2) {
        super(element);
        this.isBreakChar = bl2;
    }

    public VariableSpaceView(Element element, int n2) {
        super(element);
        this.type = (byte)n2;
    }

    public VariableSpaceView(Element element, ViewPainter viewPainter) {
        super(element, viewPainter);
    }

    public VariableSpaceView(Element element, boolean bl2, ViewPainter viewPainter) {
        super(element, viewPainter);
        this.isBreakChar = bl2;
    }

    public VariableSpaceView(Element element, int n2, ViewPainter viewPainter) {
        super(element, viewPainter);
        this.type = (byte)n2;
    }

    public VariableSpaceView(Element element, int n2, ViewPainter viewPainter, ContentPainter contentPainter) {
        super(element, viewPainter, contentPainter);
        this.type = (byte)n2;
    }

    public void setParent(View view) {
        if (this.getParent() != null && this.getParent() == view) {
            return;
        }
        super.setParent(view);
        if (view == null) {
            return;
        }
        if (this.getElement().getAttributes().isDefined("CR")) {
            this.isCRmarker = true;
            this.predictedWidth = 0;
            this.isFixed = true;
        }
        if (this.type == 1 || this.type == 3) {
            IBoxPainter iBoxPainter = ((BoxView)view).getBoxPainter(this.getElement());
            if (iBoxPainter == null) {
                this.setWidth(0);
            } else {
                if (this.type == 1) {
                    this.setWidth(iBoxPainter.getLeftBorderPadding());
                } else {
                    this.setWidth(iBoxPainter.getTotalWidthGain() - iBoxPainter.getLeftBorderPadding());
                }
                this.isBorderPart = true;
            }
            this.isFixed = true;
        }
        this.performPreLayout();
    }

    protected String getText() {
        return null;
    }

    public void setPaintMode(int n2) {
        this.type = (byte)n2;
    }

    public float getPreferredSpan(int n2) {
        if (n2 == 0 && this.predictedWidth >= 0 && this.isFixed) {
            return this.predictedWidth;
        }
        if (n2 == 1 && this.predictedHeight >= 0 && this.isFixed) {
            return this.predictedHeight;
        }
        if (n2 == 2) {
            return super.getPreferredSpan(n2);
        }
        return this.getMinimumSpan(n2);
    }

    public float getMinimumSpan(int n2) {
        if (n2 == 0) {
            if (!this.isFixed) {
                return this.getContentPainter().getSpan() * (float)(this.isPre ? this.getEndOffset() - this.getStartOffset() : 1);
            }
            return this.predictedWidth;
        }
        return super.getPreferredSpan(n2);
    }

    public Rectangle performLayout(boolean bl2) {
        if (!this.isFixed) {
            this.setContentWidth(this.getPreferredSpan(0));
        }
        return null;
    }

    public void setWidth(int n2) {
        if (this.isBorderPart || this.isCRmarker) {
            return;
        }
        this.predictedWidth = n2;
        this.isFixed = n2 >= 0;
    }

    public void setHeight(int n2) {
        this.predictedHeight = n2;
    }

    public int getOuterHeight() {
        if (this.predictedHeight >= 0) {
            return this.predictedHeight;
        }
        return super.getContentHeight();
    }

    public int getOuterWidth() {
        if (this.isFixed && this.predictedWidth >= 0) {
            return this.predictedWidth;
        }
        return super.getContentWidth();
    }

    public int getLeftInset() {
        return 0;
    }

    public int getRightInset() {
        return 0;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean bl2) {
        if (this.isBorderPart || this.isCRmarker) {
            this.isFixed = true;
            return;
        }
        this.isFixed = bl2;
    }

    public void setSize(float f2, float f3) {
        this.setWidth((int)f2);
        this.setHeight((int)f3);
    }

    public void setStartAndEndOffset(int n2, int n3) {
        super.setStartAndEndOffset(n2, n3);
    }

    public int getContentWidth() {
        return this.getOuterWidth();
    }

    public int getContentHeight() {
        return 1;
    }

    protected int getTopPainterType() {
        return this.type;
    }

    public void performPreLayout() {
        super.performPreLayout();
    }

    public String toString() {
        return "VarSpace(" + (this.isFixed ? "fixed" : "variable) " + this.getStartOffset() + "," + this.getEndOffset());
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle = shape.getBounds();
        if ((this.isPre || this.isTab) && rectangle != null) {
            int n3 = this.getEndOffset() - this.getStartOffset();
            int n4 = this.getContentWidth();
            float f2 = (float)n4 / (float)n3;
            rectangle.x = this.isNativeLTR() ? (int)((float)rectangle.x + f2 * (float)(n2 - this.getStartOffset())) : (int)((float)rectangle.x + ((float)n4 - f2 * (float)(n2 - this.getStartOffset())));
            rectangle.width = 0;
            return rectangle;
        }
        rectangle = (Rectangle)super.modelToView(n2, shape, bias);
        if (this.isBreak() && rectangle != null) {
            rectangle.width = 10;
        }
        return rectangle;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (rectangle != null) {
            int n2;
            int n3 = this.getEndOffset() - this.getStartOffset();
            int n4 = n2 = this.isBreak() ? 0 : Math.round((f2 - (float)rectangle.x) / ((float)rectangle.width / (float)n3));
            if (!this.isNativeLTR()) {
                n2 = n3 - n2;
            }
            return n2 += this.getStartOffset();
        }
        return super.viewToModel(f2, f3, shape, biasArray);
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.isBreak() && shape != null) {
            ((Rectangle)shape).width = 10;
        }
        super.paint(graphics, shape);
    }

    private boolean isNativePre() {
        return this.getWhiteSpace() != 0 && this.getWhiteSpace() != 5;
    }

    public void setPre(boolean bl2) {
        this.isPre = bl2;
    }

    public boolean isBreak() {
        if (this.isBreakChar) {
            switch (this.getWhiteSpace()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return super.isBreak();
    }

    public void setIsBreakChar() {
        this.isBreakChar = true;
    }

    public boolean isBreakable() {
        return this.isBreak() || this.breakable && !this.isNativePre();
    }

    public void setBreakable(boolean bl2) {
        this.breakable = bl2;
    }

    protected Segment getSegment() throws BadLocationException {
        return SPACE_SEGMENT;
    }

    public boolean isTab() {
        return this.isTab;
    }

    public void setTab(boolean bl2) {
        this.isTab = bl2;
    }
}

