/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.form;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import com.inet.html.views.ControlView;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.text.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form
implements ActionListener,
KeyListener {
    private boolean methodPOST = false;
    private Object target;
    private HashMap<Element, BoxView> controls = new HashMap(3);
    private HashMap<String, ButtonGroup> radios;
    private final Element formElement;
    private ControlView defaultSubmit = null;
    private static final String POST_DATA_PROPERTY = "javax.swing.JEditorPane.postdata";
    private static final ViewSorter VIEW_SORTER = new ViewSorter();

    public Form(Element element) {
        this.formElement = element;
        if (element != null) {
            if (element.getAttributes().isDefined((Object)HTML.Attribute.METHOD) && "post".equalsIgnoreCase(element.getAttributes().getAttribute((Object)HTML.Attribute.METHOD).toString())) {
                this.methodPOST = true;
            }
            this.target = element.getAttributes().getAttribute((Object)HTML.Attribute.ACTION);
        }
    }

    public void addControl(BoxView boxView) {
        this.controls.put(boxView.getElement(), boxView);
        if (boxView instanceof ControlView) {
            ControlView controlView = (ControlView)boxView;
            JComponent jComponent = controlView.getControl();
            if (controlView.getType() == 3) {
                this.addRadioButton(jComponent, boxView.getElement());
            }
            if (jComponent != null) {
                if (jComponent instanceof JButton) {
                    ((AbstractButton)jComponent).addActionListener(this);
                } else if (!(jComponent instanceof JTextArea)) {
                    jComponent.addKeyListener(this);
                }
            }
            if (controlView.isSubmit() && !controlView.isReset()) {
                this.updateDefaultControl();
            }
        }
    }

    public void removeControl(BoxView boxView) {
        if (boxView == null || this.controls == null) {
            return;
        }
        this.controls.remove(boxView);
        if (boxView instanceof ControlView) {
            ControlView controlView = (ControlView)boxView;
            JComponent jComponent = controlView.getControl();
            if (jComponent != null && jComponent instanceof AbstractButton && this.radios != null) {
                for (ButtonGroup buttonGroup : this.radios.values()) {
                    buttonGroup.remove((AbstractButton)jComponent);
                }
            }
            if (controlView.isSubmit() && !controlView.isReset()) {
                this.updateDefaultControl();
            }
        }
    }

    private void updateDefaultControl() {
        this.defaultSubmit = null;
        for (BoxView boxView : this.controls.values()) {
            if (!(boxView instanceof ControlView) || !((ControlView)boxView).isSubmit() || ((ControlView)boxView).isReset() || this.defaultSubmit != null && boxView.getStartOffset() >= this.defaultSubmit.getStartOffset()) continue;
            this.defaultSubmit = (ControlView)boxView;
        }
    }

    public boolean isEmpty() {
        return this.controls == null || this.controls.size() <= 0;
    }

    private void addRadioButton(JComponent jComponent, Element element) {
        ButtonGroup buttonGroup;
        if (!(jComponent instanceof JRadioButton)) {
            return;
        }
        if (!element.getAttributes().isDefined((Object)HTML.Attribute.NAME)) {
            return;
        }
        String string = element.getAttributes().getAttribute((Object)HTML.Attribute.NAME).toString().toLowerCase();
        if (this.radios == null) {
            this.radios = new HashMap();
        }
        if ((buttonGroup = this.radios.get(string)) == null) {
            buttonGroup = new ButtonGroup();
            ((JRadioButton)jComponent).setSelected(true);
            this.radios.put(string, buttonGroup);
        }
        buttonGroup.add((JRadioButton)jComponent);
        if (element.getAttributes().isDefined((Object)HTML.Attribute.CHECKED)) {
            ((JRadioButton)jComponent).setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != null && actionEvent.getSource() instanceof JComponent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            ControlView controlView = this.getViewForControl(jComponent);
            JEditorPane jEditorPane = this.getEditor(controlView, jComponent);
            if (controlView.isSubmit()) {
                if (controlView.isReset()) {
                    this.resetForm(controlView);
                } else {
                    this.submitForm(controlView, jEditorPane);
                }
            }
        }
    }

    private void submitForm(ControlView controlView, JEditorPane jEditorPane) {
        block6: {
            if (jEditorPane == null) {
                if (Logger.doesLog(1)) {
                    Logger.error("Could no submit " + this.formElement + " because no parent editor could be found");
                }
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            TreeSet<String> treeSet = new TreeSet<String>();
            ArrayList<BoxView> arrayList3 = new ArrayList<BoxView>(this.controls.size());
            arrayList3.addAll(this.controls.values());
            Collections.sort(arrayList3, VIEW_SORTER);
            for (BoxView object4 : arrayList3) {
                if (!(object4 instanceof ControlView)) continue;
                ControlView controlView2 = (ControlView)object4;
                Object object = controlView2.getValue();
                String string = controlView2.getName();
                if (!controlView2.isSuccessful(controlView) || treeSet.contains(string)) continue;
                treeSet.add(string);
                arrayList.add(string);
                arrayList2.add(object);
            }
            Object object = this.createData(arrayList, arrayList2);
            if (object != null && this.methodPOST) {
                this.getDocument().putProperty(POST_DATA_PROPERTY, object);
                object = null;
            }
            Object object2 = object = object != null ? "?" + (String)object : "";
            this.target = this.target == null || "_self".equals(this.target.toString()) ? object : (this.target instanceof UrlValue ? ((UrlValue)this.target).getUrl() + (String)object : this.target.toString() + (String)object);
            try {
                URL iOException = new URL(this.getDocument().getBase(), this.target.toString());
                jEditorPane.setPage(iOException);
            }
            catch (IOException iOException) {
                if (!Logger.doesLog(1)) break block6;
                Logger.error(iOException);
            }
        }
    }

    private JEditorPane getEditor(ControlView controlView, JComponent jComponent) {
        Container container;
        if (controlView == null && jComponent == null) {
            return null;
        }
        if (controlView != null) {
            for (container = controlView.getContainer(); container != null && !(container instanceof JEditorPane); container = container.getParent()) {
            }
            if (container != null) {
                return (JEditorPane)container;
            }
        }
        if (jComponent != null) {
            for (container = jComponent; container != null && !(container instanceof JEditorPane); container = container.getParent()) {
            }
            if (container != null) {
                return (JEditorPane)container;
            }
        }
        return null;
    }

    private InetHtmlDocument getDocument() {
        return (InetHtmlDocument)this.formElement.getDocument();
    }

    private String createData(ArrayList<String> arrayList, ArrayList<Object> arrayList2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList2 != null && arrayList2.size() > 0) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                String string = arrayList.get(i2);
                Object object = arrayList2.get(i2);
                if (object == null || !(object instanceof Object[])) {
                    try {
                        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        stringBuilder.append(string);
                    }
                    if (object == null) continue;
                    stringBuilder.append("=");
                    try {
                        stringBuilder.append(URLEncoder.encode(object.toString(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        stringBuilder.append(object);
                    }
                    continue;
                }
                stringBuilder.append(this.buildMultiValueString(string, (Object[])object));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private String buildMultiValueString(String string, Object[] objectArray) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            try {
                string = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!Logger.doesLog(1)) break block6;
                Logger.error("Could not encode the URL parameter key '" + string + "'");
            }
        }
        for (Object object : objectArray) {
            String string2;
            block7: {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                string2 = object.toString();
                try {
                    string2 = URLEncoder.encode(string2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!Logger.doesLog(1)) break block7;
                    Logger.error("Could not encode the URL parameter value '" + string2 + "'");
                }
            }
            stringBuilder.append(string).append('=').append(string2);
        }
        return stringBuilder.toString();
    }

    private void resetForm(ControlView controlView) {
    }

    private ControlView getViewForControl(JComponent jComponent) {
        if (jComponent == null) {
            return null;
        }
        for (BoxView boxView : this.controls.values()) {
            ControlView controlView;
            if (boxView == null || !(boxView instanceof ControlView) || (controlView = (ControlView)boxView).getControl() != jComponent) continue;
            return controlView;
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.getSource() != null && keyEvent.getSource() instanceof JComponent) {
            JComponent jComponent = (JComponent)keyEvent.getSource();
            ControlView controlView = this.getViewForControl(jComponent);
            JEditorPane jEditorPane = this.getEditor(controlView, jComponent);
            this.submitForm(this.defaultSubmit, jEditorPane);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViewSorter
    implements Comparator<BoxView> {
        private ViewSorter() {
        }

        @Override
        public int compare(BoxView boxView, BoxView boxView2) {
            if (boxView == null && boxView2 == null) {
                return 0;
            }
            if (boxView == null) {
                return -1;
            }
            if (boxView2 == null) {
                return 1;
            }
            return boxView.getStartOffset() - boxView2.getStartOffset();
        }
    }
}

