/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.ImageView;
import com.inet.html.views.TableView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import com.inet.html.views.layouts.StackManager;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.View;

public class BlockLayout
extends Layout {
    private Rectangle span = new Rectangle();

    public BlockLayout(BoxView boxView) {
        super(boxView);
        this.childPositions = new ArrayList(boxView.getViewCount());
    }

    protected void calculateCollapsedMargins() {
        View view = this.view.getParent();
        boolean bl2 = this.view.getBottomInset() == 0;
        boolean bl3 = this.view.getBottomInset() == 0;
        Insets insets = ((BlockView)this.view).getMargins();
        if (view != null && view instanceof BoxView && !(view instanceof HtmlRootView)) {
            Layout layout;
            BoxView boxView = (BoxView)view;
            if (view instanceof ILayouted && (layout = ((ILayouted)((Object)view)).getLayout()) instanceof BlockLayout) {
                if (boxView.getTopInset() == 0 && this.getChild(boxView, true) == this.view) {
                    bl2 = false;
                    insets.top = 0;
                }
                if (boxView.getBottomInset() == 0 && this.getChild(boxView, false) == this.view) {
                    bl3 = false;
                    insets.bottom = 0;
                }
            }
        }
        if (bl2) {
            insets.top = this.getCollapsedMargin(true);
        }
        if (bl3) {
            insets.bottom = this.getCollapsedMargin(false);
        }
    }

    private int getCollapsedMargin(boolean bl2) {
        BoxView boxView = this.view;
        Insets insets = null;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        do {
            insets = ((BlockView)boxView).getOriginalMargins();
            n2 = Math.max(n2, bl2 ? insets.top : insets.bottom);
            n3 = Math.min(n3, bl2 ? insets.top : insets.bottom);
        } while (boxView.getTopInset() <= 0 && boxView.getBottomInset() <= 0 && (boxView = (BoxView)this.getChild(boxView, bl2)) != null && boxView instanceof BlockView && boxView.isBlock());
        return this.collapseMargin(n2, n3);
    }

    public Rectangle layout(boolean bl2) {
        Object object;
        int n2;
        Dimension dimension;
        int n3 = this.adjustHeight();
        if (n3 != Integer.MIN_VALUE) {
            this.setCurrentHeight(n3);
        }
        if ((dimension = this.applyMinMaxValue(true, this.width, 0)) != null) {
            this.width = dimension.width;
        }
        int n4 = 0;
        int n5 = this.view.getViewCount();
        this.childPositions.clear();
        Layout.PositionInfo positionInfo = null;
        StackManager stackManager = ((BlockView)this.view).getPositionManager(false);
        Point point = ((BlockView)this.view).getLeftUpperCorner(this.view);
        this.span.setBounds(0, 0, this.width, 0);
        Rectangle rectangle = new Rectangle(0, 0, this.width, 0);
        Rectangle rectangle2 = new Rectangle();
        StackManager.LineSpaceInfo lineSpaceInfo = null;
        int n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            Rectangle rectangle3;
            int n7;
            Object object2;
            object = (BoxView)this.view.getView(n2);
            Layout.PositionInfo positionInfo2 = new Layout.PositionInfo(this, (BoxView)object);
            if (!((BoxView)object).isInFlow() && (stackManager = ((BlockView)this.view).getPositionManager(true)) != null) {
                if (((BoxView)object).isFloating()) {
                    ((BoxView)object).performLayoutWidth();
                    ((BoxView)object).performLayout(bl2);
                }
                stackManager.addView((BoxView)object, n4 + n6);
                stackManager.notifyNewLine(n4 + n6);
                continue;
            }
            ((BoxView)object).performLayoutWidth();
            this.childPositions.add(positionInfo2);
            if (((BoxView)object).isMarker() && (object2 = StyleResolver.getAttributeValue(((View)object).getElement(), AttributeFinder.LIST_STYLE_POSITION)) != null && ((ListPositionValue)object2).getType() == 0) {
                positionInfo = positionInfo2;
                continue;
            }
            if (stackManager != null && ((BoxView)object).getClear() != 0) {
                rectangle2.width = Math.max(this.width - 2, 1);
                rectangle2.height = 1;
                rectangle.y = n4 + point.y;
                lineSpaceInfo = stackManager.findLineSpace(rectangle2, rectangle, ((BoxView)object).getClear(), this.view.getJustification());
                n4 = lineSpaceInfo.getY() - point.y;
            }
            object2 = ((BoxView)object).getMargins();
            positionInfo2.y = n2 == 0 ? (n4 += ((Insets)object2).top) : (n4 += this.collapseMargin(((Insets)object2).top, n6));
            int n8 = this.view.getJustification();
            if ((object instanceof ImageView || object instanceof TableView) && ((BoxView)object).getJustification() == 1) {
                n8 = 1;
            }
            if ((n7 = ((BoxView)object).getAutoMarginJustify()) >= 0) {
                n8 = n7;
            }
            switch (n8) {
                case 2: {
                    positionInfo2.x = Math.max(this.width - ((BoxView)object).getOuterWidth() - ((Insets)object2).right, ((Insets)object2).left);
                    break;
                }
                case 1: {
                    positionInfo2.x = Math.max((this.width - ((BoxView)object).getOuterWidth()) / 2, ((Insets)object2).left);
                    break;
                }
                default: {
                    positionInfo2.x = ((Insets)object2).left;
                }
            }
            if (((BoxView)object).getPosition() == 1) {
                BlockLayout.offsetRelative(positionInfo2);
            }
            if ((rectangle3 = ((BoxView)object).performLayout(bl2)) != null) {
                Rectangle rectangle4 = rectangle3.getBounds();
                rectangle4.translate(positionInfo2.x, positionInfo2.y);
                BlockLayout.union(this.span, rectangle4);
            }
            if (((BoxView)object).isBlock() && stackManager == null) {
                stackManager = ((BlockView)this.view).getPositionManager(false);
            }
            n4 += ((BoxView)object).getOuterHeight();
            n6 = ((Insets)object2).bottom;
            if (positionInfo != null) {
                positionInfo.x = ((BoxView)object).isLTR() ? positionInfo2.x - positionInfo.view.getOuterWidth() - MARKER_OFFSET : positionInfo2.x + positionInfo2.width + MARKER_OFFSET;
                positionInfo.y = 0 + ((BoxView)object).getFirstLineBaseLine() - (int)positionInfo.view.getPreferredSpan(2) + ((BoxView)object).getTopInset() + ((BoxView)object).getMargins().top;
                positionInfo = null;
            }
            if (this.view.getFirstLineBaseLine() == 0) {
                this.view.setFirstLineBaseLine((short)(((BoxView)object).getFirstLineBaseLine() + ((BoxView)object).getTopInset() + ((BoxView)object).getMargins().top));
            }
            if (((BoxView)object).getPosition() != 1 || (stackManager = ((BlockView)this.view).getPositionManager(true)) == null) continue;
            stackManager.addView((BoxView)object, positionInfo2.x, positionInfo2.y);
            positionInfo2.paintInFlow = false;
        }
        n2 = n4 + n6;
        this.span.height = Math.max(this.span.height, n2);
        this.setFinalHight(n3, n2, this.span);
        object = this.applyMinMaxValue(false, this.getCurrentWidth(), this.getCurrentHeight());
        if (object != null) {
            this.setCurrentWidth(((Dimension)object).width);
            this.setCurrentHeight(((Dimension)object).height);
        }
        return this.span;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        int n3;
        int n4;
        List<Layout.PositionInfo> list;
        Rectangle rectangle = shape.getBounds();
        if (this.view.getVisibility() != 0) {
            throw new BadLocationException("Location is within a unvisible Element", n2);
        }
        int n5 = rectangle.x + this.view.getLeftInset();
        int n6 = rectangle.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        Shape shape2 = null;
        StackManager stackManager = ((BlockView)this.view).getPositionManager(false);
        if (stackManager != null && (list = stackManager.modelToView(n2, shape, bias, 5)) != null) {
            return list;
        }
        list = this.getChildren();
        Layout.PositionInfo positionInfo = list.size() > 0 ? (Layout.PositionInfo)list.get(list.size() - 1) : null;
        for (Layout.PositionInfo positionInfo2 : list) {
            boolean bl2;
            if (positionInfo2.view.isMarker()) continue;
            n4 = positionInfo2.view.getStartOffset();
            n3 = positionInfo2.view.getEndOffset();
            if (bias == Position.Bias.Forward && positionInfo2 != positionInfo) {
                bl2 = n3 > n2;
            } else {
                boolean bl3 = bl2 = n3 >= n2;
            }
            if (n4 >= n3 || n4 > n2 || !bl2) continue;
            rectangle.x = positionInfo2.x + n5;
            rectangle.y = positionInfo2.y + n6;
            rectangle.width = positionInfo2.view.getOuterWidth();
            rectangle.height = positionInfo2.view.getOuterHeight();
            shape2 = positionInfo2.view.modelToView(n2, rectangle, bias);
            break;
        }
        if (stackManager != null && shape2 == null) {
            return stackManager.modelToView(n2, shape, bias, 0);
        }
        if (shape2 == null && list.size() > 0) {
            Layout.PositionInfo positionInfo2;
            FontMetrics fontMetrics = this.getFallbackFontMetrics();
            positionInfo2 = (Layout.PositionInfo)list.get(0);
            n4 = positionInfo2.view.getStartOffset();
            if (n2 < n4) {
                n3 = Math.max(positionInfo2.view.getFirstLineBaseLine(), fontMetrics.getAscent());
                rectangle.x = positionInfo2.x + n5 - 1;
                rectangle.y = positionInfo2.y + n6 + positionInfo2.view.getFirstLineBaseLine() - n3;
                rectangle.width = 1;
                rectangle.height = fontMetrics.getHeight();
                return rectangle.getBounds();
            }
            n3 = positionInfo.view.getEndOffset();
            if (n2 >= n3) {
                rectangle.x = positionInfo.x + n5 + positionInfo.view.getOuterWidth();
                rectangle.y = positionInfo.y + n6 + positionInfo.view.getOuterHeight() - fontMetrics.getHeight();
                rectangle.width = 1;
                rectangle.height = fontMetrics.getHeight();
                return rectangle.getBounds();
            }
        }
        return shape2;
    }

    /*
     * WARNING - void declaration
     */
    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = shape.getBounds();
        if (this.view.getVisibility() != 0) {
            return -1;
        }
        StackManager stackManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        int n2 = rectangle.x + this.view.getLeftInset();
        int n3 = rectangle.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        int n4 = -1;
        if (stackManager != null && (n4 = stackManager.viewToModel(f2, f3, shape, biasArray, 5)) >= 0) {
            return n4;
        }
        for (Layout.PositionInfo object : this.getChildren()) {
            rectangle.width = object.view.getOuterWidth();
            rectangle.setBounds(object.x + n2, object.y + n3, rectangle.width, object.view.getOuterHeight());
            if (!rectangle.contains(new Point2D.Float(f2, f3))) continue;
            n4 = object.view.viewToModel(f2, f3, rectangle, biasArray);
            break;
        }
        if (stackManager != null) {
            n4 = stackManager.viewToModel(f2, f3, shape, biasArray, 0);
        }
        if (n4 == -1) {
            Object object = null;
            for (Layout.PositionInfo positionInfo : this.getChildren()) {
                rectangle.width = positionInfo.view.getOuterWidth();
                rectangle.setBounds(positionInfo.x + n2, positionInfo.y + n3, rectangle.width, positionInfo.view.getOuterHeight());
                if ((float)rectangle.y <= f3 && (float)(rectangle.y + rectangle.height) >= f3) {
                    return positionInfo.view.viewToModel(f2, f3, rectangle, biasArray);
                }
                if ((float)rectangle.y > f3) {
                    void var12_15;
                    if (object != null) {
                        Object object2 = object;
                        rectangle.width = ((Layout.PositionInfo)object2).view.getOuterWidth();
                        rectangle.setBounds(((Layout.PositionInfo)object2).x + n2, ((Layout.PositionInfo)object2).y + n3, rectangle.width, ((Layout.PositionInfo)object2).view.getOuterHeight());
                    }
                    return var12_15.view.viewToModel(f2, f3, rectangle, biasArray);
                }
                object = positionInfo;
            }
            if (object != null) {
                rectangle.setBounds(n2, n3, this.view.getOuterWidth(), this.view.getOuterHeight());
                return ((Layout.PositionInfo)object).view.viewToModel(f2, f3, rectangle, biasArray);
            }
        }
        return n4;
    }

    private int collapseMargin(int n2, int n3) {
        if (n2 < 0 && n3 < 0) {
            return Math.min(n2, n3);
        }
        if (n2 < 0) {
            return n3 + n2;
        }
        if (n3 < 0) {
            return n2 + n3;
        }
        return Math.max(n2, n3);
    }

    public void preLayout() {
        int n2 = this.view.getViewCount();
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minimumWidth = 0;
        this.minimumHeight = 0;
        LengthUnit lengthUnit = this.view.getWidthUnit();
        if (lengthUnit != null && !lengthUnit.isAuto() && lengthUnit.isAbsolute()) {
            this.minimumWidth = this.preferredWidth = Math.round(lengthUnit.getValue());
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            int n5;
            Insets insets;
            View view = this.view.getView(i2);
            Insets insets2 = insets = view instanceof BoxView ? ((BoxView)view).getMargins() : new Insets(0, 0, 0, 0);
            if (i2 == 0) {
                this.preferredHeight += insets.top;
            }
            if (view instanceof BlockView) {
                BlockView blockView = (BlockView)view;
                int n6 = blockView.getBox().getTotalWidthGain();
                Layout layout = blockView.getLayout();
                n5 = layout.getPreferredWidth() + n6;
                n4 = layout.getMinimumWidth() + n6;
            } else {
                n5 = (int)view.getPreferredSpan(0);
                n4 = (int)view.getMinimumSpan(0);
            }
            this.minimumWidth = Math.max(this.minimumWidth, n4);
            this.preferredWidth = Math.max(this.preferredWidth, n5);
            if (this.view.isTableCell() && this.preferredWidth < this.minimumWidth) {
                this.preferredWidth = this.minimumWidth;
            }
            if (this.view.isInFlow()) {
                this.preferredHeight -= this.collapseMargin(insets.top, n3);
            }
            this.preferredHeight += (int)view.getPreferredSpan(1);
            n3 = insets.bottom;
        }
        this.preferredHeight += n3;
        this.minimumHeight = this.preferredHeight;
        this.setPreLayouted();
    }

    public void predictWidth(int n2) {
        this.width = n2;
        this.currentWidth = n2;
    }

    public void layoutVerticalAlign(int n2, int n3) {
        int n4 = this.view.getContentHeight();
        int n5 = n4 - this.currentHeight;
        this.currentHeight = this.view.getContentHeight();
        if (n5 > 0) {
            switch (n2) {
                case 8: {
                    this.view.setContentVerticalOffset(n5);
                    break;
                }
                case 2: {
                    this.view.setContentVerticalOffset(n5 / 2);
                    break;
                }
                case 7: {
                    this.view.setContentVerticalOffset(0);
                    break;
                }
            }
        } else {
            this.view.setContentVerticalOffset(0);
        }
    }

    public ViewPositionInfo getViewForPosition(Point point, Rectangle rectangle) {
        StackManager stackManager;
        Rectangle rectangle2 = rectangle.getBounds();
        if (this.view.getVisibility() != 0) {
            return null;
        }
        int n2 = rectangle2.x + this.view.getLeftInset();
        int n3 = rectangle2.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        ViewPositionInfo viewPositionInfo = null;
        StackManager stackManager2 = stackManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        if (stackManager != null && (viewPositionInfo = stackManager.getViewForPosition(point, rectangle, 5)) != null) {
            return viewPositionInfo;
        }
        for (Layout.PositionInfo positionInfo : this.getChildren()) {
            rectangle2.width = positionInfo.view.getOuterWidth();
            rectangle2.setBounds(positionInfo.x + n2, positionInfo.y + n3, rectangle2.width, positionInfo.view.getOuterHeight());
            if (!rectangle2.contains(point)) continue;
            viewPositionInfo = positionInfo.view.getViewForPosition(point, rectangle2);
            if (viewPositionInfo == null) {
                return new ViewPositionInfo(rectangle2, positionInfo.view);
            }
            return viewPositionInfo;
        }
        if (stackManager != null && (viewPositionInfo = stackManager.getViewForPosition(point, rectangle, 0)) != null) {
            return viewPositionInfo;
        }
        return null;
    }

    public Rectangle getSpan() {
        return this.span;
    }
}

