/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.InetHtmlFactory;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.InsertedContentView;
import com.inet.html.views.VariableSpaceView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.BlockLayout;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import com.inet.html.views.layouts.StackManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineLayout
extends Layout {
    private static final char[] BREAK_CHARS = new char[]{'#', '&', '/', '@', '\\'};
    private int preferredBaseline;
    private BlockView blockView;
    private boolean reflowed = false;
    private boolean hasMarker = false;
    private int contentHeight;
    private Rectangle span = new Rectangle();
    private LevelList bidiList;
    private int lastSyncLen = -1;
    private boolean rtl;
    private boolean canWrapOnOverflow;
    private boolean collapseWhitespaces;
    private int listPos = 0;

    public InlineLayout(BlockView blockView) {
        super(blockView);
        ListPositionValue listPositionValue;
        this.blockView = blockView;
        int n2 = blockView.getWhiteSpace();
        this.canWrapOnOverflow = n2 == 0 || n2 == 5 || n2 == 4 || n2 == 3;
        this.collapseWhitespaces = n2 == 1 || n2 == 3;
        this.hasMarker = blockView.isListItemWithMarker();
        if (this.hasMarker && (listPositionValue = StyleResolver.getAttributeValue(blockView.getElement(), AttributeFinder.LIST_STYLE_POSITION)) != null && blockView.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED) {
            this.listPos = listPositionValue.getType();
        }
        this.childPositions = new ArrayList(blockView.getViewCount());
    }

    @Override
    protected void calculateCollapsedMargins() {
        if (this.view.isFloating()) {
            return;
        }
        View view = this.view.getParent();
        Insets insets = this.blockView.getMargins();
        if (view != null && view instanceof BoxView && !(view instanceof HtmlRootView)) {
            Layout layout;
            BoxView boxView = (BoxView)view;
            if (view instanceof ILayouted && (layout = ((ILayouted)((Object)view)).getLayout()) instanceof BlockLayout) {
                if (boxView.getTopInset() == 0 && this.getChild(boxView, true) == this.view) {
                    insets.top = 0;
                }
                if (boxView.getBottomInset() == 0 && this.getChild(boxView, false) == this.view) {
                    insets.bottom = 0;
                }
            }
        }
    }

    @Override
    public Rectangle layout(boolean bl2) {
        Object object;
        Dimension dimension = this.applyMinMaxValue(true, this.width, 0);
        if (dimension != null) {
            this.width = dimension.width;
        }
        Point point = this.blockView.getLeftUpperCorner(this.view);
        this.span.setBounds(0, 0, this.width, 0);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.width, 0);
        Rectangle rectangle2 = new Rectangle();
        StackManager stackManager = this.blockView.getPositionManager(false);
        int n2 = this.view.getViewCount();
        StackManager.LineSpaceInfo lineSpaceInfo = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.width;
        this.preferredBaseline = 0;
        this.contentHeight = 0;
        this.preferredHeight = 0;
        this.childPositions.clear();
        boolean bl3 = false;
        int n8 = this.blockView.getRenderContext().getBreakMode();
        int n9 = 0;
        int n10 = 0;
        ViewIterator viewIterator = new ViewIterator();
        boolean bl4 = this.view.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED || this.view.getParent() == null || this.view.getParent().getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY;
        int n11 = this.adjustHeight();
        if (n11 != Integer.MIN_VALUE) {
            this.setCurrentHeight(n11);
        }
        if (this.hasMarker && this.listPos == 0 && n2 != 1) {
            n3 = 1;
            n9 = 1;
            viewIterator.step();
        }
        boolean bl5 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.view.getView(i2);
            if (!(object instanceof VariableSpaceView)) continue;
            VariableSpaceView variableSpaceView = (VariableSpaceView)object;
            variableSpaceView.setWidth(-1);
        }
        View view = null;
        object = null;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        while (viewIterator.hasNext()) {
            BoxView[] boxViewArray;
            int n12;
            int n13;
            Object object2;
            Object object3;
            BoxView boxView = viewIterator.peek();
            bl6 = false;
            if (view == null || boxView == view) {
                object = this.getSegmentSize(viewIterator, false);
                view = ((SegmentInfo)object).next;
                bl8 = true;
            } else {
                if (bl7) {
                    bl7 = false;
                    bl6 = true;
                } else {
                    bl6 = false;
                }
                bl8 = false;
            }
            if (boxView == null || object == null) {
                viewIterator.step();
                continue;
            }
            if ((bl3 || !bl5) && boxView instanceof VariableSpaceView && !((VariableSpaceView)(object3 = (VariableSpaceView)boxView)).isBreak() && ((VariableSpaceView)object3).isBreakable() && !((VariableSpaceView)object3).isFixed() && (object2 = this.getNextVisibleView(viewIterator)) != null && ((BoxView)object2).isFloating()) {
                viewIterator.step();
                continue;
            }
            viewIterator.step();
            object3 = boxView.getElement();
            object2 = new Layout.PositionInfo(this, boxView);
            int n14 = this.childPositions.size();
            boxView.performLayoutWidth();
            boxView.performLayout(bl2);
            if (!boxView.isInFlow() && (stackManager = this.blockView.getPositionManager(true)) != null) {
                stackManager.addView(boxView, n5);
                continue;
            }
            ((Layout.PositionInfo)object2).width = boxView.getOuterWidth();
            if (boxView.isBlock() && stackManager == null) {
                stackManager = this.blockView.getPositionManager(false);
            }
            Insets insets = boxView.getMargins();
            int n15 = insets.top + insets.bottom;
            int n16 = boxView.getOuterWidth() + insets.left + insets.right;
            int n17 = boxView.getOuterHeight() + n15;
            ((Layout.PositionInfo)object2).baseline = (short)(boxView.getPreferredSpan(2) + (float)n15);
            int n18 = n17;
            int n19 = 0;
            LengthUnit lengthUnit = boxView.getLineHeight();
            if (boxView instanceof ContentView && lengthUnit != null && !lengthUnit.isAuto() && lengthUnit.getValue() > 0.0f) {
                n13 = (int)lengthUnit.calculateValue(n17, boxView);
                n19 = (n13 - n17) / 2;
                n17 = n13;
            }
            n13 = ((Layout.PositionInfo)object2).baseline + n19;
            n17 = Math.max(n6 - this.preferredBaseline, n17 - n13) + Math.max(n13, this.preferredBaseline);
            if (!bl5) {
                n12 = this.blockView.getTextIndent();
                if (stackManager != null) {
                    stackManager.notifyNewLine(n5);
                    rectangle2.width = ((SegmentInfo)object).width;
                    rectangle2.height = ((SegmentInfo)object).height;
                    Rectangle rectangle3 = rectangle;
                    if (n12 != 0) {
                        rectangle3 = (Rectangle)rectangle.clone();
                        rectangle3.x += n12;
                        rectangle3.width -= n12;
                    }
                    lineSpaceInfo = stackManager.findLineSpace(rectangle2, rectangle3, boxView.getClear(), this.view.getJustification());
                    n4 = lineSpaceInfo.getX() - point.x;
                    n5 = lineSpaceInfo.getY() - point.y;
                    n7 = lineSpaceInfo.getMaxWidth() + n4;
                    this.preferredBaseline = 0;
                } else {
                    n4 += n12;
                }
                if (this.hasMarker && this.listPos == 0) {
                    n6 = this.placeOutsideMarker(bl2, n4, n5, n6, n19, n13);
                    ++n14;
                }
                bl5 = true;
            }
            if ((n12 = boxView.isBreak()) != 0) {
                bl3 = true;
            }
            boolean bl9 = (!((Layout.PositionInfo)object2).isVarSpace || ((SegmentInfo)object).segmentLen > 1) && this.canWrapOnOverflow && bl8;
            boolean bl10 = boxView instanceof ContentView && ((ContentView)boxView).getCJKType() == 2;
            boolean bl11 = object3.getAttributes().isDefined("CR");
            bl9 &= !bl11;
            if (n8 != 0 || bl10) {
                if (bl9 && bl10) {
                    if (n8 == 2) {
                        bl9 &= bl6 || ((SegmentInfo)object).width <= n7;
                    } else if (bl10) {
                        bl9 &= bl6;
                    }
                } else {
                    bl9 |= bl6;
                    bl9 |= !((Layout.PositionInfo)object2).isVarSpace && n4 + n16 > n7 && n4 > 0 && boxView.getEndOffset() - boxView.getStartOffset() == 1;
                }
            }
            if (bl9 && n4 + ((SegmentInfo)object).width > n7 && n4 > 0 || bl9 && lineSpaceInfo != null && lineSpaceInfo.getMaxHeightOnMaxWidth() < ((SegmentInfo)object).height || n12 != 0) {
                this.span.width = Math.max(this.span.width, n4);
                if (n12 != 0) {
                    bl3 = false;
                    this.childPositions.add(object2);
                    ++n14;
                    n6 = Math.max(n6, n17);
                    ((Layout.PositionInfo)object2).x = n4;
                    ((Layout.PositionInfo)object2).y = n5;
                    ((Layout.PositionInfo)object2).vAlign = (byte)boxView.getAlignment(1);
                    this.preferredBaseline = Math.max(this.preferredBaseline, n13);
                }
                if (n9 == n3) {
                    this.view.setFirstLineBaseLine((short)this.preferredBaseline);
                }
                n14 = this.justification(n9, n10, n14, n7, n4, n12 != 0, this.collapseWhitespaces);
                this.verticalAlign(n9 == n3 ? 0 : n9, n14, this.childPositions);
                n9 = n14;
                n10 = n14;
                n4 = 0;
                n5 += n6;
                this.preferredBaseline = 0;
                if (n12 != 0) {
                    object = this.getSegmentSize(viewIterator, false);
                    view = ((SegmentInfo)object).next;
                }
                if (stackManager != null) {
                    stackManager.notifyNewLine(n5);
                    rectangle2.width = ((SegmentInfo)object).width;
                    rectangle2.height = ((SegmentInfo)object).height;
                    rectangle.y = n5 + point.y;
                    lineSpaceInfo = stackManager.findLineSpace(rectangle2, rectangle, boxView.getClear(), this.view.getJustification());
                    n4 = lineSpaceInfo.getX() - point.x;
                    n5 = lineSpaceInfo.getY() - point.y;
                    n7 = lineSpaceInfo.getMaxWidth() + n4;
                }
                n6 = 0;
                n17 = n18;
                if (n12 != 0) continue;
            }
            if (n12 == 0) {
                if (bl3) {
                    int n20 = this.childPositions.size() - 1;
                    n4 = ((Layout.PositionInfo)this.childPositions.get((int)n20)).x;
                }
                bl3 = false;
            }
            if (n4 + n16 > n7 && (n8 != 0 && boxView.getEndOffset() - boxView.getStartOffset() > 1 || bl10) && (boxViewArray = this.breakInline(boxView, n7 - n4, n9 == n14)) != null) {
                if (boxViewArray.length == 1) {
                    if (!bl6) {
                        viewIterator.push(boxViewArray[0]);
                        bl7 = true;
                        bl6 = false;
                        continue;
                    }
                } else {
                    boxView = boxViewArray[0];
                    viewIterator.push(boxViewArray[1]);
                    boxView.performLayoutWidth();
                    boxView.performLayout(bl2);
                    ((Layout.PositionInfo)object2).width = boxView.getOuterWidth();
                    int n21 = n16 - boxViewArray[1].getOuterWidth() - insets.left + insets.right;
                    n16 = ((Layout.PositionInfo)object2).width + insets.left + insets.right;
                    ((Layout.PositionInfo)object2).view = boxView;
                    ((SegmentInfo)object).width -= n21;
                    bl7 = true;
                }
            }
            this.childPositions.add(object2);
            ((Rectangle)object2).setLocation(n4 + insets.left, n5 + insets.top);
            if (boxView instanceof VariableSpaceView && ((VariableSpaceView)boxView).isTab()) {
                n16 = this.view.getRenderContext().getTabSize(n4, n16);
                ((VariableSpaceView)boxView).setWidth(n16);
                n10 = n14;
            }
            n4 += n16;
            if (!bl11 || !this.getView().getRenderContext().collapseEmptyBlocks()) {
                if (this.getView().getRenderContext().collapseEmptyBlocks()) {
                    if (!bl11) {
                        n6 = Math.max(n6, n17);
                        this.preferredBaseline = Math.max(this.preferredBaseline, n13);
                    }
                } else {
                    BoxView boxView2 = viewIterator.peek();
                    if (!(bl11 && boxView2 == null && !bl4 || bl11 && n6 > 0)) {
                        n6 = Math.max(n6, n17);
                        this.preferredBaseline = Math.max(this.preferredBaseline, n13);
                    }
                }
            }
            ((Layout.PositionInfo)object2).vAlign = (byte)boxView.getAlignment(1);
            if (boxView.getPosition() != 1) continue;
            InlineLayout.offsetRelative((Layout.ViewPosition)object2);
            Layout.union(this.span, ((Layout.PositionInfo)object2).x, ((Layout.PositionInfo)object2).y, ((Layout.PositionInfo)object2).view.getOuterWidth(), ((Layout.PositionInfo)object2).view.getOuterHeight());
            stackManager = ((BlockView)this.view).getPositionManager(true);
            if (stackManager == null) continue;
            stackManager.addView(boxView, ((Layout.PositionInfo)object2).x, ((Layout.PositionInfo)object2).y);
            ((Layout.PositionInfo)object2).paintInFlow = false;
        }
        this.span.width = this.span.width = Math.max(this.span.width, n4 - this.span.x);
        if (stackManager != null) {
            stackManager.notifyNewLine(n5 + n6);
        }
        if (!bl5) {
            if (this.hasMarker && this.listPos == 0) {
                n6 = this.placeOutsideMarker(bl2, n4, n5, n6, 0, this.preferredBaseline);
            }
            this.view.setFirstLineBaseLine((short)this.preferredBaseline);
        } else if (n9 == n3) {
            this.view.setFirstLineBaseLine((short)this.preferredBaseline);
        }
        int n22 = this.childPositions.size();
        this.justification(n9, n10, n22, n7, n4, true, this.collapseWhitespaces);
        this.verticalAlign(n9 == n3 ? 0 : n9, n22, this.childPositions);
        this.span.height = this.contentHeight = n5 + n6;
        if (!this.view.isInFlow() || this.view.isBlock()) {
            this.setFinalHight(n11, n5 + n6, this.span);
        } else {
            this.setCurrentHeight(n5 + n6);
        }
        dimension = this.applyMinMaxValue(false, this.getCurrentWidth(), this.getCurrentHeight());
        if (dimension != null) {
            this.setCurrentWidth(dimension.width);
            this.setCurrentHeight(dimension.height);
        }
        this.view.setSizeContent(this.getCurrentWidth(), this.getCurrentHeight());
        return this.span;
    }

    private int placeOutsideMarker(boolean bl2, int n2, int n3, int n4, int n5, int n6) {
        BoxView boxView = (BoxView)this.view.getView(0);
        boxView.performLayoutWidth();
        boxView.performLayout(bl2);
        Layout.PositionInfo positionInfo = new Layout.PositionInfo(this, boxView);
        this.childPositions.add(positionInfo);
        positionInfo.baseline = (short)boxView.getPreferredSpan(2);
        int n7 = positionInfo.baseline + n5;
        positionInfo.x = this.view.isLTR() ? n2 - boxView.getOuterWidth() - MARKER_OFFSET : this.width + MARKER_OFFSET;
        positionInfo.y = n3;
        Layout.union(this.span, positionInfo.x, positionInfo.y, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
        n4 = Math.max(n4, boxView.getOuterHeight());
        positionInfo.vAlign = (byte)boxView.getAlignment(1);
        this.preferredBaseline = Math.max(n6, n7);
        return n4;
    }

    private BoxView[] breakInline(BoxView boxView, int n2, boolean bl2) {
        ContentView contentView;
        float[] fArray;
        if (boxView instanceof ContentView && !(boxView instanceof VariableSpaceView) && (fArray = (contentView = (ContentView)boxView).getContentPainter().getCharOffsets()) != null && fArray.length > 1) {
            int n3;
            for (n3 = 0; n3 < fArray.length && !(fArray[n3] > (float)n2); ++n3) {
            }
            if (n3 <= 1 && !bl2) {
                return new BoxView[]{boxView};
            }
            n3 = n3 <= 1 ? 1 : n3 - 1;
            int n4 = boxView.getStartOffset();
            if (n3 > boxView.getEndOffset() - n4) {
                return null;
            }
            BoxView[] boxViewArray = new BoxView[]{(BoxView)boxView.createFragment(n4, n4 + n3), (BoxView)boxView.createFragment(n4 + n3, boxView.getEndOffset())};
            return boxViewArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoxView getNextVisibleView(ViewIterator viewIterator) {
        viewIterator.freeze();
        try {
            BoxView boxView;
            viewIterator.next();
            while (viewIterator.hasNext()) {
                boxView = viewIterator.next();
                if (!boxView.isVisible()) continue;
                BoxView boxView2 = boxView;
                return boxView2;
            }
            boxView = null;
            return boxView;
        }
        finally {
            viewIterator.unfreeze();
        }
    }

    private void bidiReorder(int n2, int n3, int n4, int n5) {
        if (n2 == n3 || this.bidiList == null && !this.rtl) {
            return;
        }
        Layout.PositionInfo positionInfo = (Layout.PositionInfo)this.childPositions.get(n2);
        Layout.PositionInfo positionInfo2 = (Layout.PositionInfo)this.childPositions.get(n3 - 1);
        if (this.rtl) {
            Layout.PositionInfo positionInfo3 = positionInfo2;
            this.reverseOrder(n2, n3 - 1, positionInfo.x, positionInfo3.x + positionInfo3.width);
            return;
        }
        int n6 = positionInfo.view.getStartOffset();
        int n7 = positionInfo2.view.getEndOffset();
        for (int i2 = this.bidiList.getMaxLevel(); i2 > 0; --i2) {
            List<LevelInfo> list = this.bidiList.getRuns(i2, n6, n7);
            if (list == null) continue;
            for (LevelInfo levelInfo : list) {
                int[] nArray = this.getStartEndIndex(n2, n3, levelInfo);
                if (nArray == null) continue;
                this.reverseOrder(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
        }
    }

    private int[] getStartEndIndex(int n2, int n3, LevelInfo levelInfo) {
        int n4 = n3;
        int n5 = n2;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        for (int i2 = n2; i2 < n3; ++i2) {
            Layout.PositionInfo positionInfo = (Layout.PositionInfo)this.childPositions.get(i2);
            if (!levelInfo.isInRange(positionInfo.view)) continue;
            n4 = n4 < i2 ? n4 : i2;
            n5 = n5 > i2 ? n5 : i2;
            n6 = Math.min(n6, positionInfo.x);
            n7 = Math.max(n7, positionInfo.x + positionInfo.width);
        }
        if (n4 < n5) {
            return new int[]{n4, n5, n6, n7};
        }
        return null;
    }

    private int justification(int n2, int n3, int n4, int n5, int n6, boolean bl2, boolean bl3) {
        if (n4 == 0) {
            return n4;
        }
        this.bidiReorder(n2, n4, n5, n6);
        Layout.PositionInfo positionInfo = (Layout.PositionInfo)this.childPositions.get(n4 - 1);
        if (positionInfo.isVarSpace && positionInfo.view != null && this.view.getJustification() != 1 && this.view.getJustification() != 2 && positionInfo.view.isBreak()) {
            VariableSpaceView variableSpaceView = (VariableSpaceView)positionInfo.view;
            variableSpaceView.setWidth(1);
        }
        if (n5 == n6) {
            return n4;
        }
        positionInfo = null;
        switch (this.view.getJustification()) {
            case 2: {
                Layout.PositionInfo positionInfo2;
                int n7;
                int n8 = n5 - n6 - 1;
                int n9 = n4;
                if (this.view.isLTR()) {
                    for (n7 = n9 - 1; n7 >= n2; --n7) {
                        positionInfo2 = (Layout.PositionInfo)this.childPositions.get(n7);
                        if (!positionInfo2.isVarSpace || positionInfo2.isFixed) break;
                        if (positionInfo2.view == null) continue;
                        --n9;
                        positionInfo2.x = n5;
                        if (positionInfo2.view.isBreak()) {
                            ((VariableSpaceView)positionInfo2.view).setWidth(0);
                            continue;
                        }
                        n8 += positionInfo2.view.getContentWidth();
                        ((VariableSpaceView)positionInfo2.view).setWidth(0);
                    }
                }
                for (n7 = n2; n7 < n9; ++n7) {
                    positionInfo2 = (Layout.PositionInfo)this.childPositions.get(n7);
                    positionInfo2.x += n8;
                    if (positionInfo2.x >= 0) continue;
                    positionInfo2.x = 0;
                }
                return n4;
            }
            case 1: {
                int n10 = (n5 - n6) / 2;
                if (n10 > 0) {
                    for (int i2 = n2; i2 < n4; ++i2) {
                        ((Layout.PositionInfo)this.childPositions.get((int)i2)).x += n10;
                    }
                }
                return n4;
            }
            case 3: {
                if (!bl2) {
                    return this.justify(n3, n4, n5, n6);
                }
                return n4;
            }
        }
        return n4;
    }

    private int justify(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            Layout.PositionInfo positionInfo = (Layout.PositionInfo)this.childPositions.get(i2);
            if (!positionInfo.isVarSpace || positionInfo.isFixed || positionInfo.view == null) continue;
            ++n6;
        }
        float f2 = n6 > 0 ? (float)(n4 - n5) / (float)n6 : 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i3 = n2; i3 < n3 - 1; ++i3) {
            Layout.PositionInfo positionInfo = (Layout.PositionInfo)this.childPositions.get(i3);
            positionInfo.x = (int)((float)positionInfo.x + f3);
            if (!positionInfo.isVarSpace || positionInfo.isFixed || positionInfo.view == null) continue;
            VariableSpaceView variableSpaceView = (VariableSpaceView)positionInfo.view;
            variableSpaceView.setWidth(variableSpaceView.getContentWidth() + (int)(f3 += f2) - (int)f4);
            f4 = f3;
        }
        ((Layout.PositionInfo)this.childPositions.get((int)(n3 - 1))).x = (int)((float)((Layout.PositionInfo)this.childPositions.get((int)(n3 - 1))).x + f3);
        return n3;
    }

    private void verticalAlign(int n2, int n3, List<Layout.PositionInfo> list) {
        Layout.PositionInfo positionInfo;
        int n4;
        block10: for (n4 = n2; n4 < n3; ++n4) {
            positionInfo = list.get(n4);
            switch (positionInfo.vAlign) {
                case 5: 
                case 7: {
                    continue block10;
                }
                case 2: 
                case 6: 
                case 8: {
                    continue block10;
                }
                case 4: {
                    if (positionInfo.view == null) continue block10;
                    positionInfo.y = (int)((float)positionInfo.y + ((float)(this.preferredBaseline - positionInfo.baseline) - positionInfo.view.getFontSize() / 3.0f));
                    this.preferredHeight = Math.max(this.preferredHeight, positionInfo.y + positionInfo.view.getContentHeight());
                    continue block10;
                }
                case 3: {
                    if (positionInfo.view == null) continue block10;
                    positionInfo.y = (int)((float)positionInfo.y + ((float)(this.preferredBaseline - positionInfo.baseline) + positionInfo.view.getFontSize() / 3.0f));
                    this.preferredHeight = Math.max(this.preferredHeight, positionInfo.y + positionInfo.view.getContentHeight());
                    continue block10;
                }
                default: {
                    positionInfo.y += this.preferredBaseline - positionInfo.baseline;
                    if (positionInfo.view == null) continue block10;
                    this.preferredHeight = Math.max(this.preferredHeight, positionInfo.y + positionInfo.view.getContentHeight());
                }
            }
        }
        block11: for (n4 = n2; n4 < n3; ++n4) {
            positionInfo = list.get(n4);
            switch (positionInfo.vAlign) {
                case 6: 
                case 8: {
                    positionInfo.y = this.preferredHeight - positionInfo.baseline;
                    continue block11;
                }
                case 2: {
                    if (positionInfo.view == null) continue block11;
                    positionInfo.y = (int)((float)positionInfo.y + ((float)(this.preferredBaseline - positionInfo.view.getOuterHeight() / 2) - positionInfo.view.getFontSize() / 3.0f));
                }
            }
        }
    }

    @Override
    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        int n3;
        Rectangle rectangle = shape.getBounds();
        if (this.view.getVisibility() != 0) {
            throw new BadLocationException("Location is within a unvisible Element", n2);
        }
        int n4 = rectangle.x + this.view.getLeftInset();
        int n5 = rectangle.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        Shape shape2 = null;
        StackManager stackManager = ((BlockView)this.view).getPositionManager(false);
        if (stackManager != null && (shape2 = stackManager.modelToView(n2, shape, bias, 5)) != null) {
            return shape2;
        }
        boolean bl2 = false;
        boolean bl3 = this.blockView.isListItemWithMarker();
        List<Layout.PositionInfo> list = this.getChildren();
        int n6 = n3 = bl3 ? 1 : 0;
        while (n3 < list.size()) {
            Layout.PositionInfo positionInfo = list.get(n3);
            if (positionInfo.view != null) {
                boolean bl4;
                int n7 = positionInfo.view.getStartOffset();
                int n8 = positionInfo.view.getEndOffset();
                bl2 = positionInfo.view.isBreak();
                boolean bl5 = bl4 = !bl2 && n8 > n2 || bl2 && n7 == n2 || (n3 == list.size() - 1 || bias == Position.Bias.Backward) && n8 >= n2 && !bl2;
                if (n7 < n8 && n7 <= n2 && bl4) {
                    rectangle.x = positionInfo.x + n4;
                    rectangle.y = positionInfo.y + n5;
                    rectangle.width = positionInfo.view.getOuterWidth();
                    rectangle.height = positionInfo.view.getOuterHeight();
                    shape2 = positionInfo.view.modelToView(n2, rectangle, bias);
                    break;
                }
            }
            ++n3;
        }
        if (stackManager != null && shape2 == null) {
            return stackManager.modelToView(n2, shape, bias, 0);
        }
        return shape2;
    }

    private int getDistance(int n2, int n3, int n4) {
        if (n3 <= n2 && n3 + n4 >= n2) {
            return 0;
        }
        if (n2 < n3) {
            return n3 - n2;
        }
        return n2 - n3 - n4;
    }

    @Override
    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        StackManager stackManager;
        Rectangle rectangle = shape.getBounds();
        if (this.view.getVisibility() != 0) {
            return -1;
        }
        int n2 = rectangle.x + this.view.getLeftInset();
        int n3 = rectangle.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        int n4 = -1;
        Layout.PositionInfo positionInfo = null;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        StackManager stackManager2 = stackManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        if (stackManager != null && (n4 = stackManager.viewToModel(f2, f3, shape, biasArray, 5)) >= 0) {
            return n4;
        }
        boolean bl2 = this.hasMarker;
        for (Layout.PositionInfo positionInfo2 : this.getChildren()) {
            if (bl2 || positionInfo2.view == null) {
                bl2 = false;
                continue;
            }
            rectangle.setBounds(positionInfo2.x + n2, positionInfo2.y + n3, positionInfo2.view.getOuterWidth(), positionInfo2.view.getOuterHeight());
            if (rectangle.contains(new Point2D.Float(f2, f3))) {
                n4 = positionInfo2.view.viewToModel(f2, f3, rectangle, biasArray);
                break;
            }
            int n7 = this.getDistance((int)f3, rectangle.y, rectangle.height);
            int n8 = this.getDistance((int)f2, rectangle.x, rectangle.width);
            if ((n8 >= n5 || n7 != n6) && n7 >= n6) continue;
            n5 = n8;
            n6 = n7;
            positionInfo = positionInfo2;
        }
        if (n4 == -1 && stackManager != null) {
            n4 = stackManager.viewToModel(f2, f3, shape, biasArray, 0);
        }
        if (n4 == -1 && positionInfo != null && positionInfo.view != null) {
            rectangle.setBounds(positionInfo.x + n2, positionInfo.y + n3, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
            f2 = ViewUtils.mapPositionToArea((int)f2, rectangle.x, rectangle.width);
            f3 = ViewUtils.mapPositionToArea((int)f3, rectangle.y, rectangle.height);
            n4 = positionInfo.view.viewToModel(f2, f3, rectangle, biasArray);
        }
        return n4;
    }

    @Override
    public void preLayout() {
        Object object;
        this.updateBidi();
        try {
            if (!this.reflowed) {
                object = new HashMap();
                for (int i2 = 0; i2 < this.blockView.getViewCount(); ++i2) {
                    View object2 = this.blockView.getView(i2);
                    List<View> list = InlineLayout.reflow((BoxView)object2, this.blockView, this.view.getRenderContext().allowTabs());
                    if (list == null) continue;
                    ((HashMap)object).put(object2, list);
                }
                for (Map.Entry entry : ((HashMap)object).entrySet()) {
                    InlineLayout.replace((View)entry.getKey(), ((List)entry.getValue()).toArray(new View[((List)entry.getValue()).size()]));
                }
                this.reflowed = true;
            }
        }
        catch (Throwable throwable) {
            Logger.critical(throwable);
        }
        if (this.bidiList != null) {
            this.setBidiOnChildren();
        }
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.preferredBaseline = 0;
        this.minimumWidth = 0;
        this.minimumHeight = 0;
        this.width = 2146483647;
        object = this.view.getWidthUnit();
        if (object != null && !((LengthUnit)object).isAuto() && ((LengthUnit)object).isAbsolute()) {
            this.width = this.preferredWidth = Math.round(((LengthUnit)object).getValue());
        }
        int n2 = 0;
        boolean bl2 = false;
        int n3 = this.blockView.getWhiteSpace();
        boolean bl3 = n3 == 0 || n3 == 5 || n3 == 3 || n3 == 4;
        ViewIterator viewIterator = new ViewIterator();
        if (this.blockView.isListItemWithMarker()) {
            viewIterator.step();
        }
        while (viewIterator.hasNext()) {
            int n4;
            int n5;
            SegmentInfo segmentInfo = this.getSegmentSize(viewIterator, true);
            if (segmentInfo.segmentLen == 1) {
                BoxView boxView = viewIterator.peek();
                if (boxView == null || boxView.isBreak()) {
                    n2 = 0;
                    n5 = this.preferredHeight;
                    viewIterator.step();
                    continue;
                }
                if (boxView.isBlock() && boxView.isFloating()) {
                    segmentInfo.width++;
                }
            }
            if (n2 + (n4 = segmentInfo.width) > this.width && n2 > 0 && bl3) {
                n2 = 0;
                n5 = this.preferredHeight;
            }
            int n6 = n4 > 0 ? n4 : 0;
            this.minimumWidth = Math.max(this.minimumWidth, segmentInfo.minWidth);
            int n7 = this.view.getBox().getTotalWidthGain();
            this.minimumOuterWidth = this.minimumWidth + n7;
            this.preferredWidth = Math.max(this.preferredWidth, n2 += n6);
            int n8 = segmentInfo.height;
            this.preferredHeight = Math.max(this.preferredHeight, n5 + n8);
            this.minimumHeight = Math.max(this.minimumHeight, n8);
            viewIterator.step(segmentInfo.segmentLen);
        }
        this.setPreLayouted();
    }

    private void updateBidi() {
        if (this.view.getRenderContext().requiresBidiCheck()) {
            ParagraphIterator paragraphIterator = new ParagraphIterator((BlockView)this.getView());
            int n2 = paragraphIterator.getContentStart();
            int n3 = paragraphIterator.getContentEnd();
            if (this.lastSyncLen == n3 - n2) {
                return;
            }
            this.lastSyncLen = n3 - n2;
            int n4 = paragraphIterator.start;
            int n5 = paragraphIterator.end;
            int n6 = n2 - n4;
            paragraphIterator = new ParagraphIterator((BlockView)this.getView(), n2, n3);
            if (n2 < n3 && (Bidi.requiresBidi(paragraphIterator.array, paragraphIterator.offset, paragraphIterator.offset + paragraphIterator.count) || this.isBidiByAttributes())) {
                Bidi bidi = new Bidi(paragraphIterator);
                this.rtl = bidi.isRightToLeft();
                boolean bl2 = bidi.isMixed();
                if (bl2) {
                    int n7 = bidi.getRunCount();
                    this.bidiList = new LevelList(this.view.getStartOffset());
                    for (int i2 = 0; i2 < n7; ++i2) {
                        this.bidiList.add(new LevelInfo(bidi.getRunLevel(i2), bidi.getRunStart(i2) + n6, bidi.getRunLimit(i2) + n6, this.bidiList));
                    }
                    this.view.setIsNativeLTR(this.bidiList.isPrimaryLTR());
                    this.bidiList.compile();
                    if (this.view.getDirection() == 1) {
                        if (n4 < n2) {
                            this.bidiList.add(0, new LevelInfo(1, 0, n6, this.bidiList));
                        }
                        if (n5 > n3) {
                            this.bidiList.add(new LevelInfo(1, n3 - n4, n5 - n4, this.bidiList));
                        }
                        this.bidiList.compile();
                    }
                } else {
                    this.view.setIsNativeLTR(!this.rtl);
                }
            }
        }
    }

    private boolean isBidiByAttributes() {
        int n2 = this.view.getStartOffset();
        int n3 = this.view.getEndOffset();
        while (n2 < n3) {
            BoxView boxView = ViewUtils.getLeafView((BlockView)this.view, n2, true);
            if (boxView == null) {
                ++n2;
                continue;
            }
            if (boxView.getDirection() == 1 && boxView.getUnicodeBidi() != 0) {
                return true;
            }
            n2 = boxView.getEndOffset();
        }
        return false;
    }

    private void setBidiOnChildren() {
        if (this.bidiList == null && !this.rtl) {
            return;
        }
        int n2 = this.view.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            BoxView boxView = (BoxView)this.view.getView(i2);
            if (this.bidiList != null) {
                boxView.setIsNativeLTR(this.bidiList.getLevel(boxView) % 2 == 0);
                continue;
            }
            boxView.setIsNativeLTR(false);
        }
    }

    @Override
    public void predictWidth(int n2) {
        this.width = n2;
        this.currentWidth = n2;
    }

    @Override
    public void layoutVerticalAlign(int n2, int n3) {
        int n4 = this.view.getContentHeight();
        int n5 = n4 - this.contentHeight;
        if (n5 > 0) {
            switch (n2) {
                case 8: {
                    this.view.setContentVerticalOffset(n5);
                    break;
                }
                case 2: {
                    this.view.setContentVerticalOffset(n5 / 2);
                    break;
                }
                case 7: {
                    this.view.setContentVerticalOffset(0);
                    break;
                }
            }
        } else {
            this.view.setContentVerticalOffset(0);
        }
    }

    public void resetPreLayouted() {
        this.reflowed = false;
    }

    public static List<View> reflow(BoxView boxView, BlockView blockView, boolean bl2) throws BadLocationException {
        Object object = boxView.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (boxView instanceof ContentView && !(boxView instanceof InsertedContentView) && !(boxView instanceof VariableSpaceView) && object != null && object == HTML.Tag.CONTENT) {
            int n2;
            Object object222;
            Object object3;
            ArrayList<View> arrayList = new ArrayList<View>();
            if (blockView == null) {
                arrayList.add(boxView);
                return arrayList;
            }
            int n4 = boxView.getStartOffset();
            int n5 = boxView.getEndOffset();
            InetHtmlFactory inetHtmlFactory = (InetHtmlFactory)blockView.getViewFactory();
            Element element = boxView.getElement();
            Element element2 = blockView.getElement();
            if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
                element2 = element2.getParentElement();
            }
            ArrayList<Object> arrayList2 = null;
            while (element != element2 && element.getStartOffset() == n4) {
                object3 = inetHtmlFactory.createSpace(element, 1);
                ((VariableSpaceView)object3).setParent(blockView);
                ((VariableSpaceView)object3).setStartAndEndOffset(n4, n4);
                if (((VariableSpaceView)object3).getContentWidth() > 0) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Object>();
                    }
                    arrayList2.add(object3);
                }
                element = element.getParentElement();
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                Collections.reverse(arrayList2);
                for (Object object222 : arrayList2) {
                    arrayList.add((View)object222);
                }
            }
            arrayList2 = null;
            object3 = null;
            if (blockView.getLayout() instanceof InlineLayout) {
                object222 = (InlineLayout)blockView.getLayout();
                super.updateBidi();
                object3 = ((InlineLayout)object222).bidiList;
            }
            object222 = new Segment();
            boxView.getDocument().getText(n4, n5 - n4, (Segment)object222);
            Container container = blockView.getContainer();
            BreakIterator breakIterator = container != null ? BreakIterator.getWordInstance(container.getLocale()) : BreakIterator.getWordInstance();
            breakIterator.setText((CharacterIterator)object222);
            if (object3 != null) {
                breakIterator = new BidiDualIterator(breakIterator, (LevelList)object3, n4, n5 - n4);
            }
            int n6 = breakIterator.first();
            int n7 = n4 - n6;
            int n8 = breakIterator.next();
            while (n8 != -1) {
                char c2 = ((Segment)object222).array[n6];
                n2 = ((Segment)object222).array[n8 - 1];
                int n3 = InlineLayout.getContentLength(((Segment)object222).array, n6, n8);
                if (n3 > 0) {
                    if (c2 == '\u00a0' || n2 == 160) {
                        VariableSpaceView view = inetHtmlFactory.createSpace(boxView.getElement(), false);
                        view.setParent(blockView);
                        view.setStartAndEndOffset(n6 + n7, n8 + n7);
                        view.setPre(true);
                        view.setBreakable(true);
                        arrayList.add(view);
                    } else {
                        if (boxView.getParent() == null) {
                            boxView.setParent(blockView);
                        }
                        View variableSpaceView = boxView.createFragment(n6 + n7, n6 + n3 + n7);
                        arrayList.add(variableSpaceView);
                        if (n3 == 1 && variableSpaceView.getClass() == ContentView.class && Arrays.binarySearch(BREAK_CHARS, c2) >= 0) {
                            ((ContentView)variableSpaceView).setBreakable(true);
                        }
                        ((ContentView)variableSpaceView).setCJKType(InlineLayout.getCJKType(((Segment)object222).array, n6));
                    }
                } else {
                    boolean bl3;
                    boolean bl4 = bl3 = n2 == 10 || n2 == 13;
                    if (bl3 && n8 - n6 > 1) {
                        VariableSpaceView variableSpaceView = inetHtmlFactory.createSpace(boxView.getElement(), false);
                        variableSpaceView.setParent(blockView);
                        variableSpaceView.setStartAndEndOffset(n6 + n7, n8 + n7 - 1);
                        variableSpaceView.setPre(true);
                        variableSpaceView.setBreakable(true);
                        arrayList.add(variableSpaceView);
                        variableSpaceView = inetHtmlFactory.createSpace(boxView.getElement(), true);
                        variableSpaceView.setParent(blockView);
                        variableSpaceView.setStartAndEndOffset(n8 + n7 - 1, n8 + n7);
                        arrayList.add(variableSpaceView);
                    } else {
                        boolean bl5;
                        int n9 = n6;
                        boolean bl6 = bl5 = n8 - n6 > 1;
                        if (bl2) {
                            while (n6 < n8) {
                                VariableSpaceView variableSpaceView;
                                char c3 = ((Segment)object222).array[n6];
                                ++n6;
                                if (c3 != '\t') continue;
                                if (n6 - n9 > 1) {
                                    variableSpaceView = InlineLayout.createSpace(boxView, blockView, inetHtmlFactory, n9 + n7, n6 - 1 + n7, bl5, bl3);
                                    variableSpaceView.setBreakable(true);
                                    arrayList.add(variableSpaceView);
                                }
                                variableSpaceView = InlineLayout.createSpace(boxView, blockView, inetHtmlFactory, n6 - 1 + n7, n6 + n7, bl5, bl3);
                                variableSpaceView.setTab(true);
                                arrayList.add(variableSpaceView);
                                n9 = n6;
                            }
                        }
                        if (n9 < n8) {
                            VariableSpaceView variableSpaceView = InlineLayout.createSpace(boxView, blockView, inetHtmlFactory, n9 + n7, n8 + n7, bl5, bl3);
                            variableSpaceView.setBreakable(true);
                            arrayList.add(variableSpaceView);
                        }
                    }
                }
                n6 = n8;
                n8 = breakIterator.next();
            }
            n8 = breakIterator.last();
            if (n6 < n8) {
                int arrayList3 = breakIterator.last();
                n2 = arrayList3 - n6;
                int n10 = InlineLayout.getContentLength(((Segment)object222).array, n6 + n7, arrayList3 + n7);
                if (n10 > 0) {
                    if (boxView.getParent() != null) {
                        boxView.setParent(blockView);
                    }
                    View view = boxView.createFragment(n6 + n7, n6 + n10 + n7);
                    arrayList.add(view);
                }
                if (n10 != n2) {
                    VariableSpaceView variableSpaceView = inetHtmlFactory.createSpace(boxView.getElement(), false);
                    variableSpaceView.setParent(blockView);
                    variableSpaceView.setStartAndEndOffset(n6 + n7 + n10, arrayList3 + n7);
                    arrayList.add(variableSpaceView);
                }
            }
            ArrayList<VariableSpaceView> arrayList3 = new ArrayList<VariableSpaceView>();
            for (element = boxView.getElement(); element != element2 && element.getEndOffset() == n5; element = element.getParentElement()) {
                VariableSpaceView variableSpaceView = inetHtmlFactory.createSpace(element, 3);
                variableSpaceView.setParent(blockView);
                variableSpaceView.setStartAndEndOffset(n5, n5);
                if (variableSpaceView.getContentWidth() <= 0) continue;
                arrayList3.add(variableSpaceView);
            }
            if (arrayList3.size() > 0) {
                for (BoxView boxView2 : arrayList3) {
                    arrayList.add(boxView2);
                }
            }
            Object var18_21 = null;
            return arrayList;
        }
        if (boxView.getParent() == null) {
            boxView.setParent(blockView);
        }
        boxView.performPreLayout();
        return null;
    }

    private static int getCJKType(char[] cArray, int n2) {
        int n3 = Character.codePointAt(cArray, n2);
        if (n3 < 4352) {
            return 0;
        }
        if (n3 >= 12288 && n3 <= 12351 || n3 == 65292) {
            return 1;
        }
        if (n3 >= 4352 && n3 <= 4607) {
            return 2;
        }
        if (n3 >= 12352 && n3 <= 12687) {
            return 2;
        }
        if (n3 >= 13312 && n3 <= 19903) {
            return 2;
        }
        if (n3 >= 19456 && n3 <= 55215) {
            return 2;
        }
        if (n3 >= 131072 && n3 <= 173791) {
            return 2;
        }
        if (n3 >= 173824 && n3 <= 177983) {
            return 2;
        }
        if (n3 >= 177984 && n3 <= 178207) {
            return 2;
        }
        if (n3 >= 178208 && n3 <= 194559) {
            return 2;
        }
        return 0;
    }

    private static VariableSpaceView createSpace(BoxView boxView, BoxView boxView2, InetHtmlFactory inetHtmlFactory, int n2, int n3, boolean bl2, boolean bl3) {
        VariableSpaceView variableSpaceView = inetHtmlFactory.createSpace(boxView.getElement(), bl3);
        variableSpaceView.setBreakable(true);
        variableSpaceView.setParent(boxView2);
        variableSpaceView.setPre(bl2);
        variableSpaceView.setStartAndEndOffset(n2, bl2 ? n3 : n2 + 1);
        return variableSpaceView;
    }

    private static int getContentLength(char[] cArray, int n2, int n3) {
        if (n2 >= n3) {
            return 0;
        }
        n3 = n3 > cArray.length ? cArray.length : n3;
        char c2 = cArray[n2];
        while (c2 <= ' ' && ++n2 < n3) {
            c2 = cArray[n2];
        }
        c2 = cArray[n3 - 1];
        while (n2 < n3 && c2 <= ' ') {
            c2 = cArray[--n3 - 1];
        }
        return n3 - n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentInfo getSegmentSize(ViewIterator viewIterator, boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        viewIterator.freeze();
        try {
            boolean bl3;
            if (!viewIterator.hasNext()) {
                SegmentInfo segmentInfo = new SegmentInfo(1, 0, 0, 0, null);
                return segmentInfo;
            }
            BoxView boxView = viewIterator.next();
            boolean bl4 = boxView == null || boxView.isInFlow();
            boolean bl5 = bl3 = boxView == null || !(boxView instanceof ContentView) || !((ContentView)boxView).isBreakable();
            if (boxView != null && (bl2 && boxView.isAbsolutePositioned() || !bl2 && !boxView.isInFlow())) {
                SegmentInfo segmentInfo = new SegmentInfo(1, 0, 0, 0, null);
                return segmentInfo;
            }
            do {
                int n6;
                int n7;
                Object object;
                int n8;
                if (boxView == null) {
                    ++n5;
                    if (!viewIterator.hasNext()) break;
                    continue;
                }
                int n9 = n8 = boxView instanceof ContentView ? ((ContentView)boxView).getCJKType() : 0;
                if (n8 >= 2 && n5 > 0) break;
                n2 = Math.max(n2, (int)boxView.getPreferredSpan(1));
                if (boxView instanceof ILayouted) {
                    object = ((ILayouted)((Object)boxView)).getLayout();
                    n7 = (int)((Layout)object).getPreferredSpan(0);
                    n6 = (int)((Layout)object).getMinimumSpan(0);
                } else {
                    n7 = (int)boxView.getPreferredSpan(0);
                    n6 = (int)boxView.getMinimumSpan(0);
                }
                object = boxView.getBox().getMargins();
                int n10 = boxView.getLeftInset() + boxView.getRightInset() + ((Insets)object).left + ((Insets)object).right;
                n4 += (n6 += n10);
                n3 += (n7 += n10);
                if (++n5 == 1 && boxView instanceof ContentView && ((ContentView)boxView).isBreakable()) {
                    boxView = null;
                    break;
                }
                if (!viewIterator.hasNext()) {
                    boxView = null;
                    break;
                }
                boxView = viewIterator.next();
                if (n8 == 1) break;
                if (n8 == 2) {
                    int n11 = n8 = boxView instanceof ContentView ? ((ContentView)boxView).getCJKType() : 0;
                    if (n8 != 1) break;
                }
                bl4 = boxView == null || boxView.isInFlow();
                boolean bl6 = bl3 = boxView == null || !boxView.isBreakable();
            } while (viewIterator.hasNext() && bl4 && bl3);
            SegmentInfo segmentInfo = new SegmentInfo(n5, n3, n4, n2, boxView);
            return segmentInfo;
        }
        finally {
            viewIterator.unfreeze();
        }
    }

    @Override
    public ViewPositionInfo getViewForPosition(Point point, Rectangle rectangle) {
        StackManager stackManager;
        Rectangle rectangle2 = rectangle.getBounds();
        if (this.view.getVisibility() != 0) {
            return null;
        }
        int n2 = rectangle2.x + this.view.getLeftInset();
        int n3 = rectangle2.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        ViewPositionInfo viewPositionInfo = null;
        StackManager stackManager2 = stackManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        if (stackManager != null && (viewPositionInfo = stackManager.getViewForPosition(point, rectangle, 5)) != null) {
            return viewPositionInfo;
        }
        for (Layout.PositionInfo positionInfo : this.getChildren()) {
            if (positionInfo.view == null) continue;
            rectangle2.setBounds(positionInfo.x + n2, positionInfo.y + n3, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
            if (!rectangle2.contains(point)) continue;
            viewPositionInfo = positionInfo.view.getViewForPosition(point, rectangle2);
            if (viewPositionInfo == null) {
                return new ViewPositionInfo(rectangle2, positionInfo.view);
            }
            return viewPositionInfo;
        }
        if (stackManager != null && (viewPositionInfo = stackManager.getViewForPosition(point, rectangle, 0)) != null) {
            return viewPositionInfo;
        }
        return null;
    }

    @Override
    public Rectangle getSpan() {
        return this.span;
    }

    private static class BidiDualIterator
    extends BreakIterator {
        private int currentBase;
        private int currentLevel;
        private int currentIndex;
        private int offset;
        private int startIndex;
        private final LevelList levels;
        private final BreakIterator base;
        private final int length;
        private int baseOffset = 0;

        public BidiDualIterator(BreakIterator breakIterator, LevelList levelList, int n2, int n3) {
            this.base = breakIterator;
            this.levels = levelList;
            this.length = n3;
            this.startIndex = 0;
            while (this.startIndex < levelList.size() && n2 >= ((LevelInfo)levelList.get(this.startIndex)).end + levelList.offset) {
                ++this.startIndex;
            }
            this.offset = n2;
            if (breakIterator.getText().getBeginIndex() == 0) {
                this.baseOffset = n2;
                this.offset = 0;
            }
        }

        public int first() {
            this.currentBase = this.base.first();
            this.currentIndex = this.startIndex - 1;
            this.nextLevel();
            return this.current();
        }

        public int last() {
            this.currentBase = this.base.last();
            this.currentLevel = -1;
            this.currentIndex = this.levels.size() - 1;
            while (this.currentIndex >= 0) {
                int n2 = ((LevelInfo)this.levels.get(this.currentIndex)).end + this.levels.offset - this.baseOffset;
                if (n2 > this.offset && n2 < this.offset + this.length) {
                    this.currentLevel = n2;
                    break;
                }
                --this.currentIndex;
            }
            return Math.max(this.currentBase, this.currentLevel);
        }

        public int next(int n2) {
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = this.next();
                if (n3 != -1) continue;
                return n3;
            }
            return n3;
        }

        public int next() {
            if (this.currentBase == -1) {
                return this.nextLevel();
            }
            if (this.currentBase == this.currentLevel) {
                this.nextBase();
                this.nextLevel();
            } else if (this.currentBase < this.currentLevel || this.currentLevel == -1) {
                this.nextBase();
            } else if (this.currentLevel != -1) {
                this.nextLevel();
            }
            return this.current();
        }

        private int nextBase() {
            this.currentBase = this.base.next();
            return this.currentBase;
        }

        private int nextLevel() {
            if (this.currentLevel != -1) {
                ++this.currentIndex;
                if (this.currentIndex < this.levels.size()) {
                    this.currentLevel = ((LevelInfo)this.levels.get(this.currentIndex)).end + this.levels.offset - this.baseOffset;
                    if (this.currentLevel >= this.length + this.offset) {
                        this.currentLevel = -1;
                    }
                } else {
                    this.currentLevel = -1;
                }
            }
            return this.currentLevel;
        }

        public int previous() {
            throw new IllegalStateException("previous cannot be used on the dual iterator");
        }

        public int following(int n2) {
            throw new IllegalStateException("following cannot be used on the dual iterator");
        }

        public int current() {
            if (this.currentBase == -1) {
                return this.currentLevel;
            }
            if (this.currentLevel == -1) {
                return this.currentBase;
            }
            return Math.min(this.currentBase, this.currentLevel);
        }

        public CharacterIterator getText() {
            return this.base.getText();
        }

        public void setText(CharacterIterator characterIterator) {
            throw new IllegalStateException("setText cannot be used on the dual iterator");
        }
    }

    private class ViewIterator {
        private int position;
        private BoxView stack;
        private int positionFreeze;
        private BoxView stackFreeze;

        private ViewIterator() {
        }

        public boolean hasNext() {
            return this.stack != null || this.position < InlineLayout.this.view.getViewCount();
        }

        public BoxView next() {
            if (this.stack != null) {
                BoxView boxView = this.stack;
                this.stack = null;
                return boxView;
            }
            return (BoxView)InlineLayout.this.view.getView(this.position++);
        }

        public BoxView peek() {
            return this.stack != null ? this.stack : (this.position < InlineLayout.this.view.getViewCount() ? (BoxView)InlineLayout.this.view.getView(this.position) : null);
        }

        public void step() {
            if (this.stack != null) {
                this.stack = null;
            } else {
                ++this.position;
            }
        }

        public void step(int n2) {
            if (this.stack != null) {
                --n2;
                this.stack = null;
            }
            this.position += n2;
        }

        public void freeze() {
            this.positionFreeze = this.position;
            this.stackFreeze = this.stack;
        }

        public void unfreeze() {
            this.position = this.positionFreeze;
            this.stack = this.stackFreeze;
        }

        public void push(BoxView boxView) {
            this.stack = boxView;
        }
    }

    private static class LevelInfo {
        private int level;
        private int start;
        private int end;
        private final LevelList parent;

        public LevelInfo(int n2, int n3, int n4, LevelList levelList) {
            this.level = n2;
            this.start = n3;
            this.end = n4;
            this.parent = levelList;
        }

        public LevelInfo copy(LevelList levelList) {
            return new LevelInfo(this.level, this.start, this.end, levelList);
        }

        public boolean isInRange(BoxView boxView) {
            int n2 = this.parent != null ? this.parent.offset : 0;
            return this.start + n2 <= boxView.getStartOffset() && this.end + n2 >= boxView.getEndOffset();
        }

        public String toString() {
            return "Bidi-level " + this.level + ", location(" + this.start + ":" + this.end + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LevelList
    extends ArrayList<LevelInfo> {
        private static final long serialVersionUID = 1L;
        private int maxLevel = 0;
        private boolean[] levelUsed;
        private final int offset;

        public LevelList(int n2) {
            this.offset = n2;
        }

        @Override
        public boolean add(LevelInfo levelInfo) {
            this.maxLevel = Math.max(this.maxLevel, levelInfo.level);
            return super.add(levelInfo);
        }

        public void compile() {
            int n2;
            int n3;
            if (this.levelUsed == null) {
                this.levelUsed = new boolean[this.maxLevel + 1];
                for (LevelInfo levelInfo : this) {
                    this.levelUsed[((LevelInfo)levelInfo).level] = true;
                }
            }
            boolean bl2 = true;
            for (n3 = 0; n3 < this.levelUsed.length; ++n3) {
                bl2 = bl2 && this.levelUsed[n3];
            }
            if (bl2) {
                return;
            }
            n3 = 0;
            for (n2 = this.maxLevel; n2 > 1; --n2) {
                if (this.levelUsed[n2 - 1]) continue;
                for (Object object : this) {
                    if (((LevelInfo)object).level != n2) continue;
                    ((LevelInfo)object).level -= 2;
                    n3 = 1;
                }
            }
            if (n3 == 0) {
                n2 = -1;
                boolean bl3 = false;
                for (LevelInfo levelInfo2 : this) {
                    if (n2 == levelInfo2.level) {
                        bl3 = true;
                        break;
                    }
                    n2 = levelInfo2.level;
                }
                if (!bl3) {
                    return;
                }
            } else {
                this.levelUsed = new boolean[this.maxLevel + 1];
                for (Object object : this) {
                    this.levelUsed[((LevelInfo)object).level] = true;
                }
            }
            ArrayList<LevelInfo> arrayList = new ArrayList<LevelInfo>(this.size());
            LevelInfo levelInfo = null;
            for (LevelInfo levelInfo2 : this) {
                if (levelInfo == null) {
                    levelInfo = levelInfo2;
                    arrayList.add(levelInfo2);
                    continue;
                }
                if (levelInfo.level == levelInfo2.level) {
                    levelInfo.end = levelInfo2.end;
                    continue;
                }
                arrayList.add(levelInfo2);
                levelInfo = levelInfo2;
            }
            this.clear();
            this.addAll(arrayList);
        }

        public List<LevelInfo> getRuns(int n2, int n3, int n4) {
            if (this.levelUsed != null && !this.levelUsed[n2]) {
                return null;
            }
            n3 -= this.offset;
            n4 -= this.offset;
            ArrayList<LevelInfo> arrayList = new ArrayList<LevelInfo>();
            LevelInfo levelInfo = null;
            for (LevelInfo levelInfo2 : this) {
                if (levelInfo2.end < n3) continue;
                if (levelInfo2.start > n4) break;
                if (levelInfo2.level >= n2) {
                    if (levelInfo == null) {
                        levelInfo = levelInfo2.copy(this);
                        continue;
                    }
                    levelInfo.end = levelInfo2.end;
                    continue;
                }
                if (levelInfo == null) continue;
                arrayList.add(levelInfo);
                levelInfo = null;
            }
            if (levelInfo != null) {
                arrayList.add(levelInfo);
            }
            return arrayList;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public boolean isPrimaryLTR() {
            if (this.levelUsed == null) {
                this.levelUsed = new boolean[this.maxLevel + 1];
                for (LevelInfo levelInfo : this) {
                    this.levelUsed[((LevelInfo)levelInfo).level] = true;
                }
            }
            for (int i2 = 0; i2 < this.maxLevel; ++i2) {
                if (!this.levelUsed[i2]) continue;
                return i2 % 2 == 0;
            }
            return true;
        }

        public int getLevel(View view) {
            int n2 = view.getStartOffset() - this.offset;
            for (LevelInfo levelInfo : this) {
                if (n2 < levelInfo.start) continue;
                return levelInfo.level;
            }
            return this.isPrimaryLTR() ? 0 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParagraphIterator
    extends Segment
    implements AttributedCharacterIterator {
        private final BlockView block;
        private Set<AttributedCharacterIterator.Attribute> set;
        private int start;
        private int end;
        private Document doc;
        private static final NumericShaper SHAPER = NumericShaper.getShaper(1);

        public ParagraphIterator(BlockView blockView) {
            this(blockView, blockView.getStartOffset(), blockView.getEndOffset());
        }

        public ParagraphIterator(BlockView blockView, int n2, int n3) {
            this.block = blockView;
            this.start = n2;
            this.end = n3;
            try {
                this.doc = this.block.getDocument();
                this.doc.getText(this.start, Math.max(0, this.end - this.start), this);
            }
            catch (BadLocationException badLocationException) {
                Logger.error(badLocationException);
            }
        }

        public int getContentStart() {
            int n2;
            for (n2 = this.offset; n2 < this.array.length - 1 && Character.isWhitespace(this.array[n2]); ++n2) {
            }
            return n2 + (this.start - this.offset);
        }

        public int getContentEnd() {
            int n2;
            for (n2 = this.offset + this.count; n2 > 0 && Character.isWhitespace(this.array[n2 - 1]); --n2) {
            }
            return n2 + (this.start - this.offset);
        }

        private Set<AttributedCharacterIterator.Attribute> getSet() {
            if (this.set == null) {
                this.set = new HashSet<AttributedCharacterIterator.Attribute>();
                this.set.add(TextAttribute.BIDI_EMBEDDING);
                this.set.add(TextAttribute.RUN_DIRECTION);
            }
            return this.set;
        }

        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            return this.getSet();
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            AtomicInteger atomicInteger = new AtomicInteger();
            Element element = this.getLeafView(this.block, this.getIndex(), atomicInteger);
            if (attribute == TextAttribute.BIDI_EMBEDDING) {
                return atomicInteger.get();
            }
            if (attribute == TextAttribute.NUMERIC_SHAPING) {
                return SHAPER;
            }
            if (attribute == TextAttribute.RUN_DIRECTION) {
                return StyleResolver.getAttributeValue(element, AttributeFinder.DIRECTION).getValue() == 0 ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            }
            return null;
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>(2);
            for (AttributedCharacterIterator.Attribute attribute : this.getSet()) {
                hashMap.put(attribute, this.getAttribute(attribute));
            }
            return hashMap;
        }

        private Element getLeafView(BlockView blockView, int n2, AtomicInteger atomicInteger) {
            int n3;
            Element element;
            int n4 = 0;
            for (element = blockView.getElement(); element != null && !element.isLeaf(); element = element.getElement(n3)) {
                byte by2 = StyleResolver.getAttributeValue(element, AttributeFinder.UNICODEBIDI).getValue();
                byte by3 = StyleResolver.getAttributeValue(element, AttributeFinder.DIRECTION).getValue();
                n4 = Math.abs(n4);
                if (by2 != 0) {
                    n4 = by3 == 0 ? n4 + 2 - n4 % 2 : n4 + 1 + n4 % 2;
                    if (by2 == 2) {
                        n4 = -n4;
                    }
                }
                if ((n3 = element.getElementIndex(n2)) >= 0) {
                    continue;
                }
                return element;
            }
            if (atomicInteger != null) {
                atomicInteger.set(n4);
            }
            return element;
        }

        private int getBidiStatus(int n2) {
            AtomicInteger atomicInteger = new AtomicInteger();
            this.getLeafView(this.block, n2, atomicInteger);
            return atomicInteger.get();
        }

        @Override
        public int getRunLimit() {
            int n2;
            int n3 = this.getEndIndex();
            int n4 = this.getIndex();
            int n5 = n2 = this.getBidiStatus(n4);
            while (n2 == n5 && n4 < n3) {
                n5 = this.getBidiStatus(++n4);
            }
            return n4;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            return this.getRunLimit();
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> set) {
            return this.getRunLimit();
        }

        @Override
        public int getRunStart() {
            int n2;
            int n3 = this.block.getStartOffset();
            int n4 = this.getIndex();
            int n5 = n2 = this.getBidiStatus(n4);
            while (n2 == n5 && n4 > n3) {
                n5 = this.getBidiStatus(--n4);
            }
            return n4;
        }

        @Override
        public Object clone() {
            return new ParagraphIterator(this.block);
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            return this.getRunStart();
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> set) {
            return this.getRunStart();
        }
    }

    private class SegmentInfo {
        private int width;
        private int height;
        private int segmentLen;
        private View next;
        private int minWidth;

        public SegmentInfo(int n2, int n3, int n4, int n5, View view) {
            this.width = n3;
            this.minWidth = n4;
            this.height = n5;
            this.segmentLen = n2;
            this.next = view;
        }
    }
}

