/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.MinMaxControl;
import com.inet.html.views.VariableSpaceView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.ILayouted;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Layout {
    private static final Font FALLBACK_FONT = new Font("Sans Serif", 0, 12);
    public static final int MARKER_OFFSET = (int)new LengthUnit("7pt").getValue();
    protected final BoxView view;
    protected int width;
    protected int preferredWidth;
    protected int preferredHeight;
    protected int minimumOuterWidth;
    protected int minimumOuterHeight;
    protected int minimumWidth;
    protected int minimumHeight;
    protected int currentTop;
    protected int currentLeft;
    protected int currentWidth;
    protected int currentHeight;
    protected List<PositionInfo> childPositions = new ArrayList<PositionInfo>();
    private boolean isPreLayouted = false;
    private MinMaxControl minMaxControl;

    public Layout(BoxView boxView) {
        this.view = boxView;
        this.minMaxControl = new MinMaxControl(boxView);
        if (!this.minMaxControl.hasWHConstraint()) {
            this.minMaxControl = null;
        }
    }

    public float getCurrentSpan(int n2) {
        if (n2 == 0) {
            return this.preferredWidth;
        }
        return this.preferredHeight;
    }

    public float getPreferredSpan(int n2) {
        if (n2 == 0) {
            return this.preferredWidth;
        }
        return this.preferredHeight;
    }

    public float getMinimumSpan(int n2) {
        if (n2 == 0) {
            return this.minimumWidth;
        }
        return this.minimumHeight;
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public void getChildAllocation(int n2, Rectangle rectangle) {
        PositionInfo positionInfo = this.childPositions.get(n2);
        rectangle.setLocation(positionInfo.x, positionInfo.y);
        rectangle.setSize(positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
    }

    public List<PositionInfo> getChildren() {
        return this.childPositions;
    }

    public int getViewCount() {
        return this.childPositions.size();
    }

    public abstract void preLayout();

    public abstract Rectangle layout(boolean var1);

    public void layoutWidth() {
        this.calculateCollapsedMargins();
        this.width = this.adjustWidth();
        this.setCurrentWidth(this.width);
        this.view.setContentWidth(this.width);
    }

    protected abstract void calculateCollapsedMargins();

    protected boolean isReadjustRequired() {
        if (this.view.getWidthUnit() == null && !this.view.isInFlow()) {
            if (this.view.getParent() != null && this.view.getParent() instanceof BlockView) {
                int n2 = ((BlockView)this.view.getParent()).getLayout().getCurrentWidth();
                if (n2 > this.preferredWidth) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected int adjustHeight() {
        LengthUnit lengthUnit = this.view.getHeightUnit();
        if (lengthUnit == null || lengthUnit.isAuto()) {
            return Integer.MIN_VALUE;
        }
        if (lengthUnit.isAbsolute()) {
            return Math.round(lengthUnit.getValue());
        }
        if (lengthUnit.getType() != 1) {
            return Math.round(lengthUnit.calculateValue(1.0f, this.view));
        }
        float f2 = 1.0f;
        switch (this.view.getPosition()) {
            case 3: {
                f2 = this.view.getRenderContext().getViewportHeight();
                break;
            }
            case 2: {
                return Integer.MIN_VALUE;
            }
            default: {
                BoxView boxView = Layout.getHeightParent(this.view);
                if (this.hasDefinedHeight(boxView)) {
                    f2 = Layout.getHeight(this.view, boxView, false);
                    break;
                }
                return Integer.MIN_VALUE;
            }
        }
        if (f2 >= 0.0f) {
            return Math.round(lengthUnit.calculateValue(f2, this.view));
        }
        return Integer.MIN_VALUE;
    }

    private boolean hasDefinedHeight(BoxView boxView) {
        if (boxView != null) {
            return boxView.getHeightUnit() != null && !boxView.getHeightUnit().isAuto();
        }
        return true;
    }

    public static BoxView getHeightParent(BoxView boxView) {
        boolean bl2;
        View view = boxView.getParent();
        boolean bl3 = bl2 = boxView.getPosition() == 2;
        while (view instanceof BoxView) {
            BoxView boxView2 = (BoxView)view;
            if (boxView2.getPosition() == 2 || boxView2.getPosition() == 3 || bl2 && boxView2.getPosition() == 1) {
                return boxView2;
            }
            if (!bl2) {
                if (boxView2.getHeightUnit() != null && boxView2.getHeightUnit().getType() != -1) {
                    return boxView2;
                }
                if (((InetHtmlDocument)boxView.getDocument()).getDocType().isHTML4OrHigher()) {
                    return view instanceof BoxView ? (BoxView)view : null;
                }
            }
            view = view.getParent();
        }
        return null;
    }

    public static int getHeight(BoxView boxView, BoxView boxView2, boolean bl2) {
        if (boxView2 != null) {
            int n2 = boxView2 instanceof ILayouted ? ((ILayouted)((Object)boxView2)).getLayout().getCurrentHeight() : boxView2.getContentHeight();
            return n2 + (bl2 ? boxView2.getBox().getPadding().top + boxView2.getBox().getPadding().bottom : 0);
        }
        return Layout.getRootHeight(boxView);
    }

    private static int getRootHeight(BoxView boxView) {
        HtmlRootView htmlRootView = boxView.getHTMLRoot();
        int n2 = boxView.getRenderContext().getTextContainer() != null ? boxView.getRenderContext().getViewportHeight() : htmlRootView.getContentHeight();
        n2 -= htmlRootView.getBox().getTotalHeightGain();
        if (htmlRootView.getViewCount() > 0) {
            BoxView boxView2 = (BoxView)htmlRootView.getView(0);
            n2 -= boxView2.getBox().getTotalHeightGain();
        }
        return n2;
    }

    protected int adjustWidth() {
        int n2;
        IBoxPainter iBoxPainter = this.view.getBox();
        LengthUnit lengthUnit = this.view.getWidthUnit();
        int n3 = 0;
        View view = this.view.getParent();
        if (view instanceof ILayouted) {
            ILayouted iLayouted = (ILayouted)((Object)view);
            n3 = iLayouted.getLayout().getCurrentWidth();
        } else if (view instanceof BoxView) {
            n3 = ((BoxView)view).getContentWidth();
        } else {
            return this.view.getContentWidth();
        }
        this.getView().getBox().updateRelativeValues(n3);
        int n4 = lengthUnit != null && lengthUnit.getType() != -1 ? (lengthUnit.isAbsolute() ? Math.round(lengthUnit.getValue()) : Math.round(lengthUnit.calculateValue(n3, this.view))) : (this.view instanceof BlockView && (this.view.isFloating() || this.view.isAbsolutePositioned()) ? (view instanceof BlockView ? (n3 > this.preferredWidth + 1 ? this.preferredWidth + 1 : n3) : n3) : (view instanceof BlockView && this.view.isBlock() ? ((n2 = n3 - iBoxPainter.getTotalWidthGain()) < this.minimumWidth && this.view.isTableCell() ? this.minimumWidth : n2) : this.preferredWidth));
        if (this.minMaxControl == null) {
            return n4;
        }
        return this.minMaxControl.getMinMaxValues((boolean)true, (int)n4, (int)0).width;
    }

    protected View getLeafViewAtPosition(int n2) {
        BoxView boxView = this.view;
        return this.getLeafViewAtPosition(boxView, n2);
    }

    private View getLeafViewAtPosition(View view, int n2) {
        int n3 = view.getViewCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            View view2 = view.getView(i2);
            if (view2.getStartOffset() >= n2 || n2 >= view2.getEndOffset()) continue;
            return this.getLeafViewAtPosition(view2, n2);
        }
        return view;
    }

    public static void replace(View view, View[] viewArray) {
        int n2;
        View view2 = view.getParent();
        int n3 = view2.getViewCount();
        if (viewArray != null && viewArray.length == 1 && view == viewArray[0] && view2 == viewArray[0].getParent()) {
            return;
        }
        for (n2 = 0; n2 < n3 && view != view2.getView(n2); ++n2) {
        }
        if (n2 >= n3) {
            return;
        }
        view2.replace(n2, 1, viewArray);
    }

    public PositionInfo getChildPosition(BoxView boxView) {
        for (PositionInfo positionInfo : this.childPositions) {
            if (positionInfo.view != boxView) continue;
            return positionInfo;
        }
        return null;
    }

    public BoxView getView() {
        return this.view;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public int getCurrentTop() {
        return this.currentTop;
    }

    public int getCurrentLeft() {
        return this.currentLeft;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public boolean isPreLayouted() {
        return this.isPreLayouted;
    }

    public void setPreLayouted() {
        this.isPreLayouted = true;
    }

    public void setCurrentHeight(int n2) {
        this.currentHeight = n2;
    }

    public void setCurrentWidth(int n2) {
        this.currentWidth = n2;
    }

    public abstract void predictWidth(int var1);

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.view.toString();
    }

    public abstract void layoutVerticalAlign(int var1, int var2);

    public abstract ViewPositionInfo getViewForPosition(Point var1, Rectangle var2);

    protected View getChild(BoxView boxView, boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = boxView.getViewCount();
        if (bl2) {
            if (boxView.isListItemWithMarker()) {
                n2 = 1;
            }
        } else {
            if (boxView.isListItemWithMarker()) {
                n3 = 1;
            }
            n2 = n5 - 1;
            n4 = -1;
        }
        for (int i2 = n2; i2 >= n3 && i2 < n5; i2 += n4) {
            View view = boxView.getView(i2);
            if (!(view instanceof BoxView) || !((BoxView)view).isInFlow()) continue;
            return view;
        }
        return null;
    }

    public abstract Rectangle getSpan();

    public static void union(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = rectangle.x < rectangle2.x ? rectangle.x : rectangle2.x;
        int n3 = (int)Math.max(rectangle.getMaxX(), rectangle2.getMaxX());
        rectangle.x = n2;
        rectangle.width = n3 - n2;
        n2 = rectangle.y < rectangle2.y ? rectangle.y : rectangle2.y;
        n3 = (int)Math.max(rectangle.getMaxY(), rectangle2.getMaxY());
        rectangle.y = n2;
        rectangle.height = n3 - n2;
    }

    public static void union(Rectangle rectangle, int n2, int n3, int n4, int n5) {
        int n6 = rectangle.x < n2 ? rectangle.x : n2;
        int n7 = rectangle.x + rectangle.width > n2 + n4 ? rectangle.x + rectangle.width : n2 + n4;
        rectangle.x = n6;
        rectangle.width = n7 - n6;
        n6 = rectangle.y < n3 ? rectangle.y : n3;
        n7 = rectangle.y + rectangle.height > n3 + n5 ? rectangle.y + rectangle.height : n3 + n5;
        rectangle.y = n6;
        rectangle.height = n7 - n6;
    }

    protected void reverseOrder(int n2, int n3, int n4, int n5) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            PositionInfo positionInfo = this.childPositions.get(i2);
            positionInfo.x = n5 - (positionInfo.x + positionInfo.width - n4);
        }
    }

    protected void setFinalHight(int n2, int n3, Rectangle rectangle) {
        int n4;
        Object object;
        this.setCurrentHeight(n3);
        if (n2 == Integer.MIN_VALUE && this.view.getHeightUnit() != null && this.view.getHeightUnit().getType() == 1 && (this.hasDefinedHeight((BoxView)(object = Layout.getHeightParent(this.view))) || this.view.getPosition() == 2) && (n4 = Layout.getHeight(this.view, (BoxView)object, true)) != Integer.MIN_VALUE) {
            n2 = (int)this.view.getHeightUnit().calculateValue(n4, this.view);
        }
        if (n2 != Integer.MIN_VALUE) {
            if (this.view.getDisplay() == 12) {
                if (n2 > n3) {
                    rectangle.height = Math.max(rectangle.height, n2);
                    this.setCurrentHeight(n2);
                }
            } else {
                if (n2 > rectangle.height) {
                    object = this.view.getMargins();
                    ((Insets)object).bottom = n2 - rectangle.height > ((Insets)object).bottom ? 0 : n2 - rectangle.height;
                }
                rectangle.height = Math.max(rectangle.height, n2);
                this.setCurrentHeight(n2);
            }
        }
    }

    public static void offsetRelative(ViewPosition viewPosition) {
        Element element = viewPosition.view.getElement();
        LengthUnit lengthUnit = StyleResolver.getAttributeValue(element, AttributeFinder.LEFT);
        LengthUnit lengthUnit2 = StyleResolver.getAttributeValue(element, AttributeFinder.RIGHT);
        if (lengthUnit2 != null && lengthUnit2.getType() != -1 && lengthUnit2.getType() != 1) {
            viewPosition.x = (int)((float)viewPosition.x - lengthUnit2.calculateValue(viewPosition.view.getFontSize(), viewPosition.view));
        } else if (lengthUnit != null && lengthUnit.getType() != -1 && lengthUnit.getType() != 1) {
            viewPosition.x = (int)((float)viewPosition.x + lengthUnit.calculateValue(viewPosition.view.getFontSize(), viewPosition.view));
        }
        LengthUnit lengthUnit3 = StyleResolver.getAttributeValue(element, AttributeFinder.TOP);
        LengthUnit lengthUnit4 = StyleResolver.getAttributeValue(element, AttributeFinder.BOTTOM);
        if (lengthUnit4 != null && lengthUnit4.getType() != -1 && lengthUnit4.getType() != 1) {
            viewPosition.y = (int)((float)viewPosition.y - lengthUnit4.calculateValue(viewPosition.view.getFontSize(), viewPosition.view));
        } else if (lengthUnit3 != null && lengthUnit3.getType() != -1 && lengthUnit3.getType() != 1) {
            viewPosition.y = (int)((float)viewPosition.y + lengthUnit3.calculateValue(viewPosition.view.getFontSize(), viewPosition.view));
        }
    }

    protected Dimension applyMinMaxValue(boolean bl2, int n2, int n3) {
        if (this.minMaxControl != null) {
            return this.minMaxControl.getMinMaxValues(bl2, n2, n3);
        }
        return null;
    }

    protected FontMetrics getFallbackFontMetrics() {
        FontMetrics fontMetrics;
        Font font = this.view.getRenderContext().getFont(this.view);
        JEditorPane jEditorPane = this.view.getRenderContext().getTextContainer();
        FontMetrics fontMetrics2 = fontMetrics = jEditorPane != null ? ((Component)jEditorPane).getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (fontMetrics.getHeight() == 0 && font.getSize() > 0) {
            font = FALLBACK_FONT.deriveFont(font.getSize2D()).deriveFont(font.getStyle());
            fontMetrics = jEditorPane != null ? ((Component)jEditorPane).getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
        return fontMetrics;
    }

    public class PositionInfo
    extends ViewPosition {
        private static final long serialVersionUID = 1L;
        public short baseline;
        public byte vAlign;
        public boolean isVarSpace = false;
        public boolean isFixed = false;
        public boolean isLayouted = false;
        public boolean paintInFlow = true;

        public PositionInfo(BoxView boxView) {
            this.view = boxView;
            if (this.view instanceof VariableSpaceView) {
                this.isVarSpace = true;
                this.isFixed = ((VariableSpaceView)this.view).isFixed();
            }
            if (boxView instanceof ILayouted) {
                this.isLayouted = true;
            }
        }

        public String toString() {
            return "Position for " + this.view + " is " + this.x + ":" + this.y + " width:" + this.width;
        }
    }

    public static class ViewPosition
    extends Rectangle {
        private static final long serialVersionUID = 1L;
        public BoxView view;
    }
}

