/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ZIndexValue;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.Layout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackManager {
    public static final byte CLEAR_NONE = 0;
    public static final byte CLEAR_LEFT = 1;
    public static final byte CLEAR_RIGHT = 2;
    public static final byte CLEAR_BOTH = 3;
    private static final int NO_MORE_FLOATS_BELOW = 2146483647;
    private static final Integer AUTO_POSITION = new Integer(Integer.MIN_VALUE);
    private static final Insets IGNORE_MARGIN = new Insets(0, 0, 0, 0);
    private static final Iterator<PositionInfo> EMPTY_ITERATOR = new EmptyIterator();
    public static final int MODE_NEGATIVE = 0;
    public static final int MODE_FLOATING = 1;
    public static final int MODE_NEUTRAL = 2;
    public static final int MODE_POSITIVE = 3;
    private static final int MODE_ALL = 4;
    public static final int MODE_ALL_NON_NEGATIVE = 5;
    private BoxView root;
    private List<PositionInfo> floated;
    private SortedMap<Integer, List<PositionInfo>> positionedNegative;
    private List<PositionInfo> positionedNeutral;
    private SortedMap<Integer, List<PositionInfo>> positionedPositive;
    private List<PositionInfo> recentFloats;
    private Rectangle spanNegative = new Rectangle();
    private Rectangle spanPositive = new Rectangle();
    private Rectangle spanNeutral = new Rectangle();
    private Rectangle spanFloated = new Rectangle();
    private boolean hasObjects = false;

    public StackManager(BoxView boxView) {
        this.root = boxView;
    }

    public Point getPositionInfo(BoxView boxView) {
        if (this.floated == null) {
            return null;
        }
        for (PositionInfo positionInfo : this.floated) {
            if (positionInfo.view != boxView) continue;
            Point point = new Point(positionInfo.x, positionInfo.y);
            return point;
        }
        return null;
    }

    public void addView(BoxView boxView, int n2) {
        this.addView(boxView, 0, n2);
    }

    public void addView(BoxView boxView, int n2, int n3) {
        this.hasObjects = true;
        if (boxView.isFloating()) {
            if (this.recentFloats == null) {
                this.recentFloats = new ArrayList<PositionInfo>();
            }
            this.recentFloats.add(new PositionInfo(boxView, boxView.getFloat() == 3));
        } else {
            PositionInfo positionInfo = new PositionInfo(boxView);
            positionInfo.y = n3;
            positionInfo.x = n2;
            positionInfo.layouted = !boxView.isAbsolutePositioned();
            ZIndexValue zIndexValue = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.ZINDEX);
            Integer n4 = zIndexValue == null || zIndexValue.isAuto() ? AUTO_POSITION : Integer.valueOf(zIndexValue.getInt());
            this.addToStack(n4, positionInfo);
        }
    }

    public void paint(Graphics graphics, Shape shape, int n2) {
        Rectangle rectangle = (Rectangle)shape;
        Rectangle rectangle2 = graphics.getClipBounds();
        if (this.floated != null && n2 == 1) {
            Iterator<PositionInfo> iterator = new ArrayList(this.floated.size());
            iterator.addAll(this.floated);
            Iterator object = iterator.iterator();
            while (object.hasNext()) {
                PositionInfo positionInfo = (PositionInfo)object.next();
                this.paintView(rectangle, rectangle2, positionInfo, graphics);
            }
        }
        switch (n2) {
            case 0: {
                if (this.positionedNegative == null) break;
                for (PositionInfo positionInfo : new PositionIterable(n2, true)) {
                    this.paintView(rectangle, rectangle2, positionInfo, graphics);
                }
                break;
            }
            case 3: {
                if (this.positionedNeutral != null) {
                    for (PositionInfo positionInfo : this.positionedNeutral) {
                        this.paintView(rectangle, rectangle2, positionInfo, graphics);
                    }
                }
                if (this.positionedPositive == null) break;
                for (PositionInfo positionInfo : new PositionIterable(n2, true)) {
                    this.paintView(rectangle, rectangle2, positionInfo, graphics);
                }
                break;
            }
        }
    }

    private void paintView(Rectangle rectangle, Rectangle rectangle2, PositionInfo positionInfo, Graphics graphics) {
        Insets insets = positionInfo.pos_relative ? IGNORE_MARGIN : positionInfo.view.getMargins();
        Rectangle rectangle3 = positionInfo.view.getSpan();
        Rectangle rectangle4 = new Rectangle(rectangle.x + positionInfo.x + insets.left, rectangle.y + positionInfo.y + insets.top, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
        rectangle4.width = Math.max(1, rectangle4.width);
        rectangle4.height = Math.max(1, rectangle4.height);
        Rectangle rectangle5 = rectangle4;
        if (rectangle2 != null && (rectangle3.width > rectangle4.width || rectangle3.height > rectangle4.height)) {
            rectangle5 = new Rectangle(rectangle4);
            rectangle5.width = rectangle3.width;
            rectangle5.height = rectangle3.height;
        }
        if (rectangle2 == null || rectangle4.intersects(rectangle5)) {
            positionInfo.view.paint(graphics, rectangle4);
        }
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray, int n2) {
        Rectangle rectangle = shape.getBounds();
        for (PositionInfo positionInfo : new PositionIterable(n2, false)) {
            int n3;
            Rectangle rectangle2 = this.getBoundingRect(rectangle, positionInfo, f2, f3);
            if (rectangle2 == null || (n3 = positionInfo.view.viewToModel(f2, f3, rectangle2, biasArray)) < 0) continue;
            positionInfo.view.viewToModel(f2, f3, rectangle2, biasArray);
            return n3;
        }
        return -1;
    }

    private Rectangle getBoundingRect(Rectangle rectangle, PositionInfo positionInfo, float f2, float f3) {
        Rectangle rectangle2 = new Rectangle(rectangle.x + positionInfo.x + positionInfo.view.getMargins().left, rectangle.y + positionInfo.y + positionInfo.view.getMargins().top, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
        if (rectangle2.contains(f2, f3)) {
            return rectangle2;
        }
        return null;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias, int n3) throws BadLocationException {
        Rectangle rectangle = shape.getBounds();
        for (PositionInfo positionInfo : new PositionIterable(n3, false)) {
            Shape shape2 = this.modelToViewSingular(n2, bias, rectangle, positionInfo);
            if (shape2 == null) continue;
            return shape2;
        }
        return null;
    }

    private Shape modelToViewSingular(int n2, Position.Bias bias, Rectangle rectangle, PositionInfo positionInfo) throws BadLocationException {
        int n3 = positionInfo.view.getStartOffset();
        int n4 = positionInfo.view.getEndOffset();
        if (bias == Position.Bias.Forward) {
            --n4;
        } else {
            ++n3;
        }
        if (n3 <= n2 && n4 >= n2) {
            rectangle.x += positionInfo.x + positionInfo.view.getMargins().left;
            rectangle.y += positionInfo.y + positionInfo.view.getMargins().top;
            rectangle.width = positionInfo.view.getOuterWidth();
            rectangle.height = positionInfo.view.getOuterHeight();
            return positionInfo.view.modelToView(n2, rectangle, bias);
        }
        return null;
    }

    private PositionInfo getMostOuterFloat(int n2, boolean bl2) {
        PositionInfo positionInfo = null;
        for (PositionInfo positionInfo2 : this.floated) {
            if (positionInfo2.getTop() > n2 || positionInfo2.getBottom() <= n2 || positionInfo2.typeLeft != bl2) continue;
            if (positionInfo != null) {
                if (bl2) {
                    if (positionInfo2.getRight() <= positionInfo.getRight()) continue;
                    positionInfo = positionInfo2;
                    continue;
                }
                if (positionInfo2.getLeft() >= positionInfo.getLeft()) continue;
                positionInfo = positionInfo2;
                continue;
            }
            positionInfo = positionInfo2;
        }
        return positionInfo;
    }

    private PositionInfo findMostOuterFloat(int n2, int n3, boolean bl2) {
        PositionInfo positionInfo = null;
        for (PositionInfo positionInfo2 : this.floated) {
            boolean bl3 = positionInfo2.getTop() <= n2 && positionInfo2.getBottom() > n2 || positionInfo2.getTop() <= n3 && positionInfo2.getBottom() > n3 || positionInfo2.getTop() < n2 && positionInfo2.getBottom() > n3;
            if (!bl3 || positionInfo2.typeLeft != bl2) continue;
            if (positionInfo != null) {
                if (bl2) {
                    if (positionInfo2.getRight() <= positionInfo.getRight()) continue;
                    positionInfo = positionInfo2;
                    continue;
                }
                if (positionInfo2.getLeft() >= positionInfo.getLeft()) continue;
                positionInfo = positionInfo2;
                continue;
            }
            positionInfo = positionInfo2;
        }
        return positionInfo;
    }

    public PositionInfo getNextFloatBelow(int n2, int n3, int n4, boolean bl2) {
        for (PositionInfo positionInfo : this.floated) {
            if (positionInfo.typeLeft != bl2 || positionInfo.getRight() <= n3 || positionInfo.getLeft() >= n4 || positionInfo.y <= n2) continue;
            return positionInfo;
        }
        return null;
    }

    public int getAvailableVSpace(int n2, int n3, int n4) {
        for (PositionInfo positionInfo : this.floated) {
            if (positionInfo.getRight() <= n3 || positionInfo.getLeft() >= n4 || positionInfo.y <= n2) continue;
            return positionInfo.y - n2;
        }
        return 2146483647;
    }

    public LineSpaceInfo findLineSpace(Rectangle rectangle, Rectangle rectangle2, int n2, int n3) {
        LineSpaceInfo lineSpaceInfo = new LineSpaceInfo();
        int n4 = rectangle2.x;
        int n5 = rectangle2.x + rectangle2.width;
        lineSpaceInfo.y = rectangle2.y;
        if (this.floated == null || this.floated.size() == 0) {
            lineSpaceInfo.maxWidth = rectangle2.width;
            lineSpaceInfo.x = n4;
            lineSpaceInfo.maxHeightOnMaxWidth = 2146483647;
            lineSpaceInfo.maxHeightOnReqWidth = 2146483647;
            return lineSpaceInfo;
        }
        PositionInfo positionInfo = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, true);
        PositionInfo positionInfo2 = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, false);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        boolean bl2 = false;
        do {
            PositionInfo positionInfo3;
            bl2 = false;
            if (positionInfo != null && positionInfo.getRight() > n4) {
                n6 = positionInfo.x;
                n7 = positionInfo.getRight();
                n8 = positionInfo.getBottom();
            } else {
                n6 = n4;
                n7 = n4;
                positionInfo3 = this.getNextFloatBelow(lineSpaceInfo.y, n4, n5, true);
                if (positionInfo3 != null) {
                    n8 = positionInfo3.y;
                } else {
                    int n12 = n8 = positionInfo != null ? positionInfo.getBottom() : 2146483647;
                }
            }
            if (positionInfo2 != null && positionInfo2.x < n5) {
                n9 = positionInfo2.x;
                n10 = positionInfo2.getBottom();
            } else {
                n9 = n5;
                positionInfo3 = this.getNextFloatBelow(lineSpaceInfo.y, n4, n5, false);
                n10 = positionInfo3 != null ? positionInfo3.y : (positionInfo2 != null ? positionInfo2.getBottom() : 2146483647);
            }
            n11 = n6 < n9 ? n9 - n7 : n9 - n4;
            boolean bl3 = bl2 = n11 < rectangle.width && (n10 != 2146483647 || n8 != 2146483647) || (n2 == 1 || n2 == 3) && positionInfo != null || (n2 == 2 || n2 == 3) && positionInfo2 != null;
            if (!bl2) continue;
            if (n8 < n10) {
                lineSpaceInfo.y = n8;
            } else {
                lineSpaceInfo.y = n10;
            }
            positionInfo = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, true);
            positionInfo2 = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, false);
        } while (n11 < rectangle.width && bl2);
        lineSpaceInfo.x = n6 < n9 ? n7 : n4;
        lineSpaceInfo.maxWidth = n11;
        lineSpaceInfo.maxHeightOnMaxWidth = this.getAvailableVSpace(lineSpaceInfo.y, lineSpaceInfo.x, lineSpaceInfo.x + n11);
        if (n3 == 0) {
            lineSpaceInfo.maxHeightOnReqWidth = this.getAvailableVSpace(lineSpaceInfo.y, lineSpaceInfo.x, lineSpaceInfo.x + rectangle.width);
        } else {
            lineSpaceInfo.maxHeightOnReqWidth = this.getAvailableVSpace(lineSpaceInfo.y, lineSpaceInfo.x + n11 - rectangle.width, lineSpaceInfo.x + n11);
        }
        return lineSpaceInfo;
    }

    public LineSpaceInfo findClearSpace(Rectangle rectangle, Rectangle rectangle2, int n2, int n3) {
        LineSpaceInfo lineSpaceInfo = new LineSpaceInfo();
        int n4 = rectangle2.x;
        int n5 = rectangle2.x + rectangle2.width;
        lineSpaceInfo.y = rectangle2.y;
        if (this.floated.size() == 0) {
            lineSpaceInfo.maxWidth = rectangle2.width;
            lineSpaceInfo.x = n4;
            lineSpaceInfo.maxHeightOnMaxWidth = 2146483647;
            lineSpaceInfo.maxHeightOnReqWidth = 2146483647;
            return lineSpaceInfo;
        }
        PositionInfo positionInfo = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, true);
        PositionInfo positionInfo2 = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, false);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        do {
            boolean bl2;
            PositionInfo positionInfo3;
            if (positionInfo != null) {
                n6 = positionInfo.x;
                n7 = positionInfo.getRight();
                n8 = positionInfo.getBottom();
            } else {
                n6 = n4;
                n7 = n4;
                positionInfo3 = this.getNextFloatBelow(lineSpaceInfo.y, n4, n5, true);
                n8 = positionInfo3 != null ? positionInfo3.y : 2146483647;
            }
            if (positionInfo2 != null) {
                n9 = positionInfo2.x;
                n10 = positionInfo2.getBottom();
            } else {
                n9 = n5;
                positionInfo3 = this.getNextFloatBelow(lineSpaceInfo.y, n4, n5, false);
                n10 = positionInfo3 != null ? positionInfo3.y : 2146483647;
            }
            n11 = n6 < n9 ? n9 - n7 : n9 - n4;
            boolean bl3 = bl2 = n11 < rectangle.width || (n2 == 1 || n2 == 3) && positionInfo != null || (n2 == 2 || n2 == 3) && positionInfo2 != null;
            if (!bl2) continue;
            if (n8 < n10) {
                lineSpaceInfo.y = n8;
            } else {
                lineSpaceInfo.y = n10;
            }
            positionInfo = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, true);
            positionInfo2 = this.findMostOuterFloat(lineSpaceInfo.y, lineSpaceInfo.y + rectangle.height, false);
        } while (n11 < rectangle.width);
        lineSpaceInfo.x = n6 < n9 ? n7 : n4;
        lineSpaceInfo.maxWidth = n11;
        lineSpaceInfo.maxHeightOnMaxWidth = this.getAvailableVSpace(lineSpaceInfo.y, lineSpaceInfo.x, lineSpaceInfo.x + n11);
        if (n3 == 0) {
            lineSpaceInfo.maxHeightOnReqWidth = this.getAvailableVSpace(lineSpaceInfo.y, lineSpaceInfo.x, lineSpaceInfo.x + rectangle.width);
        } else {
            lineSpaceInfo.maxHeightOnReqWidth = this.getAvailableVSpace(lineSpaceInfo.y, lineSpaceInfo.x + n11 - rectangle.width, lineSpaceInfo.x + n11);
        }
        return lineSpaceInfo;
    }

    private int getMinY(int n2, boolean bl2) {
        int n3 = n2;
        for (int i2 = this.floated.size() - 1; i2 >= 0; --i2) {
            PositionInfo positionInfo = this.floated.get(i2);
            if (positionInfo.typeLeft != bl2) continue;
            if (positionInfo.y <= n3) break;
            n3 = positionInfo.y;
            break;
        }
        return n3;
    }

    private void findLocation(PositionInfo positionInfo, Point point, int n2) {
        int n3 = point.x;
        int n4 = point.x + n2;
        positionInfo.y = this.getMinY(point.y, positionInfo.typeLeft);
        PositionInfo positionInfo2 = this.getMostOuterFloat(positionInfo.y, true);
        PositionInfo positionInfo3 = this.getMostOuterFloat(positionInfo.y, false);
        positionInfo.x = positionInfo.typeLeft ? point.x : n4 - positionInfo.width;
        int n5 = 0;
        boolean bl2 = false;
        do {
            bl2 = false;
            if (positionInfo.typeLeft) {
                if (positionInfo2 != null && positionInfo.getLeft() < positionInfo2.getRight()) {
                    positionInfo.x = positionInfo2.getRight();
                    if (positionInfo.getRight() > n4) {
                        positionInfo.x = n3;
                        positionInfo.y = positionInfo2.getBottom();
                        positionInfo2 = this.getMostOuterFloat(positionInfo.y, true);
                        positionInfo3 = this.getMostOuterFloat(positionInfo.y, false);
                        bl2 = true;
                    }
                }
                if (positionInfo3 == null || positionInfo.getRight() <= positionInfo3.getLeft()) continue;
                if (positionInfo2 == null || positionInfo2.getBottom() > positionInfo3.getBottom()) {
                    positionInfo.y = positionInfo3.getBottom();
                } else {
                    positionInfo.y = positionInfo2.getBottom();
                    positionInfo.x = n3;
                }
                positionInfo2 = this.getMostOuterFloat(positionInfo.y, true);
                positionInfo3 = this.getMostOuterFloat(positionInfo.y, false);
                bl2 = true;
                continue;
            }
            if (positionInfo3 != null && positionInfo.getRight() > positionInfo3.getLeft()) {
                positionInfo.x = positionInfo3.getLeft() - positionInfo.width;
                if (positionInfo.getLeft() < n3) {
                    positionInfo.x = n4 - positionInfo.width;
                    positionInfo.y = positionInfo3.getBottom();
                    positionInfo3 = this.getMostOuterFloat(positionInfo.y, false);
                    positionInfo2 = this.getMostOuterFloat(positionInfo.y, true);
                }
                bl2 = true;
            }
            if (positionInfo2 == null || positionInfo.getLeft() >= positionInfo2.getRight()) continue;
            if (positionInfo3 == null || positionInfo2.getBottom() < positionInfo3.getBottom()) {
                positionInfo.y = positionInfo2.getBottom();
            } else {
                positionInfo.y = positionInfo3.getBottom();
                positionInfo.x = n4 - positionInfo.width;
            }
            positionInfo3 = this.getMostOuterFloat(positionInfo.y, false);
            positionInfo2 = this.getMostOuterFloat(positionInfo.y, true);
            bl2 = true;
        } while (++n5 < 10000 && bl2);
    }

    public void notifyNewLine(float f2) {
        if (this.recentFloats != null && this.recentFloats.size() > 0) {
            for (PositionInfo positionInfo : this.recentFloats) {
                BlockView blockView = (BlockView)positionInfo.view.getParent();
                Point point = blockView.getLeftUpperCorner(blockView);
                point.y = (int)((float)point.y + f2);
                int n2 = blockView.getContentWidth();
                if (this.floated == null) {
                    this.floated = new ArrayList<PositionInfo>();
                }
                Insets insets = positionInfo.view.getMargins();
                positionInfo.width = positionInfo.view.getOuterWidth() + insets.left + insets.right;
                positionInfo.height = positionInfo.view.getOuterHeight() + insets.top + insets.bottom;
                this.findLocation(positionInfo, point, n2);
                if (insets.left < 0 && positionInfo.typeLeft) {
                    positionInfo.x += insets.left;
                }
                if (insets.right < 0 && !positionInfo.typeLeft) {
                    positionInfo.x += insets.right;
                }
                if (positionInfo.view.getPosition() == 1) {
                    Layout.offsetRelative(positionInfo);
                }
                Layout.union(this.spanFloated, positionInfo.x, positionInfo.y, positionInfo.width, positionInfo.height);
                this.floated.add(positionInfo);
            }
        }
        this.recentFloats = null;
    }

    public int getBottomPosition(BlockView blockView) {
        int n2 = 0;
        Point point = blockView.getLeftUpperCorner(blockView);
        if (this.floated != null && this.floated.size() > 0) {
            for (PositionInfo positionInfo : this.floated) {
                int n3 = positionInfo.y + positionInfo.height;
                if (n3 <= n2) continue;
                n2 = n3;
            }
        }
        return n2 - point.y;
    }

    public void clear() {
        if (this.floated != null) {
            this.floated.clear();
        }
        if (this.positionedNegative != null) {
            this.positionedNegative.clear();
        }
        if (this.positionedNeutral != null) {
            this.positionedNeutral.clear();
        }
        if (this.positionedPositive != null) {
            this.positionedPositive.clear();
        }
        this.hasObjects = false;
        this.recentFloats = null;
        this.spanFloated.setBounds(0, 0, 0, 0);
        this.spanNegative.setBounds(0, 0, 0, 0);
        this.spanNeutral.setBounds(0, 0, 0, 0);
        this.spanPositive.setBounds(0, 0, 0, 0);
    }

    public void clearMyFloats(BoxView boxView) {
        if (this.floated == null) {
            return;
        }
        ArrayList<PositionInfo> arrayList = new ArrayList<PositionInfo>(this.floated.size());
        arrayList.addAll(this.floated);
        for (PositionInfo positionInfo : arrayList) {
            if (positionInfo.view.getParent() != boxView) continue;
            this.floated.remove(positionInfo);
        }
        if (!(this.floated.size() != 0 || this.positionedNegative != null && this.positionedNegative.size() != 0 || this.positionedNeutral != null && this.positionedNeutral.size() != 0 || this.positionedPositive != null && this.positionedPositive.size() != 0)) {
            this.hasObjects = false;
        }
        this.recalculateSpan();
    }

    private void recalculateSpan() {
        this.spanFloated.setBounds(0, 0, 0, 0);
        this.spanNegative.setBounds(0, 0, 0, 0);
        this.spanNeutral.setBounds(0, 0, 0, 0);
        this.spanPositive.setBounds(0, 0, 0, 0);
        for (PositionInfo positionInfo : new PositionIterable(4, true)) {
            Layout.union(this.spanFloated, positionInfo.x, positionInfo.y, positionInfo.width, positionInfo.height);
        }
    }

    public boolean hasViews() {
        return this.hasObjects;
    }

    public ViewPositionInfo getViewForPosition(Point point, Rectangle rectangle, int n2) {
        Rectangle rectangle2 = rectangle.getBounds();
        for (PositionInfo positionInfo : new PositionIterable(n2, false)) {
            Rectangle rectangle3 = new Rectangle(rectangle2.x + positionInfo.x, rectangle2.y + positionInfo.y, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
            if (!rectangle3.contains(point) || positionInfo.view.getVisibility() == 1) continue;
            ViewPositionInfo viewPositionInfo = positionInfo.view.getViewForPosition(point, rectangle3);
            if (viewPositionInfo == null) {
                return new ViewPositionInfo(rectangle3, positionInfo.view);
            }
            return viewPositionInfo;
        }
        return null;
    }

    public Rectangle getSpan() {
        Rectangle rectangle = this.spanFloated.getBounds();
        Layout.union(rectangle, this.spanNegative);
        Layout.union(rectangle, this.spanNeutral);
        Layout.union(rectangle, this.spanPositive);
        return rectangle;
    }

    public void notifyBlockFinished(boolean bl2) {
        int n2;
        if (this.positionedNegative != null && this.positionedNegative.size() > 0) {
            for (Map.Entry<Integer, List<PositionInfo>> entry : this.positionedNegative.entrySet()) {
                n2 = entry.getKey();
                this.processPositioned(bl2, entry.getValue(), n2);
            }
        }
        if (this.positionedNeutral != null && this.positionedNeutral.size() > 0) {
            this.processPositioned(bl2, this.positionedNeutral, Integer.MIN_VALUE);
        }
        if (this.positionedPositive != null && this.positionedPositive.size() > 0) {
            for (Map.Entry<Integer, List<PositionInfo>> entry : this.positionedPositive.entrySet()) {
                n2 = entry.getKey();
                this.processPositioned(bl2, entry.getValue(), n2);
            }
        }
    }

    private void processPositioned(boolean bl2, List<PositionInfo> list, int n2) {
        for (PositionInfo positionInfo : list) {
            BoxView boxView = positionInfo.view;
            if (!positionInfo.layouted || bl2) {
                boxView.performLayoutWidth();
                boxView.performLayout(bl2);
            }
            this.placePositioned(positionInfo);
            this.addSpan(n2, positionInfo);
        }
    }

    private void addSpan(int n2, PositionInfo positionInfo) {
        if (n2 == Integer.MIN_VALUE) {
            Layout.union(this.spanNeutral, positionInfo.x, positionInfo.y, positionInfo.width, positionInfo.height);
        } else if (n2 < 0) {
            Layout.union(this.spanNegative, positionInfo.x, positionInfo.y, positionInfo.width, positionInfo.height);
        } else {
            Layout.union(this.spanPositive, positionInfo.x, positionInfo.y, positionInfo.width, positionInfo.height);
        }
    }

    private void addToStack(Integer n2, PositionInfo positionInfo) {
        ArrayList<PositionInfo> arrayList;
        if (n2 != AUTO_POSITION) {
            SortedMap<Integer, List<PositionInfo>> sortedMap;
            if (n2 >= 0) {
                if (this.positionedPositive == null) {
                    this.positionedPositive = new TreeMap<Integer, List<PositionInfo>>();
                }
                sortedMap = this.positionedPositive;
            } else {
                if (this.positionedNegative == null) {
                    this.positionedNegative = new TreeMap<Integer, List<PositionInfo>>();
                }
                sortedMap = this.positionedNegative;
            }
            arrayList = (ArrayList<PositionInfo>)sortedMap.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList<PositionInfo>();
                sortedMap.put(n2, arrayList);
            }
        } else {
            if (this.positionedNeutral == null) {
                this.positionedNeutral = new ArrayList<PositionInfo>();
            }
            arrayList = this.positionedNeutral;
        }
        arrayList.add(positionInfo);
    }

    private void placePositioned(PositionInfo positionInfo) {
        int n2;
        if (positionInfo.view.getPosition() == 1) {
            BlockView blockView = (BlockView)positionInfo.view.getParent();
            Point point = blockView.getLeftUpperCorner(blockView);
            positionInfo.x += point.x;
            positionInfo.y += point.y;
            return;
        }
        Element element = positionInfo.view.getElement();
        LengthUnit lengthUnit = StyleResolver.getAttributeValue(element, AttributeFinder.LEFT);
        LengthUnit lengthUnit2 = StyleResolver.getAttributeValue(element, AttributeFinder.RIGHT);
        LengthUnit lengthUnit3 = StyleResolver.getAttributeValue(element, AttributeFinder.TOP);
        LengthUnit lengthUnit4 = StyleResolver.getAttributeValue(element, AttributeFinder.BOTTOM);
        if (lengthUnit2 != null && lengthUnit2.getType() != -1) {
            n2 = this.root.getContentWidth();
            positionInfo.x = (int)((float)n2 - lengthUnit2.calculateValue(n2, positionInfo.view) - (float)positionInfo.view.getOuterWidth());
        } else if (lengthUnit != null && lengthUnit.getType() != -1) {
            positionInfo.x = (int)lengthUnit.calculateValue(this.root.getOuterWidth(), positionInfo.view);
        } else {
            BlockView blockView = (BlockView)positionInfo.view.getParent();
            positionInfo.x += blockView.getLeftUpperCorner((BoxView)blockView).x;
        }
        if (lengthUnit4 != null && lengthUnit4.getType() != -1) {
            n2 = this.root.getContentHeight();
            positionInfo.y = (int)((float)n2 - lengthUnit4.calculateValue(n2, positionInfo.view) - (float)positionInfo.view.getOuterHeight());
        } else if (lengthUnit3 != null && lengthUnit3.getType() != -1) {
            positionInfo.y = (int)lengthUnit3.calculateValue(this.root.getContentHeight(), positionInfo.view);
        } else {
            BlockView blockView = (BlockView)positionInfo.view.getParent();
            positionInfo.y += blockView.getLeftUpperCorner((BoxView)blockView).y;
        }
        positionInfo.width = positionInfo.view.getContentWidth();
        positionInfo.height = positionInfo.view.getContentHeight();
    }

    public Rectangle getSpan(int n2) {
        switch (n2) {
            case 0: {
                return this.spanNegative;
            }
            case 1: {
                return this.spanFloated;
            }
            case 2: {
                return this.spanNeutral;
            }
            case 3: {
                return this.spanPositive;
            }
        }
        return this.getSpan();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<PositionInfo> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public PositionInfo next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PositionIterator
    implements Iterator<PositionInfo> {
        private List<List<PositionInfo>> sortedList;
        private List<PositionInfo> current;
        private PositionInfo info;
        private int level;
        private int index;
        private final boolean forward;

        public PositionIterator(int n2, boolean bl2) {
            this.forward = bl2;
            this.sortedList = new ArrayList<List<PositionInfo>>();
            switch (n2) {
                case 0: {
                    if (StackManager.this.positionedNegative == null) break;
                    this.sortedList.addAll(StackManager.this.positionedNegative.values());
                    break;
                }
                case 2: {
                    if (StackManager.this.positionedNeutral == null) break;
                    this.sortedList.add(StackManager.this.positionedNeutral);
                    break;
                }
                case 3: {
                    if (StackManager.this.positionedPositive == null) break;
                    this.sortedList.addAll(StackManager.this.positionedPositive.values());
                    break;
                }
                case 4: {
                    if (StackManager.this.positionedNegative != null) {
                        this.sortedList.addAll(StackManager.this.positionedNegative.values());
                    }
                }
                case 5: {
                    if (StackManager.this.floated != null && StackManager.this.floated.size() > 0) {
                        this.sortedList.add(StackManager.this.floated);
                    }
                    if (StackManager.this.positionedNeutral != null && StackManager.this.positionedNeutral.size() > 0) {
                        this.sortedList.add(StackManager.this.positionedNeutral);
                    }
                    if (StackManager.this.positionedPositive == null || StackManager.this.positionedPositive.size() <= 0) break;
                    this.sortedList.addAll(StackManager.this.positionedPositive.values());
                }
            }
            if (!bl2 && this.sortedList.size() > 1) {
                Collections.reverse(this.sortedList);
            }
            while (this.sortedList.size() > this.level && this.sortedList.get(this.level).size() == 0) {
                ++this.level;
            }
            List<PositionInfo> list = this.current = this.sortedList.size() > this.level ? this.sortedList.get(this.level) : null;
            if (this.current != null) {
                this.index = bl2 ? 0 : this.current.size() - 1;
                this.info = this.current.get(this.index);
            }
        }

        @Override
        public boolean hasNext() {
            return this.info != null && this.current != null;
        }

        @Override
        public PositionInfo next() {
            if (this.current == null || this.info == null) {
                return null;
            }
            PositionInfo positionInfo = this.info;
            if (this.forward ? this.index >= this.current.size() - 1 : this.index <= 0) {
                while (this.sortedList.size() > this.level && this.sortedList.get(this.level++).size() == 0) {
                }
                if (this.sortedList.size() == this.level) {
                    this.current = null;
                    this.info = null;
                } else {
                    this.current = this.sortedList.size() > this.level ? this.sortedList.get(this.level) : null;
                    this.index = this.forward ? 0 : this.current.size() - 1;
                    this.info = this.current.get(this.index);
                }
            } else {
                this.index += this.forward ? 1 : -1;
                this.info = this.current.get(this.index);
            }
            return positionInfo;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PositionIterable
    implements Iterable<PositionInfo> {
        private Iterator<PositionInfo> iterator;

        public PositionIterable(int n2, boolean bl2) {
            switch (n2) {
                case 1: {
                    this.iterator = StackManager.this.floated != null ? StackManager.this.floated.iterator() : EMPTY_ITERATOR;
                    break;
                }
                default: {
                    this.iterator = StackManager.this.hasObjects ? new PositionIterator(n2, bl2) : EMPTY_ITERATOR;
                }
            }
        }

        @Override
        public Iterator<PositionInfo> iterator() {
            return this.iterator;
        }
    }

    public static class LineSpaceInfo {
        private int x;
        private int y;
        private int maxWidth;
        private int maxHeightOnMaxWidth;
        private int maxHeightOnReqWidth;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public int getMaxHeightOnMaxWidth() {
            return this.maxHeightOnMaxWidth;
        }

        public int getMaxHeightOnReqWidth() {
            return this.maxHeightOnReqWidth;
        }
    }

    private class PositionInfo
    extends Layout.ViewPosition {
        private static final long serialVersionUID = 1L;
        private boolean layouted = false;
        private boolean pos_relative = false;
        private boolean typeLeft;

        PositionInfo(BoxView boxView) {
            this.pos_relative = boxView.getPosition() == 1;
            this.view = boxView;
        }

        PositionInfo(BoxView boxView, boolean bl2) {
            this(boxView);
            this.typeLeft = bl2;
        }

        public int getLeft() {
            return this.x;
        }

        public int getRight() {
            return this.x + this.width;
        }

        public int getTop() {
            return this.y;
        }

        public int getBottom() {
            return this.height > 0 ? this.y + this.height : this.y + 1;
        }

        public String toString() {
            return "Floated: " + this.view.toString();
        }
    }
}

