/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.BorderCollapseValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.MultiIntegerValue;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.views.BackgroundPainter;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBackgroundPainter;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.TableBoxPainter;
import com.inet.html.views.TableView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableLayout
extends Layout {
    private static int constraintIndexCounter = 0;
    private static BorderDescription NOBORDER;
    private List<ColumnData> columnData = new ArrayList<ColumnData>();
    private List<RowData> rowHeight;
    private List<ListRow<CellData>> tableHeader;
    private List<ListRow<CellData>> tableContent;
    private List<ListRow<CellData>> tableFooter;
    private TableView table;
    private int width;
    private int widthPref;
    private int widthMax;
    private boolean borderCollapse = false;
    private int cellSpacingH = 0;
    private int cellSpacingHtotal = 0;
    private int cellSpacingV = 0;
    private Rectangle span = new Rectangle();
    private TreeSet<WidthConstraint> constraints;
    private static final int CELL_TYPE_AUTO = 0;
    private static final int CELL_TYPE_FIXED = 1;
    private static final int CELL_TYPE_RELATIVE = 2;

    public TableLayout(BoxView boxView) {
        super(boxView);
        NOBORDER = new BorderDescription();
        NOBORDER.style = 0;
        NOBORDER.width = 0;
        this.table = (TableView)boxView;
    }

    @Override
    public Rectangle layout(boolean bl2) {
        int n2;
        int n3 = this.calculateRowHeights(bl2);
        if (this.getView().getHeightUnit() != null && this.getView().getHeightUnit().isAbsolute() && (n2 = (int)this.getView().getHeightUnit().calculateValue(n3, this.getView())) > n3) {
            float f2 = n2 - n3;
            int n4 = this.rowHeight.size();
            for (RowData rowData : this.rowHeight) {
                float f3 = f2 / (float)n4;
                rowData.height = rowData.selfHeight + Math.round(f3);
                f2 += f3;
            }
        }
        n3 = this.applyRowHeights();
        this.setCurrentHeight(n3);
        this.view.setSizeContent(this.width, n3);
        IBoxPainter iBoxPainter = this.view.getBox();
        this.span.setBounds(iBoxPainter.getLeftBorderPadding(), iBoxPainter.getTopBorderPadding(), this.view.getOuterWidth(), this.view.getOuterHeight());
        for (Layout.PositionInfo positionInfo : this.childPositions) {
            if (positionInfo.view == null) continue;
            this.view.setFirstLineBaseLine((short)(positionInfo.y + positionInfo.view.getFirstLineBaseLine() + positionInfo.view.getTopInset() + positionInfo.view.getMargins().top));
            break;
        }
        return this.span;
    }

    private int calculateRowHeights(boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.rowHeight.clear();
        for (int i2 = 0; i2 < 3; ++i2) {
            List<ListRow<CellData>> list = null;
            if (i2 == 0) {
                list = this.tableHeader;
            }
            if (i2 == 1) {
                list = this.tableContent;
            }
            if (i2 == 2) {
                list = this.tableFooter;
            }
            for (int i3 = 0; list != null && i3 < list.size(); ++i3) {
                List list2 = list.get(i3);
                n2 = 0;
                n3 = 0;
                for (int i4 = 0; i4 < list2.size(); ++i4) {
                    int n7;
                    int n8;
                    CellData cellData = (CellData)list2.get(i4);
                    if (cellData.filled && !cellData.fillFinish || cellData.reference == null) continue;
                    BoxView boxView = cellData.reference.getContent();
                    float f2 = this.columnData.get(i4).size;
                    if (cellData.reference.getColspan() > 1) {
                        for (n8 = 1; n8 < cellData.reference.getColspan() && i4 + n8 < this.columnData.size(); ++n8) {
                            f2 += (float)(this.columnData.get(i4 + n8).size + this.cellSpacingH);
                        }
                    }
                    if (boxView != null) {
                        boxView.setContentWidth(f2 - (float)boxView.getBox().getTotalWidthGain());
                        boxView.performLayout(bl2);
                        n3 = Math.max(boxView.getFirstLineBaseLine(), n3);
                        n4 = boxView.getOuterHeight();
                        LengthUnit lengthUnit = boxView.getHeightUnit();
                        if (lengthUnit != null && lengthUnit.isAbsolute() && ((n7 = (int)lengthUnit.getValue()) > n4 || boxView.getEndOffset() - boxView.getStartOffset() <= 1)) {
                            n4 = n7;
                        }
                    }
                    if ((n8 = cellData.reference.getRowspan()) > 1) {
                        n7 = n4;
                        if (!cellData.fillFinish) continue;
                        for (int i5 = 0; i5 < n8 - 1; ++i5) {
                            n7 -= this.rowHeight.get(n5 - n8 + i5 + 1).selfHeight + this.cellSpacingV;
                        }
                        n4 = n7;
                    }
                    n2 = Math.max(n2, n4);
                }
                n6 += n2;
                this.rowHeight.add(new RowData(n2, n3));
                ++n5;
            }
        }
        return n6;
    }

    private int applyRowHeights() {
        int n2 = this.cellSpacingV;
        int n3 = this.cellSpacingH;
        int n4 = 0;
        this.childPositions.clear();
        for (int i2 = 0; i2 < 3; ++i2) {
            List<ListRow<CellData>> list = null;
            if (i2 == 0) {
                list = this.tableHeader;
            }
            if (i2 == 1) {
                list = this.tableContent;
            }
            if (i2 == 2) {
                list = this.tableFooter;
            }
            for (int i3 = 0; list != null && i3 < list.size(); ++i3) {
                Object object;
                int n5;
                List list2 = list.get(i3);
                RowData rowData = this.rowHeight.get(n4);
                n3 = this.cellSpacingH;
                int n6 = this.childPositions.size();
                for (n5 = 0; n5 < list2.size(); ++n5) {
                    CellData cellData = (CellData)list2.get(n5);
                    object = this.columnData.get(n5);
                    float f2 = ((ColumnData)object).size;
                    if ((!cellData.filled || cellData.fillFinish) && cellData.reference != null) {
                        int n7;
                        BoxView boxView = cellData.reference.getContent();
                        CellPositionInfo cellPositionInfo = new CellPositionInfo(boxView);
                        float f3 = f2;
                        if (cellData.reference.getColspan() > 1) {
                            for (n7 = 1; n7 < cellData.reference.getColspan() && n5 + n7 < this.columnData.size(); ++n7) {
                                f3 += (float)(this.columnData.get(n5 + n7).size + this.cellSpacingH);
                            }
                        }
                        n7 = rowData.height;
                        int n8 = cellData.reference.getRowspan();
                        if (n8 > 1) {
                            if (!cellData.fillFinish) {
                                n3 = (int)((float)n3 + (f2 + (float)this.cellSpacingH));
                                continue;
                            }
                            for (int i4 = 0; i4 < n8 - 1; ++i4) {
                                n7 += this.rowHeight.get(i3 - n8 + i4 + 1).height + this.cellSpacingV;
                            }
                            cellPositionInfo.y = rowData.height - n7;
                        }
                        if (boxView != null) {
                            boxView.setSize(f3, n7);
                            if (boxView.getAlignment(1) != 7.0f) {
                                boxView.performLayoutVAlign(rowData.baseline);
                            }
                        }
                        cellPositionInfo.x += n3;
                        cellPositionInfo.y += n2;
                        cellPositionInfo.width = (int)f3;
                        cellPositionInfo.rowPainter = cellData.rowPainter;
                        cellPositionInfo.columnPainter = ((ColumnData)object).painter;
                        this.childPositions.add(cellPositionInfo);
                    }
                    n3 = (int)((float)n3 + (f2 + (float)this.cellSpacingH));
                }
                n2 += rowData.height + this.cellSpacingV;
                n5 = this.childPositions.size() - 1;
                if (!this.view.isLTR() && n5 > n6) {
                    int n9 = ((Layout.PositionInfo)this.childPositions.get((int)n6)).x;
                    object = (Layout.PositionInfo)this.childPositions.get(n5);
                    int n10 = ((Layout.PositionInfo)object).x + ((Layout.PositionInfo)object).width;
                    this.reverseOrder(n6, n5, n9, n10);
                }
                ++n4;
            }
        }
        return n2;
    }

    @Override
    public void preLayout() {
        int n2;
        HtmlAttribute htmlAttribute;
        int n3;
        Object object2;
        Object object3;
        this.columnData = new ArrayList<ColumnData>();
        this.rowHeight = new ArrayList<RowData>();
        this.tableHeader = new ArrayList<ListRow<CellData>>();
        this.tableContent = new ArrayList<ListRow<CellData>>();
        this.tableFooter = new ArrayList<ListRow<CellData>>();
        BorderCollapseValue borderCollapseValue = StyleResolver.getAttributeValue(this.table.getElement(), AttributeFinder.BORDER_COLLAPSE);
        this.borderCollapse = borderCollapseValue != null && borderCollapseValue.getCollapseType() == 1;
        if (!this.borderCollapse) {
            if (this.table.getHTMLBorderValue() > -1) {
                this.cellSpacingV = 2;
                this.cellSpacingH = 2;
            }
            if ((object3 = StyleResolver.getAttributeValue(this.table.getElement(), AttributeFinder.CELL_SPACING)) != null) {
                if (((MultiIntegerValue)object3).getValues().size() == 1) {
                    this.cellSpacingH = this.cellSpacingV = ((MultiIntegerValue)object3).getValues().get(0).getInt();
                }
                if (((MultiIntegerValue)object3).getValues().size() >= 2) {
                    this.cellSpacingH = ((MultiIntegerValue)object3).getValues().get(0).getInt();
                    this.cellSpacingV = ((MultiIntegerValue)object3).getValues().get(1).getInt();
                }
            } else {
                object2 = StyleResolver.getAttributeValue(this.table.getElement(), AttributeFinder.BORDER_SPACING);
                if (object2 != null) {
                    this.cellSpacingH = this.cellSpacingV = (int)((LengthUnit)object2).calculateValue(1.0f, this.table);
                }
            }
        }
        if (((TableView.TableContainer)(object3 = this.table.getTableContainer())).getHeader() != null) {
            this.prepareTablePart(((TableView.TableContainer)object3).getHeader(), this.tableHeader);
        }
        if (((TableView.TableContainer)object3).getBody() != null) {
            this.prepareTablePart(((TableView.TableContainer)object3).getBody(), this.tableContent);
        }
        if (((TableView.TableContainer)object3).getFooter() != null) {
            this.prepareTablePart(((TableView.TableContainer)object3).getFooter(), this.tableFooter);
        }
        this.constraints = new TreeSet();
        if (this.tableHeader.size() > 0) {
            this.doATLpass1(this.tableHeader);
        }
        if (this.tableContent.size() > 0) {
            this.doATLpass1(this.tableContent);
        }
        if (this.tableFooter.size() > 0) {
            this.doATLpass1(this.tableFooter);
        }
        if ((object2 = this.table.getTableContainer().getColDescription()) != null) {
            n3 = 0;
            Iterator object4 = object2.iterator();
            while (object4.hasNext()) {
                TableView.TableColumnGroupInfo tableColumnGroupInfo = (TableView.TableColumnGroupInfo)object4.next();
                int n4 = n3;
                int n5 = n3;
                htmlAttribute = StyleResolver.getAttributeValue(tableColumnGroupInfo.getSource(), AttributeFinder.COL_SPAN_COL);
                if (htmlAttribute != null) {
                    LengthUnit lengthUnit = StyleResolver.getAttributeValue(tableColumnGroupInfo.getSource(), AttributeFinder.WIDTH);
                    IBackgroundPainter iBackgroundPainter = this.createPainter(tableColumnGroupInfo.getSource());
                    n5 = n4 + ((IntegerValue)htmlAttribute).getInt();
                    if (lengthUnit != null && !lengthUnit.isAuto()) {
                        for (int i2 = n4; i2 < n5; ++i2) {
                            this.addConstraintUnique(new WidthConstraint(lengthUnit, i2, i2 + 1));
                            if (lengthUnit.isAbsolute()) {
                                this.fixWidthOfColumn(i2, lengthUnit);
                            }
                            if (iBackgroundPainter == null) continue;
                            this.columnData.get(i2).painter = iBackgroundPainter;
                        }
                    }
                }
                n2 = n4;
                for (TableView.TableColumnInfo tableColumnInfo : tableColumnGroupInfo.getColumns()) {
                    IBackgroundPainter iBackgroundPainter;
                    LengthUnit lengthUnit;
                    Element element = tableColumnInfo.getSource();
                    htmlAttribute = StyleResolver.getAttributeValue(element, AttributeFinder.COL_SPAN_COL);
                    int n6 = 1;
                    if (htmlAttribute != null) {
                        n6 = ((IntegerValue)htmlAttribute).getInt();
                    }
                    if ((lengthUnit = StyleResolver.getAttributeValue(tableColumnInfo.getSource(), AttributeFinder.WIDTH)) != null && !lengthUnit.isAuto()) {
                        this.addConstraintUnique(new WidthConstraint(lengthUnit, n2, n2 + n6));
                        if (n6 == 1 && lengthUnit.isAbsolute()) {
                            this.fixWidthOfColumn(n2, lengthUnit);
                        }
                    }
                    if ((iBackgroundPainter = this.createPainter(element)) != null) {
                        for (int i3 = n2; i3 < n2 + n6; ++i3) {
                            this.columnData.get(i3).painter = iBackgroundPainter;
                        }
                    }
                    n2 += n6;
                }
                n3 = Math.max(n2, n5);
            }
        }
        for (n3 = 0; n3 < this.tableContent.size(); ++n3) {
            List list = this.tableContent.get(n3);
            for (int i4 = 0; i4 < list.size(); ++i4) {
                TableView.TableCellInfo tableCellInfo;
                CellData cellData = this.fetchCell(list, i4);
                if (cellData.filled || (tableCellInfo = cellData.reference) == null || tableCellInfo.getContent() == null || !(tableCellInfo.getContent() instanceof BlockView)) continue;
                htmlAttribute = ((BlockView)tableCellInfo.getContent()).getWidthUnit();
                n2 = i4 + tableCellInfo.getColspan();
                if (!(htmlAttribute == null || ((LengthUnit)htmlAttribute).isAsterisk() || ((LengthUnit)htmlAttribute).isAuto() || ((LengthUnit)htmlAttribute).getType() == 1 && ((LengthUnit)htmlAttribute).getValue() == 1.0f)) {
                    this.addConstraintUnique(new WidthConstraint((LengthUnit)htmlAttribute, i4, n2));
                    continue;
                }
                if (tableCellInfo.getContent() == null || tableCellInfo.getColspan() <= 1) continue;
                int n7 = (int)tableCellInfo.getContent().getMinimumSpan(0);
                LengthUnit lengthUnit = new LengthUnit(n7 += tableCellInfo.getContent().getBox().getTotalWidthGain());
                this.addConstraintUnique(new WidthConstraint(lengthUnit, i4, n2));
            }
        }
        this.minimumWidth = 0;
        this.preferredWidth = 0;
        for (ColumnData columnData : this.columnData) {
            this.minimumWidth += columnData.virtualMin;
            this.preferredWidth += columnData.virtualMax;
        }
        this.cellSpacingHtotal = this.cellSpacingH * (this.columnData.size() + 1);
        Insets insets = this.getView().getBox().getBorderInsets();
        int n8 = insets.left + insets.right;
        this.minimumWidth += this.cellSpacingHtotal + n8;
        this.preferredWidth += this.cellSpacingHtotal + n8;
        if (this.view.getWidthUnit() != null && this.view.getWidthUnit().isAbsolute()) {
            int n9 = (int)this.view.getWidthUnit().calculateValue(0.0f, this.view);
            if (this.minimumWidth < n9) {
                this.minimumWidth = n9;
            }
            if (this.preferredWidth < n9) {
                this.preferredWidth = n9;
            }
        }
        this.setPreLayouted();
    }

    private void fixWidthOfColumn(int n2, LengthUnit lengthUnit) {
        if (n2 >= this.columnData.size()) {
            return;
        }
        int n3 = Math.round(lengthUnit.calculateValue(1.0f, this.table));
        this.columnData.get(n2).min = n3;
        this.columnData.get(n2).size = n3;
        this.columnData.get(n2).max = n3;
        this.columnData.get(n2).virtualMin = n3;
        this.columnData.get(n2).virtualMax = n3;
    }

    private IBackgroundPainter createPainter(Element element) {
        if (element == null) {
            return null;
        }
        ColorValue colorValue = StyleResolver.getAttributeValue(element, AttributeFinder.BACKGROUND_COLOR);
        UriValue uriValue = StyleResolver.getAttributeValue(element, AttributeFinder.BACKGROUND_IMAGE);
        if (colorValue != null && !colorValue.isTransparent() || uriValue != null && !uriValue.isNone()) {
            return new BackgroundPainter(element, this.getView().getRenderContext());
        }
        return null;
    }

    private void addConstraintUnique(WidthConstraint widthConstraint) {
        if (widthConstraint.start >= this.columnData.size()) {
            return;
        }
        if (widthConstraint.end > this.columnData.size()) {
            widthConstraint.end = this.columnData.size();
        }
        for (WidthConstraint widthConstraint2 : this.constraints) {
            if (widthConstraint2.start != widthConstraint.start || widthConstraint2.end != widthConstraint.end || widthConstraint2.type != widthConstraint.type || !(widthConstraint2.amount.getValue() <= widthConstraint.amount.getValue())) continue;
            this.constraints.remove(widthConstraint2);
            break;
        }
        this.constraints.add(widthConstraint);
    }

    private BorderDescription getWinningBorder(BoxView boxView, BoxView boxView2, boolean bl2, boolean bl3) {
        BorderDescription borderDescription = bl2 ? this.getBorder(boxView, true) : this.getBorder(boxView, false);
        BorderDescription borderDescription2 = bl3 ? this.getBorder(boxView2, false) : this.getBorder(boxView2, true);
        if (borderDescription.style == 9) {
            return borderDescription;
        }
        if (borderDescription2.style == 9) {
            return borderDescription2;
        }
        if (borderDescription2.width > borderDescription.width || bl2 && borderDescription2.width == borderDescription.width) {
            return borderDescription2;
        }
        if (borderDescription2.width < borderDescription.width || bl3 && borderDescription2.width == borderDescription.width) {
            return borderDescription;
        }
        if (borderDescription2.style != borderDescription.style) {
            return borderDescription2.style > borderDescription.style ? borderDescription2 : borderDescription;
        }
        return borderDescription;
    }

    private BorderDescription getWinningBorderH(BoxView boxView, BoxView boxView2, boolean bl2, boolean bl3) {
        BorderDescription borderDescription = bl2 ? this.getBorderH(boxView, true) : this.getBorderH(boxView, false);
        BorderDescription borderDescription2 = bl3 ? this.getBorderH(boxView2, false) : this.getBorderH(boxView2, true);
        if (borderDescription.style == 9) {
            return borderDescription;
        }
        if (borderDescription2.style == 9) {
            return borderDescription2;
        }
        if (borderDescription2.width > borderDescription.width || bl2 && borderDescription2.width == borderDescription.width) {
            return borderDescription2;
        }
        if (borderDescription2.width < borderDescription.width || bl3 && borderDescription2.width == borderDescription.width) {
            return borderDescription;
        }
        if (borderDescription2.style != borderDescription.style) {
            return borderDescription2.style > borderDescription.style ? borderDescription2 : borderDescription;
        }
        return borderDescription;
    }

    private BorderDescription getBorder(BoxView boxView, boolean bl2) {
        BorderDescription borderDescription = new BorderDescription();
        IBoxPainter iBoxPainter = boxView.getBox();
        if (bl2) {
            borderDescription.style = iBoxPainter.setBorderStyles().left;
            if (iBoxPainter instanceof TableBoxPainter) {
                borderDescription.width = ((TableBoxPainter)iBoxPainter).getPaintInsets().left;
            } else {
                borderDescription.width = iBoxPainter.setBorderInsets().left;
            }
        } else {
            borderDescription.style = iBoxPainter.setBorderStyles().right;
            if (iBoxPainter instanceof TableBoxPainter) {
                borderDescription.width = ((TableBoxPainter)iBoxPainter).getPaintInsets().right;
            } else {
                borderDescription.width = iBoxPainter.setBorderInsets().right;
            }
        }
        borderDescription.source = boxView;
        return borderDescription;
    }

    private BorderDescription getBorderH(BoxView boxView, boolean bl2) {
        BorderDescription borderDescription = new BorderDescription();
        IBoxPainter iBoxPainter = boxView.getBox();
        if (bl2) {
            borderDescription.style = iBoxPainter.setBorderStyles().top;
            if (iBoxPainter instanceof TableBoxPainter) {
                borderDescription.width = ((TableBoxPainter)iBoxPainter).getPaintInsets().top;
            } else {
                borderDescription.width = iBoxPainter.setBorderInsets().top;
            }
        } else {
            borderDescription.style = iBoxPainter.setBorderStyles().bottom;
            if (iBoxPainter instanceof TableBoxPainter) {
                borderDescription.width = ((TableBoxPainter)iBoxPainter).getPaintInsets().bottom;
            } else {
                borderDescription.width = iBoxPainter.setBorderInsets().bottom;
            }
        }
        borderDescription.source = boxView;
        return borderDescription;
    }

    private void doATLpass1(List<ListRow<CellData>> list) {
        int n2 = 0;
        for (ListRow<CellData> listRow : list) {
            ListRow<CellData> listRow2 = this.getNextRow(list, n2);
            boolean bl2 = listRow2 == null;
            for (int i2 = 0; i2 < listRow.size(); ++i2) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                CellData cellData = (CellData)listRow.get(i2);
                if (cellData == null || cellData.reference == null) continue;
                BoxView boxView = cellData.reference.getContent();
                if (boxView != null) {
                    boxView.performLayoutWidth();
                }
                if (this.borderCollapse) {
                    Object object5;
                    BorderDescription borderDescription = i2 == 0 || ((CellData)listRow.get(i2 - 1)).reference == null ? this.getWinningBorder(this.table, boxView, true, false) : this.getWinningBorder(((CellData)listRow.get(i2 - 1)).reference.getContent(), boxView, false, false);
                    object4 = i2 == listRow.size() - 1 || ((CellData)listRow.get(i2 + 1)).reference == null ? this.getWinningBorder(boxView, this.table, false, true) : this.getWinningBorder(boxView, ((CellData)listRow.get(i2 + 1)).reference.getContent(), false, false);
                    if (n2 == 0) {
                        object3 = this.getWinningBorderH(this.table, boxView, true, false);
                    } else {
                        object2 = list.get(n2 - 1);
                        if (object2.size() > i2 && ((CellData)object2.get(i2)).reference != null) {
                            object5 = ((CellData)object2.get(i2)).reference.getContent();
                            object3 = this.getWinningBorderH((BoxView)object5, boxView, false, false);
                        } else {
                            object3 = this.getBorderH(boxView, true);
                        }
                    }
                    if (bl2) {
                        object = this.getWinningBorderH(boxView, this.table, false, true);
                    } else if (listRow2 != null && listRow2.size() > i2) {
                        object2 = ((CellData)listRow2.get(i2)).reference.getContent();
                        object = this.getWinningBorderH(boxView, (BoxView)object2, false, false);
                    } else {
                        object = this.getBorderH(boxView, false);
                    }
                    if (boxView != null) {
                        object2 = boxView.getBox();
                        object5 = (TableBoxPainter)(object2 instanceof TableBoxPainter ? object2 : null);
                        if (i2 > 0) {
                            object2.setBorderInsets().left = (int)Math.ceil((float)borderDescription.width / 2.0f);
                        } else if (borderDescription.source != boxView) {
                            object2.setBorderInsets().left = 0;
                        } else if (object5 != null) {
                            ((TableBoxPainter)object5).setLeftIsTableBorder(true);
                        }
                        if (i2 < this.columnData.size() - 1) {
                            object2.setBorderInsets().right = (int)Math.floor((float)((BorderDescription)object4).width / 2.0f);
                        } else if (((BorderDescription)object4).source != boxView) {
                            object2.setBorderInsets().right = 0;
                        } else if (object5 != null) {
                            ((TableBoxPainter)object5).setRightIsTableBorder(true);
                        }
                        if (n2 > 0) {
                            object2.setBorderInsets().top = (int)Math.ceil((float)((BorderDescription)object3).width / 2.0f);
                        } else if (((BorderDescription)object3).source != boxView) {
                            object2.setBorderInsets().top = 0;
                        } else if (object5 != null) {
                            ((TableBoxPainter)object5).setTopIsTableBorder(true);
                        }
                        if (!bl2) {
                            object2.setBorderInsets().bottom = (int)Math.floor((float)((BorderDescription)object).width / 2.0f);
                        } else if (((BorderDescription)object).source != boxView) {
                            object2.setBorderInsets().bottom = 0;
                        } else if (object5 != null) {
                            ((TableBoxPainter)object5).setBottomIsTableBorder(true);
                        }
                        if (borderDescription.source != boxView) {
                            object2.setBorderStyles().left = 0;
                        }
                        if (((BorderDescription)object4).source != boxView) {
                            object2.setBorderStyles().right = 0;
                        }
                        if (((BorderDescription)object3).source != boxView) {
                            object2.setBorderStyles().top = 0;
                        }
                        if (((BorderDescription)object).source != boxView) {
                            object2.setBorderStyles().bottom = 0;
                        }
                    }
                }
                if (cellData.filled) continue;
                int n3 = cellData.reference.getColspan();
                if (n3 == 1) {
                    if (boxView != null) {
                        int n4 = (int)boxView.getMinimumSpan(0) + boxView.getBox().getTotalWidthGain();
                        int n5 = (int)boxView.getPreferredSpan(0) + boxView.getBox().getTotalWidthGain();
                        object = boxView.getWidthUnit();
                        object2 = this.columnData.get(i2);
                        if (object2 == null) {
                            object2 = new ColumnData();
                            this.columnData.set(i2, (ColumnData)object2);
                        }
                        if (((ColumnData)object2).virtualMax < n5) {
                            ((ColumnData)object2).virtualMax = n5;
                        }
                        if (object != null && ((LengthUnit)object).isAbsolute()) {
                            int n6 = (int)((LengthUnit)object).getValue();
                            n4 = n6 > n4 ? n6 : n4;
                            ((ColumnData)object2).virtualMax = n4;
                        }
                        if (((ColumnData)object2).min < n4) {
                            ((ColumnData)object2).min = n4;
                        }
                        if (((ColumnData)object2).max < n5) {
                            ((ColumnData)object2).max = n5;
                        }
                        if (((ColumnData)object2).virtualMin >= n4) continue;
                        ((ColumnData)object2).virtualMin = n4;
                        continue;
                    }
                    object4 = this.columnData.get(i2);
                    if (object4 != null) continue;
                    object4 = new ColumnData();
                    this.columnData.set(i2, (ColumnData)object4);
                    continue;
                }
                if (boxView != null) {
                    ColumnData columnData;
                    int n7;
                    int n8 = (int)boxView.getMinimumSpan(0) + boxView.getBox().getTotalWidthGain();
                    int n9 = (int)boxView.getPreferredSpan(0) + boxView.getBox().getTotalWidthGain();
                    int n10 = 0;
                    int n11 = 0;
                    for (n7 = 0; n7 < n3; ++n7) {
                        ColumnData columnData2 = this.columnData.get(i2 + n7);
                        if (columnData2 == null) {
                            columnData2 = new ColumnData();
                            this.columnData.set(i2 + n7, columnData2);
                        }
                        n10 += columnData2.virtualMin;
                        n11 += columnData2.virtualMax;
                    }
                    n11 += (n3 - 1) * this.cellSpacingH;
                    if (n8 > (n10 += (n3 - 1) * this.cellSpacingH)) {
                        n7 = n8 - n10;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            columnData = this.columnData.get(i2 + i3);
                            columnData.virtualMin += n7 / n3;
                        }
                    }
                    if (n9 <= n11) continue;
                    n7 = n9 - n11;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        columnData = this.columnData.get(i2 + i4);
                        columnData.virtualMax += n7 / n3;
                    }
                    continue;
                }
                for (int i5 = 0; i5 < n3; ++i5) {
                    object3 = this.columnData.get(i2);
                    if (object3 != null) continue;
                    object3 = new ColumnData();
                    this.columnData.set(i2, (ColumnData)object3);
                }
            }
            ++n2;
        }
    }

    private ListRow<CellData> getNextRow(List<ListRow<CellData>> list, int n2) {
        if (n2 < list.size() - 1) {
            return list.get(n2);
        }
        if (list == this.tableHeader) {
            if (this.tableContent.size() > 0) {
                return this.tableContent.get(0);
            }
            if (this.tableFooter.size() > 0) {
                return this.tableFooter.get(0);
            }
        }
        if (list == this.tableContent && this.tableFooter.size() > 0) {
            return this.tableFooter.get(0);
        }
        return null;
    }

    private void prepareTablePart(TableView.TableRowGroup tableRowGroup, List<ListRow<CellData>> list) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (TableView.TableRowInfo tableRowInfo : tableRowGroup.getRows()) {
            n4 = Math.max(n4, tableRowInfo.countValidCells());
        }
        for (TableView.TableRowInfo tableRowInfo : tableRowGroup.getRows()) {
            n2 = 0;
            ListRow<CellData> listRow = this.fetchLine(list, n3);
            ((ListRow)listRow).painter = this.createPainter(tableRowInfo.getSource());
            List<TableView.TableCellInfo> list2 = tableRowInfo.getCells();
            if (list2.size() < n4 && list2.size() > 0 && tableRowInfo.countErrorCells() > 0) {
                TableView.TableCellInfo tableCellInfo = list2.get(list2.size() - 1);
                tableCellInfo.setColspan(n4 - list2.size() + 1);
            }
            for (TableView.TableCellInfo tableCellInfo : list2) {
                CellData cellData = this.fetchCell(listRow, n2);
                while (cellData == null || cellData.filled || cellData.reference != null) {
                    if (cellData != null && cellData.rowPainter == null) {
                        cellData.rowPainter = ((ListRow)listRow).painter;
                    }
                    cellData = this.fetchCell(listRow, ++n2);
                }
                if (cellData.rowPainter == null) {
                    cellData.rowPainter = ((ListRow)listRow).painter;
                }
                cellData.filled = false;
                cellData.reference = tableCellInfo;
                if (tableCellInfo.getContent() instanceof BlockView) {
                    BlockView blockView = (BlockView)tableCellInfo.getContent();
                    blockView.performPreLayout();
                }
                if (tableCellInfo.getRowspan() > 1 || tableCellInfo.getColspan() > 1) {
                    for (int i2 = 0; i2 < tableCellInfo.getRowspan(); ++i2) {
                        ListRow<CellData> listRow2 = this.fetchLine(list, n3 + i2);
                        for (int i3 = 0; i3 < tableCellInfo.getColspan(); ++i3) {
                            CellData cellData2 = this.fetchCell(listRow2, n2 + i3);
                            cellData2.filled = true;
                            cellData2.reference = tableCellInfo;
                            cellData2.rowPainter = ((ListRow)listRow).painter;
                            if (i3 != 0 || i2 != tableCellInfo.getRowspan() - 1) continue;
                            cellData2.fillFinish = true;
                        }
                    }
                }
                cellData.filled = false;
                ++n2;
            }
            ++n3;
        }
    }

    private CellData fetchCell(List<CellData> list, int n2) {
        while (list.size() <= n2) {
            list.add(new CellData());
            if (this.columnData.size() >= list.size()) continue;
            this.columnData.add(null);
        }
        return list.get(n2);
    }

    private ListRow<CellData> fetchLine(List<ListRow<CellData>> list, int n2) {
        while (list.size() <= n2) {
            list.add(new ListRow());
            if (this.rowHeight.size() >= list.size()) continue;
            this.rowHeight.add(null);
        }
        return list.get(n2);
    }

    @Override
    protected int adjustWidth() {
        int n2 = 0;
        LengthUnit lengthUnit = this.view.getWidthUnit();
        if (lengthUnit != null && !lengthUnit.isAuto()) {
            if (lengthUnit.isAbsolute()) {
                n2 = Math.round(lengthUnit.getValue());
            } else {
                ILayouted iLayouted = (ILayouted)((Object)this.view.getParent());
                int n3 = iLayouted.getLayout().getCurrentWidth();
                n2 = Math.round(lengthUnit.calculateValue(n3, this.view));
            }
            n2 -= this.cellSpacingHtotal;
            this.widthPref = n2 -= this.view.getBox().getTotalWidthGain();
        } else {
            n2 = this.view.getParent() != null && this.view.getParent() instanceof BlockView ? ((BlockView)this.view.getParent()).getLayout().getCurrentWidth() : this.view.getContentWidth();
            n2 -= this.cellSpacingHtotal;
            n2 -= this.view.getBox().getTotalWidthGain();
        }
        int n4 = this.minimumWidth - this.cellSpacingHtotal - this.view.getBox().getLeftBorderPadding() - this.view.getBox().getRightBorderPadding();
        if (n2 < n4) {
            n2 = n4;
        }
        if (this.widthPref < n4) {
            this.widthPref = n4;
        }
        this.widthMax = n2;
        return n2;
    }

    @Override
    public void layoutWidth() {
        this.widthPref = this.preferredWidth - this.cellSpacingHtotal - this.view.getBox().getLeftBorderPadding() - this.view.getBox().getRightBorderPadding();
        this.adjustWidth();
        this.width = 0;
        for (ColumnData object2 : this.columnData) {
            object2.size = object2.min;
        }
        for (WidthConstraint widthConstraint : this.constraints) {
            if (widthConstraint.type != 1) continue;
            this.applyConstraintFixed(widthConstraint);
        }
        this.scale(0);
        float f2 = 0.0f;
        boolean[] blArray = new boolean[this.columnData.size()];
        for (WidthConstraint widthConstraint : this.constraints) {
            if (widthConstraint.type != 2 || widthConstraint.end - widthConstraint.start > 1 || blArray[widthConstraint.start]) continue;
            blArray[((WidthConstraint)widthConstraint).start] = true;
            f2 += widthConstraint.amount.getValue();
        }
        boolean bl2 = true;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (blArray[i2]) continue;
            bl2 = false;
            f3 += (float)this.columnData.get(i2).size;
        }
        if (!bl2) {
            int n2;
            float f4 = f2;
            if (f2 >= 1.0f) {
                f4 = 0.99f;
            }
            if ((n2 = (int)(f3 + f3 / (1.0f - f4) * f4)) > this.widthPref) {
                this.widthPref = n2;
                if (this.widthPref > this.widthMax) {
                    this.widthPref = this.widthMax;
                }
            }
        }
        for (WidthConstraint widthConstraint : this.constraints) {
            int n3;
            if (widthConstraint.type != 2 || widthConstraint.end - widthConstraint.start > 1 || (n3 = this.getConstraintUpscaleValue(widthConstraint, f2, f3, bl2)) <= this.widthPref) continue;
            this.widthPref = n3;
            if (this.widthPref <= this.widthMax) continue;
            this.widthPref = this.widthMax;
            break;
        }
        for (WidthConstraint widthConstraint : this.constraints) {
            if (widthConstraint.type != 2 || widthConstraint.end - widthConstraint.start > 1) continue;
            this.applyConstraintSingleRelative(widthConstraint, f2, f3, bl2);
        }
        this.scale(this.widthPref);
        this.setCurrentWidth(this.width + this.cellSpacingHtotal);
        this.view.setContentWidth(this.width + this.cellSpacingHtotal);
    }

    private int getConstraintUpscaleValue(WidthConstraint widthConstraint, float f2, float f3, boolean bl2) {
        if (widthConstraint.type != 2) {
            return -1;
        }
        if (widthConstraint.end - widthConstraint.start > 1) {
            return -1;
        }
        float f4 = widthConstraint.amount.getValue();
        if (f4 == 1.0f) {
            return -1;
        }
        if (!bl2) {
            if (f2 >= 1.0f) {
                f4 /= f2;
                f2 = 0.99f;
            }
        } else {
            f4 /= f2;
        }
        ColumnData columnData = this.columnData.get(widthConstraint.start);
        return Math.round((float)columnData.max / f4);
    }

    private void applyConstraintSingleRelative(WidthConstraint widthConstraint, float f2, float f3, boolean bl2) {
        if (widthConstraint.type != 2) {
            return;
        }
        if (widthConstraint.end - widthConstraint.start > 1) {
            return;
        }
        float f4 = widthConstraint.amount.getValue();
        if (f4 == 1.0f) {
            return;
        }
        float f5 = Math.min(this.widthPref, this.widthMax);
        if (!bl2) {
            if (f2 >= 1.0f) {
                f2 = 0.99f;
            }
        } else {
            f4 /= f2;
        }
        ColumnData columnData = this.columnData.get(widthConstraint.start);
        int n2 = Math.round(f5 * f4);
        columnData.size = Math.max(columnData.min, n2);
        columnData.type = 2;
    }

    private void applyConstraintFixed(WidthConstraint widthConstraint) {
        ColumnData columnData3;
        int n2;
        if (widthConstraint.type != 1) {
            return;
        }
        if (this.columnData == null || this.columnData.size() == 0) {
            return;
        }
        int n3 = (int)widthConstraint.amount.getValue();
        if (widthConstraint.end - widthConstraint.start == 1) {
            ColumnData columnData2 = this.columnData.get(widthConstraint.start);
            int n4 = columnData2.size;
            columnData2.type = widthConstraint.type;
            if (n4 < n3) {
                this.width += n3 - n4;
                columnData2.size = n3;
            }
            return;
        }
        int n5 = 0;
        for (n2 = widthConstraint.start; n2 < widthConstraint.end; ++n2) {
            columnData3 = this.columnData.get(n2);
            if (columnData3.type == 0) {
                ++n5;
            }
            n3 -= columnData3.size;
        }
        if (n3 > 0) {
            this.width += n3;
            for (n2 = widthConstraint.start; n2 < widthConstraint.end; ++n2) {
                columnData3 = this.columnData.get(n2);
                if (columnData3.type != 0) continue;
                int n6 = this.columnData.get(n2).size;
                this.columnData.get(n2).size = n6 + n3 / n5;
            }
        }
        this.width = 0;
        for (ColumnData columnData3 : this.columnData) {
            this.width += columnData3.size;
        }
    }

    private void scale(int n2) {
        int n3;
        int n4;
        int n5;
        this.width = 0;
        for (ColumnData columnData : this.columnData) {
            this.width += columnData.size;
        }
        int n6 = this.widthPref;
        if (this.width >= this.widthPref && this.width < this.widthMax && (n2 == 0 || n2 == this.width)) {
            return;
        }
        if (this.width < this.widthPref) {
            n6 = this.widthPref;
        }
        if (n2 > 0) {
            n6 = n2;
        }
        if (n6 > this.widthMax) {
            n6 = this.widthMax;
        }
        if ((n5 = n6 - this.width) == 0) {
            return;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        int[] nArray4 = new int[3];
        for (ColumnData columnData : this.columnData) {
            if (columnData.size < columnData.min) {
                columnData.size = columnData.min;
            }
            int n7 = columnData.type;
            nArray4[n7] = nArray4[n7] + columnData.size;
            int n8 = columnData.type;
            nArray2[n8] = nArray2[n8] + (columnData.max > 0 ? columnData.max : columnData.size);
            int n9 = columnData.type;
            nArray[n9] = nArray[n9] + columnData.min;
            int n10 = columnData.type;
            nArray3[n10] = nArray3[n10] + 1;
        }
        if (this.width < this.widthMax && nArray2[0] == 0 && nArray2[2] == 0 && nArray2[1] > 0 && nArray3[1] == this.columnData.size()) {
            return;
        }
        for (n4 = 0; n4 <= 2; ++n4) {
            int n11 = nArray3[n4];
            if (n11 > 0) {
                int n12;
                int n13;
                int n14 = n5 > 0 ? n5 : ((n13 = nArray[n4] - nArray4[n4]) > n5 ? n13 : n5);
                n5 -= n14;
                this.width += n14;
                n13 = n14;
                n3 = nArray2[n4] - nArray4[n4];
                if (n14 > 0 && n3 > 0 && nArray2[n4] > 0) {
                    float f2 = 0.0f;
                    f2 = n3 < n14 ? 1.0f : (float)n14 / (float)n3;
                    for (ColumnData columnData : this.columnData) {
                        int n15;
                        if (columnData.type != n4 || (n15 = columnData.max - columnData.size) <= 0) continue;
                        n12 = Math.round((float)n15 * f2);
                        n14 -= n12;
                        columnData.size += n12;
                    }
                }
                n13 = n14;
                if (n14 != 0 && nArray2[n4] > 0) {
                    int n16 = 0;
                    for (ColumnData columnData : this.columnData) {
                        if (columnData.type != n4) continue;
                        n16 += n14 >= 0 ? (columnData.max > 0 ? columnData.max : columnData.size) : columnData.size - columnData.min;
                    }
                    if (n16 != 0) {
                        for (ColumnData columnData : this.columnData) {
                            if (columnData.type != n4) continue;
                            float f3 = (float)(n14 >= 0 ? (columnData.max > 0 ? columnData.max : columnData.size) : columnData.size - columnData.min) / (float)n16;
                            n12 = Math.round((float)n13 * f3);
                            if (n12 < columnData.min - columnData.size) {
                                n12 = columnData.min - columnData.size;
                            }
                            n14 -= n12;
                            columnData.size += n12;
                        }
                        if (n14 > 0) {
                            this.columnData.get(this.columnData.size() - 1).size += n14;
                        }
                    }
                }
                n5 += n14;
                this.width -= n14;
            }
            if (n5 == 0) break;
        }
        for (n4 = 0; n4 <= 2; ++n4) {
            int n17 = nArray3[n4];
            if (n17 <= 0 || Math.abs(n5) <= 2) continue;
            Iterator<ColumnData> iterator = this.columnData.iterator();
            while (iterator.hasNext()) {
                n3 = n5 / n17;
                ColumnData columnData = iterator.next();
                if (n3 < columnData.min - columnData.size) {
                    n3 = columnData.min - columnData.size;
                }
                n5 -= n3;
                columnData.size += n3;
            }
        }
        if (n5 > 0) {
            for (ColumnData columnData : this.columnData) {
                columnData.size += n5 / this.columnData.size();
            }
            n5 = 0;
        }
        this.width = n6 - n5;
    }

    @Override
    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle = shape.getBounds();
        if (this.view.getVisibility() != 0) {
            throw new BadLocationException("Location is within a unvisible Element", n2);
        }
        int n3 = rectangle.x + this.view.getLeftInset();
        int n4 = rectangle.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        Shape shape2 = null;
        for (Layout.PositionInfo positionInfo : this.getChildren()) {
            if (positionInfo.view == null) continue;
            int n5 = positionInfo.view.getStartOffset();
            int n6 = positionInfo.view.getEndOffset();
            if (bias == Position.Bias.Forward) {
                --n6;
            } else {
                ++n5;
            }
            if (n5 > n2 || n6 < n2) continue;
            rectangle.x = positionInfo.x + n3;
            rectangle.y = positionInfo.y + n4;
            rectangle.width = positionInfo.view.getOuterWidth();
            rectangle.height = positionInfo.view.getOuterHeight();
            shape2 = positionInfo.view.modelToView(n2, rectangle, bias);
            break;
        }
        return shape2;
    }

    @Override
    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = shape.getBounds();
        if (this.view.getVisibility() != 0) {
            return -1;
        }
        int n2 = rectangle.x + this.view.getLeftInset();
        int n3 = rectangle.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        int n4 = -1;
        Point point = new Point((int)f2, (int)f3);
        for (Layout.PositionInfo positionInfo : this.getChildren()) {
            if (positionInfo.view == null) continue;
            rectangle.x = positionInfo.x + n2;
            rectangle.y = positionInfo.y + n3;
            rectangle.width = positionInfo.view.getOuterWidth();
            rectangle.height = positionInfo.view.getOuterHeight();
            if (!rectangle.contains(point)) continue;
            n4 = positionInfo.view.viewToModel(f2, f3, rectangle, biasArray);
            break;
        }
        if (n4 < 0) {
            double d2 = 2.147483647E9;
            Layout.PositionInfo positionInfo = null;
            Point point2 = new Point();
            double d3 = 0.0;
            for (Layout.PositionInfo positionInfo2 : this.getChildren()) {
                if (positionInfo2.view == null) continue;
                rectangle.x = positionInfo2.x + n2;
                rectangle.y = positionInfo2.y + n3;
                rectangle.width = positionInfo2.view.getOuterWidth();
                rectangle.height = positionInfo2.view.getOuterHeight();
                point2.x = rectangle.x;
                point2.y = rectangle.y;
                d3 = point2.distance(point);
                point2.x += rectangle.width;
                d3 = Math.min(d3, point2.distance(point));
                point2.y += rectangle.height;
                d3 = Math.min(d3, point2.distance(point));
                point2.x -= rectangle.width;
                if (!((d3 = Math.min(d3, point2.distance(point))) < d2)) continue;
                d2 = d3;
                positionInfo = positionInfo2;
            }
            if (positionInfo != null) {
                rectangle.x = positionInfo.x + n2;
                rectangle.y = positionInfo.y + n3;
                rectangle.width = positionInfo.view.getOuterWidth();
                rectangle.height = positionInfo.view.getOuterHeight();
                n4 = positionInfo.view.viewToModel(f2, f3, rectangle, biasArray);
            }
        }
        return n4;
    }

    @Override
    public void predictWidth(int n2) {
        this.width = n2;
    }

    public boolean isBorderCollapse() {
        return this.borderCollapse;
    }

    @Override
    public void layoutVerticalAlign(int n2, int n3) {
    }

    @Override
    public ViewPositionInfo getViewForPosition(Point point, Rectangle rectangle) {
        Rectangle rectangle2 = rectangle.getBounds();
        if (this.view.getVisibility() != 0) {
            return null;
        }
        int n2 = rectangle2.x + this.view.getLeftInset();
        int n3 = rectangle2.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        ViewPositionInfo viewPositionInfo = null;
        for (Layout.PositionInfo positionInfo : this.getChildren()) {
            if (positionInfo.view != null) {
                rectangle2.setBounds(positionInfo.x + n2, positionInfo.y + n3, positionInfo.view.getOuterWidth(), positionInfo.view.getOuterHeight());
            } else {
                rectangle2.setBounds(positionInfo.x + n2, positionInfo.y + n3, positionInfo.width, positionInfo.height);
            }
            if (!rectangle2.contains(point)) continue;
            viewPositionInfo = positionInfo.view.getViewForPosition(point, rectangle2);
            if (viewPositionInfo == null) {
                return new ViewPositionInfo(rectangle2, positionInfo.view);
            }
            return viewPositionInfo;
        }
        return null;
    }

    @Override
    public Rectangle getSpan() {
        return this.span;
    }

    @Override
    protected void calculateCollapsedMargins() {
    }

    static /* synthetic */ int access$008() {
        return constraintIndexCounter++;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListRow<T>
    extends ArrayList<T> {
        private IBackgroundPainter painter;

        private ListRow() {
        }
    }

    public class CellPositionInfo
    extends Layout.PositionInfo {
        private static final long serialVersionUID = 6888370347647866367L;
        private IBackgroundPainter columnPainter;
        private IBackgroundPainter rowPainter;

        public CellPositionInfo(BoxView boxView) {
            super(boxView);
        }

        public IBackgroundPainter getColumnPainter() {
            return this.columnPainter;
        }

        public IBackgroundPainter getRowPainter() {
            return this.rowPainter;
        }
    }

    private static class BorderDescription {
        private int width;
        private int style;
        private BoxView source;

        private BorderDescription() {
        }
    }

    private static class RowData {
        private int selfHeight;
        private int height;
        private int baseline;

        public RowData(int n2, int n3) {
            this.selfHeight = n2;
            this.height = n2;
            this.baseline = n3;
        }
    }

    private static class ColumnData {
        private int min;
        private int virtualMin;
        private int max;
        private int virtualMax;
        private int type;
        private int size;
        private IBackgroundPainter painter = null;

        private ColumnData() {
        }

        public String toString() {
            return "Min:" + this.min + ",Max:" + this.max + ",Type:" + this.type + ",Size:" + this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WidthConstraint
    implements Comparable<WidthConstraint> {
        private int index = TableLayout.access$008();
        private int type;
        private LengthUnit amount;
        private int start;
        private int end;

        public WidthConstraint(LengthUnit lengthUnit, int n2, int n3) {
            this.start = n2;
            this.end = n3;
            this.amount = lengthUnit;
            this.type = lengthUnit.isAbsolute() ? 1 : 2;
        }

        public String toString() {
            return "[" + this.start + ":" + this.end + "] width:" + this.amount;
        }

        @Override
        public int compareTo(WidthConstraint widthConstraint) {
            if (this.type < widthConstraint.type) {
                return 1;
            }
            if (this.end - this.start < widthConstraint.end - widthConstraint.start) {
                return 1;
            }
            int n2 = (int)(this.amount.getValue() - widthConstraint.amount.getValue());
            if (n2 != 0) {
                return -n2;
            }
            return widthConstraint.index - this.index;
        }
    }

    private static class CellData {
        private boolean filled = false;
        private boolean fillFinish = false;
        private TableView.TableCellInfo reference;
        private IBackgroundPainter rowPainter;

        private CellData() {
        }

        public String toString() {
            if (this.reference != null) {
                if (this.filled) {
                    return "Spaned Cell";
                }
                return this.reference.getContent().toString();
            }
            return "Empty Cell";
        }
    }
}

