/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.util.BooleanList;
import org.jfree.util.PaintList;
import org.jfree.util.StrokeList;

public class HashUtilities {
    public static int hashCodeForPaint(Paint p2) {
        if (p2 == null) {
            return 0;
        }
        int result = 0;
        if (p2 instanceof GradientPaint) {
            GradientPaint gp2 = (GradientPaint)p2;
            result = 193;
            result = 37 * result + gp2.getColor1().hashCode();
            result = 37 * result + gp2.getPoint1().hashCode();
            result = 37 * result + gp2.getColor2().hashCode();
            result = 37 * result + gp2.getPoint2().hashCode();
        } else {
            result = p2.hashCode();
        }
        return result;
    }

    public static int hashCodeForDoubleArray(double[] a2) {
        if (a2 == null) {
            return 0;
        }
        int result = 193;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            long temp = Double.doubleToLongBits(a2[i2]);
            result = 29 * result + (int)(temp ^ temp >>> 32);
        }
        return result;
    }

    public static int hashCode(int pre, boolean b2) {
        return 37 * pre + (b2 ? 0 : 1);
    }

    public static int hashCode(int pre, int i2) {
        return 37 * pre + i2;
    }

    public static int hashCode(int pre, double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return 37 * pre + (int)(l2 ^ l2 >>> 32);
    }

    public static int hashCode(int pre, Paint p2) {
        return 37 * pre + HashUtilities.hashCodeForPaint(p2);
    }

    public static int hashCode(int pre, Stroke s2) {
        int h2 = s2 != null ? s2.hashCode() : 0;
        return 37 * pre + h2;
    }

    public static int hashCode(int pre, String s2) {
        int h2 = s2 != null ? s2.hashCode() : 0;
        return 37 * pre + h2;
    }

    public static int hashCode(int pre, Comparable c2) {
        int h2 = c2 != null ? c2.hashCode() : 0;
        return 37 * pre + h2;
    }

    public static int hashCode(int pre, Object obj) {
        int h2 = obj != null ? obj.hashCode() : 0;
        return 37 * pre + h2;
    }

    public static int hashCode(int pre, BooleanList list) {
        if (list == null) {
            return pre;
        }
        int result = 127;
        int size = list.size();
        result = HashUtilities.hashCode(result, size);
        if (size > 0) {
            result = HashUtilities.hashCode(result, list.getBoolean(0));
            if (size > 1) {
                result = HashUtilities.hashCode(result, list.getBoolean(size - 1));
                if (size > 2) {
                    result = HashUtilities.hashCode(result, list.getBoolean(size / 2));
                }
            }
        }
        return 37 * pre + result;
    }

    public static int hashCode(int pre, PaintList list) {
        if (list == null) {
            return pre;
        }
        int result = 127;
        int size = list.size();
        result = HashUtilities.hashCode(result, size);
        if (size > 0) {
            result = HashUtilities.hashCode(result, list.getPaint(0));
            if (size > 1) {
                result = HashUtilities.hashCode(result, list.getPaint(size - 1));
                if (size > 2) {
                    result = HashUtilities.hashCode(result, list.getPaint(size / 2));
                }
            }
        }
        return 37 * pre + result;
    }

    public static int hashCode(int pre, StrokeList list) {
        if (list == null) {
            return pre;
        }
        int result = 127;
        int size = list.size();
        result = HashUtilities.hashCode(result, size);
        if (size > 0) {
            result = HashUtilities.hashCode(result, list.getStroke(0));
            if (size > 1) {
                result = HashUtilities.hashCode(result, list.getStroke(size - 1));
                if (size > 2) {
                    result = HashUtilities.hashCode(result, list.getStroke(size / 2));
                }
            }
        }
        return 37 * pre + result;
    }
}

