/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.axis;

import com.inet.jfree.chart.axis.NumberAxis;
import com.inet.jfree.chart.plot.IntervalMarker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;

public class MarkerAxisBand
implements Serializable {
    private static final long serialVersionUID = -1729482413886398919L;
    private NumberAxis axis;
    private double topOuterGap;
    private double topInnerGap;
    private double bottomOuterGap;
    private double bottomInnerGap;
    private Font font;
    private List markers;

    public MarkerAxisBand(NumberAxis axis, double topOuterGap, double topInnerGap, double bottomOuterGap, double bottomInnerGap, Font font) {
        this.axis = axis;
        this.topOuterGap = topOuterGap;
        this.topInnerGap = topInnerGap;
        this.bottomOuterGap = bottomOuterGap;
        this.bottomInnerGap = bottomInnerGap;
        this.font = font;
        this.markers = new ArrayList();
    }

    public void addMarker(IntervalMarker marker) {
        this.markers.add(marker);
    }

    public double getHeight(Graphics2D g2) {
        double result = 0.0;
        if (this.markers.size() > 0) {
            LineMetrics metrics = this.font.getLineMetrics("123g", g2.getFontRenderContext());
            result = this.topOuterGap + this.topInnerGap + (double)metrics.getHeight() + this.bottomInnerGap + this.bottomOuterGap;
        }
        return result;
    }

    private void drawStringInRect(Graphics2D g2, Rectangle2D bounds, Font font, String text) {
        g2.setFont(font);
        FontMetrics fm2 = g2.getFontMetrics(font);
        Rectangle2D r2 = TextUtilities.getTextBounds(text, g2, fm2);
        double x2 = bounds.getX();
        if (r2.getWidth() < bounds.getWidth()) {
            x2 += (bounds.getWidth() - r2.getWidth()) / 2.0;
        }
        LineMetrics metrics = font.getLineMetrics(text, g2.getFontRenderContext());
        g2.drawString(text, (float)x2, (float)(bounds.getMaxY() - this.bottomInnerGap - (double)metrics.getDescent()));
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, double x2, double y2) {
        double h2 = this.getHeight(g2);
        for (IntervalMarker marker : this.markers) {
            double start = Math.max(marker.getStartValue(), this.axis.getRange().getLowerBound());
            double end = Math.min(marker.getEndValue(), this.axis.getRange().getUpperBound());
            double s2 = this.axis.valueToJava2D(start, dataArea, RectangleEdge.BOTTOM);
            double e2 = this.axis.valueToJava2D(end, dataArea, RectangleEdge.BOTTOM);
            Rectangle2D.Double r2 = new Rectangle2D.Double(s2, y2 + this.topOuterGap, e2 - s2, h2 - this.topOuterGap - this.bottomOuterGap);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            g2.setPaint(marker.getPaint());
            g2.fill(r2);
            g2.setPaint(marker.getOutlinePaint());
            g2.draw(r2);
            g2.setComposite(originalComposite);
            g2.setPaint(Color.black);
            this.drawStringInRect(g2, r2, this.font, marker.getLabel());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MarkerAxisBand)) {
            return false;
        }
        MarkerAxisBand that = (MarkerAxisBand)obj;
        if (this.topOuterGap != that.topOuterGap) {
            return false;
        }
        if (this.topInnerGap != that.topInnerGap) {
            return false;
        }
        if (this.bottomInnerGap != that.bottomInnerGap) {
            return false;
        }
        if (this.bottomOuterGap != that.bottomOuterGap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.font, that.font)) {
            return false;
        }
        return ObjectUtilities.equal(this.markers, that.markers);
    }

    public int hashCode() {
        int result = 37;
        result = 19 * result + this.font.hashCode();
        result = 19 * result + ((Object)this.markers).hashCode();
        return result;
    }
}

