/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.axis;

import com.inet.jfree.chart.axis.NumberTickUnit;
import com.inet.jfree.chart.axis.TickUnit;
import com.inet.jfree.chart.axis.TickUnitSource;
import java.io.Serializable;
import java.text.DecimalFormat;

public class StandardTickUnitSource
implements TickUnitSource,
Serializable {
    private static final double LOG_10_VALUE = Math.log(10.0);

    public TickUnit getLargerTickUnit(TickUnit unit) {
        double x2 = unit.getSize();
        double log = Math.log(x2) / LOG_10_VALUE;
        double higher = Math.ceil(log);
        return new NumberTickUnit(Math.pow(10.0, higher), new DecimalFormat("0.0E0"));
    }

    public TickUnit getCeilingTickUnit(TickUnit unit) {
        return this.getLargerTickUnit(unit);
    }

    public TickUnit getCeilingTickUnit(double size) {
        double log = Math.log(size) / LOG_10_VALUE;
        double higher = Math.ceil(log);
        return new NumberTickUnit(Math.pow(10.0, higher), new DecimalFormat("0.0E0"));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof StandardTickUnitSource;
    }

    public int hashCode() {
        return 0;
    }
}

