/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.block;

import com.inet.jfree.chart.block.Arrangement;
import com.inet.jfree.chart.block.Block;
import com.inet.jfree.chart.block.BlockContainer;
import com.inet.jfree.chart.block.LengthConstraintType;
import com.inet.jfree.chart.block.RectangleConstraint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import org.jfree.ui.Size2D;

public class GridArrangement
implements Arrangement,
Serializable {
    private static final long serialVersionUID = -2563758090144655938L;
    private int rows;
    private int columns;

    public GridArrangement(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
    }

    public void add(Block block, Object key) {
    }

    public Size2D arrange(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        LengthConstraintType w2 = constraint.getWidthConstraintType();
        LengthConstraintType h2 = constraint.getHeightConstraintType();
        if (w2 == LengthConstraintType.NONE) {
            if (h2 == LengthConstraintType.NONE) {
                return this.arrangeNN(container, g2);
            }
            if (h2 == LengthConstraintType.FIXED) {
                return this.arrangeNF(container, g2, constraint);
            }
            if (h2 == LengthConstraintType.RANGE) {
                return this.arrangeNR(container, g2, constraint);
            }
        } else if (w2 == LengthConstraintType.FIXED) {
            if (h2 == LengthConstraintType.NONE) {
                return this.arrangeFN(container, g2, constraint);
            }
            if (h2 == LengthConstraintType.FIXED) {
                return this.arrangeFF(container, g2, constraint);
            }
            if (h2 == LengthConstraintType.RANGE) {
                return this.arrangeFR(container, g2, constraint);
            }
        } else if (w2 == LengthConstraintType.RANGE) {
            if (h2 == LengthConstraintType.NONE) {
                return this.arrangeRN(container, g2, constraint);
            }
            if (h2 == LengthConstraintType.FIXED) {
                return this.arrangeRF(container, g2, constraint);
            }
            if (h2 == LengthConstraintType.RANGE) {
                return this.arrangeRR(container, g2, constraint);
            }
        }
        throw new RuntimeException("Should never get to here!");
    }

    protected Size2D arrangeNN(BlockContainer container, Graphics2D g2) {
        double maxW = 0.0;
        double maxH = 0.0;
        List blocks = container.getBlocks();
        for (Block b2 : blocks) {
            if (b2 == null) continue;
            Size2D s2 = b2.arrange(g2, RectangleConstraint.NONE);
            maxW = Math.max(maxW, s2.width);
            maxH = Math.max(maxH, s2.height);
        }
        double width = (double)this.columns * maxW;
        double height = (double)this.rows * maxH;
        RectangleConstraint c2 = new RectangleConstraint(width, height);
        return this.arrangeFF(container, g2, c2);
    }

    protected Size2D arrangeFF(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        double width = constraint.getWidth() / (double)this.columns;
        double height = constraint.getHeight() / (double)this.rows;
        List blocks = container.getBlocks();
        for (int c2 = 0; c2 < this.columns; ++c2) {
            int index;
            for (int r2 = 0; r2 < this.rows && (index = r2 * this.columns + c2) < blocks.size(); ++r2) {
                Block b2 = (Block)blocks.get(index);
                if (b2 == null) continue;
                b2.setBounds(new Rectangle2D.Double((double)c2 * width, (double)r2 * height, width, height));
            }
        }
        return new Size2D((double)this.columns * width, (double)this.rows * height);
    }

    protected Size2D arrangeFR(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint c1 = constraint.toUnconstrainedHeight();
        Size2D size1 = this.arrange(container, g2, c1);
        if (constraint.getHeightRange().contains(size1.getHeight())) {
            return size1;
        }
        double h2 = constraint.getHeightRange().constrain(size1.getHeight());
        RectangleConstraint c2 = constraint.toFixedHeight(h2);
        return this.arrange(container, g2, c2);
    }

    protected Size2D arrangeRF(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint c1 = constraint.toUnconstrainedWidth();
        Size2D size1 = this.arrange(container, g2, c1);
        if (constraint.getWidthRange().contains(size1.getWidth())) {
            return size1;
        }
        double w2 = constraint.getWidthRange().constrain(size1.getWidth());
        RectangleConstraint c2 = constraint.toFixedWidth(w2);
        return this.arrange(container, g2, c2);
    }

    protected Size2D arrangeRN(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint c1 = constraint.toUnconstrainedWidth();
        Size2D size1 = this.arrange(container, g2, c1);
        if (constraint.getWidthRange().contains(size1.getWidth())) {
            return size1;
        }
        double w2 = constraint.getWidthRange().constrain(size1.getWidth());
        RectangleConstraint c2 = constraint.toFixedWidth(w2);
        return this.arrange(container, g2, c2);
    }

    protected Size2D arrangeNR(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint c1 = constraint.toUnconstrainedHeight();
        Size2D size1 = this.arrange(container, g2, c1);
        if (constraint.getHeightRange().contains(size1.getHeight())) {
            return size1;
        }
        double h2 = constraint.getHeightRange().constrain(size1.getHeight());
        RectangleConstraint c2 = constraint.toFixedHeight(h2);
        return this.arrange(container, g2, c2);
    }

    protected Size2D arrangeRR(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        Size2D size1 = this.arrange(container, g2, RectangleConstraint.NONE);
        if (constraint.getWidthRange().contains(size1.getWidth())) {
            if (constraint.getHeightRange().contains(size1.getHeight())) {
                return size1;
            }
            double h2 = constraint.getHeightRange().constrain(size1.getHeight());
            RectangleConstraint cc2 = new RectangleConstraint(size1.getWidth(), h2);
            return this.arrangeFF(container, g2, cc2);
        }
        if (constraint.getHeightRange().contains(size1.getHeight())) {
            double w2 = constraint.getWidthRange().constrain(size1.getWidth());
            RectangleConstraint cc3 = new RectangleConstraint(w2, size1.getHeight());
            return this.arrangeFF(container, g2, cc3);
        }
        double w3 = constraint.getWidthRange().constrain(size1.getWidth());
        double h3 = constraint.getHeightRange().constrain(size1.getHeight());
        RectangleConstraint cc4 = new RectangleConstraint(w3, h3);
        return this.arrangeFF(container, g2, cc4);
    }

    protected Size2D arrangeFN(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        double width = constraint.getWidth() / (double)this.columns;
        RectangleConstraint bc2 = constraint.toFixedWidth(width);
        List blocks = container.getBlocks();
        double maxH = 0.0;
        for (int r2 = 0; r2 < this.rows; ++r2) {
            int index;
            for (int c2 = 0; c2 < this.columns && (index = r2 * this.columns + c2) < blocks.size(); ++c2) {
                Block b2 = (Block)blocks.get(index);
                if (b2 == null) continue;
                Size2D s2 = b2.arrange(g2, bc2);
                maxH = Math.max(maxH, s2.getHeight());
            }
        }
        RectangleConstraint cc2 = constraint.toFixedHeight(maxH * (double)this.rows);
        return this.arrange(container, g2, cc2);
    }

    protected Size2D arrangeNF(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        double height = constraint.getHeight() / (double)this.rows;
        RectangleConstraint bc2 = constraint.toFixedHeight(height);
        List blocks = container.getBlocks();
        double maxW = 0.0;
        for (int r2 = 0; r2 < this.rows; ++r2) {
            int index;
            for (int c2 = 0; c2 < this.columns && (index = r2 * this.columns + c2) < blocks.size(); ++c2) {
                Block b2 = (Block)blocks.get(index);
                if (b2 == null) continue;
                Size2D s2 = b2.arrange(g2, bc2);
                maxW = Math.max(maxW, s2.getWidth());
            }
        }
        RectangleConstraint cc2 = constraint.toFixedWidth(maxW * (double)this.columns);
        return this.arrange(container, g2, cc2);
    }

    public void clear() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridArrangement)) {
            return false;
        }
        GridArrangement that = (GridArrangement)obj;
        if (this.columns != that.columns) {
            return false;
        }
        return this.rows == that.rows;
    }
}

