/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.imagemap;

import com.inet.jfree.chart.ChartRenderingInfo;
import com.inet.jfree.chart.entity.ChartEntity;
import com.inet.jfree.chart.entity.EntityCollection;
import com.inet.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import com.inet.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import com.inet.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import com.inet.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import com.inet.jfree.chart.imagemap.URLTagFragmentGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.util.StringUtils;

public class ImageMapUtilities {
    public static void writeImageMap(PrintWriter writer, String name, ChartRenderingInfo info) throws IOException {
        ImageMapUtilities.writeImageMap(writer, name, info, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter writer, String name, ChartRenderingInfo info, boolean useOverLibForToolTips) throws IOException {
        ToolTipTagFragmentGenerator toolTipTagFragmentGenerator = null;
        toolTipTagFragmentGenerator = useOverLibForToolTips ? new OverLIBToolTipTagFragmentGenerator() : new StandardToolTipTagFragmentGenerator();
        ImageMapUtilities.writeImageMap(writer, name, info, toolTipTagFragmentGenerator, new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter writer, String name, ChartRenderingInfo info, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) throws IOException {
        writer.println(ImageMapUtilities.getImageMap(name, info, toolTipTagFragmentGenerator, urlTagFragmentGenerator));
    }

    public static String getImageMap(String name, ChartRenderingInfo info) {
        return ImageMapUtilities.getImageMap(name, info, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static String getImageMap(String name, ChartRenderingInfo info, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) {
        StringBuffer sb = new StringBuffer();
        sb.append("<map id=\"" + ImageMapUtilities.htmlEscape(name) + "\" name=\"" + ImageMapUtilities.htmlEscape(name) + "\">");
        sb.append(StringUtils.getLineSeparator());
        EntityCollection entities = info.getEntityCollection();
        if (entities != null) {
            int count = entities.getEntityCount();
            for (int i2 = count - 1; i2 >= 0; --i2) {
                String area;
                ChartEntity entity = entities.getEntity(i2);
                if (entity.getToolTipText() == null && entity.getURLText() == null || (area = entity.getImageMapAreaTag(toolTipTagFragmentGenerator, urlTagFragmentGenerator)).length() <= 0) continue;
                sb.append(area);
                sb.append(StringUtils.getLineSeparator());
            }
        }
        sb.append("</map>");
        return sb.toString();
    }

    public static String htmlEscape(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Null 'input' argument.");
        }
        StringBuffer result = new StringBuffer();
        int length = input.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = input.charAt(i2);
            if (c2 == '&') {
                result.append("&amp;");
                continue;
            }
            if (c2 == '\"') {
                result.append("&quot;");
                continue;
            }
            if (c2 == '<') {
                result.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                result.append("&gt;");
                continue;
            }
            if (c2 == '\'') {
                result.append("&#39;");
                continue;
            }
            if (c2 == '\\') {
                result.append("&#092;");
                continue;
            }
            result.append(c2);
        }
        return result.toString();
    }

    public static String javascriptEscape(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Null 'input' argument.");
        }
        StringBuffer result = new StringBuffer();
        int length = input.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = input.charAt(i2);
            if (c2 == '\"') {
                result.append("\\\"");
                continue;
            }
            if (c2 == '\'') {
                result.append("\\'");
                continue;
            }
            if (c2 == '\\') {
                result.append("\\\\");
                continue;
            }
            result.append(c2);
        }
        return result.toString();
    }
}

