/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.labels;

import com.inet.jfree.chart.labels.AbstractCategoryItemLabelGenerator;
import com.inet.jfree.chart.labels.CategoryItemLabelGenerator;
import com.inet.jfree.data.DataUtilities;
import com.inet.jfree.data.category.CategoryDataset;
import com.inet.jfree.data.category.StackedCategoryDataset;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;

public class FormattedLabelGenerator
extends AbstractCategoryItemLabelGenerator
implements CategoryItemLabelGenerator {
    private boolean getCumulativeValue = false;
    private boolean getPercentValue = false;
    private final String nullValueString = "-";
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private NumberFormat percentFormat;
    public static final String PATTERN_LABEL = "{0}";
    public static final String PATTERN_VALUE = "{2}";
    public static final String PATTERN_PERCENT = "{3}";
    public static final String PATTERN_LABEL_VALUE = "{0} {2}";
    public static final String PATTERN_LABEL_PERCENT = "{0} {3}";

    private FormattedLabelGenerator(String pattern, NumberFormat format) {
        super(pattern, format);
        this.numberFormat = format;
        this.dateFormat = null;
        this.percentFormat = null;
    }

    private FormattedLabelGenerator(String pattern, DateFormat format) {
        super(pattern, format);
        this.numberFormat = null;
        this.dateFormat = format;
        this.percentFormat = null;
    }

    public static CategoryItemLabelGenerator getCumulativeInstance(String pattern, Format format) {
        FormattedLabelGenerator generator = (FormattedLabelGenerator)FormattedLabelGenerator.getInstance(pattern, format);
        if (generator != null) {
            generator.getCumulativeValue = true;
        }
        return generator;
    }

    public static CategoryItemLabelGenerator getPercentCumulativeInstance(String pattern, Format format) {
        FormattedLabelGenerator generator = (FormattedLabelGenerator)FormattedLabelGenerator.getCumulativeInstance(pattern, format);
        if (generator != null) {
            generator.getPercentValue = true;
        }
        return generator;
    }

    public static CategoryItemLabelGenerator getPercentInstance(String pattern, Format format) {
        FormattedLabelGenerator generator = (FormattedLabelGenerator)FormattedLabelGenerator.getInstance(pattern, format);
        if (generator != null) {
            generator.getPercentValue = true;
        }
        return generator;
    }

    public static CategoryItemLabelGenerator getInstance(String pattern, Format format) {
        FormattedLabelGenerator generator = null;
        if (format instanceof NumberFormat) {
            generator = new FormattedLabelGenerator(pattern, (NumberFormat)format);
        } else if (format instanceof DateFormat) {
            generator = new FormattedLabelGenerator(pattern, (DateFormat)format);
        }
        return generator;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] result = new Object[4];
        result[0] = dataset.getRowKey(row).toString();
        result[1] = dataset.getColumnKey(column).toString();
        Number value = this.getValue(dataset, row, column);
        if (value != null) {
            if (this.numberFormat != null) {
                result[2] = this.numberFormat.format(value);
            } else if (this.dateFormat != null) {
                result[2] = this.dateFormat.format(value);
            }
        } else {
            result[2] = this.nullValueString;
        }
        if (value != null && this.percentFormat != null) {
            double total = DataUtilities.calculateColumnTotal(dataset, column);
            double percent = 0.0;
            if (value.doubleValue() > 0.0) {
                percent = value.doubleValue() / total;
            }
            result[3] = this.percentFormat.format(percent);
        } else {
            result[3] = this.nullValueString;
        }
        return result;
    }

    private Number getValue(CategoryDataset dataset, int row, int column) {
        Number result = null;
        if (dataset instanceof StackedCategoryDataset) {
            result = this.getStackedCategoryDatasetValue((StackedCategoryDataset)dataset, row, column);
        } else {
            result = this.getCumulativeValue ? (Number)this.getCumulativeValue(dataset, row, column) : (Number)dataset.getValue(row, column);
            if (result != null && this.getPercentValue) {
                result = new Double(result.doubleValue() / FormattedLabelGenerator.getTotalPercentValue(dataset, column));
            }
        }
        return result;
    }

    private Number getStackedCategoryDatasetValue(StackedCategoryDataset dataset, int row, int column) {
        Number result = null;
        result = this.getCumulativeValue ? (Number)(this.getPercentValue ? (Number)dataset.getValue(row, column) : (Number)dataset.getStackedValue(row, column)) : (Number)(this.getPercentValue ? (Number)dataset.getPercentValue(row, column) : (Number)dataset.getOriginalValue(row, column));
        return result;
    }

    private static double getTotalPercentValue(CategoryDataset dataset, int column) {
        double total = 0.0;
        int rowCount = dataset.getRowCount();
        for (int r2 = 0; r2 < rowCount; ++r2) {
            Number n2 = dataset.getValue(r2, column);
            if (n2 == null) continue;
            total += n2.doubleValue();
        }
        return total;
    }

    private Number getCumulativeValue(CategoryDataset dataset, int series, int category) {
        double result = 0.0;
        for (int i2 = 0; i2 <= series; ++i2) {
            if (dataset.getValue(i2, category) == null) continue;
            result += dataset.getValue(i2, category).doubleValue();
        }
        return new Double(result);
    }

    public String generateLabel(CategoryDataset dataset, int row, int column) {
        return this.generateLabelString(dataset, row, column);
    }

    public String generateColumnLabel(CategoryDataset dataset, int column) {
        if (!this.getCumulativeValue && !this.getPercentValue && this.getLabelFormat().equals(PATTERN_VALUE)) {
            this.getCumulativeValue = true;
            String totalLabel = this.generateLabel(dataset, dataset.getRowCount() - 1, column);
            this.getCumulativeValue = false;
            return totalLabel;
        }
        return null;
    }
}

