/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.labels;

import com.inet.jfree.chart.labels.GroupNameValuesContainer;
import com.inet.jfree.chart.labels.StandardXYItemLabelGenerator;
import com.inet.jfree.data.xy.XYDataset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;

public class GroupNameLabelGenerator
extends StandardXYItemLabelGenerator {
    private NumberFormat xFormat;
    private DateFormat xDateFormat;
    private NumberFormat yFormat;
    private GroupNameValuesContainer groupNameValues;

    public GroupNameLabelGenerator(String formatString, NumberFormat xFormat, NumberFormat yFormat) {
        super(formatString, xFormat, yFormat);
        this.xFormat = xFormat;
        this.yFormat = yFormat;
    }

    public GroupNameLabelGenerator(String formatString, DateFormat xFormat, NumberFormat yFormat) {
        super(formatString, xFormat, yFormat);
        this.xDateFormat = xFormat;
        this.yFormat = yFormat;
    }

    protected Object[] createItemArray(XYDataset dataset, int series, int item) {
        Object[] result = new Object[3];
        result[0] = dataset.getSeriesKey(series).toString();
        if (this.groupNameValues != null) {
            result[1] = this.groupNameValues.get(series, item);
        } else {
            double x2 = dataset.getXValue(series, item);
            result[1] = this.xDateFormat != null ? this.xDateFormat.format(new Date((long)x2)) : this.xFormat.format(x2);
        }
        double y2 = dataset.getYValue(series, item);
        result[2] = Double.isNaN(y2) && dataset.getY(series, item) == null ? "null" : this.yFormat.format(y2);
        return result;
    }

    public void setGroupNameValues(GroupNameValuesContainer values) {
        this.groupNameValues = values;
    }
}

