/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.labels;

import com.inet.jfree.chart.labels.ContourToolTipGenerator;
import com.inet.jfree.data.contour.ContourDataset;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StandardContourToolTipGenerator
implements ContourToolTipGenerator,
Serializable {
    private static final long serialVersionUID = -1881659351247502711L;
    private DecimalFormat valueForm = new DecimalFormat("##.###");

    public String generateToolTip(ContourDataset data, int item) {
        double x2 = data.getXValue(0, item);
        double y2 = data.getYValue(0, item);
        double z2 = data.getZValue(0, item);
        String xString = null;
        if (data.isDateAxis(0)) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            StringBuffer strbuf = new StringBuffer();
            strbuf = formatter.format(new Date((long)x2), strbuf, new FieldPosition(0));
            xString = strbuf.toString();
        } else {
            xString = this.valueForm.format(x2);
        }
        if (!Double.isNaN(z2)) {
            return "X: " + xString + ", Y: " + this.valueForm.format(y2) + ", Z: " + this.valueForm.format(z2);
        }
        return "X: " + xString + ", Y: " + this.valueForm.format(y2) + ", Z: no data";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardContourToolTipGenerator)) {
            return false;
        }
        StandardContourToolTipGenerator that = (StandardContourToolTipGenerator)obj;
        if (this.valueForm != null) {
            return this.valueForm.equals(that.valueForm);
        }
        return false;
    }
}

