/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.LegendItemCollection;
import com.inet.jfree.chart.axis.AxisSpace;
import com.inet.jfree.chart.axis.AxisState;
import com.inet.jfree.chart.axis.NumberAxis;
import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.event.PlotChangeEvent;
import com.inet.jfree.chart.event.PlotChangeListener;
import com.inet.jfree.chart.plot.Plot;
import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.PlotState;
import com.inet.jfree.chart.plot.XYPlot;
import com.inet.jfree.chart.renderer.xy.XYItemRenderer;
import com.inet.jfree.data.Range;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;

public class CombinedRangeXYPlot
extends XYPlot
implements PlotChangeListener {
    private static final long serialVersionUID = -5177814085082031168L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedRangeXYPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeXYPlot(ValueAxis rangeAxis) {
        super(null, null, rangeAxis, null);
    }

    public String getPlotType() {
        return localizationResources.getString("Combined_Range_XYPlot");
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double gap) {
        this.gap = gap;
    }

    public void add(XYPlot subplot) {
        this.add(subplot, 1);
    }

    public void add(XYPlot subplot, int weight) {
        if (weight <= 0) {
            String msg = "The 'weight' must be positive.";
            throw new IllegalArgumentException(msg);
        }
        subplot.setParent(this);
        subplot.setWeight(weight);
        subplot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        subplot.setRangeAxis(null);
        subplot.addChangeListener(this);
        this.subplots.add(subplot);
        this.configureRangeAxes();
        this.fireChangeEvent();
    }

    public void remove(XYPlot subplot) {
        if (subplot == null) {
            throw new IllegalArgumentException(" Null 'subplot' argument.");
        }
        int position = -1;
        int size = this.subplots.size();
        for (int i2 = 0; position == -1 && i2 < size; ++i2) {
            if (this.subplots.get(i2) != subplot) continue;
            position = i2;
        }
        if (position != -1) {
            this.subplots.remove(position);
            subplot.setParent(null);
            subplot.removeChangeListener(this);
            this.configureRangeAxes();
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D g2, Rectangle2D plotArea) {
        AxisSpace space = new AxisSpace();
        PlotOrientation orientation = this.getOrientation();
        AxisSpace fixed = this.getFixedRangeAxisSpace();
        if (fixed != null) {
            if (orientation == PlotOrientation.VERTICAL) {
                space.setLeft(fixed.getLeft());
                space.setRight(fixed.getRight());
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                space.setTop(fixed.getTop());
                space.setBottom(fixed.getBottom());
            }
        } else {
            ValueAxis valueAxis = this.getRangeAxis();
            RectangleEdge valueEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), orientation);
            if (valueAxis != null) {
                space = valueAxis.reserveSpace(g2, this, plotArea, valueEdge, space);
            }
        }
        Rectangle2D adjustedPlotArea = space.shrink(plotArea, null);
        int n2 = this.subplots.size();
        int totalWeight = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            XYPlot sub = (XYPlot)this.subplots.get(i2);
            totalWeight += sub.getWeight();
        }
        this.subplotAreas = new Rectangle2D[n2];
        double x2 = adjustedPlotArea.getX();
        double y2 = adjustedPlotArea.getY();
        double usableSize = 0.0;
        if (orientation == PlotOrientation.VERTICAL) {
            usableSize = adjustedPlotArea.getWidth() - this.gap * (double)(n2 - 1);
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            usableSize = adjustedPlotArea.getHeight() - this.gap * (double)(n2 - 1);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            XYPlot plot = (XYPlot)this.subplots.get(i3);
            if (orientation == PlotOrientation.VERTICAL) {
                double w2 = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotAreas[i3] = new Rectangle2D.Double(x2, y2, w2, adjustedPlotArea.getHeight());
                x2 = x2 + w2 + this.gap;
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                double h2 = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotAreas[i3] = new Rectangle2D.Double(x2, y2, adjustedPlotArea.getWidth(), h2);
                y2 = y2 + h2 + this.gap;
            }
            AxisSpace subSpace = plot.calculateDomainAxisSpace(g2, this.subplotAreas[i3], null);
            space.ensureAtLeast(subSpace);
        }
        return space;
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(area);
        }
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        AxisSpace space = this.calculateAxisSpace(g2, area);
        Rectangle2D dataArea = space.shrink(area, null);
        this.setFixedDomainAxisSpaceForSubplots(space);
        ValueAxis axis = this.getRangeAxis();
        RectangleEdge edge = this.getRangeAxisEdge();
        double cursor = RectangleEdge.coordinate(dataArea, edge);
        AxisState axisState = axis.draw(g2, cursor, area, dataArea, edge, info);
        if (parentState == null) {
            parentState = new PlotState();
        }
        parentState.getSharedAxisStates().put(axis, axisState);
        for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
            XYPlot plot = (XYPlot)this.subplots.get(i2);
            PlotRenderingInfo subplotInfo = null;
            if (info != null) {
                subplotInfo = new PlotRenderingInfo(info.getOwner());
                info.addSubplotInfo(subplotInfo);
            }
            plot.draw(g2, this.subplotAreas[i2], anchor, parentState, subplotInfo);
        }
        if (info != null) {
            info.setDataArea(dataArea);
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = this.getFixedLegendItems();
        if (result == null) {
            result = new LegendItemCollection();
            if (this.subplots != null) {
                for (XYPlot plot : this.subplots) {
                    LegendItemCollection more = plot.getLegendItems();
                    result.addAll(more);
                }
            }
        }
        return result;
    }

    public void zoomDomainAxes(double factor, PlotRenderingInfo info, Point2D source) {
        this.zoomDomainAxes(factor, info, source, false);
    }

    public void zoomDomainAxes(double factor, PlotRenderingInfo info, Point2D source, boolean useAnchor) {
        XYPlot subplot2 = this.findSubplot(info, source);
        if (subplot2 != null) {
            subplot2.zoomDomainAxes(factor, info, source, useAnchor);
        } else {
            for (XYPlot subplot2 : this.getSubplots()) {
                subplot2.zoomDomainAxes(factor, info, source, useAnchor);
            }
        }
    }

    public void zoomDomainAxes(double lowerPercent, double upperPercent, PlotRenderingInfo info, Point2D source) {
        XYPlot subplot2 = this.findSubplot(info, source);
        if (subplot2 != null) {
            subplot2.zoomDomainAxes(lowerPercent, upperPercent, info, source);
        } else {
            for (XYPlot subplot2 : this.getSubplots()) {
                subplot2.zoomDomainAxes(lowerPercent, upperPercent, info, source);
            }
        }
    }

    public XYPlot findSubplot(PlotRenderingInfo info, Point2D source) {
        if (info == null) {
            throw new IllegalArgumentException("Null 'info' argument.");
        }
        if (source == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        XYPlot result = null;
        int subplotIndex = info.getSubplotIndex(source);
        if (subplotIndex >= 0) {
            result = (XYPlot)this.subplots.get(subplotIndex);
        }
        return result;
    }

    public void setRenderer(XYItemRenderer renderer) {
        super.setRenderer(renderer);
        for (XYPlot plot : this.subplots) {
            plot.setRenderer(renderer);
        }
    }

    public void setOrientation(PlotOrientation orientation) {
        super.setOrientation(orientation);
        for (XYPlot plot : this.subplots) {
            plot.setOrientation(orientation);
        }
    }

    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        if (this.subplots != null) {
            for (XYPlot subplot : this.subplots) {
                result = Range.combine(result, subplot.getDataRange(axis));
            }
        }
        return result;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace space) {
        for (XYPlot plot : this.subplots) {
            plot.setFixedDomainAxisSpace(space, false);
        }
    }

    public void handleClick(int x2, int y2, PlotRenderingInfo info) {
        Rectangle2D dataArea = info.getDataArea();
        if (dataArea.contains(x2, y2)) {
            for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
                XYPlot subplot = (XYPlot)this.subplots.get(i2);
                PlotRenderingInfo subplotInfo = info.getSubplotInfo(i2);
                subplot.handleClick(x2, y2, subplotInfo);
            }
        }
    }

    public void plotChanged(PlotChangeEvent event) {
        this.notifyListeners(event);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CombinedRangeXYPlot)) {
            return false;
        }
        CombinedRangeXYPlot that = (CombinedRangeXYPlot)obj;
        if (this.gap != that.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, that.subplots)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        CombinedRangeXYPlot result = (CombinedRangeXYPlot)super.clone();
        result.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot child : result.subplots) {
            child.setParent(result);
        }
        ValueAxis rangeAxis = result.getRangeAxis();
        if (rangeAxis != null) {
            rangeAxis.configure();
        }
        return result;
    }
}

