/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.plot.InetPiePlot;
import com.inet.jfree.chart.plot.StandardPiePainter;
import com.inet.jfree.chart.renderer.GradientPainter;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GradientPiePainter
extends StandardPiePainter {
    private GradientPainter painter = new GradientPainter();
    private boolean horizontal = true;

    public void paintArc(Graphics2D g2, InetPiePlot plot, Comparable key, Arc2D.Double arc) {
        Paint paint = plot.lookupSectionPaint(key, true);
        Point2D p0 = null;
        Point2D p1 = null;
        if (this.horizontal) {
            p0 = arc.getStartPoint();
            p1 = arc.getEndPoint();
            if (Math.abs(arc.getAngleExtent()) > 270.0) {
                Rectangle2D bounds2d = arc.getBounds2D();
                p1 = new Point2D.Double(bounds2d.getMinX(), bounds2d.getMaxY() - bounds2d.getMinY());
                p0 = new Point2D.Double(bounds2d.getMaxX(), bounds2d.getMaxY() - bounds2d.getMinY());
            }
        } else {
            double radius = Math.sqrt(Math.pow(arc.getStartPoint().getX() - arc.getCenterX(), 2.0) + Math.pow(arc.getStartPoint().getY() - arc.getCenterY(), 2.0));
            double startAngle = arc.getAngleStart();
            if (startAngle < 0.0) {
                startAngle = 360.0 + startAngle;
            }
            double a2 = startAngle - Math.abs(arc.getAngleExtent() / 2.0);
            double aRad = a2 * Math.PI / 180.0 * -1.0;
            double x0 = arc.getCenterX() + radius * Math.cos(aRad);
            double y0 = arc.getCenterY() + radius * Math.sin(aRad);
            p0 = new Point2D.Double(arc.getCenterX(), arc.getCenterY());
            p1 = new Point2D.Double(x0, y0);
        }
        this.painter.paintGradient(g2, paint, arc, p0, p1, GradientPainter.ColorOfGradient.gradient);
        this.drawOutline(g2, plot, arc, key);
    }

    public void paintShape(Graphics2D g2, InetPiePlot plot, Comparable key, Shape shape, boolean side) {
        Paint paint = plot.lookupSectionPaint(key, true);
        if (side) {
            this.painter.paintGradient(g2, paint, shape, null, null, GradientPainter.ColorOfGradient.firstColor);
        } else {
            Rectangle2D bounds = shape.getBounds2D();
            Point2D.Double start = null;
            Point2D.Double end = null;
            if (this.horizontal) {
                start = new Point2D.Double(bounds.getMaxX(), bounds.getMinY());
                end = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
            } else {
                start = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
                end = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
            }
            this.painter.paintGradient(g2, paint, shape, start, end, GradientPainter.ColorOfGradient.gradient);
        }
        this.drawOutline(g2, plot, shape, key);
    }
}

