/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.LegendItemCollection;
import com.inet.jfree.chart.MultiColumnLegendItem;
import com.inet.jfree.chart.entity.EntityCollection;
import com.inet.jfree.chart.entity.PieSectionEntity;
import com.inet.jfree.chart.event.PlotChangeEvent;
import com.inet.jfree.chart.plot.PieLabelDistributor;
import com.inet.jfree.chart.plot.PieLabelRecord;
import com.inet.jfree.chart.plot.PieLegendGenerator;
import com.inet.jfree.chart.plot.PiePlot;
import com.inet.jfree.chart.plot.PiePlotState;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.PlotState;
import com.inet.jfree.chart.plot.StandardPiePainter;
import com.inet.jfree.data.DefaultKeyedValues;
import com.inet.jfree.data.KeyedValues;
import com.inet.jfree.data.general.DatasetUtilities;
import com.inet.jfree.data.general.PieDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Rotation;
import org.jfree.util.ShapeUtilities;

public class InetPiePlot
extends PiePlot {
    public static final double DEFAULT_INTERIOR_GAP_CC = 0.25;
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT_CC = Color.lightGray;
    private PieLegendGenerator legendLabelGenerator = new PieLegendGenerator();
    private PieLegendGenerator legendLabelToolTipGenerator = null;
    private StandardPiePainter piePainter;

    public InetPiePlot() {
        this(null);
    }

    public InetPiePlot(PieDataset dataset) {
        super(dataset);
        this.setInteriorGap(0.25);
        this.setLabelShadowPaint(DEFAULT_LABEL_SHADOW_PAINT_CC);
        this.setMaximumLabelWidth(0.2);
        this.setLabelGap(0.05);
        this.setLabelLinkMargin(0.05);
        this.piePainter = new StandardPiePainter();
    }

    public PieLegendGenerator getMultiColumnLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public Paint lookupSectionOutlinePaint(Comparable key) {
        return this.lookupSectionOutlinePaint(key, true);
    }

    public Stroke lookupSectionOutlineStroke(Comparable key) {
        return this.lookupSectionOutlineStroke(key, true);
    }

    public void setMultiColumnLegendLabelGenerator(PieLegendGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendLabelGenerator = generator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        if (this.getDataset() == null) {
            return result;
        }
        List keys = this.getDataset().getKeys();
        int section = 0;
        Shape shape = this.getLegendItemShape();
        for (Comparable key : keys) {
            Number n2 = this.getDataset().getValue(key);
            boolean include = true;
            if (n2 == null) {
                include = !this.getIgnoreNullValues();
            } else {
                double v2 = n2.doubleValue();
                if (v2 == 0.0) {
                    include = !this.getIgnoreZeroValues();
                } else {
                    boolean bl2 = include = v2 > 0.0;
                }
            }
            if (include) {
                List labels = this.legendLabelGenerator.generateSectionLabels(this.getDataset(), key);
                String description = (String)labels.get(0);
                List toolTipTexts = null;
                toolTipTexts = this.legendLabelToolTipGenerator != null ? this.legendLabelToolTipGenerator.generateSectionLabels(this.getDataset(), key) : labels;
                String urlText = null;
                Paint paint = this.lookupSectionPaint(key, true);
                Paint outlinePaint = this.lookupSectionOutlinePaint(key);
                Stroke outlineStroke = this.lookupSectionOutlineStroke(key);
                MultiColumnLegendItem item = new MultiColumnLegendItem(labels, description, toolTipTexts, urlText, true, shape, true, paint, this.getSectionOutlinesVisible(), outlinePaint, outlineStroke, false, (Shape)new Line2D.Float(), (Stroke)new BasicStroke(), (Paint)Color.black);
                result.add(item);
                ++section;
                continue;
            }
            ++section;
        }
        return result;
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        this.drawBackground(g2, area);
        this.drawOutline(g2, area);
        Shape savedClip = g2.getClip();
        g2.clip(area);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull(this.getDataset())) {
            this.drawPie(g2, area, info);
        } else {
            this.drawNoDataMessage(g2, area);
        }
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, area);
    }

    protected void drawPie(Graphics2D g2, Rectangle2D plotArea, PlotRenderingInfo info) {
        PiePlotState state = this.initialise(g2, plotArea, this, null, info);
        double labelWidth = 0.0;
        if (this.getLabelGenerator() != null) {
            labelWidth = this.getLabelGap() + this.getMaximumLabelWidth() + this.getLabelLinkMargin();
        }
        double gapHorizontal = plotArea.getWidth() * (this.getInteriorGap() + labelWidth);
        double gapVertical = plotArea.getHeight() * this.getInteriorGap();
        double linkX = plotArea.getX() + gapHorizontal / 2.0;
        double linkY = plotArea.getY() + gapVertical / 2.0;
        double linkW = plotArea.getWidth() - gapHorizontal;
        double linkH = plotArea.getHeight() - gapVertical;
        if (this.isCircular()) {
            double min = Math.min(linkW, linkH) / 2.0;
            linkX = (linkX + linkX + linkW) / 2.0 - min;
            linkY = (linkY + linkY + linkH) / 2.0 - min;
            linkW = 2.0 * min;
            linkH = 2.0 * min;
        }
        Rectangle2D.Double linkArea = new Rectangle2D.Double(linkX, linkY, linkW, linkH);
        state.setLinkArea(linkArea);
        double hh2 = ((RectangularShape)linkArea).getWidth() * this.getLabelLinkMargin();
        double vv = ((RectangularShape)linkArea).getHeight() * this.getLabelLinkMargin();
        Rectangle2D.Double explodeArea = new Rectangle2D.Double(linkX + hh2 / 2.0, linkY + vv / 2.0, linkW - hh2, linkH - vv);
        state.setExplodedPieArea(explodeArea);
        double maximumExplodePercent = this.getMaximumExplodePercent();
        double percent = maximumExplodePercent / (1.0 + maximumExplodePercent);
        double h1 = ((RectangularShape)explodeArea).getWidth() * percent;
        double v1 = ((RectangularShape)explodeArea).getHeight() * percent;
        Rectangle2D.Double pieArea = new Rectangle2D.Double(((RectangularShape)explodeArea).getX() + h1 / 2.0, ((RectangularShape)explodeArea).getY() + v1 / 2.0, ((RectangularShape)explodeArea).getWidth() - h1, ((RectangularShape)explodeArea).getHeight() - v1);
        state.setPieArea(pieArea);
        state.setPieCenterX(pieArea.getCenterX());
        state.setPieCenterY(pieArea.getCenterY());
        state.setPieWRadius(((RectangularShape)pieArea).getWidth() / 2.0);
        state.setPieHRadius(((RectangularShape)pieArea).getHeight() / 2.0);
        if (this.getDataset() != null && this.getDataset().getKeys().size() > 0) {
            List keys = this.getDataset().getKeys();
            double totalValue = DatasetUtilities.calculatePieDatasetTotal(this.getDataset());
            int passesRequired = state.getPassesRequired();
            for (int pass = 0; pass < passesRequired; ++pass) {
                double runningTotal = 0.0;
                for (int section = 0; section < keys.size(); ++section) {
                    double value;
                    Number n2 = this.getDataset().getValue(section);
                    if (n2 == null || !((value = n2.doubleValue()) > 0.0)) continue;
                    runningTotal += value;
                    this.drawItem(g2, section, explodeArea, state, pass);
                }
            }
            this.drawLabels(g2, keys, totalValue, plotArea, linkArea, state);
        } else {
            this.drawNoDataMessage(g2, plotArea);
        }
    }

    protected void drawItem(Graphics2D g2, int section, Rectangle2D dataArea, PiePlotState state, int currentPass) {
        Number n2 = this.getDataset().getValue(section);
        if (n2 == null) {
            return;
        }
        double value = n2.doubleValue();
        double angle1 = 0.0;
        double angle2 = 0.0;
        if (this.getDirection() == Rotation.CLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 - value / state.getTotal() * 360.0;
        } else if (this.getDirection() == Rotation.ANTICLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 + value / state.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double angle = angle2 - angle1;
        if (Math.abs(angle) > this.getMinimumArcAngleToDraw()) {
            double ep2 = 0.0;
            double mep = this.getMaximumExplodePercent();
            if (mep > 0.0) {
                ep2 = this.getExplodePercent(this.getSectionKey(section)) / mep;
            }
            Rectangle2D arcBounds = this.getArcBounds(state.getPieArea(), state.getExplodedPieArea(), angle1, angle, ep2);
            Arc2D.Double arc = new Arc2D.Double(arcBounds, angle1, angle, 2);
            if (currentPass == 0) {
                if (this.getShadowPaint() != null) {
                    Shape shadowArc = ShapeUtilities.createTranslatedShape(arc, (float)this.getShadowXOffset(), (float)this.getShadowYOffset());
                    g2.setPaint(this.getShadowPaint());
                    g2.fill(shadowArc);
                }
            } else if (currentPass == 1) {
                EntityCollection entities;
                Comparable key = this.getSectionKey(section);
                this.piePainter.paintArc(g2, this, key, arc);
                if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
                    String tip = null;
                    if (this.getToolTipGenerator() != null) {
                        tip = this.getToolTipGenerator().generateToolTip(this.getDataset(), key);
                    }
                    String url = null;
                    if (this.getURLGenerator() != null) {
                        url = this.getURLGenerator().generateURL(this.getDataset(), key, this.getPieIndex());
                    }
                    PieSectionEntity entity = new PieSectionEntity(arc, this.getDataset(), this.getPieIndex(), section, key, tip, url);
                    entities.add(entity);
                }
            }
        }
        state.setLatestAngle(angle2);
    }

    protected void drawLabels(Graphics2D g2, List keys, double totalValue, Rectangle2D plotArea, Rectangle2D linkArea, PiePlotState state) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        DefaultKeyedValues leftKeys = new DefaultKeyedValues();
        DefaultKeyedValues rightKeys = new DefaultKeyedValues();
        double runningTotal1 = 0.0;
        for (Comparable key : keys) {
            boolean include = true;
            double v2 = 0.0;
            Number n2 = this.getDataset().getValue(key);
            if (n2 == null) {
                include = !this.getIgnoreNullValues();
            } else {
                v2 = n2.doubleValue();
                boolean bl2 = this.getIgnoreNullValues() ? v2 > 0.0 : (include = v2 >= 0.0);
            }
            if (!include) continue;
            runningTotal1 += v2;
            double mid = this.getStartAngle() + this.getDirection().getFactor() * ((runningTotal1 - v2 / 2.0) * 360.0) / totalValue;
            if (Math.cos(Math.toRadians(mid)) < 0.0) {
                leftKeys.addValue(key, new Double(mid));
                continue;
            }
            rightKeys.addValue(key, new Double(mid));
        }
        g2.setFont(this.getLabelFont());
        float maxLabelWidth = (float)(this.getMaximumLabelWidth() * plotArea.getWidth());
        if (this.getLabelGenerator() != null) {
            this.drawLeftLabels(leftKeys, g2, plotArea, linkArea, maxLabelWidth, state);
            this.drawRightLabels(rightKeys, g2, plotArea, linkArea, maxLabelWidth, state);
        }
        g2.setComposite(originalComposite);
    }

    protected void drawLeftLabels(KeyedValues leftKeys, Graphics2D g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        int i2;
        PieLabelDistributor distributor1 = new PieLabelDistributor(leftKeys.getItemCount());
        double lGap = plotArea.getWidth() * this.getLabelGap();
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        for (i2 = 0; i2 < leftKeys.getItemCount(); ++i2) {
            String label = this.getLabelGenerator().generateSectionLabel(this.getDataset(), leftKeys.getKey(i2));
            if (label == null) continue;
            TextBlock block = TextUtilities.createTextBlock(label, this.getLabelFont(), this.getLabelPaint(), maxLabelWidth, new G2TextMeasurer(g2));
            TextBox labelBox = new TextBox(block);
            labelBox.setBackgroundPaint(this.getLabelBackgroundPaint());
            labelBox.setOutlinePaint(this.getLabelOutlinePaint());
            labelBox.setOutlineStroke(this.getLabelOutlineStroke());
            labelBox.setShadowPaint(this.getLabelShadowPaint());
            double theta = Math.toRadians(leftKeys.getValue(i2).doubleValue());
            double baseY = state.getPieCenterY() - Math.sin(theta) * verticalLinkRadius;
            double hh2 = labelBox.getHeight(g2);
            distributor1.addPieLabelRecord(new PieLabelRecord(leftKeys.getKey(i2), theta, baseY, labelBox, hh2, lGap / 2.0 + lGap / 2.0 * -Math.cos(theta), 0.9 + this.getExplodePercent(leftKeys.getKey(i2))));
        }
        distributor1.distributeLabels(plotArea.getMinY(), plotArea.getHeight());
        for (i2 = 0; i2 < distributor1.getItemCount(); ++i2) {
            this.drawLeftLabel(g2, state, distributor1.getPieLabelRecord(i2));
        }
    }

    protected void drawRightLabels(KeyedValues keys, Graphics2D g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        int i2;
        PieLabelDistributor distributor2 = new PieLabelDistributor(keys.getItemCount());
        double lGap = plotArea.getWidth() * this.getLabelGap();
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        for (i2 = 0; i2 < keys.getItemCount(); ++i2) {
            String label = this.getLabelGenerator().generateSectionLabel(this.getDataset(), keys.getKey(i2));
            if (label == null) continue;
            TextBlock block = TextUtilities.createTextBlock(label, this.getLabelFont(), this.getLabelPaint(), maxLabelWidth, new G2TextMeasurer(g2));
            TextBox labelBox = new TextBox(block);
            labelBox.setBackgroundPaint(this.getLabelBackgroundPaint());
            labelBox.setOutlinePaint(this.getLabelOutlinePaint());
            labelBox.setOutlineStroke(this.getLabelOutlineStroke());
            labelBox.setShadowPaint(this.getLabelShadowPaint());
            double theta = Math.toRadians(keys.getValue(i2).doubleValue());
            double baseY = state.getPieCenterY() - Math.sin(theta) * verticalLinkRadius;
            double hh2 = labelBox.getHeight(g2);
            distributor2.addPieLabelRecord(new PieLabelRecord(keys.getKey(i2), theta, baseY, labelBox, hh2, lGap / 2.0 + lGap / 2.0 * Math.cos(theta), 0.9 + this.getExplodePercent(keys.getKey(i2))));
        }
        distributor2.distributeLabels(plotArea.getMinY(), plotArea.getHeight());
        for (i2 = 0; i2 < distributor2.getItemCount(); ++i2) {
            this.drawRightLabel(g2, state, distributor2.getPieLabelRecord(i2));
        }
    }

    public StandardPiePainter getPiePainter() {
        return this.piePainter;
    }

    public void setPiePainter(StandardPiePainter piePainter) {
        if (piePainter == null) {
            throw new IllegalArgumentException("Parameter 'piePainter' is null.");
        }
        this.piePainter = piePainter;
    }
}

