/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.plot.InetPiePlot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;

public class StandardPiePainter {
    public void paintShape(Graphics2D g2, InetPiePlot plot, Comparable key, Shape shape, boolean side) {
        Paint paint = plot.lookupSectionPaint(key, true);
        if (!(paint instanceof Color)) {
            throw new IllegalStateException("Item paint is not a color: " + paint);
        }
        Color color = (Color)paint;
        if (side) {
            color = color.darker();
        }
        g2.setPaint(color);
        g2.fill(shape);
        this.drawOutline(g2, plot, shape, key);
    }

    protected void drawOutline(Graphics2D g2, InetPiePlot plot, Shape shape, Comparable key) {
        if (plot.getSectionOutlinesVisible()) {
            Paint outlinePaint = plot.lookupSectionOutlinePaint(key);
            Stroke outlineStroke = plot.lookupSectionOutlineStroke(key);
            if (outlinePaint != null && outlineStroke != null) {
                g2.setPaint(outlinePaint);
                g2.setStroke(outlineStroke);
                g2.draw(shape);
            }
        }
    }

    public void paintArc(Graphics2D g2, InetPiePlot plot, Comparable key, Arc2D.Double arc) {
        this.paintShape(g2, plot, key, arc, false);
    }
}

