/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot.dial;

import com.inet.jfree.chart.HashUtilities;
import com.inet.jfree.chart.plot.dial.DialLayer;
import com.inet.jfree.chart.plot.dial.DialLayerChangeEvent;
import com.inet.jfree.chart.plot.dial.DialLayerChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;

public abstract class AbstractDialLayer
implements DialLayer {
    private boolean visible = true;
    private transient EventListenerList listenerList = new EventListenerList();

    protected AbstractDialLayer() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractDialLayer)) {
            return false;
        }
        AbstractDialLayer that = (AbstractDialLayer)obj;
        return this.visible == that.visible;
    }

    public int hashCode() {
        int result = 23;
        result = HashUtilities.hashCode(result, this.visible);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDialLayer clone = (AbstractDialLayer)super.clone();
        clone.listenerList = new EventListenerList();
        return clone;
    }

    public void addChangeListener(DialLayerChangeListener listener) {
        this.listenerList.add(DialLayerChangeListener.class, listener);
    }

    public void removeChangeListener(DialLayerChangeListener listener) {
        this.listenerList.remove(DialLayerChangeListener.class, listener);
    }

    public boolean hasListener(EventListener listener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(listener);
    }

    protected void notifyListeners(DialLayerChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != DialLayerChangeListener.class) continue;
            ((DialLayerChangeListener)listeners[i2 + 1]).dialLayerChanged(event);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

