/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.category;

import com.inet.jfree.chart.renderer.GradientPainter;
import com.inet.jfree.chart.renderer.category.BarPainter;
import com.inet.jfree.chart.renderer.category.BarRenderer;
import com.inet.jfree.chart.renderer.category.CategoryItemRendererState;
import com.inet.jfree.chart.renderer.category.Face;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import org.jfree.ui.RectangleEdge;

public class SimpleGradientBarPainter
implements BarPainter,
Serializable {
    private boolean horizontal;
    private GradientPainter painter;

    public SimpleGradientBarPainter(boolean horizontal) {
        this.horizontal = horizontal;
        this.painter = new GradientPainter();
    }

    public void paintBar(Graphics2D g2, BarRenderer renderer, int row, int column, Shape bar, RectangleEdge base, CategoryItemRendererState state, Face face) {
        Paint itemPaint = renderer.getItemPaint(row, column);
        Rectangle2D bounds = bar.getBounds2D();
        Point2D.Float start = null;
        Point2D.Float end = null;
        if (!this.horizontal) {
            if (base == RectangleEdge.TOP) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
                end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
            } else if (base == RectangleEdge.BOTTOM) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
                end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
            } else if (base == RectangleEdge.LEFT) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
                end = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
            } else if (base == RectangleEdge.RIGHT) {
                start = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
                end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
            }
        } else if (base == RectangleEdge.TOP || base == RectangleEdge.BOTTOM) {
            start = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
            end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
        } else if (base == RectangleEdge.LEFT || base == RectangleEdge.RIGHT) {
            start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
            end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
        }
        boolean success = this.painter.paintGradient(g2, itemPaint, bar, start, end, GradientPainter.ColorOfGradient.gradient);
        if (success) {
            this.painter.drawOutline(g2, renderer, row, column, bar, renderer.isDrawBarOutline() && state.getBarWidth() > 3.0);
        }
    }

    public void paintBarShadow(Graphics2D g2, BarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base, boolean pegShadow) {
    }
}

