/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.category;

import com.inet.jfree.chart.axis.CategoryAxis;
import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.plot.CategoryPlot;
import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.renderer.category.CategoryItemRendererState;
import com.inet.jfree.chart.renderer.category.StackedAreaRenderer;
import com.inet.jfree.chart.renderer.category.StandardAreaPainter;
import com.inet.jfree.data.DataUtilities;
import com.inet.jfree.data.Range;
import com.inet.jfree.data.category.CategoryDataset;
import com.inet.jfree.data.general.DatasetUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.ui.RectangleEdge;

public class StackedAreaRenderer2D
extends StackedAreaRenderer
implements Serializable {
    private static final long serialVersionUID = -3595635038460823667L;
    private boolean renderAsPercentages;
    private Area[] fillArea = null;
    private GeneralPath[] separator = null;
    private boolean isInit = false;
    private StandardAreaPainter painter;

    public StackedAreaRenderer2D() {
        this(false);
        this.isInit = false;
        this.painter = new StandardAreaPainter();
    }

    public StackedAreaRenderer2D(boolean renderAsPercentages) {
        super(renderAsPercentages);
        this.renderAsPercentages = renderAsPercentages;
        this.isInit = false;
        this.painter = new StandardAreaPainter();
    }

    private void init() {
        this.fillArea = new Area[this.getRowCount()];
        this.separator = new GeneralPath[this.getRowCount() + 1];
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            this.fillArea[i2] = new Area();
            this.separator[i2] = new GeneralPath();
        }
        this.separator[this.getRowCount()] = new GeneralPath();
        this.isInit = true;
    }

    public Range findRangeBounds(CategoryDataset dataset) {
        if (this.renderAsPercentages) {
            return DatasetUtilities.findStackedPercentageRangeBounds(dataset, 0.0);
        }
        return DatasetUtilities.findStackedRangeBounds(dataset);
    }

    public static double getPreviousHeight(CategoryDataset dataset, int series, int category, int[] validRows, boolean renderAsPercentages) {
        double result = 0.0;
        double total = 0.0;
        if (renderAsPercentages) {
            total = DataUtilities.calculateColumnStackedPercentageTotal(dataset, category, validRows);
        }
        for (int i2 = 0; i2 < series; ++i2) {
            Number n2 = dataset.getValue(i2, category);
            if (n2 == null) continue;
            double v2 = n2.doubleValue();
            if (renderAsPercentages) {
                v2 = total == 0.0 ? 0.0 : (v2 /= total);
            }
            result += v2;
        }
        return result;
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (!this.isInit) {
            this.init();
        }
        PlotOrientation orientation = plot.getOrientation();
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            dataValue = new Double(0.0);
        }
        double value = dataValue.doubleValue();
        double total = 0.0;
        int[] visibleSeriesArray = state.getVisibleSeriesArray();
        if (this.renderAsPercentages) {
            total = DataUtilities.calculateColumnStackedPercentageTotal(dataset, column, visibleSeriesArray);
            value = total == 0.0 ? 0.0 : (value /= total);
        }
        double xx1 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double previousHeightx1 = StackedAreaRenderer2D.getPreviousHeight(dataset, row, column, visibleSeriesArray, this.renderAsPercentages);
        double y1 = value + previousHeightx1;
        RectangleEdge location = plot.getRangeAxisEdge();
        double yy1 = rangeAxis.valueToJava2D(y1, dataArea, location);
        Paint itemPaint = this.getItemPaint(row, column);
        g2.setPaint(itemPaint);
        g2.setStroke(this.getItemStroke(row, column));
        if (column == 0) {
            if (pass == 1) {
                if (orientation == PlotOrientation.VERTICAL) {
                    if (this.isItemLabelVisible(row, column)) {
                        this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, xx1, yy1, value < 0.0);
                    }
                } else if (orientation == PlotOrientation.HORIZONTAL && this.isItemLabelVisible(row, column)) {
                    this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, yy1, xx1, value < 0.0);
                }
                this.isInit = false;
            }
        } else {
            Number previousValue = dataset.getValue(row, column - 1);
            if (previousValue == null) {
                previousValue = new Double(0.0);
            }
            if (previousValue != null) {
                double xx0 = domainAxis.getCategoryMiddle(column - 1, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
                double y0 = previousValue.doubleValue();
                if (this.renderAsPercentages) {
                    total = DataUtilities.calculateColumnStackedPercentageTotal(dataset, column - 1, visibleSeriesArray);
                    y0 = total == 0.0 ? 0.0 : (y0 /= total);
                }
                double previousHeightx0 = StackedAreaRenderer2D.getPreviousHeight(dataset, row, column - 1, visibleSeriesArray, this.renderAsPercentages);
                double previousHeightxx0 = rangeAxis.valueToJava2D(previousHeightx0, dataArea, location);
                double previousHeightxx1 = rangeAxis.valueToJava2D(previousHeightx1, dataArea, location);
                double yy0 = rangeAxis.valueToJava2D(y0 += previousHeightx0, dataArea, location);
                if (pass == 0) {
                    GeneralPath clip = new GeneralPath();
                    Line2D.Double tr = null;
                    GeneralPath trE = null;
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        clip.moveTo((float)yy0, (float)xx0);
                        clip.lineTo((float)yy1, (float)xx1);
                        clip.lineTo((float)previousHeightxx1, (float)xx1);
                        clip.lineTo((float)previousHeightxx0, (float)xx0);
                        clip.closePath();
                        boolean plumi = false;
                        if (row > 0 && value < 0.0 && dataset.getValue(row - 1, column) != null && dataset.getValue(row - 1, column).doubleValue() == 0.0) {
                            plumi = true;
                        }
                        if (plumi) {
                            float x0y = (float)rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
                            clip = new GeneralPath();
                            clip.moveTo((float)yy0, (float)xx0);
                            clip.lineTo((float)yy1, (float)xx1);
                            clip.lineTo(x0y, (float)xx1);
                            clip.lineTo(x0y, (float)xx0);
                            clip.closePath();
                        }
                        tr = new Line2D.Double(previousHeightxx0, xx0, previousHeightxx1, xx1);
                        if (row == this.getRowCount() - 1) {
                            trE = new GeneralPath();
                            if (column == 1) {
                                trE.append(new Line2D.Double(rangeAxis.valueToJava2D(0.0, dataArea, location), xx0, yy0, xx0), false);
                            }
                            trE.append(new Line2D.Double(yy0, xx0, yy1, xx1), false);
                            if (column == this.getColumnCount() - 1) {
                                trE.append(new Line2D.Double(yy1, xx1, rangeAxis.valueToJava2D(0.0, dataArea, location), xx1), false);
                            }
                        }
                    } else if (orientation == PlotOrientation.VERTICAL) {
                        clip.moveTo((float)xx0, (float)yy0);
                        clip.lineTo((float)xx1, (float)yy1);
                        clip.lineTo((float)xx1, (float)previousHeightxx1);
                        clip.lineTo((float)xx0, (float)previousHeightxx0);
                        clip.closePath();
                        boolean plumi = false;
                        if (row > 0 && value < 0.0 && dataset.getValue(row - 1, column) != null && dataset.getValue(row - 1, column).doubleValue() == 0.0) {
                            plumi = true;
                        }
                        if (plumi) {
                            float y0x = (float)rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
                            clip = new GeneralPath();
                            clip.moveTo((float)xx0, (float)yy0);
                            clip.lineTo((float)xx1, (float)yy1);
                            clip.lineTo((float)xx1, y0x);
                            clip.lineTo((float)xx0, y0x);
                            clip.closePath();
                        }
                        tr = new Line2D.Double(xx0, previousHeightxx0, xx1, previousHeightxx1);
                        if (row == this.getRowCount() - 1) {
                            trE = new GeneralPath();
                            if (column == 1) {
                                trE.append(new Line2D.Double(xx0, rangeAxis.valueToJava2D(0.0, dataArea, location), xx0, yy0), false);
                            }
                            trE.append(new Line2D.Double(xx0, yy0, xx1, yy1), false);
                            if (column == this.getColumnCount() - 1) {
                                trE.append(new Line2D.Double(xx1, yy1, xx1, rangeAxis.valueToJava2D(0.0, dataArea, location)), false);
                            }
                        }
                    }
                    this.fillArea[row].add(new Area(clip));
                    this.separator[row].append(tr, false);
                    if (row == this.getRowCount() - 1) {
                        this.separator[row + 1].append(trE, false);
                    }
                    if (row == this.getRowCount() - 1 && column == this.getColumnCount() - 1) {
                        this.painter.paintArea(g2, this, this.getRowCount(), column, this.fillArea, this.separator, location, this.isOutline(), true);
                        this.isInit = false;
                    }
                } else if (orientation == PlotOrientation.VERTICAL) {
                    if (this.isItemLabelVisible(row, column)) {
                        this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, xx1, yy1, y1 < 0.0);
                    }
                } else if (orientation == PlotOrientation.HORIZONTAL && this.isItemLabelVisible(row, column)) {
                    this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, yy1, xx1, y1 < 0.0);
                }
            }
        }
    }

    public StandardAreaPainter getPainter() {
        return this.painter;
    }

    public void setPainter(StandardAreaPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Parameter 'painter' is null.");
        }
        this.painter = painter;
    }
}

