/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.category;

import com.inet.jfree.chart.Effect3D;
import com.inet.jfree.chart.axis.CategoryAxis;
import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.event.RendererChangeEvent;
import com.inet.jfree.chart.plot.CategoryPlot;
import com.inet.jfree.chart.plot.Marker;
import com.inet.jfree.chart.plot.Plot;
import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.plot.ValueMarker;
import com.inet.jfree.chart.renderer.category.CategoryItemRendererState;
import com.inet.jfree.chart.renderer.category.Face;
import com.inet.jfree.chart.renderer.category.StackedAreaRenderer;
import com.inet.jfree.chart.renderer.category.StackedAreaRenderer2D;
import com.inet.jfree.chart.renderer.category.StandardAreaPainter;
import com.inet.jfree.data.DataUtilities;
import com.inet.jfree.data.Range;
import com.inet.jfree.data.category.CategoryDataset;
import com.inet.jfree.data.category.InetCategoryDataset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import org.jfree.text.TextUtilities;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class StackedAreaRenderer3D
extends StackedAreaRenderer
implements Effect3D,
Serializable {
    private static final long serialVersionUID = -3595635038460823665L;
    public static final double DEFAULT_X_OFFSET = 12.0;
    public static final double DEFAULT_Y_OFFSET = 8.0;
    public static final Paint DEFAULT_WALL_PAINT = new Color(221, 221, 221);
    private double xOffset = 12.0;
    private double yOffset = 8.0;
    private transient Paint wallPaint = DEFAULT_WALL_PAINT;
    private transient Paint leftWallPaint;
    private transient Paint bottomWallPaint;
    private boolean renderAsPercentages;
    private GeneralPath currentPath = null;
    private GeneralPath clipPath = null;
    private boolean rangeAxisIsInverted = false;
    private double maxY = 0.0;
    private double minY = 0.0;
    private double maxYHeight = 0.0;
    private double minYHeight = 0.0;
    private GeneralPath sideArea = null;
    private ArrayList outsideArea = null;
    private ArrayList outsideIndex = null;
    private Area[] fillArea = null;
    private GeneralPath[] separator = null;
    private GeneralPath cutArea = null;
    private GeneralPath cleanupArea = null;
    private float trx0 = 0.0f;
    private float try0 = 0.0f;
    private float trx1 = 0.0f;
    private float try1 = 0.0f;
    private GeneralPath trE = null;
    private boolean isInit = false;
    private Area axis3D0 = null;
    private Area axis3D0Left = null;
    private float minCut = 0.0f;
    private float maxCut = 0.0f;
    private boolean drawSeparator = true;
    private StandardAreaPainter painter;

    public StackedAreaRenderer3D() {
        this(false);
        this.isInit = false;
        this.painter = new StandardAreaPainter();
    }

    public StackedAreaRenderer3D(boolean renderAsPercentages) {
        super(renderAsPercentages);
        this.renderAsPercentages = renderAsPercentages;
        this.isInit = false;
        this.painter = new StandardAreaPainter();
    }

    private void init(ValueAxis rangeAxis) {
        this.rangeAxisIsInverted = rangeAxis.isInverted();
        this.maxY = rangeAxis.getUpperBound();
        this.minY = rangeAxis.getLowerBound();
        this.fillArea = new Area[this.getRowCount()];
        this.separator = new GeneralPath[this.getRowCount()];
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            this.fillArea[i2] = new Area();
            this.separator[i2] = new GeneralPath();
        }
        this.trE = new GeneralPath();
        this.sideArea = new GeneralPath();
        this.outsideArea = new ArrayList();
        this.outsideIndex = new ArrayList();
        this.cutArea = new GeneralPath();
        this.cleanupArea = new GeneralPath();
        this.isInit = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        this.drawSeparator = true;
        if (!this.isInit) {
            this.init(rangeAxis);
        }
        PlotOrientation orientation = plot.getOrientation();
        Rectangle2D.Double adjusted = new Rectangle2D.Double(dataArea.getX(), dataArea.getY() + this.getYOffset(), dataArea.getWidth() - this.getXOffset(), dataArea.getHeight() - this.getYOffset());
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            dataValue = new Double(0.0);
        }
        double value = dataValue.doubleValue();
        double total = 0.0;
        int[] visibleSeriesArray = state.getVisibleSeriesArray();
        if (this.renderAsPercentages) {
            total = DataUtilities.calculateColumnStackedPercentageTotal(dataset, column, visibleSeriesArray);
            value = total == 0.0 ? 0.0 : (value /= total);
        }
        double xx1 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), (Rectangle2D)adjusted, plot.getDomainAxisEdge());
        double previousHeightx1 = StackedAreaRenderer2D.getPreviousHeight(dataset, row, column, visibleSeriesArray, this.renderAsPercentages);
        double y1 = value + previousHeightx1;
        RectangleEdge location = plot.getRangeAxisEdge();
        double yy1 = rangeAxis.valueToJava2D(y1, adjusted, location);
        this.minYHeight = rangeAxis.valueToJava2D(this.minY, adjusted, location);
        this.maxYHeight = rangeAxis.valueToJava2D(this.maxY, adjusted, location);
        Paint itemPaint = this.getItemPaint(row, column);
        g2.setPaint(itemPaint);
        g2.setStroke(this.getItemStroke(row, column));
        if (column == 0) {
            if (pass != 1) return;
            if (orientation == PlotOrientation.VERTICAL) {
                if (this.isItemLabelVisible(row, column)) {
                    this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, xx1, yy1, value < 0.0);
                }
            } else if (orientation == PlotOrientation.HORIZONTAL && this.isItemLabelVisible(row, column)) {
                this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, yy1, xx1, value < 0.0);
            }
            this.isInit = false;
            return;
        } else {
            Number previousValue = dataset.getValue(row, column - 1);
            if (previousValue == null) {
                previousValue = new Double(0.0);
            }
            if (previousValue == null) return;
            double xx0 = domainAxis.getCategoryMiddle(column - 1, this.getColumnCount(), (Rectangle2D)adjusted, plot.getDomainAxisEdge());
            double y0 = previousValue.doubleValue();
            if (this.renderAsPercentages) {
                total = DataUtilities.calculateColumnStackedPercentageTotal(dataset, column - 1, visibleSeriesArray);
                y0 = total == 0.0 ? 0.0 : (y0 /= total);
            }
            double previousHeightx0 = StackedAreaRenderer2D.getPreviousHeight(dataset, row, column - 1, visibleSeriesArray, this.renderAsPercentages);
            double previousHeightxx0 = rangeAxis.valueToJava2D(previousHeightx0, adjusted, location);
            double previousHeightxx1 = rangeAxis.valueToJava2D(previousHeightx1, adjusted, location);
            double yy0 = rangeAxis.valueToJava2D(y0 += previousHeightx0, adjusted, location);
            if (pass == 0) {
                double xx0V3 = xx0 + this.getXOffset();
                double yy0V3 = yy0 - this.getYOffset();
                double xx1V3 = xx1 + this.getXOffset();
                double yy1V3 = yy1 - this.getYOffset();
                double xx0H3 = xx0 - this.getYOffset();
                double yy0H3 = yy0 + this.getXOffset();
                double xx1H3 = xx1 - this.getYOffset();
                double yy1H3 = yy1 + this.getXOffset();
                boolean drawSide = true;
                if (row == this.getRowCount() - 1 && this.getRowCount() > 1) {
                    double value_1 = 0.0;
                    if (dataset.getValue(row - 1, column) != null) {
                        value_1 = dataset.getValue(row - 1, column).doubleValue();
                    }
                    if (orientation == PlotOrientation.VERTICAL) {
                        drawSide = Math.abs(y0) >= Math.abs(previousHeightx0);
                    } else if (value_1 < 0.0 && value >= 0.0 && value_1 + value < 0.0 && !this.renderAsPercentages || value_1 >= 0.0 && value < 0.0) {
                        drawSide = false;
                    }
                }
                if (row == this.getRowCount() - 1 && row > 0 && orientation == PlotOrientation.VERTICAL) {
                    double value1 = 0.0;
                    if (dataset.getValue(row - 1, column) != null) {
                        value1 = dataset.getValue(row - 1, column).doubleValue();
                    }
                    if (drawSide && value1 > 0.0 && value <= 0.0) {
                        drawSide = false;
                    }
                    if (!drawSide && !rangeAxis.isInverted() && y0 >= previousHeightx0) {
                        drawSide = true;
                    }
                    if (!drawSide && rangeAxis.isInverted() && dataset instanceof InetCategoryDataset && ((InetCategoryDataset)dataset).getInvertedColumns() && y0 >= previousHeightx1) {
                        drawSide = true;
                    }
                }
                GeneralPath ps = new GeneralPath();
                if (row == this.getRowCount() - 1 && drawSide) {
                    boolean minmaxCut;
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        ps.moveTo((float)yy0, (float)xx0);
                        ps.lineTo((float)yy1, (float)xx1);
                        ps.lineTo((float)yy1H3, (float)xx1H3);
                        ps.lineTo((float)yy0H3, (float)xx0H3);
                        ps.closePath();
                        this.currentPath = ps;
                        this.clipPath = new GeneralPath();
                        this.clipPath.moveTo((float)yy0, (float)xx0);
                        this.clipPath.lineTo((float)yy1, (float)xx1);
                        this.clipPath.lineTo((float)previousHeightxx1, (float)xx1);
                        this.clipPath.lineTo((float)previousHeightxx0, (float)xx0);
                        this.clipPath.closePath();
                        minmaxCut = false;
                        if (y1 > this.maxY || y0 > this.maxY) {
                            if (rangeAxis.isInverted() && y0 > 0.0 && y1 < 0.0 && y1 < this.minY) {
                                this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            } else {
                                this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                            }
                            this.axis3D0.intersect(new Area(ps));
                            if (y1 > this.maxY && y0 > this.maxY && !this.rangeAxisIsInverted) {
                                this.axis3D0.reset();
                            }
                            if (!this.axis3D0.isEmpty()) {
                                ps = y1 > this.maxY ? this.createAxis3DMinMaxCut(true, y0, y1, (float)yy0, (float)xx0, (float)yy0H3, (float)xx0H3, (float)xx1H3, rangeAxis.isInverted(), true, plot, rangeAxis, dataArea, adjusted) : this.createAxis3DMinMaxCut(true, y0, y1, (float)yy1, (float)xx1, (float)yy1H3, (float)xx1H3, (float)xx0H3, rangeAxis.isInverted(), true, plot, rangeAxis, dataArea, adjusted);
                                minmaxCut = true;
                            } else if (!this.rangeAxisIsInverted && this.maxY > 0.0) {
                                ps = new GeneralPath();
                                ps.moveTo((float)this.maxYHeight, (float)xx0);
                                ps.lineTo((float)this.maxYHeight, (float)xx1);
                                ps.lineTo((float)(this.maxYHeight + this.getXOffset()), (float)xx1H3);
                                ps.lineTo((float)(this.maxYHeight + this.getXOffset()), (float)xx0H3);
                                ps.closePath();
                                this.cutArea.append(ps, false);
                                ps = new GeneralPath();
                                ps.moveTo((float)this.maxYHeight, (float)xx1);
                                ps.lineTo((float)(this.maxYHeight + this.getXOffset()), (float)xx1H3);
                                ps.lineTo((float)(this.maxYHeight + this.getXOffset()), (float)xx1);
                                ps.closePath();
                                this.cleanupArea.append(ps, false);
                                ps = new GeneralPath();
                                minmaxCut = true;
                            }
                        }
                        if (!minmaxCut && y0 < 0.0) {
                            this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(ps));
                            ps = this.createAxis3DY0SideCut((float)yy1, (float)xx1, (float)yy1H3, (float)xx1H3, rangeAxis.isInverted(), true);
                            minmaxCut = true;
                        }
                        if (!minmaxCut && !this.rangeAxisIsInverted && y0 > 0.0 && y1 < 0.0 && y1 < this.minY) {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(ps));
                            ps = this.createAxis3DY0SideCut((float)yy0, (float)xx0, (float)yy0H3, (float)xx0H3, rangeAxis.isInverted(), true);
                            minmaxCut = true;
                        }
                        if (!minmaxCut && rangeAxis.isInverted() && y0 > y1 && y1 < 0.0) {
                            float xi0 = (float)yy1;
                            float yi0 = (float)xx1;
                            float xi0H3 = (float)yy1H3;
                            float yi0H3 = (float)xx1H3;
                            if (y1 < this.minY) {
                                this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                                this.axis3D0.intersect(new Area(this.clipPath));
                                boolean notEmpty = this.setminCutmaxCut(true, false, true);
                                if (notEmpty) {
                                    xi0 = (float)this.minYHeight;
                                    yi0 = this.minCut;
                                    xi0H3 = (float)(this.minYHeight + this.getXOffset());
                                    yi0H3 = (float)((double)this.minCut - this.getYOffset());
                                }
                            }
                            this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.currentPath));
                            ps = this.createAxis3DY0SideCut(xi0, yi0, xi0H3, yi0H3, false, true);
                            if (y1 < this.minY) {
                                GeneralPath psd = new GeneralPath();
                                psd.moveTo(xi0, yi0);
                                psd.lineTo(xi0H3, yi0H3);
                                psd.lineTo(xi0H3, (float)xx1H3);
                                psd.lineTo(xi0, (float)xx1);
                                psd.closePath();
                                ps.append(psd, false);
                            }
                            minmaxCut = true;
                        }
                        if (!minmaxCut && rangeAxis.isInverted() && y1 > y0 && y0 < 0.0 && y0 < this.minY) {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            boolean notEmpty = this.setminCutmaxCut(true, false, true);
                            if (notEmpty) {
                                GeneralPath psd = new GeneralPath();
                                psd.moveTo((float)this.minYHeight, this.maxCut);
                                psd.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)this.maxCut - this.getYOffset()));
                                psd.lineTo((float)(this.minYHeight + this.getXOffset()), (float)xx0H3);
                                psd.lineTo((float)this.minYHeight, (float)xx0);
                                psd.closePath();
                            }
                        }
                    } else if (orientation == PlotOrientation.VERTICAL) {
                        ps.moveTo((float)xx0, (float)yy0);
                        ps.lineTo((float)xx1, (float)yy1);
                        ps.lineTo((float)xx1V3, (float)yy1V3);
                        ps.lineTo((float)xx0V3, (float)yy0V3);
                        ps.closePath();
                        this.currentPath = ps;
                        this.clipPath = new GeneralPath();
                        this.clipPath.moveTo((float)xx0, (float)yy0);
                        this.clipPath.lineTo((float)xx1, (float)yy1);
                        this.clipPath.lineTo((float)xx1, (float)previousHeightxx1);
                        this.clipPath.lineTo((float)xx0, (float)previousHeightxx0);
                        this.clipPath.closePath();
                        minmaxCut = false;
                        if (y1 > this.maxY || y0 > this.maxY) {
                            this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                            if (!this.rangeAxisIsInverted) {
                                this.createAxis3DY0LeftArea(this.maxY, plot, rangeAxis, dataArea, adjusted);
                                this.axis3D0 = this.axis3D0Left;
                            }
                            this.axis3D0.intersect(new Area(this.clipPath));
                            if (y1 > this.maxY && y0 > this.maxY && !this.rangeAxisIsInverted) {
                                this.axis3D0.reset();
                            }
                            if (!this.axis3D0.isEmpty()) {
                                if (y1 > this.maxY && y0 < 0.0 && y0 < this.minY && this.rangeAxisIsInverted && this.maxY > 0.0) {
                                    if (this.minY > 0.0) {
                                        this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                                    } else {
                                        this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                                    }
                                    this.axis3D0.intersect(new Area(this.currentPath));
                                }
                                if (y1 > this.maxY) {
                                    float yE0 = (float)yy0;
                                    float yE0V3 = (float)yy0V3;
                                    if ((double)yE0 < this.maxYHeight && !this.rangeAxisIsInverted) {
                                        yE0 = (float)this.maxYHeight;
                                        yE0V3 = (float)((double)yE0 - this.getYOffset());
                                    }
                                    ps = this.createAxis3DMinMaxCut(true, y0, y1, (float)xx0, yE0, (float)xx0V3, yE0V3, (float)xx1V3, rangeAxis.isInverted(), false, plot, rangeAxis, dataArea, adjusted);
                                } else {
                                    float yE1 = (float)yy1;
                                    float yE1V3 = (float)yy1V3;
                                    if ((double)yE1 < this.maxYHeight && !this.rangeAxisIsInverted) {
                                        yE1 = (float)this.maxYHeight;
                                        yE1V3 = (float)((double)yE1 - this.getYOffset());
                                    }
                                    ps = this.createAxis3DMinMaxCut(true, y0, y1, (float)xx1, yE1, (float)xx1V3, yE1V3, (float)xx0V3, rangeAxis.isInverted(), false, plot, rangeAxis, dataArea, adjusted);
                                }
                                minmaxCut = true;
                            } else if (!this.rangeAxisIsInverted && this.maxY > 0.0) {
                                boolean notEmpty;
                                if (y1 > this.maxY && y0 < this.maxY) {
                                    this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                                    this.axis3D0.intersect(new Area(this.currentPath));
                                    if (!this.axis3D0.isEmpty() && (notEmpty = this.setminCutmaxCut(false, true, rangeAxis.isInverted()))) {
                                        ps = new GeneralPath();
                                        ps.moveTo((float)xx1, (float)this.maxYHeight);
                                        ps.lineTo((float)xx1V3, (float)(this.maxYHeight - this.getYOffset()));
                                        ps.lineTo(this.maxCut, (float)(this.maxYHeight - this.getYOffset()));
                                        ps.lineTo((float)((double)this.maxCut - this.getXOffset()), (float)this.maxYHeight);
                                        ps.closePath();
                                    }
                                } else if (y1 < this.maxY && y0 > this.maxY) {
                                    this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                                    this.axis3D0.intersect(new Area(this.currentPath));
                                    if (!this.axis3D0.isEmpty() && (notEmpty = this.setminCutmaxCut(false, true, rangeAxis.isInverted()))) {
                                        ps = new GeneralPath();
                                        ps.moveTo((float)xx0, (float)this.maxYHeight);
                                        ps.lineTo((float)xx0V3, (float)(this.maxYHeight - this.getYOffset()));
                                        ps.lineTo(this.maxCut, (float)(this.maxYHeight - this.getYOffset()));
                                        ps.lineTo((float)((double)this.maxCut - this.getXOffset()), (float)this.maxYHeight);
                                        ps.lineTo((float)xx0, (float)this.maxYHeight);
                                        ps.moveTo(this.maxCut, (float)(this.maxYHeight - this.getYOffset()));
                                        ps.lineTo((float)((double)this.maxCut - this.getXOffset()), (float)this.maxYHeight);
                                        ps.lineTo((float)xx1, (float)yy1);
                                        ps.lineTo((float)xx1V3, (float)yy1V3);
                                        ps.closePath();
                                    }
                                } else {
                                    ps = new GeneralPath();
                                    ps.moveTo((float)xx0, (float)this.maxYHeight);
                                    ps.lineTo((float)xx1, (float)this.maxYHeight);
                                    ps.lineTo((float)xx1V3, (float)(this.maxYHeight - this.getYOffset()));
                                    ps.lineTo((float)xx0V3, (float)(this.maxYHeight - this.getYOffset()));
                                    ps.closePath();
                                }
                                this.cutArea.append(ps, false);
                                ps = new GeneralPath();
                                ps.moveTo((float)xx0, (float)this.maxYHeight);
                                ps.lineTo((float)xx0V3, (float)(this.maxYHeight - this.getYOffset()));
                                ps.lineTo((float)xx0V3, (float)this.maxYHeight);
                                ps.closePath();
                                this.cleanupArea.append(ps, false);
                                ps = new GeneralPath();
                                minmaxCut = true;
                            }
                        }
                        if (!minmaxCut && (y1 < this.minY || y0 < this.minY)) {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            if (this.axis3D0.isEmpty()) {
                                ps = new GeneralPath();
                            } else {
                                ps = y1 < this.minY ? this.createAxis3DMinMaxCut(false, y0, y1, (float)xx0, (float)yy0, (float)xx0V3, (float)yy0V3, (float)xx1V3, rangeAxis.isInverted(), false, plot, rangeAxis, dataArea, adjusted) : this.createAxis3DMinMaxCut(false, y0, y1, (float)xx1, (float)yy1, (float)xx1V3, (float)yy1V3, (float)xx0V3, rangeAxis.isInverted(), false, plot, rangeAxis, dataArea, adjusted);
                                if (y0 < this.minY && y1 < this.minY) {
                                    ps = new GeneralPath();
                                }
                            }
                            minmaxCut = true;
                        }
                        if (!minmaxCut && value < 0.0 && !rangeAxis.isInverted()) {
                            this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.currentPath));
                            ps = this.axis3D0.isEmpty() ? new GeneralPath() : this.createAxis3DY0SideCut((float)xx0, (float)yy0, (float)xx0V3, (float)yy0V3, rangeAxis.isInverted(), false);
                            minmaxCut = true;
                        }
                        if (!minmaxCut && y0 > 0.0 && y1 < 0.0 && !rangeAxis.isInverted()) {
                            this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(ps));
                            ps = this.createAxis3DY0SideCut((float)xx0, (float)yy0, (float)xx0V3, (float)yy0V3, rangeAxis.isInverted(), false);
                            minmaxCut = true;
                        }
                        if (!minmaxCut && y0 < 0.0 && rangeAxis.isInverted()) {
                            this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.currentPath));
                            ps = this.axis3D0.isEmpty() ? new GeneralPath() : this.createAxis3DY0SideCut((float)xx0, (float)yy0, (float)xx0V3, (float)yy0V3, rangeAxis.isInverted(), false);
                            minmaxCut = true;
                        }
                    }
                    this.painter.paintSide(g2, this, row, column, ps, itemPaint, location, Face.Top);
                }
                if (column == this.getColumnCount() - 1 && orientation == PlotOrientation.VERTICAL) {
                    double lastHeightx1 = StackedAreaRenderer2D.getPreviousHeight(dataset, row, column, visibleSeriesArray, this.renderAsPercentages);
                    boolean drawSideArea = true;
                    if (!this.rangeAxisIsInverted && lastHeightx1 > this.maxY && yy1 < this.maxYHeight) {
                        drawSideArea = false;
                    }
                    if (lastHeightx1 < this.minY) {
                        lastHeightx1 = this.minY;
                    }
                    if (lastHeightx1 > this.maxY) {
                        lastHeightx1 = this.maxY;
                    }
                    double yE2 = rangeAxis.valueToJava2D(lastHeightx1, adjusted, location);
                    double yE3 = yE2 - this.getYOffset();
                    float yE1 = (float)yy1;
                    float yE1V3 = (float)yy1V3;
                    if ((double)yE1 < this.maxYHeight && !this.rangeAxisIsInverted) {
                        yE1 = (float)this.maxYHeight;
                        yE1V3 = (float)((double)yE1 - this.getYOffset());
                    }
                    if ((double)yE1 > this.maxYHeight && this.rangeAxisIsInverted) {
                        yE1 = (float)this.maxYHeight;
                        yE1V3 = (float)((double)yE1 - this.getYOffset());
                    }
                    if (drawSideArea && ((yy1 < this.minYHeight || yE2 < this.minYHeight) && !rangeAxis.isInverted() || ((double)yE1 <= this.maxYHeight || yE2 < this.maxYHeight) && rangeAxis.isInverted())) {
                        ps = new GeneralPath();
                        ps.moveTo((float)xx1, yE1);
                        ps.lineTo((float)xx1, (float)yE2);
                        ps.lineTo((float)xx1V3, (float)yE3);
                        ps.lineTo((float)xx1V3, yE1V3);
                        ps.closePath();
                        this.currentPath = ps;
                        this.clipPath = null;
                        if ((yy1 > this.minYHeight || yE2 > this.minYHeight) && !rangeAxis.isInverted() || (yy1 < this.minYHeight || yE2 < this.minYHeight) && rangeAxis.isInverted()) {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(ps));
                            ps = this.createAxis3DMinMaxEnd(y0, y1, (float)xx1, (float)yy1, (float)yE2, rangeAxis.isInverted(), false);
                        }
                        if (ps != null) {
                            this.outsideArea.add(ps);
                            this.outsideIndex.add(new Integer(row));
                        }
                    }
                }
                if (column == 1 && orientation == PlotOrientation.HORIZONTAL) {
                    double lastHeightx1 = StackedAreaRenderer2D.getPreviousHeight(dataset, row, column - 1, visibleSeriesArray, this.renderAsPercentages);
                    if (lastHeightx1 < this.minY) {
                        lastHeightx1 = this.minY;
                    }
                    if (lastHeightx1 > this.maxY) {
                        lastHeightx1 = this.maxY;
                    }
                    double xE2 = rangeAxis.valueToJava2D(lastHeightx1, adjusted, location);
                    double xE3 = xE2 + this.getXOffset();
                    ps = new GeneralPath();
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        ps.moveTo((float)yy0, (float)xx0);
                        ps.lineTo((float)xE2, (float)xx0);
                        ps.lineTo((float)xE3, (float)xx0H3);
                        ps.lineTo((float)yy0H3, (float)xx0H3);
                        ps.closePath();
                    }
                    if ((yy0 < this.maxYHeight || xE2 < this.maxYHeight) && rangeAxis.isInverted() && yy0 < this.maxYHeight && xE2 >= this.maxYHeight) {
                        ps = new GeneralPath();
                        ps.moveTo((float)this.maxYHeight, (float)xx0);
                        ps.lineTo((float)xE2, (float)xx0);
                        ps.lineTo((float)xE3, (float)xx0H3);
                        ps.lineTo((float)(this.maxYHeight + this.getXOffset()), (float)xx0H3);
                        ps.closePath();
                    }
                    if (yy0 > this.maxYHeight && !rangeAxis.isInverted()) {
                        ps = new GeneralPath();
                        ps.moveTo((float)this.maxYHeight, (float)xx0);
                        ps.lineTo((float)xE2, (float)xx0);
                        ps.lineTo((float)xE3, (float)xx0H3);
                        ps.lineTo((float)(this.maxYHeight + this.getXOffset()), (float)xx0H3);
                        ps.closePath();
                    }
                    if (y0 < this.minY && y1 < this.minY || y0 > this.maxY && y1 > this.maxY) {
                        ps = null;
                    }
                    if (this.maxY < 0.0 && this.minY < 0.0) {
                        ps = null;
                    }
                    if (ps != null) {
                        this.outsideArea.add(ps);
                        this.outsideIndex.add(new Integer(row));
                    }
                }
            }
            if (pass == 0) {
                int i2;
                GeneralPath clip = new GeneralPath();
                GeneralPath tr = new GeneralPath();
                if (orientation == PlotOrientation.HORIZONTAL) {
                    clip.moveTo((float)yy0, (float)xx0);
                    clip.lineTo((float)yy1, (float)xx1);
                    clip.lineTo((float)previousHeightxx1, (float)xx1);
                    clip.lineTo((float)previousHeightxx0, (float)xx0);
                    clip.closePath();
                    this.currentPath = clip;
                    this.clipPath = clip;
                    if (!(y0 > this.maxY) || y1 > this.maxY) {
                        // empty if block
                    }
                    if (!(y0 < this.minY) || y1 < this.minY) {
                        // empty if block
                    }
                    this.trx0 = (float)previousHeightxx0;
                    this.try0 = (float)xx0;
                    this.trx1 = (float)previousHeightxx1;
                    this.try1 = (float)xx1;
                    boolean drawTr = true;
                    if (this.rangeAxisIsInverted) {
                        if (previousHeightxx0 <= this.maxYHeight && previousHeightxx1 <= this.maxYHeight) {
                            drawTr = false;
                        }
                        if (previousHeightxx0 >= this.minYHeight && previousHeightxx1 >= this.minYHeight) {
                            drawTr = false;
                        }
                    }
                    if (!this.rangeAxisIsInverted) {
                        if (previousHeightxx0 >= this.maxYHeight && previousHeightxx1 >= this.maxYHeight) {
                            drawTr = false;
                        }
                        if (previousHeightxx0 <= this.minYHeight && previousHeightxx1 <= this.minYHeight) {
                            drawTr = false;
                        }
                    }
                    if (drawTr) {
                        tr = new GeneralPath(new Line2D.Double(this.trx0, this.try0, this.trx1, this.try1));
                    }
                    if (row == this.getRowCount() - 1) {
                        if (column == this.getColumnCount() - 1) {
                            this.trE = new GeneralPath();
                            float yye = (float)yy1;
                            if (!this.rangeAxisIsInverted) {
                                yye = yy1 < this.maxYHeight ? (float)yy1 : (float)this.maxYHeight;
                            }
                            float yya = (float)rangeAxis.valueToJava2D(0.0, adjusted, location);
                            if (!this.rangeAxisIsInverted && this.maxY < 0.0) {
                                yya = (float)this.maxYHeight;
                            }
                            this.trE.append(new Line2D.Double(yye, (float)xx1, yya, xx1), false);
                        }
                        if (clip != null) {
                            if (y1 > this.maxY || y0 > this.maxY) {
                                GeneralPath trC = null;
                                trC = y1 > this.maxY ? this.createAxis3DMinMaxLine(clip, y0, y1, (float)yy0, (float)xx0, (float)yy1, (float)xx1, (float)previousHeightxx0, (float)previousHeightxx1, rangeAxis.isInverted(), true, plot, rangeAxis, dataArea, adjusted) : this.createAxis3DMinMaxLine(clip, y0, y1, (float)yy1, (float)xx1, (float)yy0, (float)xx0, (float)previousHeightxx0, (float)previousHeightxx1, rangeAxis.isInverted(), true, plot, rangeAxis, dataArea, adjusted);
                                if (!(y1 > 0.0 && y0 < 0.0 || y1 < 0.0 || y0 > 0.0)) {
                                    this.trE.append(trC, false);
                                }
                            } else if (!(y1 < this.minY) && !(y0 < this.minY)) {
                                this.trE.append(new Line2D.Double(yy0, xx0, yy1, xx1), false);
                            }
                        }
                    }
                } else if (orientation == PlotOrientation.VERTICAL) {
                    if (previousHeightxx0 >= this.minYHeight && previousHeightxx1 >= this.minYHeight && y0 <= this.minY && y1 <= this.minY) {
                        if (row != this.getRowCount() - 1 || column != this.getColumnCount() - 1) return;
                        this.drawSeparator = false;
                    } else {
                        clip.moveTo((float)xx0, (float)yy0);
                        clip.lineTo((float)xx1, (float)yy1);
                        clip.lineTo((float)xx1, (float)previousHeightxx1);
                        clip.lineTo((float)xx0, (float)previousHeightxx0);
                        clip.closePath();
                        this.currentPath = clip;
                        this.clipPath = clip;
                        this.trx0 = (float)xx0;
                        this.try0 = (float)previousHeightxx0;
                        this.trx1 = (float)xx1;
                        this.try1 = (float)previousHeightxx1;
                        if (y0 > this.maxY && y1 > this.maxY) {
                            if (this.rangeAxisIsInverted) {
                                if (previousHeightxx0 > this.maxYHeight && previousHeightxx1 > this.maxYHeight && column < this.getColumnCount() - 1) {
                                    return;
                                }
                            } else if (previousHeightxx0 < this.maxYHeight && previousHeightxx1 < this.maxYHeight && !this.rangeAxisIsInverted) {
                                if (row == this.getRowCount() - 1) {
                                    if (this.trE == null) {
                                        this.trE = new GeneralPath();
                                    }
                                    if (!(y0 > this.minY) || !(y1 > this.minY)) {
                                        this.trE.append(new Line2D.Double(xx0, this.maxYHeight, xx1, this.maxYHeight), false);
                                    }
                                }
                                if (column < this.getColumnCount() - 1) {
                                    return;
                                }
                            }
                        }
                        if (y0 < this.minY && y1 < this.minY && (this.rangeAxisIsInverted ? previousHeightxx0 < this.minYHeight && previousHeightxx1 < this.minYHeight && column < this.getColumnCount() - 1 : previousHeightxx0 > this.minYHeight && previousHeightxx1 > this.minYHeight && column < this.getColumnCount() - 1)) {
                            return;
                        }
                        boolean drawTr = true;
                        if (!this.rangeAxisIsInverted && previousHeightxx0 <= this.maxYHeight && previousHeightxx1 <= this.maxYHeight) {
                            drawTr = false;
                        }
                        if (drawTr) {
                            tr = new GeneralPath(new Line2D.Double(this.trx0, this.try0, this.trx1, this.try1));
                        }
                        if (row == this.getRowCount() - 1) {
                            if (column == 1) {
                                float yye;
                                this.trE = new GeneralPath();
                                float f2 = yye = yy0 > this.maxYHeight ? (float)yy0 : (float)this.maxYHeight;
                                if (this.rangeAxisIsInverted) {
                                    yye = yy0 < this.maxYHeight ? (float)yy0 : (float)this.maxYHeight;
                                }
                                float yya = (float)rangeAxis.valueToJava2D(0.0, adjusted, location);
                                if (!this.rangeAxisIsInverted && this.maxY < 0.0) {
                                    yya = (float)this.maxYHeight;
                                }
                                this.trE.append(new Line2D.Double(xx0, yya, xx0, yye), false);
                            }
                            if (clip != null) {
                                GeneralPath clipA = new GeneralPath();
                                clipA.moveTo((float)xx0, (float)yy0);
                                clipA.lineTo((float)xx1, (float)yy1);
                                clipA.lineTo((float)xx1, (float)previousHeightxx1);
                                clipA.lineTo((float)xx0, (float)previousHeightxx0);
                                clipA.closePath();
                                if (y1 > this.maxY || y0 > this.maxY) {
                                    this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                                    this.axis3D0.intersect(new Area(clipA));
                                    if (y0 > this.maxY && y1 > this.maxY && !this.rangeAxisIsInverted) {
                                        this.axis3D0.reset();
                                    }
                                    GeneralPath trC = null;
                                    if (!this.axis3D0.isEmpty()) {
                                        trC = y1 > this.maxY ? this.createAxis3DMinMaxLine(clipA, y0, y1, (float)xx0, (float)yy0, (float)xx1, (float)yy1, previousHeightxx0 > this.maxYHeight ? (float)previousHeightxx0 : (float)this.maxYHeight, previousHeightxx1 < this.maxYHeight ? (float)previousHeightxx1 : (float)this.maxYHeight, rangeAxis.isInverted(), false, plot, rangeAxis, dataArea, adjusted) : this.createAxis3DMinMaxLine(clipA, y0, y1, (float)xx1, (float)yy1, (float)xx0, (float)yy0, previousHeightxx0 > this.maxYHeight ? (float)previousHeightxx0 : (float)this.maxYHeight, previousHeightxx1 < this.maxYHeight ? (float)previousHeightxx1 : (float)this.maxYHeight, rangeAxis.isInverted(), false, plot, rangeAxis, dataArea, adjusted);
                                    } else {
                                        trC = new GeneralPath();
                                        trC.append(new Line2D.Double((float)xx0, (float)this.maxYHeight, (float)xx1, (float)this.maxYHeight), false);
                                        if (y0 > this.minY && y1 > this.minY && !this.rangeAxisIsInverted) {
                                            trC.reset();
                                        }
                                    }
                                    if (!this.rangeAxisIsInverted && !trC.getPathIterator(null).isDone()) {
                                        trC = new GeneralPath();
                                        trC.append(new Line2D.Double(xx0, yy0, xx1, yy1), false);
                                    } else {
                                        this.trE.append(trC, false);
                                    }
                                } else if (y1 < this.minY || y0 < this.minY) {
                                    this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                                    this.axis3D0.intersect(new Area(clipA));
                                } else {
                                    this.trE.append(new Line2D.Double(xx0, yy0, xx1, yy1), false);
                                }
                                if (column == this.getColumnCount() - 1) {
                                    float yye;
                                    float f3 = yye = yy1 > this.maxYHeight ? (float)yy1 : (float)this.maxYHeight;
                                    if (this.rangeAxisIsInverted) {
                                        yye = yy1 < this.maxYHeight ? (float)yy1 : (float)this.maxYHeight;
                                    }
                                    this.trE.append(new Line2D.Double(xx1, yye, xx1, rangeAxis.valueToJava2D(0.0, dataArea, location)), false);
                                }
                            }
                        }
                    }
                }
                if (this.drawSeparator) {
                    if (clip != null) {
                        this.fillArea[row].add(new Area(this.currentPath));
                    }
                    this.separator[row].append(tr, false);
                }
                if ((row != this.getRowCount() - 1 || column != this.getColumnCount() - 1 || orientation != PlotOrientation.VERTICAL) && (row != this.getRowCount() - 1 || column != 1 || orientation != PlotOrientation.HORIZONTAL)) return;
                for (i2 = 0; i2 < this.getRowCount(); ++i2) {
                    if (this.rangeAxisIsInverted) continue;
                    if (i2 == 0 && orientation == PlotOrientation.VERTICAL) {
                        this.createAxis3DY0LeftArea(this.maxY, plot, rangeAxis, dataArea, adjusted);
                        this.fillArea[0].subtract(this.axis3D0Left);
                        continue;
                    }
                    this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                    this.fillArea[i2].subtract(this.axis3D0);
                }
                this.painter.paintArea(g2, this, this.getRowCount(), column, this.fillArea, this.separator, location, this.isOutline(), false);
                if (this.rangeAxisIsInverted) {
                    this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                    g2.setPaint(this.getWallPaint());
                    g2.fill(this.axis3D0);
                }
                if (!this.rangeAxisIsInverted && !this.cutArea.getPathIterator(null).isDone()) {
                    if (plot.getBackgroundPaint() != null) {
                        g2.setPaint(plot.getBackgroundPaint());
                    } else {
                        g2.setPaint(Color.white);
                    }
                    itemPaint = Color.lightGray;
                    for (i2 = 0; i2 < this.getColumnCount() && (itemPaint = this.getItemPaint(this.getRowCount() - 1, i2)) == null; ++i2) {
                    }
                    this.painter.paintSide(g2, this, this.getRowCount() - 1, i2, this.cutArea, itemPaint, location, Face.Top);
                }
                int coli = 1;
                if (orientation == PlotOrientation.VERTICAL) {
                    coli = this.getRowCount() - 1;
                }
                for (int i3 = 0; i3 < this.outsideIndex.size(); ++i3) {
                    int rowi = (Integer)this.outsideIndex.get(i3);
                    GeneralPath ps = (GeneralPath)this.outsideArea.get(i3);
                    itemPaint = this.getItemPaint(rowi, coli);
                    this.painter.paintSide(g2, this, rowi, coli, ps, itemPaint, location, Face.Right);
                }
                g2.draw(this.trE);
                this.isInit = false;
                return;
            } else {
                if (orientation == PlotOrientation.VERTICAL) {
                    if (this.isItemLabelVisible(row, column)) {
                        this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, xx1, yy1, y1 < 0.0);
                    }
                } else if (orientation == PlotOrientation.HORIZONTAL && this.isItemLabelVisible(row, column)) {
                    this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, yy1, xx1, y1 < 0.0);
                }
                this.isInit = false;
            }
        }
    }

    public void drawBackground(Graphics2D g2, CategoryPlot plot, Rectangle2D dataArea) {
        float x0 = (float)dataArea.getX();
        float x1 = x0 + (float)Math.abs(this.xOffset);
        float x3 = (float)dataArea.getMaxX();
        float x2 = x3 - (float)Math.abs(this.xOffset);
        float y0 = (float)dataArea.getMaxY();
        float y1 = y0 - (float)Math.abs(this.yOffset);
        float y3 = (float)dataArea.getMinY();
        float y2 = y3 + (float)Math.abs(this.yOffset);
        GeneralPath clip = new GeneralPath();
        clip.moveTo(x0, y0);
        clip.lineTo(x0, y2);
        clip.lineTo(x1, y3);
        clip.lineTo(x3, y3);
        clip.lineTo(x3, y1);
        clip.lineTo(x2, y0);
        clip.closePath();
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, plot.getBackgroundAlpha()));
        Paint backgroundPaint = plot.getBackgroundPaint();
        if (backgroundPaint != null) {
            g2.setPaint(backgroundPaint);
            g2.fill(clip);
        }
        GeneralPath leftWall = new GeneralPath();
        leftWall.moveTo(x0, y0);
        leftWall.lineTo(x0, y2);
        leftWall.lineTo(x1, y3);
        leftWall.lineTo(x1, y1);
        leftWall.closePath();
        Paint leftPaint = this.getLeftWallPaint();
        if (leftPaint == null) {
            leftPaint = this.getWallPaint();
        }
        g2.setPaint(leftPaint);
        g2.fill(leftWall);
        GeneralPath bottomWall = new GeneralPath();
        bottomWall.moveTo(x0, y0);
        bottomWall.lineTo(x1, y1);
        bottomWall.lineTo(x3, y1);
        bottomWall.lineTo(x2, y0);
        bottomWall.closePath();
        Paint bottomPaint = this.getBottomWallPaint();
        if (bottomPaint == null) {
            bottomPaint = this.getWallPaint();
        }
        g2.setPaint(bottomPaint);
        g2.fill(bottomWall);
        g2.setPaint(Color.lightGray);
        Line2D.Double corner = new Line2D.Double(x0, y0, x1, y1);
        g2.draw(corner);
        ((Line2D)corner).setLine(x1, y1, x1, y3);
        g2.draw(corner);
        ((Line2D)corner).setLine(x1, y1, x3, y1);
        g2.draw(corner);
        Image backgroundImage = plot.getBackgroundImage();
        if (backgroundImage != null) {
            Rectangle2D.Double adjusted = new Rectangle2D.Double(dataArea.getX() + this.getXOffset(), dataArea.getY(), dataArea.getWidth() - this.getXOffset(), dataArea.getHeight() - this.getYOffset());
            plot.drawBackgroundImage(g2, adjusted);
        }
        g2.setComposite(originalComposite);
    }

    public void drawDomainGridline(Graphics2D g2, CategoryPlot plot, Rectangle2D dataArea, double value) {
        Line2D.Double line1 = null;
        Line2D.Double line2 = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            double y0 = value;
            double y1 = value - this.getYOffset();
            double x0 = dataArea.getMinX();
            double x1 = x0 + this.getXOffset();
            double x2 = dataArea.getMaxY();
            line1 = new Line2D.Double(x0, y0, x1, y1);
            line2 = new Line2D.Double(x1, y1, x2, y1);
        } else if (orientation == PlotOrientation.VERTICAL) {
            double x0 = value;
            double x1 = value + this.getXOffset();
            double y0 = dataArea.getMaxY();
            double y1 = y0 - this.getYOffset();
            double y2 = dataArea.getMinY();
            line1 = new Line2D.Double(x0, y0, x1, y1);
            line2 = new Line2D.Double(x1, y1, x1, y2);
        }
        Paint paint = plot.getDomainGridlinePaint();
        Stroke stroke = plot.getDomainGridlineStroke();
        g2.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        g2.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        g2.draw(line1);
        g2.draw(line2);
    }

    public void drawOutline(Graphics2D g2, CategoryPlot plot, Rectangle2D dataArea) {
        float x0 = (float)dataArea.getX();
        float x1 = x0 + (float)Math.abs(this.xOffset);
        float x3 = (float)dataArea.getMaxX();
        float x2 = x3 - (float)Math.abs(this.xOffset);
        float y0 = (float)dataArea.getMaxY();
        float y1 = y0 - (float)Math.abs(this.yOffset);
        float y3 = (float)dataArea.getMinY();
        float y2 = y3 + (float)Math.abs(this.yOffset);
        GeneralPath clip = new GeneralPath();
        clip.moveTo(x0, y0);
        clip.lineTo(x0, y2);
        clip.lineTo(x1, y3);
        clip.lineTo(x3, y3);
        clip.lineTo(x3, y1);
        clip.lineTo(x2, y0);
        clip.closePath();
        Stroke outlineStroke = plot.getOutlineStroke();
        Paint outlinePaint = plot.getOutlinePaint();
        if (outlineStroke != null && outlinePaint != null) {
            g2.setStroke(outlineStroke);
            g2.setPaint(outlinePaint);
            g2.draw(clip);
        }
    }

    public void drawRangeGridline(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Rectangle2D dataArea, double value) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        Rectangle2D.Double adjusted = new Rectangle2D.Double(dataArea.getX(), dataArea.getY() + this.getYOffset(), dataArea.getWidth() - this.getXOffset(), dataArea.getHeight() - this.getYOffset());
        Line2D.Double line1 = null;
        Line2D.Double line2 = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            double x0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double x1 = x0 + this.getXOffset();
            double y0 = dataArea.getMaxY();
            double y1 = y0 - this.getYOffset();
            double y2 = dataArea.getMinY();
            line1 = new Line2D.Double(x0, y0, x1, y1);
            line2 = new Line2D.Double(x1, y1, x1, y2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            double y0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double y1 = y0 - this.getYOffset();
            double x0 = dataArea.getMinX();
            double x1 = x0 + this.getXOffset();
            double x2 = dataArea.getMaxX();
            line1 = new Line2D.Double(x0, y0, x1, y1);
            line2 = new Line2D.Double(x1, y1, x2, y1);
        }
        Paint paint = plot.getRangeGridlinePaint();
        Stroke stroke = plot.getRangeGridlineStroke();
        g2.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        g2.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        g2.draw(line1);
        g2.draw(line2);
    }

    public void drawRangeLine(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Rectangle2D dataArea, double value, Paint paint, Stroke stroke) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        Rectangle2D.Double adjusted = new Rectangle2D.Double(dataArea.getX(), dataArea.getY() + this.getYOffset(), dataArea.getWidth() - this.getXOffset(), dataArea.getHeight() - this.getYOffset());
        Line2D.Double line1 = null;
        Line2D.Double line2 = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            double x0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double x1 = x0 + this.getXOffset();
            double y0 = dataArea.getMaxY();
            double y1 = y0 - this.getYOffset();
            double y2 = dataArea.getMinY();
            line1 = new Line2D.Double(x0, y0, x1, y1);
            line2 = new Line2D.Double(x1, y1, x1, y2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            double y0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double y1 = y0 - this.getYOffset();
            double x0 = dataArea.getMinX();
            double x1 = x0 + this.getXOffset();
            double x2 = dataArea.getMaxX();
            line1 = new Line2D.Double(x0, y0, x1, y1);
            line2 = new Line2D.Double(x1, y1, x2, y1);
        }
        g2.setPaint(paint);
        g2.setStroke(stroke);
        g2.draw(line1);
        g2.draw(line2);
    }

    private GeneralPath createAxis3DY0SideCut(float x0, float y0, float x03, float y03, boolean inverted, boolean horiz) {
        float[] x2 = new float[4];
        float[] y2 = new float[4];
        int i2 = 0;
        float[] theData = new float[6];
        PathIterator theIterator = this.axis3D0.getPathIterator(null);
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                    break;
                }
                case 1: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                }
            }
            theIterator.next();
            if (++i2 != 4) continue;
        }
        GeneralPath p0 = new GeneralPath();
        p0.moveTo(x03, y03);
        p0.lineTo(x0, y0);
        int maxy1 = 0;
        int maxy2 = 0;
        if (horiz) {
            float minXC = x2[0];
            float maxYC = y2[0];
            for (i2 = 1; i2 < 4; ++i2) {
                if (!(x2[i2] < minXC)) continue;
                minXC = x2[i2];
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (x2[i2] != minXC || !(y2[i2] > maxYC)) continue;
                maxYC = y2[i2];
            }
            if (inverted) {
                p0.lineTo(minXC, maxYC);
                p0.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)maxYC - this.getYOffset()));
            } else {
                p0.lineTo(minXC, maxYC);
                p0.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)maxYC - this.getYOffset()));
            }
        } else {
            for (i2 = 1; i2 < 4; ++i2) {
                if (!(y2[i2] > y2[maxy1])) continue;
                maxy1 = i2;
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (i2 == maxy1 || y2[i2] != y2[maxy1]) continue;
                maxy2 = i2;
                break;
            }
            if (x2[maxy1] < x2[maxy2]) {
                if (inverted) {
                    p0.lineTo(x2[maxy1], y2[maxy1]);
                    p0.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                } else {
                    p0.lineTo(x2[maxy1], y2[maxy1]);
                    p0.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                }
            } else if (inverted) {
                p0.lineTo((float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] + this.getYOffset()));
                p0.lineTo(x2[maxy2], y2[maxy2]);
            } else {
                p0.lineTo(x2[maxy2], y2[maxy2]);
                p0.lineTo((float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()));
            }
        }
        p0.closePath();
        return p0;
    }

    private GeneralPath createAxis3DMinMaxLine(GeneralPath clipA, double value0, double value1, float x0, float y0, float x1, float y1, float previousHeightxx0, float previousHeightxx1, boolean inverted, boolean horiz, CategoryPlot plot, ValueAxis rangeAxis, Rectangle2D dataArea, Rectangle2D adjusted) {
        float[] x2 = new float[4];
        float[] y2 = new float[4];
        int i2 = 0;
        float[] theData = new float[6];
        PathIterator theIterator = this.axis3D0.getPathIterator(null);
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                    break;
                }
                case 1: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                }
            }
            theIterator.next();
            if (++i2 != 4) continue;
        }
        GeneralPath trC = new GeneralPath();
        int maxy1 = 0;
        int maxy2 = 0;
        if (horiz) {
            float minXC = x2[0];
            float minYC = y2[0];
            float maxYC = y2[0];
            for (i2 = 1; i2 < 4; ++i2) {
                if (!(x2[i2] < minXC)) continue;
                minXC = x2[i2];
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (x2[i2] == minXC && y2[i2] < minYC) {
                    minYC = y2[i2];
                }
                if (x2[i2] != minXC || !(y2[i2] > maxYC)) continue;
                maxYC = y2[i2];
            }
            if (value0 < value1) {
                trC.append(new Line2D.Double(x0, y0, minXC, minYC), false);
                trC.append(new Line2D.Double(minXC, minYC, minXC, maxYC), false);
            } else {
                trC.append(new Line2D.Double(x0, y0, minXC, maxYC), false);
                trC.append(new Line2D.Double(minXC, maxYC, minXC, minYC), false);
            }
        } else {
            for (i2 = 1; i2 < 4; ++i2) {
                if (!(y2[i2] > y2[maxy1])) continue;
                maxy1 = i2;
                break;
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (i2 == maxy1 || y2[i2] != y2[maxy1]) continue;
                maxy2 = i2;
                if (!(x2[maxy1] > x2[maxy2])) break;
                maxy2 = maxy1;
                break;
            }
            if (value0 < value1) {
                if (inverted) {
                    if (value1 > this.maxY) {
                        if (value0 < this.minY) {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(clipA));
                            boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                            if (notEmpty) {
                                boolean noIntersection;
                                boolean bl2 = noIntersection = !this.checkPathIntersection(this.minY, false, value0, value1, x0, y0, x1, y1, previousHeightxx0 == -1.0f ? 0.0f : previousHeightxx0, previousHeightxx1, inverted, horiz, plot, rangeAxis, dataArea, adjusted);
                                if (noIntersection) {
                                    trC.append(new Line2D.Double(x2[maxy2], y2[maxy2], this.maxCut, this.minYHeight), false);
                                } else {
                                    trC.append(new Line2D.Double(x2[maxy1], y2[maxy1], this.maxCut, this.minYHeight), false);
                                }
                                trC.append(new Line2D.Double(this.maxCut, this.minYHeight, x0, this.minYHeight), false);
                            }
                        } else {
                            trC.append(new Line2D.Double(x2[maxy1], y2[maxy1], x0, y0), false);
                        }
                    }
                } else {
                    if (value1 > this.maxY) {
                        // empty if block
                    }
                    if (value1 > 0.0 && value0 < 0.0) {
                        trC.append(new Line2D.Double(x0, y0, x2[maxy1], y2[maxy1]), false);
                    } else {
                        trC.append(new Line2D.Double(x0, y0, x2[maxy2], y2[maxy2]), false);
                        trC.append(new Line2D.Double(x2[maxy2], y2[maxy2], x2[maxy1], y2[maxy1]), false);
                    }
                }
            } else if (inverted) {
                if (value0 > this.maxY) {
                    if (value1 < this.minY) {
                        this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                        this.axis3D0.intersect(new Area(clipA));
                        boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                        if (notEmpty) {
                            boolean noIntersection;
                            boolean bl3 = noIntersection = !this.checkPathIntersection(this.minY, false, value0, value1, x0, y0, x1, y1, previousHeightxx0 == -1.0f ? 0.0f : previousHeightxx0, previousHeightxx1, inverted, horiz, plot, rangeAxis, dataArea, adjusted);
                            if (noIntersection) {
                                trC.append(new Line2D.Double(x2[maxy1], y2[maxy2], this.minCut, this.minYHeight), false);
                            } else {
                                trC.append(new Line2D.Double(x2[maxy2], y2[maxy2], this.minCut, this.minYHeight), false);
                            }
                            trC.append(new Line2D.Double(this.minCut, this.minYHeight, x0, this.minYHeight), false);
                        }
                    } else {
                        trC.append(new Line2D.Double(x2[maxy2], y2[maxy2], x0, y0), false);
                    }
                }
            } else {
                if (value0 > this.maxY) {
                    // empty if block
                }
                trC.append(new Line2D.Double(x0, y0, x2[maxy2], y2[maxy2]), false);
                trC.append(new Line2D.Double(x2[maxy2], y2[maxy2], x2[maxy1], y2[maxy1]), false);
            }
        }
        return trC;
    }

    private boolean checkPathIntersection(double pos, boolean cutMax, double value0, double value1, float xx0, float yy0, float xx1, float yy1, float previousHeightxx0, float previousHeightxx1, boolean inverted, boolean horiz, CategoryPlot plot, ValueAxis rangeAxis, Rectangle2D dataArea, Rectangle2D adjusted) {
        if (value0 > 0.0 && value1 > 0.0 || value0 < 0.0 && value1 < 0.0) {
            return false;
        }
        GeneralPath clip = new GeneralPath();
        clip.moveTo(xx0, yy0);
        clip.lineTo(xx1, yy1);
        clip.lineTo(xx1, previousHeightxx1);
        clip.lineTo(xx0, previousHeightxx0);
        clip.closePath();
        if (this.clipPath != null) {
            clip = this.clipPath;
        }
        this.createAxis3DY0Area(pos, plot, rangeAxis, dataArea, adjusted);
        this.axis3D0.intersect(new Area(clip));
        boolean notEmpty = this.setminCutmaxCut(horiz, cutMax, inverted);
        if (notEmpty) {
            double yPos;
            double xPos = yPos = rangeAxis.valueToJava2D(pos, adjusted, plot.getRangeAxisEdge());
            if (horiz) {
                if (cutMax) {
                    if (value0 > 0.0 && value1 < 0.0) {
                        double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.minCut);
                        if (minCutD1 == 0.0) {
                            return false;
                        }
                        double minCutD2 = Line2D.ptLineDist(xx0, yy0, previousHeightxx1, yy0, xPos, this.maxCut);
                        if (minCutD2 == 0.0) {
                            return false;
                        }
                        double minCutD3 = Line2D.ptLineDist(previousHeightxx1, yy0, previousHeightxx0, yy1, xPos, this.maxCut);
                        if (minCutD3 == 0.0) {
                            return false;
                        }
                        double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.minCut);
                        if (minCutD4 == 0.0) {
                            return true;
                        }
                        double minCutD5 = Line2D.ptLineDist(previousHeightxx1, yy0, previousHeightxx0, yy1, xPos, this.maxCut);
                        if (minCutD5 == 0.0) {
                            return true;
                        }
                        double minCutD6 = Line2D.ptLineDist(xx1, yy1, previousHeightxx0, yy1, xPos, this.minCut);
                        if (minCutD6 == 0.0) {
                            return true;
                        }
                        if (Math.min(minCutD1, minCutD4) == minCutD1) {
                            return false;
                        }
                        if (Math.min(minCutD1, minCutD4) == minCutD4) {
                            return true;
                        }
                        return true;
                    }
                    double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.maxCut);
                    if (minCutD1 == 0.0) {
                        return false;
                    }
                    double minCutD2 = Line2D.ptLineDist(xx0, yy0, previousHeightxx0, yy0, xPos, this.minCut);
                    if (minCutD2 == 0.0) {
                        return false;
                    }
                    double minCutD3 = Line2D.ptLineDist(previousHeightxx0, yy0, previousHeightxx1, yy1, xPos, this.minCut);
                    if (minCutD3 == 0.0) {
                        return false;
                    }
                    double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.minCut);
                    if (minCutD4 == 0.0) {
                        return true;
                    }
                    double minCutD5 = Line2D.ptLineDist(previousHeightxx1, yy1, previousHeightxx0, yy0, xPos, this.maxCut);
                    if (minCutD5 == 0.0) {
                        return true;
                    }
                    double minCutD6 = Line2D.ptLineDist(xx1, yy1, previousHeightxx1, yy1, xPos, this.maxCut);
                    if (minCutD6 == 0.0) {
                        return true;
                    }
                    if (Math.min(minCutD1, minCutD4) == minCutD1) {
                        return false;
                    }
                    if (Math.min(minCutD1, minCutD4) == minCutD4) {
                        return true;
                    }
                    return true;
                }
                if (value0 > 0.0 && value1 < 0.0) {
                    double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.minCut);
                    if (minCutD1 == 0.0) {
                        return true;
                    }
                    double minCutD2 = Line2D.ptLineDist(xx1, yy1, previousHeightxx1, yy1, xPos, this.maxCut);
                    if (minCutD2 == 0.0) {
                        return true;
                    }
                    double minCutD3 = Line2D.ptLineDist(previousHeightxx1, yy1, previousHeightxx0, yy0, xPos, this.maxCut);
                    if (minCutD3 == 0.0) {
                        return true;
                    }
                    double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.maxCut);
                    if (minCutD4 == 0.0) {
                        return false;
                    }
                    double minCutD5 = Line2D.ptLineDist(previousHeightxx1, yy1, previousHeightxx0, yy0, xPos, this.minCut);
                    if (minCutD5 == 0.0) {
                        return false;
                    }
                    double minCutD6 = Line2D.ptLineDist(xx0, yy0, previousHeightxx0, yy0, xPos, this.minCut);
                    if (minCutD6 == 0.0) {
                        return false;
                    }
                    if (Math.min(minCutD1, minCutD4) == minCutD1) {
                        return true;
                    }
                    return Math.min(minCutD1, minCutD4) != minCutD4;
                }
                double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.minCut);
                if (minCutD1 == 0.0) {
                    return false;
                }
                double minCutD2 = Line2D.ptLineDist(xx0, yy0, previousHeightxx1, yy0, xPos, this.maxCut);
                if (minCutD2 == 0.0) {
                    return false;
                }
                double minCutD3 = Line2D.ptLineDist(previousHeightxx1, yy0, previousHeightxx0, yy1, xPos, this.maxCut);
                if (minCutD3 == 0.0) {
                    return false;
                }
                double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, xPos, this.maxCut);
                if (minCutD4 == 0.0) {
                    return true;
                }
                double minCutD5 = Line2D.ptLineDist(previousHeightxx1, yy0, previousHeightxx0, yy1, xPos, this.minCut);
                if (minCutD5 == 0.0) {
                    return true;
                }
                double minCutD6 = Line2D.ptLineDist(xx1, yy1, previousHeightxx0, yy1, xPos, this.minCut);
                if (minCutD6 == 0.0) {
                    return true;
                }
                if (Math.min(minCutD1, minCutD4) == minCutD1) {
                    return false;
                }
                if (Math.min(minCutD1, minCutD4) == minCutD4) {
                    return true;
                }
                return true;
            }
            if (cutMax) {
                if (value0 > 0.0 && value1 < 0.0) {
                    double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.maxCut, yPos);
                    if (minCutD1 == 0.0) {
                        return true;
                    }
                    double minCutD2 = Line2D.ptLineDist(xx1, yy1, xx1, previousHeightxx0, this.minCut, yPos);
                    if (minCutD2 == 0.0) {
                        return true;
                    }
                    double minCutD3 = Line2D.ptLineDist(xx0, previousHeightxx1, xx1, previousHeightxx0, this.minCut, yPos);
                    if (minCutD3 == 0.0) {
                        return true;
                    }
                    double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.minCut, yPos);
                    if (minCutD4 == 0.0) {
                        return false;
                    }
                    double minCutD5 = Line2D.ptLineDist(xx0, previousHeightxx1, xx1, previousHeightxx0, this.maxCut, yPos);
                    if (minCutD5 == 0.0) {
                        return false;
                    }
                    double minCutD6 = Line2D.ptLineDist(xx0, yy0, xx0, previousHeightxx1, this.maxCut, yPos);
                    if (minCutD6 == 0.0) {
                        return false;
                    }
                    if (Math.min(minCutD1, minCutD4) == minCutD1) {
                        return true;
                    }
                    return Math.min(minCutD1, minCutD4) != minCutD4;
                }
                double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.maxCut, yPos);
                if (inverted) {
                    minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.minCut, yPos);
                }
                if (minCutD1 == 0.0) {
                    return false;
                }
                double minCutD2 = Line2D.ptLineDist(xx0, yy0, xx0, previousHeightxx0, this.minCut, yPos);
                if (minCutD2 == 0.0) {
                    return false;
                }
                double minCutD3 = Line2D.ptLineDist(xx0, previousHeightxx0, xx1, previousHeightxx1, this.minCut, yPos);
                if (minCutD3 == 0.0) {
                    return false;
                }
                double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.minCut, yPos);
                if (inverted) {
                    minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.maxCut, yPos);
                }
                if (minCutD4 == 0.0) {
                    return true;
                }
                double minCutD5 = Line2D.ptLineDist(xx0, previousHeightxx0, xx1, previousHeightxx1, this.maxCut, yPos);
                if (minCutD5 == 0.0) {
                    return true;
                }
                double minCutD6 = Line2D.ptLineDist(xx1, yy1, xx1, previousHeightxx1, this.maxCut, yPos);
                if (minCutD6 == 0.0) {
                    return true;
                }
                if (Math.min(minCutD1, minCutD4) == minCutD1) {
                    return false;
                }
                if (Math.min(minCutD1, minCutD4) == minCutD4) {
                    return true;
                }
                return true;
            }
            if (value0 > 0.0 && value1 < 0.0) {
                double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.minCut, yPos);
                if (minCutD1 == 0.0) {
                    return true;
                }
                double minCutD2 = Line2D.ptLineDist(xx1, yy1, xx1, previousHeightxx0, this.maxCut, yPos);
                if (minCutD2 == 0.0) {
                    return true;
                }
                double minCutD3 = Line2D.ptLineDist(xx0, previousHeightxx1, xx1, previousHeightxx0, this.maxCut, yPos);
                if (minCutD3 == 0.0) {
                    return true;
                }
                double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.maxCut, yPos);
                if (minCutD4 == 0.0) {
                    return false;
                }
                double minCutD5 = Line2D.ptLineDist(xx0, previousHeightxx1, xx1, previousHeightxx0, this.minCut, yPos);
                if (minCutD5 == 0.0) {
                    return false;
                }
                double minCutD6 = Line2D.ptLineDist(xx0, yy0, xx0, previousHeightxx1, this.minCut, yPos);
                if (minCutD6 == 0.0) {
                    return false;
                }
                if (Math.min(minCutD1, minCutD4) == minCutD1) {
                    return true;
                }
                return Math.min(minCutD1, minCutD4) != minCutD4;
            }
            double minCutD1 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.minCut, yPos);
            if (minCutD1 == 0.0) {
                return false;
            }
            double minCutD2 = Line2D.ptLineDist(xx1, yy1, xx1, previousHeightxx1, this.maxCut, yPos);
            if (minCutD2 == 0.0) {
                return false;
            }
            double minCutD3 = Line2D.ptLineDist(xx0, previousHeightxx0, xx1, previousHeightxx1, this.maxCut, yPos);
            if (minCutD3 == 0.0) {
                return false;
            }
            double minCutD4 = Line2D.ptLineDist(xx0, yy0, xx1, yy1, this.maxCut, yPos);
            if (minCutD4 == 0.0) {
                return true;
            }
            double minCutD5 = Line2D.ptLineDist(xx0, previousHeightxx0, xx1, previousHeightxx1, this.minCut, yPos);
            if (minCutD5 == 0.0) {
                return true;
            }
            double minCutD6 = Line2D.ptLineDist(xx0, yy0, xx0, previousHeightxx0, this.minCut, yPos);
            if (minCutD6 == 0.0) {
                return true;
            }
            if (Math.min(minCutD1, minCutD4) == minCutD1) {
                return false;
            }
            if (Math.min(minCutD1, minCutD4) == minCutD4) {
                return true;
            }
            return true;
        }
        return true;
    }

    private GeneralPath createAxis3DMinMaxEnd(double value0, double value1, float x0, float y0, float y1, boolean inverted, boolean horiz) {
        float[] x2 = new float[4];
        float[] y2 = new float[4];
        int i2 = 0;
        float[] theData = new float[6];
        PathIterator theIterator = this.axis3D0.getPathIterator(null);
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                    break;
                }
                case 1: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                }
            }
            theIterator.next();
            if (++i2 != 4) continue;
        }
        GeneralPath p0 = new GeneralPath();
        int maxy1 = 0;
        if (!horiz) {
            for (i2 = 1; i2 < 4; ++i2) {
                if (value0 < value1 && y2[i2] > y2[maxy1]) {
                    maxy1 = i2;
                    break;
                }
                if (!(value0 > value1) || !(y2[i2] < y2[maxy1])) continue;
                maxy1 = i2;
                break;
            }
            if (value0 < value1) {
                p0.moveTo(x0, y0);
                p0.moveTo((float)((double)x0 + this.getXOffset()), (float)((double)y0 - this.getYOffset()));
                p0.moveTo((float)((double)x0 + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                p0.lineTo(x0, y2[maxy1]);
                p0.closePath();
            } else {
                p0.moveTo(x0, y1);
                p0.moveTo((float)((double)x0 + this.getXOffset()), (float)((double)y1 - this.getYOffset()));
                p0.moveTo((float)((double)x0 + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                p0.lineTo(x0, y2[maxy1]);
                p0.closePath();
            }
        }
        return p0;
    }

    private GeneralPath createAxis3DMinMaxCut(boolean cutMax, double value0, double value1, float x0, float y0, float x03, float y03, float x13, boolean inverted, boolean horiz, CategoryPlot plot, ValueAxis rangeAxis, Rectangle2D dataArea, Rectangle2D adjusted) {
        float[] x2 = new float[4];
        float[] y2 = new float[4];
        int i2 = 0;
        float[] theData = new float[6];
        PathIterator theIterator = this.axis3D0.getPathIterator(null);
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                    break;
                }
                case 1: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                }
            }
            theIterator.next();
            if (++i2 != 4) continue;
        }
        GeneralPath p0 = new GeneralPath();
        int maxy1 = 0;
        int maxy2 = 0;
        if (horiz) {
            float minXC = x2[0];
            float maxXC = x2[0];
            float minYC = y2[0];
            float maxYC = y2[0];
            for (i2 = 1; i2 < 4; ++i2) {
                if (x2[i2] < minXC) {
                    minXC = x2[i2];
                }
                if (!(x2[i2] > maxXC)) continue;
                maxXC = x2[i2];
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (x2[i2] == minXC && y2[i2] < minYC) {
                    minYC = y2[i2];
                }
                if (x2[i2] != minXC || !(y2[i2] > maxYC)) continue;
                maxYC = y2[i2];
            }
            if (cutMax) {
                if (value0 < value1) {
                    p0.moveTo(x0, y0);
                    p0.lineTo(x03, y03);
                    p0.lineTo((float)((double)minXC + this.getXOffset()), minYC);
                    p0.lineTo(minXC, maxYC);
                    p0.closePath();
                    if (!inverted) {
                        if (value1 > 0.0 && value0 < 0.0 && value0 < this.minY) {
                            if (this.minY > 0.0) {
                                this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            } else {
                                this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            }
                            this.axis3D0.intersect(new Area(p0));
                            p0 = this.createAxis3DY0SideCut(minXC, maxYC, (float)((double)minXC + this.getXOffset()), minYC, rangeAxis.isInverted(), true);
                        }
                        GeneralPath ps = new GeneralPath();
                        if (this.maxY < 0.0 && this.minY < 0.0) {
                            p0 = new GeneralPath();
                            this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            boolean notEmpty = this.setminCutmaxCut(horiz, true, inverted);
                            if (notEmpty) {
                                GeneralPath psd = new GeneralPath();
                                psd.moveTo(minXC, this.maxCut);
                                psd.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)this.maxCut - this.getYOffset()));
                                psd.lineTo((float)((double)minXC + this.getXOffset()), this.maxCut + 3.0f);
                                psd.closePath();
                                this.cleanupArea.append(psd, false);
                                ps.moveTo(minXC, this.maxCut);
                                ps.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)this.maxCut - this.getYOffset()));
                                ps.lineTo((float)((double)minXC + this.getXOffset()), y03);
                                ps.lineTo(minXC, (float)((double)y03 + this.getYOffset()));
                            }
                        } else {
                            GeneralPath psd = new GeneralPath();
                            psd.moveTo(minXC, (float)((double)x13 + this.getYOffset()));
                            psd.lineTo((float)((double)minXC + this.getXOffset()), x13);
                            psd.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)x13 + this.getYOffset()));
                            psd.closePath();
                            this.cleanupArea.append(psd, false);
                            ps.moveTo(minXC, maxYC);
                            ps.lineTo((float)((double)minXC + this.getXOffset()), minYC);
                            ps.lineTo((float)((double)minXC + this.getXOffset()), x13);
                            ps.lineTo(minXC, (float)((double)x13 + this.getYOffset()));
                        }
                        ps.closePath();
                        this.cutArea.append(ps, false);
                    }
                    if (inverted && value1 > 0.0 && value0 < 0.0 && value0 < this.minY) {
                        this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                        this.axis3D0.intersect(new Area(this.clipPath));
                        boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                        if (notEmpty) {
                            if (this.minY > 0.0) {
                                this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            } else {
                                this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            }
                            this.axis3D0.intersect(new Area(p0));
                            GeneralPath gp2 = this.createAxis3DY0SideCut(minXC, maxYC, (float)((double)minXC + this.getXOffset()), minYC, rangeAxis.isInverted(), true);
                            GeneralPath ps = new GeneralPath();
                            ps.moveTo((float)this.minYHeight, y0);
                            ps.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)y0 - this.getYOffset()));
                            ps.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)this.maxCut - this.getYOffset()));
                            ps.lineTo((float)this.minYHeight, this.maxCut);
                            ps.closePath();
                            p0 = gp2;
                            p0.append(ps, false);
                        }
                    }
                } else {
                    p0.moveTo(x0, y0);
                    p0.lineTo(x03, y03);
                    p0.lineTo(minXC, minYC);
                    p0.lineTo(minXC, maxYC);
                    p0.closePath();
                    if (!inverted && value0 > 0.0 && value1 < 0.0 && value1 < this.minY) {
                        this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                        this.axis3D0.intersect(new Area(this.currentPath));
                        boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                        if (notEmpty) {
                            p0 = new GeneralPath();
                            p0.moveTo((float)this.minYHeight, this.maxCut);
                            p0.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)this.maxCut - this.getYOffset()));
                            p0.lineTo(minXC, minYC);
                            p0.lineTo(minXC, maxYC);
                            p0.closePath();
                        }
                    }
                    if (!inverted) {
                        GeneralPath ps = new GeneralPath();
                        if (this.maxY < 0.0 && this.minY < 0.0) {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.currentPath));
                            boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                            GeneralPath p0C = new GeneralPath();
                            if (notEmpty) {
                                p0C.moveTo((float)this.minYHeight, this.maxCut);
                                p0C.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)this.maxCut - this.getYOffset()));
                            }
                            this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            notEmpty = this.setminCutmaxCut(horiz, true, inverted);
                            if (notEmpty) {
                                p0C.lineTo(maxXC, (float)((double)this.minCut - this.getYOffset()));
                                p0C.lineTo(minXC, this.minCut);
                                p0C.closePath();
                                p0 = p0C;
                                GeneralPath psd = new GeneralPath();
                                psd.moveTo(minXC, (float)((double)y03 + this.getYOffset()));
                                psd.lineTo((float)((double)minXC + this.getXOffset()), y03);
                                psd.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)y03 + this.getYOffset()));
                                psd.closePath();
                                this.cleanupArea.append(psd, false);
                                ps.moveTo(minXC, this.minCut);
                                ps.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)this.minCut - this.getYOffset()));
                                ps.lineTo((float)((double)minXC + this.getXOffset()), y03);
                                ps.lineTo(minXC, (float)((double)y03 + this.getYOffset()));
                            }
                        } else {
                            GeneralPath psd = new GeneralPath();
                            psd.moveTo(minXC, maxYC);
                            psd.lineTo((float)((double)minXC + this.getXOffset()), maxYC + 3.0f);
                            psd.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)maxYC - this.getYOffset()));
                            psd.closePath();
                            this.cleanupArea.append(psd, false);
                            ps.moveTo(minXC, maxYC);
                            ps.lineTo(minXC, (float)((double)x13 + this.getYOffset()));
                            ps.lineTo((float)((double)minXC + this.getXOffset()), x13);
                            ps.lineTo((float)((double)minXC + this.getXOffset()), (float)((double)maxYC - this.getYOffset()));
                        }
                        ps.closePath();
                        this.cutArea.append(ps, false);
                    }
                    if (inverted && value0 > 0.0 && value1 < 0.0 && value1 < this.minY) {
                        this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                        this.axis3D0.intersect(new Area(this.clipPath));
                        boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                        if (notEmpty) {
                            p0 = new GeneralPath();
                            p0.moveTo((float)this.minYHeight, this.minCut);
                            p0.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)this.minCut - this.getYOffset()));
                            p0.lineTo(maxXC, (float)((double)maxYC - this.getYOffset()));
                            p0.lineTo(minXC, maxYC);
                            p0.closePath();
                            GeneralPath ps = new GeneralPath();
                            ps.moveTo((float)this.minYHeight, y0);
                            ps.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)y0 - this.getYOffset()));
                            ps.lineTo((float)(this.minYHeight + this.getXOffset()), (float)((double)this.minCut - this.getYOffset()));
                            ps.lineTo((float)this.minYHeight, this.minCut);
                            ps.closePath();
                            p0.append(ps, false);
                        }
                    }
                }
            }
        } else {
            for (i2 = 1; i2 < 4; ++i2) {
                if (value0 < value1 && y2[i2] > y2[maxy1]) {
                    maxy1 = i2;
                    break;
                }
                if (value0 > value1 && !cutMax) {
                    if (!(y2[i2] > y2[maxy1])) continue;
                    maxy1 = i2;
                    break;
                }
                if (value0 > value1 && y2[i2] < y2[maxy1]) {
                    maxy1 = i2;
                    break;
                }
                if (!(value0 > value1) || !inverted || !(y2[i2] > y2[maxy1])) continue;
                maxy1 = i2;
                break;
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (i2 == maxy1 || y2[i2] != y2[maxy1]) continue;
                maxy2 = i2;
                if (!(x2[maxy1] > x2[maxy2])) break;
                maxy2 = maxy1;
                maxy1 = i2;
                break;
            }
            if (cutMax) {
                if (value0 < value1) {
                    p0.moveTo(x03, y03);
                    p0.lineTo(x0, y0);
                    p0.lineTo(x2[maxy1], y2[maxy1]);
                    p0.lineTo(x2[maxy2], y2[maxy1]);
                    p0.closePath();
                    if (inverted) {
                        p0 = new GeneralPath();
                        p0.moveTo(x03, y03);
                        p0.lineTo(x0, y0);
                        p0.lineTo(x2[maxy1], y2[maxy1]);
                        p0.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                        p0.closePath();
                    }
                    if (value0 < 0.0 && value0 <= this.minY) {
                        this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                        this.axis3D0.intersect(new Area(this.clipPath));
                        boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                        if (notEmpty) {
                            p0 = new GeneralPath();
                            p0.moveTo(this.maxCut, (float)this.minYHeight);
                            p0.lineTo((float)((double)this.maxCut + this.getXOffset()), (float)(this.minYHeight - this.getYOffset()));
                            if (inverted) {
                                p0.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                                p0.lineTo(x2[maxy1], y2[maxy1]);
                            } else {
                                p0.lineTo(x2[maxy2], y2[maxy1]);
                                p0.lineTo(x2[maxy1], y2[maxy1]);
                            }
                            p0.closePath();
                        }
                        if (this.minY > 0.0 && this.maxY > 0.0 && inverted) {
                            return new GeneralPath();
                        }
                        GeneralPath ps = new GeneralPath();
                        if (inverted) {
                            ps.moveTo(this.maxCut, (float)this.minYHeight);
                            ps.lineTo((float)((double)this.maxCut + this.getXOffset()), (float)(this.minYHeight - this.getYOffset()));
                            ps.lineTo((float)((double)x0 + this.getXOffset()), (float)(this.minYHeight - this.getYOffset()));
                            ps.lineTo(x0, (float)this.minYHeight);
                        } else {
                            if (this.maxY > 0.0 && this.minY <= 0.0) {
                                ps.moveTo(x2[maxy1], y2[maxy1]);
                                ps.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                                ps.lineTo(x13, (float)((double)y2[maxy1] - this.getYOffset()));
                                ps.lineTo((float)((double)x13 - this.getXOffset()), y2[maxy1]);
                            }
                            if (this.maxY > 0.0 && this.minY > 0.0) {
                                ps.moveTo(x2[maxy1], y2[maxy1]);
                                ps.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                                ps.lineTo(x13, (float)((double)y2[maxy1] - this.getYOffset()));
                                ps.lineTo((float)((double)x13 - this.getXOffset()), y2[maxy1]);
                            }
                            if (this.maxY <= 0.0 && this.minY < 0.0) {
                                float saveCut = this.maxCut;
                                this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                                this.axis3D0.intersect(new Area(this.clipPath));
                                notEmpty = this.setminCutmaxCut(horiz, true, inverted);
                                if (notEmpty) {
                                    p0 = new GeneralPath();
                                    p0.moveTo(saveCut, (float)this.minYHeight);
                                    p0.lineTo((float)((double)saveCut + this.getXOffset()), (float)(this.minYHeight - this.getYOffset()));
                                    p0.lineTo((float)((double)this.maxCut + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                                    p0.lineTo(this.maxCut, y2[maxy1]);
                                    p0.closePath();
                                    ps.moveTo(x03, (float)((double)y2[maxy1] - this.getYOffset()));
                                    ps.lineTo(x0, y2[maxy1]);
                                    ps.lineTo(this.maxCut, y2[maxy1]);
                                    ps.lineTo((float)((double)this.maxCut + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                                }
                            }
                        }
                        if (ps.getCurrentPoint() != null) {
                            ps.closePath();
                        }
                        this.cutArea.append(ps, false);
                        if (this.maxY > 0.0) {
                            ps = new GeneralPath();
                            ps.moveTo(x2[maxy1], y2[maxy1]);
                            ps.lineTo(x2[maxy1] - 3.0f, (float)((double)y2[maxy1] - this.getYOffset()));
                            ps.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                            ps.closePath();
                            this.cleanupArea.append(ps, false);
                        } else {
                            ps = new GeneralPath();
                            ps.moveTo(x03, (float)((double)y2[maxy1] - this.getYOffset()));
                            ps.lineTo(x03, y2[maxy1]);
                            ps.lineTo(x0, y2[maxy1]);
                            ps.closePath();
                            this.cleanupArea.append(ps, false);
                        }
                        this.sideArea.append(p0, false);
                        return p0;
                    }
                    if (!inverted) {
                        GeneralPath ps = new GeneralPath();
                        ps.moveTo(x2[maxy1], y2[maxy2]);
                        ps.lineTo((float)((double)x13 - this.getXOffset()), y2[maxy2]);
                        ps.lineTo(x13, (float)((double)y2[maxy2] - this.getYOffset()));
                        ps.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()));
                        ps.closePath();
                        this.cutArea.append(ps, false);
                        GeneralPath psC = new GeneralPath();
                        psC.moveTo(x2[maxy1], (float)this.maxYHeight);
                        psC.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)(this.maxYHeight - this.getYOffset()));
                        psC.lineTo(x2[maxy1], (float)(this.maxYHeight - this.getYOffset()));
                        psC.closePath();
                        this.cleanupArea.append(psC, false);
                    }
                } else {
                    p0.moveTo(x0, y0);
                    p0.lineTo(x03, y03);
                    p0.lineTo((float)((double)x2[maxy2] + this.getXOffset()), y2[maxy2]);
                    p0.lineTo(x2[maxy2], (float)((double)y2[maxy2] + this.getYOffset()));
                    p0.closePath();
                    if (this.rangeAxisIsInverted) {
                        p0 = new GeneralPath();
                        p0.moveTo(x0, y0);
                        p0.lineTo(x03, y03);
                        p0.lineTo((float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()));
                        p0.lineTo(x2[maxy2], y2[maxy2]);
                        p0.closePath();
                    }
                    if (this.rangeAxisIsInverted && value0 > 0.0 && value1 < 0.0) {
                        if (this.minY > 0.0) {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                        } else {
                            this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                        }
                        this.axis3D0.intersect(new Area(this.clipPath));
                        GeneralPath gp3 = this.createAxis3DY0SideCut(x2[maxy2], y2[maxy2], (float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()), rangeAxis.isInverted(), false);
                        if (this.minY > 0.0 && this.maxY > 0.0) {
                            gp3 = this.createAxis3DY0SideCut(x2[maxy2], y2[maxy2], (float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()), rangeAxis.isInverted(), false);
                            this.sideArea.append(gp3, false);
                            return gp3;
                        }
                        if (this.maxY < 0.0) {
                            gp3 = new GeneralPath();
                        }
                        if (value1 > this.minY) {
                            p0 = gp3;
                        } else {
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                            if (notEmpty) {
                                GeneralPath ps = new GeneralPath();
                                ps.moveTo(x0, (float)this.minYHeight);
                                ps.lineTo(x03, (float)(this.minYHeight - this.getYOffset()));
                                ps.lineTo((float)((double)this.minCut + this.getXOffset()), (float)(this.minYHeight - this.getYOffset()));
                                ps.lineTo(this.minCut, (float)this.minYHeight);
                                ps.closePath();
                                p0 = gp3;
                                this.cutArea.append(ps, false);
                                ps = new GeneralPath();
                                ps.moveTo(x0, (float)this.minYHeight);
                                ps.lineTo(x03, (float)(this.minYHeight - this.getYOffset()));
                                ps.lineTo(x03, (float)this.minYHeight);
                                ps.closePath();
                                this.cleanupArea.append(ps, false);
                            }
                        }
                        this.sideArea.append(p0, false);
                        return p0;
                    }
                    if (this.rangeAxisIsInverted && value0 > value1) {
                        this.sideArea.append(p0, false);
                        return p0;
                    }
                    GeneralPath ps = new GeneralPath();
                    if (this.maxY > 0.0 && this.minY < 0.0) {
                        ps.moveTo(x2[maxy2], y2[maxy2]);
                        ps.lineTo(x13, y2[maxy2]);
                        ps.lineTo((float)((double)x13 - this.getXOffset()), (float)((double)y2[maxy2] + this.getYOffset()));
                        ps.lineTo((float)((double)x2[maxy2] - this.getXOffset()), (float)((double)y2[maxy2] + this.getYOffset()));
                    }
                    if (!inverted) {
                        if (this.maxY > 0.0 && this.minY <= 0.0) {
                            GeneralPath pscl = new GeneralPath();
                            pscl.moveTo(x13, y2[maxy2]);
                            pscl.lineTo((float)((double)x13 - this.getXOffset()), (float)((double)y2[maxy2] + this.getYOffset()));
                            pscl.lineTo((float)((double)x13 - this.getXOffset() - 3.0), y2[maxy2]);
                            pscl.closePath();
                            this.cleanupArea.append(pscl, false);
                            ps = new GeneralPath();
                            ps.moveTo(x13, y2[maxy2]);
                            ps.lineTo((float)((double)x13 - this.getXOffset()), (float)((double)y2[maxy2] + this.getYOffset()));
                            ps.lineTo(x2[maxy2], (float)((double)y2[maxy2] + this.getYOffset()));
                            ps.lineTo((float)((double)x2[maxy2] + this.getXOffset()), y2[maxy2]);
                        }
                        if (this.maxY < 0.0 && this.minY < 0.0) {
                            p0 = new GeneralPath();
                            ps = new GeneralPath();
                            this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            boolean notEmpty = this.setminCutmaxCut(horiz, true, inverted);
                            if (notEmpty) {
                                ps.moveTo(this.minCut, (float)((double)y2[maxy2] + this.getYOffset()));
                                ps.lineTo(x0, (float)((double)y2[maxy2] + this.getYOffset()));
                                ps.lineTo((float)((double)x0 + this.getXOffset()), y2[maxy2]);
                                ps.lineTo((float)((double)this.minCut + this.getXOffset()), y2[maxy2]);
                                GeneralPath pscl = new GeneralPath();
                                pscl.moveTo(this.minCut, (float)((double)y2[maxy2] + this.getYOffset()));
                                pscl.lineTo((float)((double)this.minCut + this.getXOffset()), y2[maxy2]);
                                pscl.lineTo(this.minCut - 3.0f, y2[maxy2]);
                                pscl.closePath();
                                this.cleanupArea.append(pscl, false);
                            }
                        }
                        if (this.maxY > 0.0 && this.minY > 0.0) {
                            this.createAxis3DY0Area(this.maxY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            boolean notEmpty = this.setminCutmaxCut(horiz, true, inverted);
                            float saveCut = this.maxCut;
                            this.createAxis3DY0Area(this.minY, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                            if (notEmpty && value1 < this.minY) {
                                p0 = new GeneralPath();
                                p0.moveTo(this.minCut, (float)this.minYHeight);
                                p0.lineTo((float)((double)this.minCut + this.getXOffset()), (float)(this.minYHeight - this.getYOffset()));
                                p0.lineTo((float)((double)saveCut + this.getXOffset()), y2[maxy2]);
                                p0.lineTo(saveCut, (float)((double)y2[maxy2] + this.getYOffset()));
                                p0.closePath();
                            }
                            ps.moveTo((float)((double)saveCut + this.getXOffset()), y2[maxy2]);
                            ps.lineTo(x13, y2[maxy2]);
                            ps.lineTo((float)((double)x13 - this.getXOffset()), (float)((double)y2[maxy2] + this.getYOffset()));
                            ps.lineTo(saveCut, (float)((double)y2[maxy2] + this.getYOffset()));
                            GeneralPath pscl = new GeneralPath();
                            pscl.moveTo(x13, y2[maxy2]);
                            pscl.lineTo((float)((double)x13 - this.getXOffset() - 1.0), y2[maxy2]);
                            pscl.lineTo((float)((double)x13 - this.getXOffset() - 1.0), (float)((double)y2[maxy2] + this.getYOffset()));
                            pscl.closePath();
                            this.cleanupArea.append(pscl, false);
                        }
                        if (value0 > 0.0 && value1 < 0.0 && this.maxY > 0.0 && this.minY <= 0.0) {
                            this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                            this.axis3D0.intersect(new Area(this.clipPath));
                            boolean notEmpty = this.setminCutmaxCut(horiz, false, inverted);
                            if (notEmpty) {
                                p0 = this.createAxis3DY0SideCut(x2[maxy2], y2[maxy2], (float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()), rangeAxis.isInverted(), false);
                            }
                        }
                    }
                    if (ps.getCurrentPoint() != null) {
                        ps.closePath();
                    }
                    this.cutArea.append(ps, false);
                }
            } else if (value0 < value1) {
                p0.moveTo(x03, y03);
                p0.lineTo(x0, y0);
                p0.lineTo(x2[maxy2], y2[maxy2]);
                p0.lineTo((float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()));
                p0.closePath();
                if (!this.rangeAxisIsInverted && value0 < 0.0 && value1 > 0.0) {
                    p0 = new GeneralPath();
                    p0.moveTo(x03, y03);
                    p0.lineTo(x0, y0);
                    p0.lineTo(x2[maxy1], y2[maxy1]);
                    p0.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                    p0.closePath();
                }
                if (this.rangeAxisIsInverted && value0 < 0.0 && value1 > 0.0) {
                    this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                    this.axis3D0.intersect(new Area(this.currentPath));
                    p0 = this.createAxis3DY0SideCut(x2[maxy2], y2[maxy2], (float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()), rangeAxis.isInverted(), false);
                    GeneralPath ps = new GeneralPath();
                    ps.moveTo(x2[maxy2], y2[maxy1]);
                    ps.lineTo((float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy1] - this.getYOffset()));
                    ps.lineTo(x13, (float)((double)y2[maxy1] - this.getYOffset()));
                    ps.lineTo((float)((double)x13 - this.getXOffset()), y2[maxy1]);
                    ps.closePath();
                    p0.append(ps, false);
                }
            } else if (this.rangeAxisIsInverted && value0 > 0.0 && value1 < 0.0) {
                this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                this.axis3D0.intersect(new Area(this.currentPath));
                p0 = this.createAxis3DY0SideCut(x0, y0, x03, y03, true, false);
                GeneralPath ps = new GeneralPath();
                ps.moveTo(x2[maxy1], y2[maxy1]);
                ps.lineTo((float)((double)x2[maxy1] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()));
                ps.lineTo(x13, (float)((double)y2[maxy2] - this.getYOffset()));
                ps.lineTo((float)((double)x13 - this.getXOffset()), y2[maxy1]);
                ps.closePath();
                p0.append(ps, false);
            } else {
                p0.moveTo(x0, y0);
                p0.lineTo(x03, y03);
                p0.lineTo((float)((double)x2[maxy2] + this.getXOffset()), y2[maxy2]);
                p0.lineTo(x2[maxy2], (float)((double)y2[maxy2] + this.getYOffset()));
                p0.closePath();
                if (value0 > 0.0 && value1 < 0.0 && this.minY < 0.0) {
                    this.createAxis3DY0Area(0.0, plot, rangeAxis, dataArea, adjusted);
                    this.axis3D0.intersect(new Area(this.currentPath));
                    p0 = this.createAxis3DY0SideCut(x0, y0, x03, y03, this.rangeAxisIsInverted, false);
                } else {
                    p0 = new GeneralPath();
                    p0.moveTo(x0, y0);
                    p0.lineTo(x03, y03);
                    p0.lineTo((float)((double)x2[maxy2] + this.getXOffset()), (float)((double)y2[maxy2] - this.getYOffset()));
                    p0.lineTo(x2[maxy2], y2[maxy2]);
                    p0.closePath();
                    GeneralPath ps = new GeneralPath();
                    ps.moveTo(x0, y0);
                    ps.lineTo(x03, y03);
                    ps.lineTo(x2[maxy2], y2[maxy2]);
                    ps.lineTo((float)((double)x2[maxy2] - this.getXOffset()), (float)((double)y2[maxy2] + this.getYOffset()));
                    ps.closePath();
                }
            }
        }
        this.sideArea.append(p0, false);
        return p0;
    }

    private void createAxis3DY0Area(double pos, CategoryPlot plot, ValueAxis axis, Rectangle2D dataArea, Rectangle2D adjusted) {
        Polygon p2 = new Polygon();
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            float x2 = (float)axis.valueToJava2D(pos, adjusted, plot.getRangeAxisEdge());
            float y2 = (float)adjusted.getMaxY();
            p2.addPoint((int)x2, (int)y2);
            p2.addPoint((int)((double)x2 + this.getXOffset()), (int)((double)y2 - this.getYOffset()));
            p2.addPoint((int)((double)x2 + this.getXOffset()), (int)(adjusted.getMinY() - this.getYOffset()));
            p2.addPoint((int)x2, (int)adjusted.getMinY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            float y3 = (float)axis.valueToJava2D(pos, adjusted, plot.getRangeAxisEdge());
            float x3 = (float)dataArea.getX();
            p2.addPoint((int)x3, (int)y3);
            p2.addPoint((int)((double)x3 + this.getXOffset()), (int)((double)y3 - this.getYOffset()));
            p2.addPoint((int)(adjusted.getMaxX() + this.getXOffset()), (int)((double)y3 - this.getYOffset()));
            p2.addPoint((int)adjusted.getMaxX(), (int)y3);
        }
        this.axis3D0 = new Area(p2);
    }

    private void createAxis3DY0LeftArea(double pos, CategoryPlot plot, ValueAxis axis, Rectangle2D dataArea, Rectangle2D adjusted) {
        Polygon p2 = new Polygon();
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            float x2 = (float)axis.valueToJava2D(pos, adjusted, plot.getRangeAxisEdge());
            float y2 = (float)adjusted.getMaxY();
            p2.addPoint((int)x2, (int)y2);
            p2.addPoint((int)((double)x2 + this.getXOffset()), (int)((double)y2 - this.getYOffset()));
            p2.addPoint((int)((double)x2 + this.getXOffset()), (int)(adjusted.getMinY() - this.getYOffset()));
            p2.addPoint((int)x2, (int)adjusted.getMinY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            float y3 = (float)axis.valueToJava2D(pos, adjusted, plot.getRangeAxisEdge());
            float x3 = (float)dataArea.getX();
            p2.addPoint((int)x3, (int)y3);
            p2.addPoint((int)x3, (int)((double)y3 - this.getYOffset()));
            p2.addPoint((int)(adjusted.getMaxX() + this.getXOffset()), (int)((double)y3 - this.getYOffset()));
            p2.addPoint((int)adjusted.getMaxX(), (int)y3);
        }
        this.axis3D0Left = new Area(p2);
    }

    private boolean setminCutmaxCut(boolean horiz, boolean cutMax, boolean inverted) {
        if (this.axis3D0.isEmpty()) {
            return false;
        }
        float[] x2 = new float[4];
        float[] y2 = new float[4];
        int i2 = 0;
        float[] theData = new float[6];
        PathIterator theIterator = this.axis3D0.getPathIterator(null);
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                    break;
                }
                case 1: {
                    x2[i2] = theData[0];
                    y2[i2] = theData[1];
                }
            }
            theIterator.next();
            if (++i2 != 4) continue;
        }
        int maxy1 = 0;
        int maxy2 = 0;
        if (horiz) {
            float minXC = x2[0];
            float minYC = y2[0];
            float maxYC = y2[0];
            for (i2 = 1; i2 < 4; ++i2) {
                if (!(x2[i2] < minXC)) continue;
                minXC = x2[i2];
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (x2[i2] == minXC && y2[i2] < minYC) {
                    minYC = y2[i2];
                }
                if (x2[i2] != minXC || !(y2[i2] > maxYC)) continue;
                maxYC = y2[i2];
            }
            if (inverted) {
                if (cutMax) {
                    this.minCut = minYC;
                    this.maxCut = maxYC;
                } else {
                    this.minCut = minYC;
                    this.maxCut = maxYC;
                }
            } else if (cutMax) {
                this.minCut = minYC;
                this.maxCut = maxYC;
            } else {
                this.minCut = minYC;
                this.maxCut = maxYC;
            }
        } else {
            for (i2 = 1; i2 < 4; ++i2) {
                if (!cutMax && inverted && y2[i2] < (float)((int)this.minYHeight) || !(y2[i2] > y2[maxy1])) continue;
                maxy1 = i2;
                break;
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (i2 == maxy1 || y2[i2] != y2[maxy1]) continue;
                maxy2 = i2;
                if (!(x2[maxy1] > x2[maxy2])) break;
                maxy2 = maxy1;
                break;
            }
            if (inverted) {
                if (cutMax) {
                    this.minCut = x2[maxy1];
                    this.maxCut = x2[maxy2];
                } else {
                    this.minCut = x2[maxy1];
                    this.maxCut = x2[maxy2];
                }
            } else if (cutMax) {
                this.minCut = x2[maxy1];
                this.maxCut = x2[maxy2];
            } else {
                this.minCut = x2[maxy1];
                this.maxCut = x2[maxy2];
            }
        }
        return true;
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D dataArea) {
        this.rangeAxisIsInverted = axis.isInverted();
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = axis.getRange();
            if (!range.contains(value) && !this.rangeAxisIsInverted) {
                return;
            }
            Rectangle2D.Double adjusted = new Rectangle2D.Double(dataArea.getX(), dataArea.getY() + this.getYOffset(), dataArea.getWidth() - this.getXOffset(), dataArea.getHeight() - this.getYOffset());
            this.maxY = axis.getUpperBound();
            this.minY = axis.getLowerBound();
            this.minYHeight = axis.valueToJava2D(this.minY, adjusted, plot.getRangeAxisEdge());
            this.maxYHeight = axis.valueToJava2D(this.maxY, adjusted, plot.getRangeAxisEdge());
            GeneralPath path = null;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                float x2 = (float)axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
                if (this.rangeAxisIsInverted && x2 > (float)this.minYHeight) {
                    x2 = (float)this.minYHeight;
                }
                float y2 = (float)adjusted.getMaxY();
                path = new GeneralPath();
                path.moveTo(x2, y2);
                path.lineTo((float)((double)x2 + this.getXOffset()), y2 - (float)this.getYOffset());
                path.lineTo((float)((double)x2 + this.getXOffset()), (float)(adjusted.getMinY() - this.getYOffset()));
                path.lineTo(x2, (float)adjusted.getMinY());
                path.closePath();
            } else if (orientation == PlotOrientation.VERTICAL) {
                float y3 = (float)axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
                if (this.rangeAxisIsInverted && y3 < (float)this.minYHeight) {
                    y3 = (float)this.minYHeight;
                }
                float x3 = (float)dataArea.getX();
                path = new GeneralPath();
                path.moveTo(x3, y3);
                path.lineTo(x3 + (float)this.xOffset, y3 - (float)this.yOffset);
                path.lineTo((float)(adjusted.getMaxX() + this.xOffset), y3 - (float)this.yOffset);
                path.lineTo((float)adjusted.getMaxX(), y3);
                path.closePath();
            }
            g2.setPaint(marker.getPaint());
            g2.fill(path);
            g2.setPaint(marker.getOutlinePaint());
            g2.draw(path);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                g2.setFont(labelFont);
                g2.setPaint(marker.getLabelPaint());
                Point2D coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, path.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates.getX(), (float)coordinates.getY(), marker.getLabelTextAnchor());
            }
        } else {
            super.drawRangeMarker(g2, plot, axis, marker, dataArea);
        }
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        this.wallPaint = paint;
    }

    public Paint getLeftWallPaint() {
        return this.leftWallPaint;
    }

    public void setLeftWallPaint(Paint leftWallPaint) {
        this.leftWallPaint = leftWallPaint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getBottomWallPaint() {
        return this.bottomWallPaint;
    }

    public void setBottomWallPaint(Paint bottomWallPaint) {
        this.bottomWallPaint = bottomWallPaint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public StandardAreaPainter getPainter() {
        return this.painter;
    }

    public void setPainter(StandardAreaPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Parameter 'painter' is null.");
        }
        this.painter = painter;
    }
}

