/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.xy;

import com.inet.jfree.chart.LegendItem;
import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.entity.EntityCollection;
import com.inet.jfree.chart.entity.XYItemEntity;
import com.inet.jfree.chart.event.RendererChangeEvent;
import com.inet.jfree.chart.labels.XYToolTipGenerator;
import com.inet.jfree.chart.plot.CrosshairState;
import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.XYPlot;
import com.inet.jfree.chart.renderer.xy.XYBubbleRenderer;
import com.inet.jfree.chart.renderer.xy.XYItemRendererState;
import com.inet.jfree.data.Range;
import com.inet.jfree.data.xy.BubbleXYZDataset;
import com.inet.jfree.data.xy.XYDataset;
import com.inet.jfree.data.xy.XYZDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jfree.ui.RectangleEdge;

public class BubbleItemRenderer
extends XYBubbleRenderer {
    public static final int STYLE_SQUARE = 0;
    public static final int STYLE_CIRCLE = 1;
    public static final int STYLE_TRIANGLE = 2;
    public static final int STYLE_DIAMOND = 3;
    private final int shapeStyle;
    private final double shapeSizeCoefficient;
    private double maxRadius = 0.0;
    private boolean drawOutlines;

    public BubbleItemRenderer(int shapeStyle, double shapeSizeCoefficient) {
        super(2);
        this.shapeStyle = shapeStyle;
        this.shapeSizeCoefficient = shapeSizeCoefficient;
        this.drawOutlines = true;
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean flag) {
        this.drawOutlines = flag;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Range findRangeBounds(XYDataset dataset) {
        Range result = super.findRangeBounds(dataset);
        double rangeLength = result.getLength();
        if (dataset != null) {
            BubbleXYZDataset xyzDataset = (BubbleXYZDataset)dataset;
            double minimum = result.getLowerBound();
            double maximum = result.getUpperBound();
            int seriesCount = xyzDataset.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = xyzDataset.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    double lvalue = xyzDataset.getYValue(series, item);
                    double radius = this.getRelativeRadius(xyzDataset.getZValue(series, item), rangeLength, xyzDataset);
                    double uvalue = lvalue;
                    if (!Double.isNaN(lvalue)) {
                        minimum = Math.min(minimum, lvalue - radius);
                    }
                    if (Double.isNaN(uvalue)) continue;
                    maximum = Math.max(maximum, uvalue + radius);
                }
            }
            result = new Range(minimum, maximum);
        }
        return result;
    }

    public Range findDomainBounds(XYDataset dataset) {
        Range result = super.findDomainBounds(dataset);
        double rangeLength = result.getLength();
        if (dataset != null) {
            BubbleXYZDataset xyzDataset = (BubbleXYZDataset)dataset;
            double minimum = result.getLowerBound();
            double maximum = result.getUpperBound();
            int seriesCount = xyzDataset.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = xyzDataset.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    double lvalue = xyzDataset.getXValue(series, item);
                    double radius = this.getRelativeRadius(xyzDataset.getZValue(series, item), rangeLength, xyzDataset);
                    double uvalue = lvalue;
                    if (!Double.isNaN(lvalue)) {
                        minimum = Math.min(minimum, lvalue - radius);
                    }
                    if (Double.isNaN(uvalue)) continue;
                    maximum = Math.max(maximum, uvalue + radius);
                }
            }
            result = new Range(minimum, maximum);
        }
        return result;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYDataset dataset;
        LegendItem result = null;
        XYPlot xyplot = this.getPlot();
        if (xyplot != null && (dataset = xyplot.getDataset(datasetIndex)) != null && this.getItemVisible(series, 0)) {
            String label;
            String description = label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
            String toolTipText = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                toolTipText = this.getLegendItemToolTipGenerator().generateLabel(dataset, series);
            }
            String urlText = null;
            if (this.getLegendItemURLGenerator() != null) {
                urlText = this.getLegendItemURLGenerator().generateLabel(dataset, series);
            }
            Shape shape = this.lookupSeriesShape(series);
            Paint paint = this.lookupSeriesPaint(series);
            Paint outlinePaint = this.lookupSeriesOutlinePaint(series);
            Stroke outlineStroke = this.lookupSeriesOutlineStroke(series);
            boolean shapeOutlineVisible = this.drawOutlines;
            Stroke lineStroke = this.lookupSeriesStroke(series);
            Paint linePaint = this.lookupSeriesPaint(series);
            result = new LegendItem(label, description, toolTipText, urlText, true, shape, true, paint, shapeOutlineVisible, outlinePaint, outlineStroke, false, shape, lineStroke, linePaint);
        }
        return result;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        PlotOrientation orientation = plot.getOrientation();
        double x2 = dataset.getXValue(series, item);
        double y2 = dataset.getYValue(series, item);
        double z2 = Double.NaN;
        if (dataset instanceof XYZDataset) {
            XYZDataset xyzData = (XYZDataset)dataset;
            z2 = xyzData.getZValue(series, item);
            z2 = this.getRelativeRadius(z2, rangeAxis.getRange().getLength(), xyzData);
        }
        if (!Double.isNaN(z2)) {
            RectangleEdge domainAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge rangeAxisLocation = plot.getRangeAxisEdge();
            double transX = domainAxis.valueToJava2D(x2, dataArea, domainAxisLocation);
            double transY = rangeAxis.valueToJava2D(y2, dataArea, rangeAxisLocation);
            double transDomain = 0.0;
            double transRange = 0.0;
            switch (this.getScaleType()) {
                case 1: {
                    double zero = domainAxis.valueToJava2D(0.0, dataArea, domainAxisLocation);
                    transRange = transDomain = domainAxis.valueToJava2D(z2, dataArea, domainAxisLocation) - zero;
                    break;
                }
                case 2: {
                    double zero = rangeAxis.valueToJava2D(0.0, dataArea, rangeAxisLocation);
                    transDomain = transRange = zero - rangeAxis.valueToJava2D(z2, dataArea, rangeAxisLocation);
                    break;
                }
                default: {
                    double zero1 = domainAxis.valueToJava2D(0.0, dataArea, domainAxisLocation);
                    double zero2 = rangeAxis.valueToJava2D(0.0, dataArea, rangeAxisLocation);
                    transDomain = domainAxis.valueToJava2D(z2, dataArea, domainAxisLocation) - zero1;
                    transRange = zero2 - rangeAxis.valueToJava2D(z2, dataArea, rangeAxisLocation);
                }
            }
            transDomain = Math.abs(transDomain);
            transRange = Math.abs(transRange);
            Shape shape = null;
            if (orientation == PlotOrientation.VERTICAL) {
                shape = BubbleItemRenderer.createShape(this.shapeStyle, transX - transDomain / 2.0, transY - transRange / 2.0, transDomain, transRange);
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                shape = BubbleItemRenderer.createShape(this.shapeStyle, transY - transRange / 2.0, transX - transDomain / 2.0, transRange, transDomain);
            }
            g2.setPaint(this.getItemPaint(series, item));
            g2.fill(shape);
            if (this.drawOutlines) {
                g2.setStroke(this.getItemOutlineStroke(series, item));
                g2.setPaint(this.getItemOutlinePaint(series, item));
                g2.draw(shape);
            }
            if (this.isItemLabelVisible(series, item)) {
                if (orientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(g2, orientation, dataset, series, item, transX, transY, false);
                } else if (orientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(g2, orientation, dataset, series, item, transY, transX, false);
                }
            }
            EntityCollection entities = null;
            if (info != null) {
                entities = info.getOwner().getEntityCollection();
            }
            if (entities != null) {
                String tip = null;
                XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
                if (generator != null) {
                    tip = generator.generateToolTip(dataset, series, item);
                }
                String url = null;
                if (this.getURLGenerator() != null) {
                    url = this.getURLGenerator().generateURL(dataset, series, item);
                }
                XYItemEntity entity = new XYItemEntity(shape, dataset, series, item, tip, url);
                entities.add(entity);
            }
            int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
            int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
            this.updateCrosshairValues(crosshairState, x2, y2, domainAxisIndex, rangeAxisIndex, transX, transY, orientation);
        }
    }

    private double getRelativeRadius(double z2, double rangeLength, XYZDataset dataset) {
        return z2 * rangeLength * this.shapeSizeCoefficient / this.getMaxRadius(dataset);
    }

    private double getMaxRadius(XYZDataset dataset) {
        if (this.maxRadius == 0.0) {
            double result = 0.0;
            if (dataset != null) {
                int seriesCount = dataset.getSeriesCount();
                for (int series = 0; series < seriesCount; ++series) {
                    int itemCount = dataset.getItemCount(series);
                    for (int item = 0; item < itemCount; ++item) {
                        double radius = dataset.getZValue(series, item);
                        if (Double.isNaN(radius)) continue;
                        result = Math.max(result, radius);
                    }
                }
            }
            this.maxRadius = result;
        }
        return this.maxRadius;
    }

    private static Shape createShape(int style, double x2, double y2, double w2, double h2) {
        Shape result = null;
        int[] xpoints = null;
        int[] ypoints = null;
        switch (style) {
            case 0: {
                result = new Rectangle2D.Double(x2, y2, w2, h2);
                break;
            }
            case 1: {
                result = new Ellipse2D.Double(x2, y2, w2, h2);
                break;
            }
            case 2: {
                xpoints = new int[]{(int)(x2 + w2 / 2.0), (int)(x2 + w2), (int)x2};
                ypoints = new int[]{(int)y2, (int)(y2 + h2), (int)(y2 + h2)};
                result = new Polygon(xpoints, ypoints, 3);
                break;
            }
            case 3: {
                xpoints = new int[]{(int)x2, (int)(x2 + w2 / 2.0), (int)(x2 + w2), (int)(x2 + w2 / 2.0)};
                ypoints = new int[]{(int)(y2 + h2 / 2.0), (int)y2, (int)(y2 + h2 / 2.0), (int)(y2 + h2)};
                result = new Polygon(xpoints, ypoints, 4);
            }
        }
        return result;
    }
}

