/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.xy;

import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.entity.EntityCollection;
import com.inet.jfree.chart.labels.XYItemLabelGenerator;
import com.inet.jfree.chart.labels.XYToolTipGenerator;
import com.inet.jfree.chart.plot.CrosshairState;
import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.XYPlot;
import com.inet.jfree.chart.renderer.category.StandardAreaPainter;
import com.inet.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import com.inet.jfree.chart.renderer.xy.XYItemRendererState;
import com.inet.jfree.chart.urls.XYURLGenerator;
import com.inet.jfree.data.time.TimeTableXYDataset;
import com.inet.jfree.data.xy.DefaultTableXYDataset;
import com.inet.jfree.data.xy.TableXYDataset;
import com.inet.jfree.data.xy.XYDataset;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.ui.RectangleEdge;

public class StackedXYAreaRenderer2D
extends StackedXYAreaRenderer2 {
    private static final long serialVersionUID = -7752676509764539182L;
    private Area[] fillArea = null;
    private GeneralPath[] separator = null;
    private boolean isInit = false;
    private int seriesCount = -1;
    private StandardAreaPainter painter = new StandardAreaPainter();

    public StackedXYAreaRenderer2D() {
        this(null, null);
        this.isInit = false;
        this.painter = new StandardAreaPainter();
    }

    public StackedXYAreaRenderer2D(XYToolTipGenerator labelGenerator, XYURLGenerator urlGenerator) {
        super(labelGenerator, urlGenerator);
    }

    private void init(XYDataset dataset) {
        this.seriesCount = dataset instanceof DefaultTableXYDataset ? ((DefaultTableXYDataset)dataset).getSeriesCount() : ((TimeTableXYDataset)dataset).getSeriesCount();
        this.fillArea = new Area[this.seriesCount];
        this.separator = new GeneralPath[this.seriesCount + 1];
        for (int i2 = 0; i2 < this.seriesCount; ++i2) {
            this.fillArea[i2] = new Area();
            this.separator[i2] = new GeneralPath();
        }
        this.separator[this.seriesCount] = new GeneralPath();
        this.isInit = true;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        float transStack1;
        float transY1;
        if (!this.isInit) {
            this.init(dataset);
        }
        PlotOrientation orientation = plot.getOrientation();
        Line2D.Double tr = null;
        Line2D.Double trE = null;
        GeneralPath entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        TableXYDataset tdataset = (TableXYDataset)dataset;
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        if (Double.isNaN(y1)) {
            y1 = 0.0;
        }
        double[] stack1 = this.getStackValues(tdataset, series, item);
        double x0 = dataset.getXValue(series, Math.max(item - 1, 0));
        double y0 = dataset.getYValue(series, Math.max(item - 1, 0));
        if (Double.isNaN(y0)) {
            y0 = 0.0;
        }
        double[] stack0 = this.getStackValues(tdataset, series, Math.max(item - 1, 0));
        int itemCount = dataset.getItemCount(series);
        double x2 = dataset.getXValue(series, Math.min(item + 1, itemCount - 1));
        double y2 = dataset.getYValue(series, Math.min(item + 1, itemCount - 1));
        if (Double.isNaN(y2)) {
            y2 = 0.0;
        }
        double[] stack2 = this.getStackValues(tdataset, series, Math.min(item + 1, itemCount - 1));
        double xleft = (x0 + x1) / 2.0;
        double xright = (x1 + x2) / 2.0;
        double[] stackLeft = this.averageStackValues(stack0, stack1);
        double[] stackRight = this.averageStackValues(stack1, stack2);
        double[] adjStackLeft = this.adjustedStackValues(stack0, stack1);
        double[] adjStackRight = this.adjustedStackValues(stack1, stack2);
        RectangleEdge edge0 = plot.getDomainAxisEdge();
        float transX1 = (float)domainAxis.valueToJava2D(x1, dataArea, edge0);
        float transXLeft = (float)domainAxis.valueToJava2D(xleft, dataArea, edge0);
        float transXRight = (float)domainAxis.valueToJava2D(xright, dataArea, edge0);
        transX1 = Math.round(transX1);
        transXLeft = Math.round(transXLeft);
        transXRight = Math.round(transXRight);
        RectangleEdge edge1 = plot.getRangeAxisEdge();
        GeneralPath left = new GeneralPath();
        GeneralPath right = new GeneralPath();
        if (y1 >= 0.0) {
            transY1 = (float)rangeAxis.valueToJava2D(y1 + stack1[1], dataArea, edge1);
            transStack1 = (float)rangeAxis.valueToJava2D(stack1[1], dataArea, edge1);
            float transStackLeft = (float)rangeAxis.valueToJava2D(adjStackLeft[1], dataArea, edge1);
            if (y0 >= 0.0) {
                float yleft = (float)((y0 + y1) / 2.0 + stackLeft[1]);
                float transYLeft = (float)rangeAxis.valueToJava2D(yleft, dataArea, edge1);
                if (orientation == PlotOrientation.VERTICAL) {
                    left.moveTo(transX1, transY1);
                    left.lineTo(transX1, transStack1);
                    left.lineTo(transXLeft, transStackLeft);
                    left.lineTo(transXLeft, transYLeft);
                    left.closePath();
                    tr = new Line2D.Double(transX1, transStack1, transXLeft, transStackLeft);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transX1, transY1, transXLeft, transYLeft);
                    }
                } else {
                    left.moveTo(transY1, transX1);
                    left.lineTo(transStack1, transX1);
                    left.lineTo(transStackLeft, transXLeft);
                    left.lineTo(transYLeft, transXLeft);
                    left.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackLeft, transXLeft);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transY1, transX1, transYLeft, transXLeft);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (item == 0 && series == this.seriesCount - 1) {
                    if (orientation == PlotOrientation.VERTICAL) {
                        this.separator[this.seriesCount].append(new Line2D.Double(transXLeft, (float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transXLeft, transYLeft), false);
                    } else {
                        this.separator[this.seriesCount].append(new Line2D.Double((float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transXLeft, transYLeft, transXLeft), false);
                    }
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            } else {
                if (orientation == PlotOrientation.VERTICAL) {
                    left.moveTo(transX1, transStack1);
                    left.lineTo(transX1, transY1);
                    left.lineTo(transXLeft, transStackLeft);
                    left.closePath();
                    tr = new Line2D.Double(transX1, transStack1, transXLeft, transStackLeft);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transX1, transY1, transXLeft, transStackLeft);
                    }
                } else {
                    left.moveTo(transStack1, transX1);
                    left.lineTo(transY1, transX1);
                    left.lineTo(transStackLeft, transXLeft);
                    left.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackLeft, transXLeft);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transY1, transX1, transStackLeft, transXLeft);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            }
            float transStackRight = (float)rangeAxis.valueToJava2D(adjStackRight[1], dataArea, edge1);
            if (y2 >= 0.0) {
                float yright = (float)((y1 + y2) / 2.0 + stackRight[1]);
                float transYRight = (float)rangeAxis.valueToJava2D(yright, dataArea, edge1);
                if (orientation == PlotOrientation.VERTICAL) {
                    right.moveTo(transX1, transStack1);
                    right.lineTo(transX1, transY1);
                    right.lineTo(transXRight, transYRight);
                    right.lineTo(transXRight, transStackRight);
                    right.closePath();
                    tr = new Line2D.Double(transX1, transStack1, transXRight, transStackRight);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transX1, transY1, transXRight, transYRight);
                    }
                } else {
                    right.moveTo(transStack1, transX1);
                    right.lineTo(transY1, transX1);
                    right.lineTo(transYRight, transXRight);
                    right.lineTo(transStackRight, transXRight);
                    right.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackRight, transXRight);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transY1, transX1, transYRight, transXRight);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (item == itemCount - 1 && series == this.seriesCount - 1) {
                    if (orientation == PlotOrientation.VERTICAL) {
                        this.separator[this.seriesCount].append(new Line2D.Double(transXRight, (float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transXRight, transYRight), false);
                    } else {
                        this.separator[this.seriesCount].append(new Line2D.Double((float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transXRight, transYRight, transXRight), false);
                    }
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            } else {
                if (orientation == PlotOrientation.VERTICAL) {
                    right.moveTo(transX1, transStack1);
                    right.lineTo(transX1, transY1);
                    right.lineTo(transXRight, transStackRight);
                    right.closePath();
                    tr = new Line2D.Double(transX1, transStack1, transXRight, transStackRight);
                    if (series == this.seriesCount - 1) {
                        if (item == 0 && (trE = new Line2D.Double(transX1, transY1, transX1, transStackRight)) != null) {
                            this.separator[this.seriesCount].append(trE, false);
                        }
                        trE = new Line2D.Double(transX1, transY1, transXRight, transStackRight);
                    }
                } else {
                    right.moveTo(transStack1, transX1);
                    right.lineTo(transY1, transX1);
                    right.lineTo(transStackRight, transXRight);
                    right.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackRight, transXRight);
                    if (series == this.seriesCount - 1) {
                        if (item == 0 && (trE = new Line2D.Double(transY1, transX1, transStackRight, transX1)) != null) {
                            this.separator[this.seriesCount].append(trE, false);
                        }
                        trE = new Line2D.Double(transY1, transX1, transStackRight, transXRight);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            }
        } else {
            transY1 = (float)rangeAxis.valueToJava2D(y1 + stack1[0], dataArea, edge1);
            transStack1 = (float)rangeAxis.valueToJava2D(stack1[0], dataArea, edge1);
            float transStackLeft = (float)rangeAxis.valueToJava2D(adjStackLeft[0], dataArea, edge1);
            if (y0 >= 0.0) {
                if (orientation == PlotOrientation.VERTICAL) {
                    left.moveTo(transX1, transStack1);
                    left.lineTo(transX1, transY1);
                    left.lineTo(transXLeft, transStackLeft);
                    left.closePath();
                    tr = new Line2D.Double(transX1, transStack1, transXLeft, transStackLeft);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transX1, transY1, transXLeft, transStackLeft);
                    }
                } else {
                    left.moveTo(transStack1, transX1);
                    left.lineTo(transY1, transX1);
                    left.lineTo(transStackLeft, transXLeft);
                    left.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackLeft, transXLeft);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transY1, transX1, transStackLeft, transXLeft);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (item == itemCount - 1 && series == this.seriesCount - 1) {
                    if (orientation == PlotOrientation.VERTICAL) {
                        this.separator[this.seriesCount].append(new Line2D.Double(transX1, (float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1), false);
                    } else {
                        this.separator[this.seriesCount].append(new Line2D.Double((float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1, transX1), false);
                    }
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            } else {
                float yleft = (float)((y0 + y1) / 2.0 + stackLeft[0]);
                float transYLeft = (float)rangeAxis.valueToJava2D(yleft, dataArea, edge1);
                if (orientation == PlotOrientation.VERTICAL) {
                    left.moveTo(transX1, transY1);
                    left.lineTo(transX1, transStack1);
                    left.lineTo(transXLeft, transStackLeft);
                    left.lineTo(transXLeft, transYLeft);
                    left.closePath();
                    tr = new Line2D.Double(transXLeft, transStackLeft, transX1, transStack1);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transX1, transY1, transXLeft, transYLeft);
                    }
                } else {
                    left.moveTo(transY1, transX1);
                    left.lineTo(transStack1, transX1);
                    left.lineTo(transStackLeft, transXLeft);
                    left.lineTo(transYLeft, transXLeft);
                    left.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackLeft, transXLeft);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transYLeft, transXLeft, transY1, transX1);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (item == itemCount - 1 && series == this.seriesCount - 1) {
                    if (orientation == PlotOrientation.VERTICAL) {
                        this.separator[this.seriesCount].append(new Line2D.Double(transX1, (float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1), false);
                    } else {
                        this.separator[this.seriesCount].append(new Line2D.Double((float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1, transX1), false);
                    }
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            }
            float transStackRight = (float)rangeAxis.valueToJava2D(adjStackRight[0], dataArea, edge1);
            if (y2 >= 0.0) {
                if (orientation == PlotOrientation.VERTICAL) {
                    right.moveTo(transX1, transStack1);
                    right.lineTo(transX1, transY1);
                    right.lineTo(transXRight, transStackRight);
                    right.closePath();
                    tr = new Line2D.Double(transX1, transStack1, transXRight, transStackRight);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transX1, transY1, transXRight, transStackRight);
                    }
                } else {
                    right.moveTo(transStack1, transX1);
                    right.lineTo(transY1, transX1);
                    right.lineTo(transStackRight, transXRight);
                    right.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackRight, transXRight);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transY1, transX1, transStackRight, transXRight);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (item == 0 && series == this.seriesCount - 1) {
                    if (orientation == PlotOrientation.VERTICAL) {
                        this.separator[this.seriesCount].append(new Line2D.Double(transX1, (float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1), false);
                    } else {
                        this.separator[this.seriesCount].append(new Line2D.Double((float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1, transX1), false);
                    }
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            } else {
                float yright = (float)((y1 + y2) / 2.0 + stackRight[0]);
                float transYRight = (float)rangeAxis.valueToJava2D(yright, dataArea, edge1);
                if (orientation == PlotOrientation.VERTICAL) {
                    right.moveTo(transX1, transStack1);
                    right.lineTo(transX1, transY1);
                    right.lineTo(transXRight, transYRight);
                    right.lineTo(transXRight, transStackRight);
                    right.closePath();
                    tr = new Line2D.Double(transX1, transStack1, transXRight, transStackRight);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transX1, transY1, transXRight, transYRight);
                    }
                } else {
                    right.moveTo(transStack1, transX1);
                    right.lineTo(transY1, transX1);
                    right.lineTo(transYRight, transXRight);
                    right.lineTo(transStackRight, transXRight);
                    right.closePath();
                    tr = new Line2D.Double(transStack1, transX1, transStackRight, transXRight);
                    if (series == this.seriesCount - 1) {
                        trE = new Line2D.Double(transY1, transX1, transYRight, transXRight);
                    }
                }
                if (tr != null) {
                    this.separator[series].append(tr, false);
                }
                if (item == 0 && series == this.seriesCount - 1) {
                    if (orientation == PlotOrientation.VERTICAL) {
                        this.separator[this.seriesCount].append(new Line2D.Double(transX1, (float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1), false);
                    } else {
                        this.separator[this.seriesCount].append(new Line2D.Double((float)rangeAxis.valueToJava2D(0.0, dataArea, edge1), transX1, transY1, transX1), false);
                    }
                }
                if (series == this.seriesCount - 1 && trE != null) {
                    this.separator[this.seriesCount].append(trE, false);
                }
            }
        }
        if (pass == 0) {
            this.fillArea[series].add(new Area(left));
            this.fillArea[series].add(new Area(right));
            if (series == 0 && item == itemCount - 1) {
                this.painter.paintArea(g2, this, this.seriesCount, itemCount, this.fillArea, this.separator, this.getPlot().getRangeAxisEdge(), this.isOutline(), true);
                this.isInit = false;
            }
        }
        if (entities != null) {
            GeneralPath gp2 = new GeneralPath(left);
            gp2.append(right, false);
            entityArea = gp2;
            this.addEntity(entities, entityArea, dataset, series, item, transX1, transY1);
        }
        if (pass == 1) {
            this.isInit = false;
            if (orientation == PlotOrientation.VERTICAL) {
                if (this.isItemLabelVisible(series, item)) {
                    this.drawItemLabel(g2, plot.getOrientation(), dataset, series, item, transX1, transY1, y1 < 0.0);
                }
            } else if (orientation == PlotOrientation.HORIZONTAL && this.isItemLabelVisible(series, item)) {
                this.drawItemLabel(g2, plot.getOrientation(), dataset, series, item, transY1, transX1, y1 < 0.0);
            }
        }
    }

    protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x2, double y2, boolean negative) {
        String label;
        XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
        if (generator != null && (label = generator.generateLabel(dataset, series, item)) != null && dataset.getY(series, item) != null && dataset.getX(series, item) != null) {
            super.drawItemLabel(g2, orientation, dataset, series, item, x2, y2, negative);
        }
    }

    public int getPassCount() {
        return 2;
    }

    private double[] getStackValues(TableXYDataset dataset, int series, int index) {
        double[] result = new double[2];
        for (int i2 = 0; i2 < series; ++i2) {
            double v2 = dataset.getYValue(i2, index);
            if (Double.isNaN(v2)) continue;
            if (v2 >= 0.0) {
                result[1] = result[1] + v2;
                continue;
            }
            result[0] = result[0] + v2;
        }
        return result;
    }

    private double[] averageStackValues(double[] stack1, double[] stack2) {
        double[] result = new double[]{(stack1[0] + stack2[0]) / 2.0, (stack1[1] + stack2[1]) / 2.0};
        return result;
    }

    private double[] adjustedStackValues(double[] stack1, double[] stack2) {
        double[] result = new double[]{stack1[0] == 0.0 || stack2[0] == 0.0 ? 0.0 : (stack1[0] + stack2[0]) / 2.0, stack1[1] == 0.0 || stack2[1] == 0.0 ? 0.0 : (stack1[1] + stack2[1]) / 2.0};
        return result;
    }

    public StandardAreaPainter getPainter() {
        return this.painter;
    }

    public void setPainter(StandardAreaPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Parameter 'painter' is null.");
        }
        this.painter = painter;
    }
}

