/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.xy;

import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.entity.EntityCollection;
import com.inet.jfree.chart.plot.CrosshairState;
import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.XYPlot;
import com.inet.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import com.inet.jfree.chart.renderer.xy.XYItemRenderer;
import com.inet.jfree.chart.renderer.xy.XYItemRendererState;
import com.inet.jfree.data.Range;
import com.inet.jfree.data.xy.VectorXYDataset;
import com.inet.jfree.data.xy.XYDataset;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.util.PublicCloneable;

public class VectorRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private double baseLength = 0.1;
    private double headLength = 0.14;

    public Range findDomainBounds(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        if (dataset instanceof VectorXYDataset) {
            VectorXYDataset vdataset = (VectorXYDataset)dataset;
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = dataset.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    double lvalue;
                    double uvalue;
                    double delta = vdataset.getVectorXValue(series, item);
                    if (delta < 0.0) {
                        uvalue = vdataset.getXValue(series, item);
                        lvalue = uvalue + delta;
                    } else {
                        lvalue = vdataset.getXValue(series, item);
                        uvalue = lvalue + delta;
                    }
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                }
            }
        } else {
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = dataset.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    double lvalue;
                    double uvalue = lvalue = dataset.getXValue(series, item);
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                }
            }
        }
        if (minimum > maximum) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        if (dataset instanceof VectorXYDataset) {
            VectorXYDataset vdataset = (VectorXYDataset)dataset;
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = dataset.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    double lvalue;
                    double uvalue;
                    double delta = vdataset.getVectorYValue(series, item);
                    if (delta < 0.0) {
                        uvalue = vdataset.getYValue(series, item);
                        lvalue = uvalue + delta;
                    } else {
                        lvalue = vdataset.getYValue(series, item);
                        uvalue = lvalue + delta;
                    }
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                }
            }
        } else {
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = dataset.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    double lvalue;
                    double uvalue = lvalue = dataset.getYValue(series, item);
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                }
            }
        }
        if (minimum > maximum) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double x2 = dataset.getXValue(series, item);
        double y2 = dataset.getYValue(series, item);
        double dx2 = 0.0;
        double dy2 = 0.0;
        if (dataset instanceof VectorXYDataset) {
            dx2 = ((VectorXYDataset)dataset).getVectorXValue(series, item);
            dy2 = ((VectorXYDataset)dataset).getVectorYValue(series, item);
        }
        double xx0 = domainAxis.valueToJava2D(x2, dataArea, plot.getDomainAxisEdge());
        double yy0 = rangeAxis.valueToJava2D(y2, dataArea, plot.getRangeAxisEdge());
        double xx1 = domainAxis.valueToJava2D(x2 + dx2, dataArea, plot.getDomainAxisEdge());
        double yy1 = rangeAxis.valueToJava2D(y2 + dy2, dataArea, plot.getRangeAxisEdge());
        PlotOrientation orientation = plot.getOrientation();
        Line2D.Double line = orientation.equals(PlotOrientation.HORIZONTAL) ? new Line2D.Double(yy0, xx0, yy1, xx1) : new Line2D.Double(xx0, yy0, xx1, yy1);
        g2.setPaint(this.getItemPaint(series, item));
        g2.setStroke(this.getItemStroke(series, item));
        g2.draw(line);
        double dxx = xx1 - xx0;
        double dyy = yy1 - yy0;
        double bx2 = xx0 + (1.0 - this.baseLength) * dxx;
        double by2 = yy0 + (1.0 - this.baseLength) * dyy;
        double cx2 = xx0 + (1.0 - this.headLength) * dxx;
        double cy2 = yy0 + (1.0 - this.headLength) * dyy;
        double angle = 0.0;
        if (dxx != 0.0) {
            angle = 1.5707963267948966 - Math.atan(dyy / dxx);
        }
        double deltaX = 2.0 * Math.cos(angle);
        double deltaY = 2.0 * Math.sin(angle);
        double leftx = cx2 + deltaX;
        double lefty = cy2 - deltaY;
        double rightx = cx2 - deltaX;
        double righty = cy2 + deltaY;
        GeneralPath p2 = new GeneralPath();
        if (orientation == PlotOrientation.VERTICAL) {
            p2.moveTo((float)xx1, (float)yy1);
            p2.lineTo((float)rightx, (float)righty);
            p2.lineTo((float)bx2, (float)by2);
            p2.lineTo((float)leftx, (float)lefty);
        } else {
            p2.moveTo((float)yy1, (float)xx1);
            p2.lineTo((float)righty, (float)rightx);
            p2.lineTo((float)by2, (float)bx2);
            p2.lineTo((float)lefty, (float)leftx);
        }
        p2.closePath();
        g2.draw(p2);
        EntityCollection entities = null;
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            this.addEntity(entities, line.getBounds(), dataset, series, item, 0.0, 0.0);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorRenderer)) {
            return false;
        }
        VectorRenderer that = (VectorRenderer)obj;
        if (this.baseLength != that.baseLength) {
            return false;
        }
        if (this.headLength != that.headLength) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

