/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data;

import com.inet.jfree.data.DefaultKeyedValues;
import com.inet.jfree.data.KeyedValues;
import com.inet.jfree.data.Values2D;
import java.util.Arrays;

public abstract class DataUtilities {
    public static boolean equal(double[][] a2, double[][] b2) {
        if (a2 == null) {
            return b2 == null;
        }
        if (b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (Arrays.equals(a2[i2], b2[i2])) continue;
            return false;
        }
        return true;
    }

    public static double[][] clone(double[][] source) {
        if (source == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        double[][] clone = new double[source.length][];
        for (int i2 = 0; i2 < source.length; ++i2) {
            if (source[i2] == null) continue;
            double[] row = new double[source[i2].length];
            System.arraycopy(source[i2], 0, row, 0, source[i2].length);
            clone[i2] = row;
        }
        return clone;
    }

    public static double calculateColumnTotal(Values2D data, int column) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int rowCount = data.getRowCount();
        for (int r2 = 0; r2 < rowCount; ++r2) {
            Number n2 = data.getValue(r2, column);
            if (n2 == null) continue;
            total += n2.doubleValue();
        }
        return total;
    }

    public static double calculateColumnTotal(Values2D data, int column, int[] validRows) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int rowCount = data.getRowCount();
        for (int v2 = 0; v2 < validRows.length; ++v2) {
            Number n2;
            int row = validRows[v2];
            if (row >= rowCount || (n2 = data.getValue(row, column)) == null) continue;
            total += n2.doubleValue();
        }
        return total;
    }

    public static double calculateRowTotal(Values2D data, int row) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int columnCount = data.getColumnCount();
        for (int c2 = 0; c2 < columnCount; ++c2) {
            Number n2 = data.getValue(row, c2);
            if (n2 == null) continue;
            total += n2.doubleValue();
        }
        return total;
    }

    public static double calculateRowTotal(Values2D data, int row, int[] validCols) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int colCount = data.getColumnCount();
        for (int v2 = 0; v2 < validCols.length; ++v2) {
            Number n2;
            int col = validCols[v2];
            if (col >= colCount || (n2 = data.getValue(row, col)) == null) continue;
            total += n2.doubleValue();
        }
        return total;
    }

    public static Number[] createNumberArray(double[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] result = new Number[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            result[i2] = new Double(data[i2]);
        }
        return result;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int l1 = data.length;
        Number[][] result = new Number[l1][];
        for (int i2 = 0; i2 < l1; ++i2) {
            result[i2] = DataUtilities.createNumberArray(data[i2]);
        }
        return result;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues result = new DefaultKeyedValues();
        double total = 0.0;
        for (int i2 = 0; i2 < data.getItemCount(); ++i2) {
            Number v2 = data.getValue(i2);
            if (v2 == null) continue;
            total += v2.doubleValue();
        }
        double runningTotal = 0.0;
        for (int i3 = 0; i3 < data.getItemCount(); ++i3) {
            Number v3 = data.getValue(i3);
            if (v3 != null) {
                runningTotal += v3.doubleValue();
            }
            result.addValue(data.getKey(i3), new Double(runningTotal / total));
        }
        return result;
    }

    public static double calculateColumnStackedPercentageTotal(Values2D data, int column, int[] validRows) {
        double minimum = 0.0;
        double maximum = 0.0;
        int rowCount = data.getRowCount();
        for (int r2 = 0; r2 < validRows.length; ++r2) {
            Number n2;
            int row = validRows[r2];
            if (row >= rowCount || (n2 = data.getValue(r2, column)) == null) continue;
            double value = n2.doubleValue();
            if (value > 0.0) {
                maximum += value;
                continue;
            }
            minimum += value;
        }
        return Math.abs(minimum) + Math.abs(maximum);
    }
}

