/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.category;

import com.inet.jfree.data.category.DefaultCategoryDataset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InetCategoryDataset
extends DefaultCategoryDataset {
    private boolean invertedRows;
    private boolean invertedColumns;

    public void setInvertedRows(boolean invertedRows) {
        this.invertedRows = invertedRows;
    }

    public boolean getInvertedRows() {
        return this.invertedRows;
    }

    public void setInvertedColumns(boolean invertedColumns) {
        this.invertedColumns = invertedColumns;
    }

    public boolean getInvertedColumns() {
        return this.invertedColumns;
    }

    public Comparable getColumnKey(int column) {
        return super.getColumnKey(this.getInternColumnIndex(column));
    }

    public int getColumnIndex(Comparable key) {
        return this.getInternColumnIndex(super.getColumnIndex(key));
    }

    public List getColumnKeys() {
        if (this.invertedColumns) {
            return InetCategoryDataset.reverseList(super.getColumnKeys());
        }
        return super.getColumnKeys();
    }

    public Comparable getRowKey(int row) {
        return super.getRowKey(this.getInternRowIndex(row));
    }

    public int getRowIndex(Comparable key) {
        return this.getInternRowIndex(super.getRowIndex(key));
    }

    public List getRowKeys() {
        if (this.invertedRows) {
            return InetCategoryDataset.reverseList(super.getRowKeys());
        }
        return super.getRowKeys();
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getValue(row, column);
    }

    public Number getValue(int row, int column) {
        return super.getValue(this.getInternRowIndex(row), this.getInternColumnIndex(column));
    }

    public void removeRow(int rowIndex) {
        super.removeRow(this.getInternRowIndex(rowIndex));
    }

    public void removeRow(Comparable rowKey) {
        super.removeRow(this.getRowIndex(rowKey));
    }

    public void removeColumn(int columnIndex) {
        super.removeColumn(this.getInternColumnIndex(columnIndex));
    }

    public void removeColumn(Comparable columnKey) {
        super.removeColumn(this.getColumnIndex(columnKey));
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof InetCategoryDataset)) {
                return false;
            }
            InetCategoryDataset that = (InetCategoryDataset)obj;
            if (this.invertedColumns != that.invertedColumns) {
                return false;
            }
            return this.invertedRows == that.invertedRows;
        }
        return false;
    }

    private int getInternColumnIndex(int index) {
        if (this.invertedColumns) {
            return this.getColumnCount() - 1 - index;
        }
        return index;
    }

    private int getInternRowIndex(int index) {
        if (this.invertedRows) {
            return this.getRowCount() - 1 - index;
        }
        return index;
    }

    private static List reverseList(List list) {
        ArrayList result = new ArrayList(list.size());
        for (int i2 = list.size() - 1; i2 > -1; --i2) {
            result.add(list.get(i2));
        }
        return Collections.unmodifiableList(result);
    }
}

