/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.category;

import com.inet.jfree.data.DataUtilities;
import com.inet.jfree.data.category.IntervalOHLCCategoryDataset;
import com.inet.jfree.data.general.AbstractSeriesDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class StockCategoryDataset
extends AbstractSeriesDataset
implements IntervalOHLCCategoryDataset {
    private Comparable[] seriesKeys;
    private Comparable[] categoryKeys;
    private Number[][] startData;
    private Number[][] endData;
    private Number[][] openData;
    private Number[][] closeData;

    public StockCategoryDataset(double[][] starts, double[][] ends) {
        this(DataUtilities.createNumberArray2D(starts), DataUtilities.createNumberArray2D(ends));
    }

    public StockCategoryDataset(double[][] starts, double[][] ends, double[][] opens, double[][] closes) {
        this(DataUtilities.createNumberArray2D(starts), DataUtilities.createNumberArray2D(ends), DataUtilities.createNumberArray2D(opens), DataUtilities.createNumberArray2D(closes));
    }

    public StockCategoryDataset(Comparable[] seriesKeys, Comparable[] categoryKeys, double[][] starts, double[][] ends, double[][] opens, double[][] closes) {
        this(seriesKeys, categoryKeys, DataUtilities.createNumberArray2D(starts), DataUtilities.createNumberArray2D(ends), opens != null ? DataUtilities.createNumberArray2D(opens) : (Number[][])null, closes != null ? DataUtilities.createNumberArray2D(closes) : (Number[][])null);
    }

    public StockCategoryDataset(Number[][] starts, Number[][] ends) {
        this(starts, ends, (Number[][])null, (Number[][])null);
    }

    public StockCategoryDataset(Number[][] starts, Number[][] ends, Number[][] opens, Number[][] closes) {
        this(null, null, starts, ends, opens, closes);
    }

    public StockCategoryDataset(String[] seriesNames, Number[][] starts, Number[][] ends, Number[][] opens, Number[][] closes) {
        this((Comparable[])seriesNames, null, starts, ends, opens, closes);
    }

    public StockCategoryDataset(Comparable[] seriesKeys, Comparable[] categoryKeys, Number[][] starts, Number[][] ends, Number[][] opens, Number[][] closes) {
        this.startData = starts;
        this.endData = ends;
        this.openData = opens;
        this.closeData = closes;
        if (starts != null && ends != null) {
            String baseName = "com.inet.jfree.data.resources.DataPackageResources";
            ResourceBundle resources = ResourceBundle.getBundle(baseName);
            int seriesCount = starts.length;
            if (seriesCount != ends.length) {
                String errMsg = "StockCategoryDataset: the number of series in the start value dataset does not match the number of series in the end value dataset.";
                throw new IllegalArgumentException(errMsg);
            }
            if (seriesCount > 0) {
                if (seriesKeys != null) {
                    if (seriesKeys.length != seriesCount) {
                        throw new IllegalArgumentException("The number of series keys does not match the number of series in the data.");
                    }
                    this.seriesKeys = seriesKeys;
                } else {
                    String prefix = resources.getString("series.default-prefix") + " ";
                    this.seriesKeys = this.generateKeys(seriesCount, prefix);
                }
                int categoryCount = starts[0].length;
                if (categoryCount != ends[0].length) {
                    String errMsg = "StockCategoryDataset: the number of categories in the start value dataset does not match the number of categories in the end value dataset.";
                    throw new IllegalArgumentException(errMsg);
                }
                if (categoryKeys != null) {
                    if (categoryKeys.length != categoryCount) {
                        throw new IllegalArgumentException("The number of category keys does not match the number of categories in the data.");
                    }
                    this.categoryKeys = categoryKeys;
                } else {
                    String prefix = resources.getString("categories.default-prefix") + " ";
                    this.categoryKeys = this.generateKeys(categoryCount, prefix);
                }
            } else {
                this.seriesKeys = null;
                this.categoryKeys = null;
            }
        }
    }

    public int getSeriesCount() {
        int result = 0;
        if (this.startData != null) {
            result = this.startData.length;
        }
        return result;
    }

    public int getItemCount() {
        return this.categoryKeys.length;
    }

    public int getSeriesIndex(Comparable series) {
        return this.getSeries().indexOf(series);
    }

    public Comparable getSeriesKey(int series) {
        if (series >= this.getSeriesCount() || series < 0) {
            throw new IllegalArgumentException("No such series : " + series);
        }
        return this.seriesKeys[series];
    }

    public void setSeriesKeys(Comparable[] seriesKeys) {
        if (seriesKeys == null) {
            throw new IllegalArgumentException("Null 'seriesKeys' argument.");
        }
        if (seriesKeys.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.setSeriesKeys(): the number of series keys does not match the data.");
        }
        this.seriesKeys = seriesKeys;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int result = 0;
        if (this.startData != null && this.getSeriesCount() > 0) {
            result = this.startData[0].length;
        }
        return result;
    }

    public List getSeries() {
        if (this.seriesKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.seriesKeys));
    }

    public List getCategories() {
        return this.getColumnKeys();
    }

    public List getColumnKeys() {
        if (this.categoryKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categoryKeys));
    }

    public void setCategoryKeys(Comparable[] categoryKeys) {
        if (categoryKeys == null) {
            throw new IllegalArgumentException("Null 'categoryKeys' argument.");
        }
        if (categoryKeys.length != this.startData[0].length) {
            throw new IllegalArgumentException("The number of categories does not match the data.");
        }
        for (int i2 = 0; i2 < categoryKeys.length; ++i2) {
            if (categoryKeys[i2] != null) continue;
            throw new IllegalArgumentException("StockCategoryDataset.setCategoryKeys(): null category not permitted.");
        }
        this.categoryKeys = categoryKeys;
        this.fireDatasetChanged();
    }

    public Number getValue(Comparable series, Comparable category) {
        int seriesIndex = this.getSeriesIndex(series);
        int itemIndex = this.getColumnIndex(category);
        return this.getValue(seriesIndex, itemIndex);
    }

    public Number getValue(int series, int category) {
        return this.getEndValue(series, category);
    }

    public Number getStartValue(Comparable series, Comparable category) {
        int seriesIndex = this.getSeriesIndex(series);
        int itemIndex = this.getColumnIndex(category);
        return this.getStartValue(seriesIndex, itemIndex);
    }

    public Number getStartValue(int series, int category) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): series index out of range.");
        }
        if (category < 0 || category >= this.getCategoryCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): category index out of range.");
        }
        return this.startData[series][category];
    }

    public Number getEndValue(Comparable series, Comparable category) {
        int seriesIndex = this.getSeriesIndex(series);
        int itemIndex = this.getColumnIndex(category);
        return this.getEndValue(seriesIndex, itemIndex);
    }

    public Number getEndValue(int series, int category) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): series index out of range.");
        }
        if (category < 0 || category >= this.getCategoryCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): category index out of range.");
        }
        return this.endData[series][category];
    }

    public void setStartValue(int series, Comparable category, Number value) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: series outside valid range.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: unrecognised category.");
        }
        this.startData[series][categoryIndex] = value;
        this.fireDatasetChanged();
    }

    public void setEndValue(int series, Comparable category, Number value) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: series outside valid range.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: unrecognised category.");
        }
        this.endData[series][categoryIndex] = value;
        this.fireDatasetChanged();
    }

    public void setOpenValue(int series, Comparable category, Number value) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: series outside valid range.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: unrecognised category.");
        }
        this.openData[series][categoryIndex] = value;
        this.fireDatasetChanged();
    }

    public void setCloseValue(int series, Comparable category, Number value) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: series outside valid range.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("StockCategoryDataset.setValue: unrecognised category.");
        }
        this.closeData[series][categoryIndex] = value;
        this.fireDatasetChanged();
    }

    public Number getOpenValue(int series, int category) {
        if (this.openData == null) {
            return null;
        }
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): series index out of range.");
        }
        if (category < 0 || category >= this.getCategoryCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): category index out of range.");
        }
        return this.openData[series][category];
    }

    public Number getOpenValue(Comparable series, Comparable category) {
        int seriesIndex = this.getSeriesIndex(series);
        int itemIndex = this.getColumnIndex(category);
        return this.getOpenValue(seriesIndex, itemIndex);
    }

    public Number getCloseValue(int series, int category) {
        if (this.closeData == null) {
            return null;
        }
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): series index out of range.");
        }
        if (category < 0 || category >= this.getCategoryCount()) {
            throw new IllegalArgumentException("StockCategoryDataset.getValue(): category index out of range.");
        }
        return this.closeData[series][category];
    }

    public Number getCloseValue(Comparable series, Comparable category) {
        int seriesIndex = this.getSeriesIndex(series);
        int itemIndex = this.getColumnIndex(category);
        return this.getCloseValue(seriesIndex, itemIndex);
    }

    private int getCategoryIndex(Comparable category) {
        int result = -1;
        for (int i2 = 0; i2 < this.categoryKeys.length; ++i2) {
            if (!category.equals(this.categoryKeys[i2])) continue;
            result = i2;
            break;
        }
        return result;
    }

    private Comparable[] generateKeys(int count, String prefix) {
        Comparable[] result = new Comparable[count];
        for (int i2 = 0; i2 < count; ++i2) {
            String name = prefix + (i2 + 1);
            result[i2] = name;
        }
        return result;
    }

    public Comparable getColumnKey(int column) {
        return this.categoryKeys[column];
    }

    public int getColumnIndex(Comparable columnKey) {
        List categories = this.getCategories();
        return categories.indexOf(columnKey);
    }

    public int getRowIndex(Comparable rowKey) {
        return this.getSeries().indexOf(rowKey);
    }

    public List getRowKeys() {
        if (this.seriesKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.seriesKeys));
    }

    public Comparable getRowKey(int row) {
        if (row >= this.getRowCount() || row < 0) {
            throw new IllegalArgumentException("The 'row' argument is out of bounds.");
        }
        return this.seriesKeys[row];
    }

    public int getColumnCount() {
        int result = 0;
        if (this.startData != null && this.getSeriesCount() > 0) {
            result = this.startData[0].length;
        }
        return result;
    }

    public int getRowCount() {
        int result = 0;
        if (this.startData != null) {
            result = this.startData.length;
        }
        return result;
    }
}

