/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.contour;

import com.inet.jfree.data.Range;
import com.inet.jfree.data.contour.ContourDataset;
import com.inet.jfree.data.xy.AbstractXYZDataset;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class DefaultContourDataset
extends AbstractXYZDataset
implements ContourDataset {
    protected Comparable seriesKey = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(Comparable seriesKey, Object[] xData, Object[] yData, Object[] zData) {
        this.seriesKey = seriesKey;
        this.initialize(xData, yData, zData);
    }

    public void initialize(Object[] xData, Object[] yData, Object[] zData) {
        this.xValues = new Double[xData.length];
        this.yValues = new Double[yData.length];
        this.zValues = new Double[zData.length];
        Vector<Integer> tmpVector = new Vector<Integer>();
        double x2 = 1.123452E31;
        for (int k2 = 0; k2 < this.xValues.length; ++k2) {
            Number xNumber;
            if (xData[k2] == null) continue;
            if (xData[k2] instanceof Number) {
                xNumber = (Number)xData[k2];
            } else if (xData[k2] instanceof Date) {
                this.dateAxis[0] = true;
                Date xDate = (Date)xData[k2];
                xNumber = new Long(xDate.getTime());
            } else {
                xNumber = new Integer(0);
            }
            this.xValues[k2] = new Double(xNumber.doubleValue());
            if (x2 == this.xValues[k2].doubleValue()) continue;
            tmpVector.add(new Integer(k2));
            x2 = this.xValues[k2].doubleValue();
        }
        Object[] inttmp = tmpVector.toArray();
        this.xIndex = new int[inttmp.length];
        for (int i2 = 0; i2 < inttmp.length; ++i2) {
            this.xIndex[i2] = (Integer)inttmp[i2];
        }
        for (int k3 = 0; k3 < this.yValues.length; ++k3) {
            this.yValues[k3] = (Double)yData[k3];
            if (zData[k3] == null) continue;
            this.zValues[k3] = (Double)zData[k3];
        }
    }

    public static Object[][] formObjectArray(double[][] data) {
        Object[][] object = new Double[data.length][data[0].length];
        for (int i2 = 0; i2 < object.length; ++i2) {
            for (int j2 = 0; j2 < object[i2].length; ++j2) {
                object[i2][j2] = new Double(data[i2][j2]);
            }
        }
        return object;
    }

    public static Object[] formObjectArray(double[] data) {
        Object[] object = new Double[data.length];
        for (int i2 = 0; i2 < object.length; ++i2) {
            object[i2] = new Double(data[i2]);
        }
        return object;
    }

    public int getItemCount(int series) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues.length;
    }

    public double getMaxZValue() {
        double zMax = -1.0E20;
        for (int k2 = 0; k2 < this.zValues.length; ++k2) {
            if (this.zValues[k2] == null) continue;
            zMax = Math.max(zMax, this.zValues[k2].doubleValue());
        }
        return zMax;
    }

    public double getMinZValue() {
        double zMin = 1.0E20;
        for (int k2 = 0; k2 < this.zValues.length; ++k2) {
            if (this.zValues[k2] == null) continue;
            zMin = Math.min(zMin, this.zValues[k2].doubleValue());
        }
        return zMin;
    }

    public Range getZValueRange(Range x2, Range y2) {
        double minX = x2.getLowerBound();
        double minY = y2.getLowerBound();
        double maxX = x2.getUpperBound();
        double maxY = y2.getUpperBound();
        double zMin = 1.0E20;
        double zMax = -1.0E20;
        for (int k2 = 0; k2 < this.zValues.length; ++k2) {
            if (!(this.xValues[k2].doubleValue() >= minX) || !(this.xValues[k2].doubleValue() <= maxX) || !(this.yValues[k2].doubleValue() >= minY) || !(this.yValues[k2].doubleValue() <= maxY) || this.zValues[k2] == null) continue;
            zMin = Math.min(zMin, this.zValues[k2].doubleValue());
            zMax = Math.max(zMax, this.zValues[k2].doubleValue());
        }
        return new Range(zMin, zMax);
    }

    public double getMinZValue(double minX, double minY, double maxX, double maxY) {
        double zMin = 1.0E20;
        for (int k2 = 0; k2 < this.zValues.length; ++k2) {
            if (this.zValues[k2] == null) continue;
            zMin = Math.min(zMin, this.zValues[k2].doubleValue());
        }
        return zMin;
    }

    public int getSeriesCount() {
        return 1;
    }

    public Comparable getSeriesKey(int series) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.seriesKey;
    }

    public int[] getXIndices() {
        return this.xIndex;
    }

    public Number[] getXValues() {
        return this.xValues;
    }

    public Number getX(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.xValues[item];
    }

    public Number getXValue(int item) {
        return this.xValues[item];
    }

    public Number[] getYValues() {
        return this.yValues;
    }

    public Number getY(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.yValues[item];
    }

    public Number[] getZValues() {
        return this.zValues;
    }

    public Number getZ(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues[item];
    }

    public int[] indexX() {
        int[] index = new int[this.xValues.length];
        for (int k2 = 0; k2 < index.length; ++k2) {
            index[k2] = this.indexX(k2);
        }
        return index;
    }

    public int indexX(int k2) {
        int i2 = Arrays.binarySearch(this.xIndex, k2);
        if (i2 >= 0) {
            return i2;
        }
        return -1 * i2 - 2;
    }

    public int indexY(int k2) {
        return k2 / this.xValues.length;
    }

    public int indexZ(int i2, int j2) {
        return this.xValues.length * j2 + i2;
    }

    public boolean isDateAxis(int axisNumber) {
        if (axisNumber < 0 || axisNumber > 2) {
            return false;
        }
        return this.dateAxis[axisNumber];
    }

    public void setSeriesKeys(Comparable[] seriesKeys) {
        if (seriesKeys.length > 1) {
            throw new IllegalArgumentException("Contours only support one series");
        }
        this.seriesKey = seriesKeys[0];
        this.fireDatasetChanged();
    }
}

