/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.general;

import com.inet.jfree.data.DataUtilities;
import com.inet.jfree.data.general.AbstractDataset;
import com.inet.jfree.data.general.HeatMapDataset;
import java.io.Serializable;
import org.jfree.util.PublicCloneable;

public class DefaultHeatMapDataset
extends AbstractDataset
implements HeatMapDataset,
Cloneable,
PublicCloneable,
Serializable {
    private int xSamples;
    private int ySamples;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double[][] zValues;

    public DefaultHeatMapDataset(int xSamples, int ySamples, double minX, double maxX, double minY, double maxY) {
        if (xSamples < 1) {
            throw new IllegalArgumentException("Requires 'xSamples' > 0");
        }
        if (ySamples < 1) {
            throw new IllegalArgumentException("Requires 'ySamples' > 0");
        }
        if (Double.isInfinite(minX) || Double.isNaN(minX)) {
            throw new IllegalArgumentException("'minX' cannot be INF or NaN.");
        }
        if (Double.isInfinite(maxX) || Double.isNaN(maxX)) {
            throw new IllegalArgumentException("'maxX' cannot be INF or NaN.");
        }
        if (Double.isInfinite(minY) || Double.isNaN(minY)) {
            throw new IllegalArgumentException("'minY' cannot be INF or NaN.");
        }
        if (Double.isInfinite(maxY) || Double.isNaN(maxY)) {
            throw new IllegalArgumentException("'maxY' cannot be INF or NaN.");
        }
        this.xSamples = xSamples;
        this.ySamples = ySamples;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.zValues = new double[xSamples][];
        for (int x2 = 0; x2 < xSamples; ++x2) {
            this.zValues[x2] = new double[ySamples];
        }
    }

    public int getXSampleCount() {
        return this.xSamples;
    }

    public int getYSampleCount() {
        return this.ySamples;
    }

    public double getMinimumXValue() {
        return this.minX;
    }

    public double getMaximumXValue() {
        return this.maxX;
    }

    public double getMinimumYValue() {
        return this.minY;
    }

    public double getMaximumYValue() {
        return this.maxY;
    }

    public double getXValue(int xIndex) {
        double x2 = this.minX + (this.maxX - this.minX) * ((double)xIndex / (double)this.xSamples);
        return x2;
    }

    public double getYValue(int yIndex) {
        double y2 = this.minY + (this.maxY - this.minY) * ((double)yIndex / (double)this.ySamples);
        return y2;
    }

    public double getZValue(int xIndex, int yIndex) {
        return this.zValues[xIndex][yIndex];
    }

    public Number getZ(int xIndex, int yIndex) {
        return new Double(this.getZValue(xIndex, yIndex));
    }

    public void setZValue(int xIndex, int yIndex, double z2) {
        this.setZValue(xIndex, yIndex, z2, true);
    }

    public void setZValue(int xIndex, int yIndex, double z2, boolean notify) {
        this.zValues[xIndex][yIndex] = z2;
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultHeatMapDataset)) {
            return false;
        }
        DefaultHeatMapDataset that = (DefaultHeatMapDataset)obj;
        if (this.xSamples != that.xSamples) {
            return false;
        }
        if (this.ySamples != that.ySamples) {
            return false;
        }
        if (this.minX != that.minX) {
            return false;
        }
        if (this.maxX != that.maxX) {
            return false;
        }
        if (this.minY != that.minY) {
            return false;
        }
        if (this.maxY != that.maxY) {
            return false;
        }
        return DataUtilities.equal(this.zValues, that.zValues);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultHeatMapDataset clone = (DefaultHeatMapDataset)super.clone();
        clone.zValues = DataUtilities.clone(this.zValues);
        return clone;
    }
}

