/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.general;

import com.inet.jfree.chart.renderer.PaintScale;
import com.inet.jfree.data.general.HeatMapDataset;
import com.inet.jfree.data.xy.XYDataset;
import com.inet.jfree.data.xy.XYSeries;
import com.inet.jfree.data.xy.XYSeriesCollection;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;

public abstract class HeatMapUtilities {
    public static XYDataset extractRowFromHeatMapDataset(HeatMapDataset dataset, int row, Comparable seriesName) {
        XYSeries series = new XYSeries(seriesName);
        int cols = dataset.getXSampleCount();
        for (int c2 = 0; c2 < cols; ++c2) {
            series.add(dataset.getXValue(c2), dataset.getZValue(c2, row));
        }
        XYSeriesCollection result = new XYSeriesCollection(series);
        return result;
    }

    public static XYDataset extractColumnFromHeatMapDataset(HeatMapDataset dataset, int column, Comparable seriesName) {
        XYSeries series = new XYSeries(seriesName);
        int rows = dataset.getYSampleCount();
        for (int r2 = 0; r2 < rows; ++r2) {
            series.add(dataset.getYValue(r2), dataset.getZValue(column, r2));
        }
        XYSeriesCollection result = new XYSeriesCollection(series);
        return result;
    }

    public static BufferedImage createHeatMapImage(HeatMapDataset dataset, PaintScale paintScale) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (paintScale == null) {
            throw new IllegalArgumentException("Null 'paintScale' argument.");
        }
        int xCount = dataset.getXSampleCount();
        int yCount = dataset.getYSampleCount();
        BufferedImage image = new BufferedImage(xCount, yCount, 2);
        Graphics2D g2 = image.createGraphics();
        for (int xIndex = 0; xIndex < xCount; ++xIndex) {
            for (int yIndex = 0; yIndex < yCount; ++yIndex) {
                double z2 = dataset.getZValue(xIndex, yIndex);
                Paint p2 = paintScale.getPaint(z2);
                g2.setPaint(p2);
                g2.fillRect(xIndex, yCount - yIndex - 1, 1, 1);
            }
        }
        return image;
    }
}

