/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.time;

import com.inet.jfree.data.Range;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class DateRange
extends Range
implements Serializable {
    private static final long serialVersionUID = -4705682568375418157L;
    private long lowerDate;
    private long upperDate;

    public DateRange() {
        this(new Date(0L), new Date(1L));
    }

    public DateRange(Date lower, Date upper) {
        super(lower.getTime(), upper.getTime());
        this.lowerDate = lower.getTime();
        this.upperDate = upper.getTime();
    }

    public DateRange(double lower, double upper) {
        super(lower, upper);
        this.lowerDate = (long)lower;
        this.upperDate = (long)upper;
    }

    public DateRange(Range other) {
        this(other.getLowerBound(), other.getUpperBound());
    }

    public Date getLowerDate() {
        return new Date(this.lowerDate);
    }

    public long getLowerMillis() {
        return this.lowerDate;
    }

    public Date getUpperDate() {
        return new Date(this.upperDate);
    }

    public long getUpperMillis() {
        return this.upperDate;
    }

    public String toString() {
        DateFormat df2 = DateFormat.getDateTimeInstance();
        return "[" + df2.format(this.getLowerDate()) + " --> " + df2.format(this.getUpperDate()) + "]";
    }
}

