/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.time;

import com.inet.jfree.data.time.RegularTimePeriod;
import com.inet.jfree.data.time.TimeSeries;
import com.inet.jfree.data.time.TimeSeriesDataItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramTimeSeries
extends TimeSeries {
    public HistogramTimeSeries(TimeSeries original, HashMap<Integer, String> groupNameValues) {
        super(original.getKey(), original.getTimePeriodClass());
        this.data = this.getData(original.getItems(), groupNameValues);
    }

    private List<TimeSeriesDataItem> getData(List<TimeSeriesDataItem> original, HashMap<Integer, String> groupNameValues) {
        if (original.size() == 0) {
            return original;
        }
        ArrayList<TimeSeriesDataItem> result = new ArrayList<TimeSeriesDataItem>();
        HashMap<Integer, String> newValues = new HashMap<Integer, String>();
        for (int i2 = 0; i2 < original.size(); ++i2) {
            TimeSeriesDataItem originalItem = original.get(i2);
            if (i2 > 0) {
                RegularTimePeriod previous = originalItem.getPeriod().previous();
                if (original.get(i2 - 1).getPeriod().compareTo(previous) < 0) {
                    result.add(new TimeSeriesDataItem(previous, 0.0));
                }
            }
            String value = groupNameValues.get(i2);
            newValues.put(result.size(), value);
            result.add(originalItem);
            if (i2 >= original.size() - 1) continue;
            RegularTimePeriod next = originalItem.getPeriod().next();
            if (original.get(i2 + 1).getPeriod().compareTo(next) <= 0) continue;
            result.add(new TimeSeriesDataItem(next, 0.0));
        }
        groupNameValues.clear();
        groupNameValues.putAll(newValues);
        return result;
    }
}

