/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.xy;

import com.inet.jfree.data.DomainInfo;
import com.inet.jfree.data.Range;
import com.inet.jfree.data.general.DatasetUtilities;
import com.inet.jfree.data.general.SeriesChangeEvent;
import com.inet.jfree.data.xy.AbstractIntervalXYDataset;
import com.inet.jfree.data.xy.IntervalXYDataset;
import com.inet.jfree.data.xy.IntervalXYDelegate;
import com.inet.jfree.data.xy.TableXYDataset;
import com.inet.jfree.data.xy.XYDataItem;
import com.inet.jfree.data.xy.XYSeries;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class DefaultTableXYDataset
extends AbstractIntervalXYDataset
implements TableXYDataset,
IntervalXYDataset,
DomainInfo,
PublicCloneable {
    private List data = null;
    private HashSet xPoints = null;
    private boolean propagateEvents = true;
    private boolean autoPrune = false;
    private IntervalXYDelegate intervalDelegate;

    public DefaultTableXYDataset() {
        this(false);
    }

    public DefaultTableXYDataset(boolean autoPrune) {
        this.autoPrune = autoPrune;
        this.data = new ArrayList();
        this.xPoints = new HashSet();
        this.intervalDelegate = new IntervalXYDelegate(this, false);
        this.addChangeListener(this.intervalDelegate);
    }

    public boolean isAutoPrune() {
        return this.autoPrune;
    }

    public void addSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (series.getAllowDuplicateXValues()) {
            throw new IllegalArgumentException("Cannot accept XYSeries that allow duplicate values. Use XYSeries(seriesName, <sort>, false) constructor.");
        }
        this.updateXPoints(series);
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    private void updateXPoints(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' not permitted.");
        }
        HashSet<Number> seriesXPoints = new HashSet<Number>();
        boolean savedState = this.propagateEvents;
        this.propagateEvents = false;
        for (int itemNo = 0; itemNo < series.getItemCount(); ++itemNo) {
            Number xValue = series.getX(itemNo);
            seriesXPoints.add(xValue);
            if (this.xPoints.contains(xValue)) continue;
            this.xPoints.add(xValue);
            int seriesCount = this.data.size();
            for (int seriesNo = 0; seriesNo < seriesCount; ++seriesNo) {
                XYSeries dataSeries = (XYSeries)this.data.get(seriesNo);
                if (dataSeries.equals(series)) continue;
                dataSeries.add(xValue, null);
            }
        }
        for (Number xPoint : this.xPoints) {
            if (seriesXPoints.contains(xPoint)) continue;
            series.add(xPoint, null);
        }
        this.propagateEvents = savedState;
    }

    public void updateXPoints() {
        this.propagateEvents = false;
        for (int s2 = 0; s2 < this.data.size(); ++s2) {
            this.updateXPoints((XYSeries)this.data.get(s2));
        }
        if (this.autoPrune) {
            this.prune();
        }
        this.propagateEvents = true;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public int getItemCount() {
        if (this.xPoints == null) {
            return 0;
        }
        return this.xPoints.size();
    }

    public XYSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        return (XYSeries)this.data.get(series);
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public Number getX(int series, int item) {
        XYSeries s2 = (XYSeries)this.data.get(series);
        XYDataItem dataItem = s2.getDataItem(item);
        return dataItem.getX();
    }

    public Number getStartX(int series, int item) {
        return this.intervalDelegate.getStartX(series, item);
    }

    public Number getEndX(int series, int item) {
        return this.intervalDelegate.getEndX(series, item);
    }

    public Number getY(int series, int index) {
        XYSeries ts = (XYSeries)this.data.get(series);
        XYDataItem dataItem = ts.getDataItem(index);
        return dataItem.getY();
    }

    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public void removeAllSeries() {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            XYSeries series = (XYSeries)this.data.get(i2);
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.xPoints.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            if (this.data.size() == 0) {
                this.xPoints.clear();
            }
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        XYSeries s2 = (XYSeries)this.data.get(series);
        s2.removeChangeListener(this);
        this.data.remove(series);
        if (this.data.size() == 0) {
            this.xPoints.clear();
        } else if (this.autoPrune) {
            this.prune();
        }
        this.fireDatasetChanged();
    }

    public void removeAllValuesForX(Number x2) {
        if (x2 == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        boolean savedState = this.propagateEvents;
        this.propagateEvents = false;
        for (int s2 = 0; s2 < this.data.size(); ++s2) {
            XYSeries series = (XYSeries)this.data.get(s2);
            series.remove(x2);
        }
        this.propagateEvents = savedState;
        this.xPoints.remove(x2);
        this.fireDatasetChanged();
    }

    protected boolean canPrune(Number x2) {
        for (int s2 = 0; s2 < this.data.size(); ++s2) {
            XYSeries series = (XYSeries)this.data.get(s2);
            if (series.getY(series.indexOf(x2)) == null) continue;
            return false;
        }
        return true;
    }

    public void prune() {
        HashSet hs = (HashSet)this.xPoints.clone();
        for (Number x2 : hs) {
            if (!this.canPrune(x2)) continue;
            this.removeAllValuesForX(x2);
        }
    }

    public void seriesChanged(SeriesChangeEvent event) {
        if (this.propagateEvents) {
            this.updateXPoints();
            this.fireDatasetChanged();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultTableXYDataset)) {
            return false;
        }
        DefaultTableXYDataset that = (DefaultTableXYDataset)obj;
        if (this.autoPrune != that.autoPrune) {
            return false;
        }
        if (this.propagateEvents != that.propagateEvents) {
            return false;
        }
        if (!this.intervalDelegate.equals(that.intervalDelegate)) {
            return false;
        }
        return ObjectUtilities.equal(this.data, that.data);
    }

    public int hashCode() {
        int result = this.data != null ? ((Object)this.data).hashCode() : 0;
        result = 29 * result + (this.xPoints != null ? this.xPoints.hashCode() : 0);
        result = 29 * result + (this.propagateEvents ? 1 : 0);
        result = 29 * result + (this.autoPrune ? 1 : 0);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTableXYDataset clone = (DefaultTableXYDataset)super.clone();
        int seriesCount = this.data.size();
        clone.data = new ArrayList(seriesCount);
        for (int i2 = 0; i2 < seriesCount; ++i2) {
            XYSeries series = (XYSeries)this.data.get(i2);
            clone.data.add(series.clone());
        }
        clone.intervalDelegate = new IntervalXYDelegate(clone);
        clone.intervalDelegate.setFixedIntervalWidth(this.getIntervalWidth());
        clone.intervalDelegate.setAutoWidth(this.isAutoWidth());
        clone.intervalDelegate.setIntervalPositionFactor(this.getIntervalPositionFactor());
        clone.updateXPoints();
        return clone;
    }

    public double getDomainLowerBound(boolean includeInterval) {
        return this.intervalDelegate.getDomainLowerBound(includeInterval);
    }

    public double getDomainUpperBound(boolean includeInterval) {
        return this.intervalDelegate.getDomainUpperBound(includeInterval);
    }

    public Range getDomainBounds(boolean includeInterval) {
        if (includeInterval) {
            return this.intervalDelegate.getDomainBounds(includeInterval);
        }
        return DatasetUtilities.iterateDomainBounds(this, includeInterval);
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d2) {
        this.intervalDelegate.setIntervalPositionFactor(d2);
        this.fireDatasetChanged();
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d2) {
        this.intervalDelegate.setFixedIntervalWidth(d2);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean b2) {
        this.intervalDelegate.setAutoWidth(b2);
        this.fireDatasetChanged();
    }
}

