/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.xy;

import com.inet.jfree.chart.axis.NumberTick;
import com.inet.jfree.data.Range;
import com.inet.jfree.data.xy.XYSeries;
import com.inet.jfree.data.xy.XYSeriesCollection;
import java.util.ArrayList;
import java.util.List;
import org.jfree.ui.TextAnchor;

public class PolarXYDataset
extends XYSeriesCollection {
    private final boolean isStacked;
    private List angleTicks;

    public PolarXYDataset(boolean isStacked) {
        this.isStacked = isStacked;
        this.angleTicks = new ArrayList();
    }

    private static NumberTick getNumberTick(String name, double value) {
        return new NumberTick(new Double(value), name, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
    }

    public List getAngleTicks() {
        return this.angleTicks;
    }

    public boolean isStacked() {
        return this.isStacked;
    }

    public Number getY(int series, int index) {
        return new Double(this.getYValue(series, index));
    }

    private double getSuperYValue(int series, int index) {
        double result = 0.0;
        Number y2 = super.getY(series, index);
        if (y2 != null) {
            result = y2.doubleValue();
        }
        return result;
    }

    public double getYValue(int series, int item) {
        double radius = 0.0;
        if (this.isStacked) {
            double theta = super.getXValue(series, item);
            radius = this.getSuperYValue(series, item);
            for (int j2 = series - 1; j2 >= 0; --j2) {
                if (super.getXValue(j2, item) != theta) continue;
                radius += this.getSuperYValue(j2, item);
            }
        } else {
            radius = this.getSuperYValue(series, item);
        }
        return radius;
    }

    public double getNonStackedYValue(int series, int index) {
        return this.getSuperYValue(series, index);
    }

    public void setCategories(String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("Null 'names' argument.");
        }
        double tick = 360.0 / (double)names.length;
        double currentTick = 0.0;
        for (int i2 = 0; i2 < names.length; ++i2) {
            this.angleTicks.add(PolarXYDataset.getNumberTick(names[i2], currentTick));
            currentTick += tick;
        }
    }

    public Range getRangeBounds(boolean includeInterval) {
        if (!this.isStacked) {
            return super.getRangeBounds(includeInterval);
        }
        double lower = Double.POSITIVE_INFINITY;
        double upper = Double.NEGATIVE_INFINITY;
        int seriesCount = this.getSeriesCount();
        if (seriesCount < 1) {
            return null;
        }
        for (int i2 = 0; i2 < this.getSeries(0).getItemCount(); ++i2) {
            double l2 = 0.0;
            double u2 = 0.0;
            for (int s2 = 0; s2 < seriesCount; ++s2) {
                double valueY;
                XYSeries series = this.getSeries(s2);
                Number value = series.getY(i2);
                if (value == null || Double.isNaN(valueY = value.doubleValue())) continue;
                l2 = Math.min(l2, l2 + valueY);
                u2 = Math.max(u2, u2 + valueY);
            }
            lower = Math.min(lower, l2);
            upper = Math.max(upper, u2);
        }
        if (lower > upper) {
            return null;
        }
        return new Range(lower, upper);
    }

    public double getRangeLowerBound(boolean includeInterval) {
        if (!this.isStacked) {
            return super.getRangeLowerBound(includeInterval);
        }
        Range range = this.getRangeBounds(includeInterval);
        if (range != null) {
            return range.getLowerBound();
        }
        return Double.NaN;
    }

    public double getRangeUpperBound(boolean includeInterval) {
        if (!this.isStacked) {
            return super.getRangeUpperBound(includeInterval);
        }
        Range range = this.getRangeBounds(includeInterval);
        if (range != null) {
            return range.getUpperBound();
        }
        return Double.NaN;
    }
}

