/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.xy;

import com.inet.jfree.data.xy.AbstractXYDataset;
import com.inet.jfree.data.xy.Vector;
import com.inet.jfree.data.xy.VectorDataItem;
import com.inet.jfree.data.xy.VectorSeries;
import com.inet.jfree.data.xy.VectorXYDataset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class VectorSeriesCollection
extends AbstractXYDataset
implements VectorXYDataset,
PublicCloneable,
Serializable {
    private List data = new ArrayList();

    public void addSeries(VectorSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean removeSeries(VectorSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        boolean removed = this.data.remove(series);
        if (removed) {
            series.removeChangeListener(this);
            this.fireDatasetChanged();
        }
        return removed;
    }

    public void removeAllSeries() {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            VectorSeries series = (VectorSeries)this.data.get(i2);
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public VectorSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (VectorSeries)this.data.get(series);
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    public int indexOf(VectorSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        return this.data.indexOf(series);
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public double getXValue(int series, int item) {
        VectorSeries s2 = (VectorSeries)this.data.get(series);
        VectorDataItem di2 = (VectorDataItem)s2.getDataItem(item);
        return di2.getXValue();
    }

    public Number getX(int series, int item) {
        return new Double(this.getXValue(series, item));
    }

    public double getYValue(int series, int item) {
        VectorSeries s2 = (VectorSeries)this.data.get(series);
        VectorDataItem di2 = (VectorDataItem)s2.getDataItem(item);
        return di2.getYValue();
    }

    public Number getY(int series, int item) {
        return new Double(this.getYValue(series, item));
    }

    public Vector getVector(int series, int item) {
        VectorSeries s2 = (VectorSeries)this.data.get(series);
        VectorDataItem di2 = (VectorDataItem)s2.getDataItem(item);
        return di2.getVector();
    }

    public double getVectorXValue(int series, int item) {
        VectorSeries s2 = (VectorSeries)this.data.get(series);
        VectorDataItem di2 = (VectorDataItem)s2.getDataItem(item);
        return di2.getVectorX();
    }

    public double getVectorYValue(int series, int item) {
        VectorSeries s2 = (VectorSeries)this.data.get(series);
        VectorDataItem di2 = (VectorDataItem)s2.getDataItem(item);
        return di2.getVectorY();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorSeriesCollection)) {
            return false;
        }
        VectorSeriesCollection that = (VectorSeriesCollection)obj;
        return ObjectUtilities.equal(this.data, that.data);
    }

    public Object clone() throws CloneNotSupportedException {
        VectorSeriesCollection clone = (VectorSeriesCollection)super.clone();
        clone.data = (List)ObjectUtilities.deepClone(this.data);
        return clone;
    }
}

