/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.xy;

import java.io.Serializable;
import org.jfree.util.ObjectUtilities;

public class XYDataItem
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 2751513470325494890L;
    private Number x;
    private Number y;

    public XYDataItem(Number x2, Number y2) {
        if (x2 == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        this.x = x2;
        this.y = y2;
    }

    public XYDataItem(double x2, double y2) {
        this(new Double(x2), new Double(y2));
    }

    public Number getX() {
        return this.x;
    }

    public double getXValue() {
        return this.x.doubleValue();
    }

    public Number getY() {
        return this.y;
    }

    public double getYValue() {
        double result = Double.NaN;
        if (this.y != null) {
            result = this.y.doubleValue();
        }
        return result;
    }

    public void setY(double y2) {
        this.setY(new Double(y2));
    }

    public void setY(Number y2) {
        this.y = y2;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof XYDataItem) {
            XYDataItem dataItem = (XYDataItem)o1;
            double compare = this.x.doubleValue() - dataItem.getX().doubleValue();
            result = compare > 0.0 ? 1 : (compare < 0.0 ? -1 : 0);
        } else {
            result = 1;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYDataItem)) {
            return false;
        }
        XYDataItem that = (XYDataItem)obj;
        if (!this.x.equals(that.x)) {
            return false;
        }
        return ObjectUtilities.equal(this.y, that.y);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = 29 * result + (this.y != null ? this.y.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[" + this.getXValue() + ", " + this.getYValue() + "]";
    }
}

