/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.core;

import com.inet.lib.core.DefaultLogHandler;
import com.inet.lib.core.LogHandler;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class LibBase {
    private static final LibBase a = new LibBase();
    private Map b;
    private Map c;
    private LogHandler d = new DefaultLogHandler();

    public static final LibBase getInstance() {
        return a;
    }

    private LibBase() {
        this.b = new Hashtable();
        this.c = new Hashtable();
        try {
            this.commitTranslations(ResourceBundle.getBundle("com.inet.lib.core.LanguageResources"));
            return;
        }
        catch (MissingResourceException missingResourceException) {
            this.d.error(missingResourceException.getMessage());
            return;
        }
    }

    public LogHandler getLogHandler() {
        return this.d;
    }

    public void setLogHandler(LogHandler logHandler) {
        this.d = logHandler;
        if (this.d == null) {
            this.d = new DefaultLogHandler();
        }
    }

    public ImageIcon getIcon(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ImageIcon imageIcon = (ImageIcon)this.b.get(string);
        if (imageIcon == null) {
            imageIcon = new ImageIcon(this.getResource("/com/inet/lib/images/" + string));
            this.b.put(string, imageIcon);
        }
        return imageIcon;
    }

    public URL getResource(String string) {
        return this.getClass().getResource(string);
    }

    public void exit(int n2) {
        System.exit(n2);
    }

    public String msg(String string, Object ... objectArray) {
        String string2 = (String)this.c.get(string);
        if (string2 == null) {
            string2 = "$" + string + "$";
        } else if (objectArray != null && objectArray.length > 0) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public void commitTranslations(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = resourceBundle.getString(string);
            this.c.put(string, string2);
        }
    }
}

