/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.list;

import com.inet.lib.list.ObjectList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public final class IntArrayList
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = -1609708610121579826L;
    private final Object a = new Object();
    private int[][] b;
    private int c;
    private int d;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(Vector vector) {
        this(vector.size());
        vector.copyInto((Object[])this.b);
        this.c = vector.size();
    }

    public IntArrayList(IntArrayList intArrayList) {
        this(intArrayList.size());
        System.arraycopy(intArrayList.b, 0, this.b, 0, intArrayList.c);
        this.c = intArrayList.c;
    }

    public IntArrayList(int n2) {
        this(n2, 0);
    }

    public IntArrayList(int n2, int n3) {
        this.b = new int[n2][];
        this.d = n3;
    }

    public final int[] elementAt(int n2) {
        if (n2 < this.c) {
            return this.b[n2];
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public final void setCapacity(int n2) {
        if (n2 < this.c) {
            this.c = n2;
        }
        if (n2 != this.b.length) {
            int[][] nArrayArray = new int[n2][];
            System.arraycopy(this.b, 0, nArrayArray, 0, this.c);
            this.b = nArrayArray;
        }
    }

    private final void a(int n2) {
        if ((n2 = ObjectList.computeMinCapacity(n2, this.b.length, this.d)) != this.b.length) {
            this.setCapacity(n2);
        }
    }

    public final void addElement(int[] nArray) {
        if (this.c >= this.b.length) {
            this.a(this.c + 1);
        }
        this.b[this.c] = nArray;
        ++this.c;
    }

    public final void insertElementAt(int[] nArray, int n2) {
        if (n2 > this.c) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.a(this.c + 1);
        System.arraycopy(this.b, n2, this.b, n2 + 1, this.c - n2);
        this.b[n2] = nArray;
        ++this.c;
    }

    public final int[] removeElementAt(int n2) {
        int[] nArray = this.b[n2];
        if (n2 < this.c - 1) {
            System.arraycopy(this.b, n2 + 1, this.b, n2, this.c - n2 - 1);
        }
        this.b[--this.c] = null;
        return nArray;
    }

    public final int size() {
        return this.c;
    }

    public final void setSize(int n2) {
        for (int i2 = n2; i2 < this.c; ++i2) {
            this.b[i2] = null;
        }
        this.a(n2);
        this.c = n2;
    }

    public final void clear() {
        this.setSize(0);
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            objectOutput.writeObject(this.b[i2]);
        }
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.c = objectInput.readInt();
        if (this.b.length < this.c) {
            this.b = new int[this.c][];
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.b[i2] = (int[])objectInput.readObject();
        }
    }

    public final int indexOf(int[] nArray) {
        if (nArray == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (!nArray.equals(this.b[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final void removeElement(int[] nArray) {
        int n2 = this.indexOf(nArray);
        if (n2 < 0) {
            return;
        }
        this.removeElementAt(n2);
    }

    public final Vector toVector() {
        Vector<int[]> vector = new Vector<int[]>(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            vector.addElement(this.b[i2]);
        }
        return vector;
    }

    public final boolean contains(int[] nArray) {
        return this.indexOf(nArray) >= 0;
    }

    public final int[][] toArray() {
        return this.toArray(new int[this.c][]);
    }

    public final int[][] toArray(int[][] object) {
        if (object == null || ((int[][])object).length != this.c) {
            object = new int[this.c][];
        }
        System.arraycopy(this.b, 0, object, 0, this.c);
        return object;
    }

    public final void copyInto(int[][] nArray) {
        if (nArray == null || nArray.length != this.c) {
            throw new RuntimeException();
        }
        System.arraycopy(this.b, 0, nArray, 0, this.c);
    }

    public final void addAll(IntArrayList intArrayList) {
        this.a(this.c + intArrayList.c);
        System.arraycopy(intArrayList.b, 0, this.b, this.c, intArrayList.c);
        this.c += intArrayList.c;
    }

    public final void setElementAt(int[] nArray, int n2) {
        if (n2 < this.c) {
            this.b[n2] = nArray;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public final int[] lastElement() {
        return this.b[this.c - 1];
    }

    public final Object clone() {
        IntArrayList intArrayList;
        try {
            intArrayList = (IntArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        intArrayList.b = new int[this.b.length][];
        System.arraycopy(this.b, 0, intArrayList.b, 0, this.c);
        return intArrayList;
    }

    public final boolean isEmpty() {
        return this.c == 0;
    }

    public final Object getID() {
        return this.a;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',').append(' ');
            }
            stringBuffer.append(this.b[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final Object getObjectAt(int n2) {
        return this.elementAt(n2);
    }
}

