/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.list;

import com.inet.lib.list.ObjectList;
import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public final class StringList
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 8534014732794122033L;
    private final Object a = new Object();
    private String[] b;
    private int c;
    private int d;

    public StringList() {
        this(10);
    }

    public StringList(Vector vector) {
        this(vector.size());
        vector.copyInto(this.b);
        this.c = vector.size();
    }

    public StringList(String[] stringArray) {
        this(stringArray.length);
        this.addAll(stringArray);
    }

    public StringList(StringList stringList) {
        this(stringList.size());
        System.arraycopy(stringList.b, 0, this.b, 0, stringList.c);
        this.c = stringList.c;
    }

    public StringList(int n2) {
        this(n2, 0);
    }

    public StringList(int n2, int n3) {
        this.b = new String[n2];
        this.d = n3;
    }

    public final String elementAt(int n2) {
        if (n2 < this.c) {
            return this.b[n2];
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public final void setCapacity(int n2) {
        if (n2 < this.c) {
            this.c = n2;
        }
        if (n2 != this.b.length) {
            String[] stringArray = new String[n2];
            System.arraycopy(this.b, 0, stringArray, 0, this.c);
            this.b = stringArray;
        }
    }

    private final void a(int n2) {
        if ((n2 = ObjectList.computeMinCapacity(n2, this.b.length, this.d)) != this.b.length) {
            this.setCapacity(n2);
        }
    }

    public final void addElement(String string) {
        if (this.c >= this.b.length) {
            this.a(this.c + 1);
        }
        this.b[this.c] = string;
        ++this.c;
    }

    public final void insertElementAt(String string, int n2) {
        if (n2 > this.c) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.a(this.c + 1);
        System.arraycopy(this.b, n2, this.b, n2 + 1, this.c - n2);
        this.b[n2] = string;
        ++this.c;
    }

    public final String removeElementAt(int n2) {
        String string = this.b[n2];
        if (n2 < this.c - 1) {
            System.arraycopy(this.b, n2 + 1, this.b, n2, this.c - n2 - 1);
        }
        this.b[--this.c] = null;
        return string;
    }

    public final int size() {
        return this.c;
    }

    public final void setSize(int n2) {
        for (int i2 = n2; i2 < this.c; ++i2) {
            this.b[i2] = null;
        }
        this.a(n2);
        this.c = n2;
    }

    public final void clear() {
        this.setSize(0);
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            objectOutput.writeObject(this.b[i2]);
        }
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.c = objectInput.readInt();
        if (this.b.length < this.c) {
            this.b = new String[this.c];
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.b[i2] = (String)objectInput.readObject();
        }
    }

    public final int indexOf(String string) {
        if (string == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (!string.equals(this.b[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOfIgnoreCase(String string) {
        if (string == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (!string.equalsIgnoreCase(this.b[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final void removeElement(String string) {
        int n2 = this.indexOf(string);
        if (n2 < 0) {
            return;
        }
        this.removeElementAt(n2);
    }

    public final Vector toVector() {
        Vector<String> vector = new Vector<String>(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            vector.addElement(this.b[i2]);
        }
        return vector;
    }

    public final boolean contains(String string) {
        return this.indexOf(string) >= 0;
    }

    public final boolean containsIgnoreCase(String string) {
        return this.indexOfIgnoreCase(string) >= 0;
    }

    public final String containsDuplicates() {
        for (int i2 = 0; i2 < this.c; ++i2) {
            String string = this.b[i2];
            for (int i3 = i2 + 1; i3 < this.c; ++i3) {
                if (!string.equalsIgnoreCase(this.b[i3])) continue;
                return string;
            }
        }
        return "";
    }

    public final String[] toArray() {
        return this.toArray(new String[this.c]);
    }

    public final String[] toArray(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.c) {
            stringArray = new String[this.c];
        }
        System.arraycopy(this.b, 0, stringArray, 0, this.c);
        return stringArray;
    }

    public final void copyInto(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.c) {
            throw new RuntimeException();
        }
        System.arraycopy(this.b, 0, stringArray, 0, this.c);
    }

    public final void addAll(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeException();
        }
        this.a(this.c + stringArray.length);
        System.arraycopy(stringArray, 0, this.b, this.c, stringArray.length);
        this.c += stringArray.length;
    }

    public final void addAll(StringList stringList) {
        this.a(this.c + stringList.c);
        System.arraycopy(stringList.b, 0, this.b, this.c, stringList.c);
        this.c += stringList.c;
    }

    public final void setElementAt(String string, int n2) {
        if (n2 < this.c) {
            this.b[n2] = string;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public final String lastElement() {
        return this.b[this.c - 1];
    }

    public final Object clone() {
        StringList stringList;
        try {
            stringList = (StringList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        stringList.b = new String[this.b.length];
        System.arraycopy(this.b, 0, stringList.b, 0, this.c);
        return stringList;
    }

    public final boolean isEmpty() {
        return this.c == 0;
    }

    public final Object getID() {
        return this.a;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',').append(' ');
            }
            stringBuffer.append(this.b[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final Object getObjectAt(int n2) {
        return this.elementAt(n2);
    }

    public final void save(File object) throws IOException {
        object = new PrintWriter(new FileWriter((File)object));
        for (int i2 = 0; i2 < this.c; ++i2) {
            ((PrintWriter)object).println(this.b[i2]);
        }
        ((PrintWriter)object).close();
    }

    public final void load(File object) throws IOException {
        object = new BufferedReader(new FileReader((File)object));
        String string = ((BufferedReader)object).readLine();
        while (string != null) {
            this.addElement(new String(string));
            string = ((BufferedReader)object).readLine();
        }
        ((BufferedReader)object).close();
    }

    public final void sort() {
        Arrays.sort(this.b, 0, this.c, new Comparator(this){

            public final int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
    }
}

