/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GUIUtilities {
    private static final String CP_LABEL = "cp.label";
    private static final AffineTransform a = new AffineTransform();
    private static final FontRenderContext b = new FontRenderContext(a, true, true);
    private static final PropertyChangeListener c = new PropertyChangeListener(){

        public final void propertyChange(PropertyChangeEvent serializable) {
            if ("enabled".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                Object object = ((JComponent)(serializable = (JComponent)((EventObject)serializable).getSource())).getClientProperty(GUIUtilities.CP_LABEL);
                if (object instanceof JLabel) {
                    object = (JLabel)object;
                    object.setEnabled(((Component)serializable).isEnabled());
                    return;
                }
                object = object;
                for (int i2 = 0; i2 < ((JLabel[])object).length; ++i2) {
                    object[i2].setEnabled(((Component)serializable).isEnabled());
                }
            }
        }
    };

    private GUIUtilities() {
    }

    public static final void synchronizeEnabling(JComponent jComponent, JLabel[] jLabelArray) {
        JLabel[] jLabelArray2;
        JLabel[] jLabelArray3 = jComponent.getClientProperty(CP_LABEL);
        if (jLabelArray3 == null) {
            jComponent.putClientProperty(CP_LABEL, jLabelArray);
        } else if (jLabelArray3 instanceof JLabel) {
            jLabelArray2 = new JLabel[jLabelArray.length + 1];
            System.arraycopy(jLabelArray, 0, jLabelArray2, 1, jLabelArray.length);
            jLabelArray2[0] = (JLabel)jLabelArray3;
            jComponent.putClientProperty(CP_LABEL, jLabelArray2);
        } else {
            jLabelArray2 = jLabelArray3;
            jLabelArray3 = new JLabel[jLabelArray.length + jLabelArray.length];
            System.arraycopy(jLabelArray2, 0, jLabelArray3, 0, jLabelArray.length);
            System.arraycopy(jLabelArray, 0, jLabelArray3, jLabelArray2.length, jLabelArray.length);
            jComponent.putClientProperty(CP_LABEL, jLabelArray3);
        }
        for (int i2 = 0; i2 < jLabelArray.length; ++i2) {
            jLabelArray[i2].setEnabled(jComponent.isEnabled());
        }
        jComponent.addPropertyChangeListener(c);
    }

    public static final void synchronizeEnabling(JComponent jComponent, JLabel jLabel) {
        JLabel[] jLabelArray = jComponent.getClientProperty(CP_LABEL);
        if (jLabelArray == null) {
            jComponent.putClientProperty(CP_LABEL, jLabel);
        } else if (jLabelArray instanceof JLabel) {
            jLabelArray = new JLabel[]{(JLabel)jLabelArray, jLabel};
            jComponent.putClientProperty(CP_LABEL, jLabelArray);
        } else {
            jLabelArray = jLabelArray;
            JLabel[] jLabelArray2 = new JLabel[jLabelArray.length + 1];
            System.arraycopy(jLabelArray, 0, jLabelArray2, 0, jLabelArray.length);
            jLabelArray2[jLabelArray.length] = jLabel;
            jComponent.putClientProperty(CP_LABEL, jLabelArray2);
        }
        jLabel.setEnabled(jComponent.isEnabled());
        jComponent.addPropertyChangeListener(c);
    }

    public static final void expandToLevel(JTree jTree, int n2) {
        while (--n2 > 0) {
            for (int i2 = jTree.getRowCount() - 1; i2 >= 0; --i2) {
                jTree.expandRow(i2);
            }
        }
    }

    public static void expandTrivialNodes(JTree jTree) {
        Object object = jTree.getModel();
        if ((object = (DefaultMutableTreeNode)object.getRoot()) != null) {
            for (int i2 = 0; i2 < ((DefaultMutableTreeNode)object).getChildCount(); ++i2) {
                Serializable serializable = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(i2);
                serializable = GUIUtilities.a(new TreePath(new Object[]{object, serializable}), serializable);
                jTree.expandPath((TreePath)serializable);
            }
        }
    }

    private static TreePath a(TreePath treePath, DefaultMutableTreeNode defaultMutableTreeNode) {
        while (defaultMutableTreeNode.getChildCount() == 1) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode);
            treePath = treePath2;
        }
        return treePath;
    }

    public static final void expandAll(JTree jTree) {
        for (int i2 = 0; i2 < jTree.getRowCount(); ++i2) {
            jTree.expandRow(i2);
        }
    }

    public static final Frame getFrame(Component component) {
        block5: {
            Window window;
            while (true) {
                if (component instanceof Frame) {
                    return (Frame)component;
                }
                window = SwingUtilities.getWindowAncestor(component);
                if (!(window instanceof Dialog)) break;
                window = (Dialog)window;
                if ((window = window.getOwner()) instanceof Frame) {
                    return (Frame)window;
                }
                if (window != component) {
                    component = window;
                    continue;
                }
                break block5;
                break;
            }
            if (window instanceof Frame) {
                return (Frame)window;
            }
        }
        return null;
    }

    public static final Object getTreeSelectionState(JTree treePathArray) {
        if ((treePathArray = treePathArray.getSelectionPaths()) == null || treePathArray.length == 0) {
            return null;
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i2 = 0; i2 < treePathArray.length; ++i2) {
            Object[] objectArray = treePathArray[i2].getPath();
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                objectArray[i3] = String.valueOf(objectArray[i3]);
            }
            vector.add(objectArray);
        }
        return vector;
    }

    public static final void setTreeSelectionState(JTree jTree, Object object) {
        DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)jTree.getSelectionModel();
        if (object != null && object instanceof Vector) {
            object = (Vector)object;
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                TreePath treePath = GUIUtilities.a(jTree, (Object[])((Vector)object).get(i2));
                if (treePath == null) continue;
                arrayList.add(treePath);
            }
            defaultTreeSelectionModel.addSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
        }
    }

    private static final TreePath a(JTree object, Object[] objectArray) {
        object = (TreeNode)((JTree)object).getModel().getRoot();
        TreePath treePath = new TreePath(object);
        for (int i2 = 1; i2 < objectArray.length; ++i2) {
            if ((object = GUIUtilities.getChild((TreeNode)object, (String)objectArray[i2])) == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(object);
        }
        return treePath;
    }

    public static final TreeNode getChild(TreeNode treeNode, String string) {
        for (int i2 = 0; i2 < treeNode.getChildCount(); ++i2) {
            TreeNode treeNode2 = treeNode.getChildAt(i2);
            if (!string.equals(String.valueOf(treeNode2))) continue;
            return treeNode2;
        }
        return null;
    }

    public static final Object getTreeState(JTree jTree) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(GUIUtilities.getTreeSelectionState(jTree));
        for (int i2 = 0; i2 < jTree.getRowCount(); ++i2) {
            if (!jTree.isExpanded(i2)) continue;
            Object[] objectArray = jTree.getPathForRow(i2).getPath();
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                objectArray[i3] = String.valueOf(objectArray[i3]);
            }
            vector.add(objectArray);
        }
        return vector;
    }

    public static final void setTreeState(JTree jTree, Object object) {
        if (((Vector)(object = (Vector)object)).size() > 0) {
            Object e2 = ((Vector)object).remove(0);
            for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                Object[] objectArray = (Object[])((Vector)object).get(i2);
                TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
                TreePath treePath = new TreePath(treeNode);
                for (int i3 = 1; i3 < objectArray.length && (treeNode = GUIUtilities.getChild(treeNode, (String)objectArray[i3])) != null; ++i3) {
                    if (jTree.isExpanded(treePath = treePath.pathByAddingChild(treeNode))) continue;
                    jTree.expandPath(treePath);
                }
            }
            GUIUtilities.setTreeSelectionState(jTree, e2);
        }
    }

    public static final Dimension getStringDimensions(Font font, int n2) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, 'W');
        return GUIUtilities.getStringDimensions(font, new String(cArray));
    }

    public static final Dimension getStringDimensions(Font object, String string) {
        object = ((Font)object).getStringBounds(string, b);
        return new Dimension((int)((RectangularShape)object).getWidth(), (int)((RectangularShape)object).getHeight());
    }

    public static final boolean isPointOnLine(Point point, Point point2, Point point3) {
        return GUIUtilities.isPointOnLine(point, point2, point3, 1);
    }

    public static final boolean isPointOnLine(Point point, Point point2, Point point3, int n2) {
        return GUIUtilities.isPointOnLine(point.x, point.y, point2.x, point2.y, point3.x, point3.y, n2);
    }

    public static final boolean isPointOnLine(int n2, int n3, int n4, int n5, int n6, int n7) {
        return GUIUtilities.isPointOnLine(n2, n3, n4, n5, n6, n7, 1);
    }

    public static final boolean isPointOnLine(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = Math.min(n4, n6) - n8;
        int n10 = Math.max(n4, n6) + n8;
        int n11 = Math.min(n5, n7) - n8;
        int n12 = Math.max(n5, n7) + n8;
        if (n2 < n9 || n3 < n11 || n2 > n10 || n3 > n12) {
            return false;
        }
        double d2 = n6 - n4;
        double d3 = n7 - n5;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        d2 /= d4;
        d3 /= d4;
        double d5 = n4;
        double d6 = n5;
        double d7 = (double)n2 - d5;
        double d8 = (double)n3 - d6;
        double d9 = d7 * d7 + d8 * d8;
        double d10 = d7 * d2 + d8 * d3;
        return Math.sqrt(d9 - (d10 *= d10)) <= Math.max(1.0, (double)n8);
    }

    public static final boolean isPointOnPath(int n2, int n3, GeneralPath object, int n4) {
        object = ((Path2D.Float)object).getPathIterator(a);
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        if (object.isDone()) {
            return false;
        }
        object.currentSegment(dArray);
        while (!object.isDone()) {
            object.currentSegment(dArray2);
            if (GUIUtilities.isPointOnLine(n2, n3, (int)dArray[0], (int)dArray[1], (int)dArray2[0], (int)dArray2[1], n4)) {
                return true;
            }
            object.next();
            System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
        }
        return false;
    }

    public static final boolean isPointOnPath(int n2, int n3, GeneralPath generalPath) {
        return GUIUtilities.isPointOnPath(n2, n3, generalPath, 1);
    }

    public static final int isPointOnPath(int n2, int n3, int[] nArray, int[] nArray2) {
        return GUIUtilities.isPointOnPath(n2, n3, nArray, nArray2, 1);
    }

    public static final int isPointOnPath(int n2, int n3, int[] nArray, int[] nArray2, int n4) {
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n5 = nArray[i2 - 1];
            int n6 = nArray2[i2 - 1];
            int n7 = nArray[i2];
            int n8 = nArray2[i2];
            if (!GUIUtilities.isPointOnLine(n2, n3, n5, n6, n7, n8, n4)) continue;
            return i2 - 1;
        }
        return -1;
    }

    public static final Border createTitledBorder(String string) {
        return BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public static void styleSplipPane(JSplitPane object) {
        ((JSplitPane)object).setOneTouchExpandable(false);
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ((JSplitPane)object).setDividerSize(10);
        ((JSplitPane)object).setResizeWeight(0.05);
        object = ((JSplitPane)object).getUI();
        if (object instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)object).getDivider().setBorder(null);
        }
    }
}

