/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing;

import com.inet.lib.core.LibBase;
import com.inet.lib.util.SwingFunctions;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class InetLookAndFeel {
    public static final int ILNF_MARGIN = 10;
    public static final int ILNF_GAP = 10;
    public static final int ILNF_GAPDEPENDENT = 20;
    public static final Color ILNF_GRADIENTCOLOR = new Color(155, 175, 220);
    public static final Color ILNF_DEFAULTBACKGROUND;
    public static final Color ILNF_BUTTON_DISABLED_COLOR;
    public static final Color ILNF_BUTTON_COLOR;
    public static final Color ILNF_BUTTON_ROLLOVER_COLOR;
    public static final Color ILNF_BUTTON_FOCUSED_COLOR;
    public static final Color ILNF_BUTTON_PRESSED_COLOR;

    public static void paintTitleGradient(Graphics object, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)object;
        InetLookAndFeel.paintGradient((Graphics)object, ILNF_GRADIENTCOLOR, n2, n3, n4, n5);
        graphics2D.setPaint(new GradientPaint((int)((double)n2 - 0.2 * (double)n4), n3, Color.WHITE, (int)((double)n2 + 1.1 * (double)n4), n3, new Color(255, 255, 255, 0)));
        graphics2D.fillRect(n2, n3, n4, n5);
        object = LibBase.getInstance().getIcon("title_image.png");
        graphics2D.drawImage(((ImageIcon)object).getImage(), n2 + n4 - ((ImageIcon)object).getIconWidth(), n3, null);
    }

    public static void paintGradient(Graphics graphics, Color color, int n2, int n3, int n4, int n5) {
        graphics = (Graphics2D)graphics;
        ((Graphics2D)graphics).setPaint(new GradientPaint(n2, (int)((double)n3 - 0.1 * (double)n5), Color.WHITE, n2, (int)((double)n3 + 1.2 * (double)n5), color));
        graphics.fillRect(n2, n3, n4, n5);
        ((Graphics2D)graphics).setPaint(new GradientPaint(n2, (int)((double)n3 + 0.65 * (double)n5), color, n2, (int)((double)n3 + 1.3 * (double)n5), Color.WHITE));
        graphics.fillRect(n2, (int)((double)n3 + 0.65 * (double)n5), n4, (int)((double)n5 - 0.65 * (double)n5));
    }

    public static void paintGradient(Graphics graphics, Color color, Color color2, int n2, int n3, int n4, int n5) {
        graphics = (Graphics2D)graphics;
        ((Graphics2D)graphics).setPaint(new GradientPaint(n2, (int)((double)n3 - 0.1 * (double)n5), color2, n2, (int)((double)n3 + 1.2 * (double)n5), color));
        graphics.fillRect(n2, n3, n4, n5);
        ((Graphics2D)graphics).setPaint(new GradientPaint(n2, (int)((double)n3 + 0.65 * (double)n5), color, n2, (int)((double)n3 + 1.3 * (double)n5), color2));
        graphics.fillRect(n2, (int)((double)n3 + 0.65 * (double)n5), n4, (int)((double)n5 - 0.65 * (double)n5));
    }

    public static Image getImage(String object) {
        if (object == null || ((String)object).length() == 0) {
            return null;
        }
        object = LibBase.getInstance().getResource("/com/inet/lib/images/" + (String)object);
        return Toolkit.getDefaultToolkit().getImage((URL)object);
    }

    public static JButton createRolloverButton(Action object) {
        object = new JButton((Action)object);
        ((AbstractButton)object).setRolloverEnabled(true);
        ((JComponent)object).setBorder(SwingFunctions.createRolloverBorder());
        ((AbstractButton)object).setFocusPainted(false);
        return object;
    }

    public static JButton createScrollButton(Action action) {
        JButton jButton = InetLookAndFeel.createRolloverButton(action);
        jButton.addMouseListener(new MouseAdapter(action){
            private boolean a = false;
            private Timer b = null;
            private /* synthetic */ Action c;
            {
                this.c = action;
            }

            public final void mousePressed(MouseEvent mouseEvent) {
                if (this.a) {
                    return;
                }
                this.a = true;
                this.b = new Timer(100, this.c);
                this.b.start();
            }

            public final void mouseReleased(MouseEvent mouseEvent) {
                if (this.b != null) {
                    this.b.stop();
                }
                this.a = false;
            }
        });
        return jButton;
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            Frame frame = new Frame();
            frame.addNotify();
            ILNF_DEFAULTBACKGROUND = frame.getBackground();
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(frame){
                    private /* synthetic */ Frame a;
                    {
                        this.a = frame;
                    }

                    public final void run() {
                        this.a.dispose();
                    }
                });
            } else {
                frame.dispose();
            }
        } else {
            ILNF_DEFAULTBACKGROUND = Color.LIGHT_GRAY;
        }
        ILNF_BUTTON_DISABLED_COLOR = new Color(185, 185, 185);
        ILNF_BUTTON_COLOR = new Color(155, 175, 220);
        ILNF_BUTTON_ROLLOVER_COLOR = new Color(247, 211, 146);
        ILNF_BUTTON_FOCUSED_COLOR = new Color(117, 140, 193);
        ILNF_BUTTON_PRESSED_COLOR = new Color(230, 183, 94);
    }
}

