/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.control;

import com.inet.lib.swing.control.Control;
import com.inet.lib.swing.control.Initializable;
import com.inet.lib.swing.control.Message;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

public abstract class ControlManager
implements PropertyChangeListener {
    public static final String PROPERTY_SELECTED = "SELECTED";
    public static final String PROPERTY_STATUS = "STATUS";
    public static final String PROPERTY_CLOSE = "CLOSE";
    public static final String PROPERTY_ADD = "ADD";
    public static final String PROPERTY_REMOVE = "REMOVE";
    public static final String PROPERTY_COMMIT = "COMMIT";
    public static final String PROPERTY_ROLLBACK = "ROLLBACK";
    public static final String PROPERTY_VERIFY = "VERIFY";
    public static final String PROPERTY_HELP = "HELP";
    public static final String PROPERTY_APPLY = "APPLY";
    public static final String PROPERTY_ENABLE = "ENABLE";
    public static final String VALUE_FIRE = "FIRE";
    public static final String VALUE_ENABLE = "ENABLE";
    public static final String VALUE_DISABLE = "DISABLE";
    private ArrayList<Control> a = new ArrayList();
    private int b = -1;
    private PropertyChangeSupport c = new PropertyChangeSupport(this);

    protected ControlManager() {
    }

    protected ControlManager(Control[] controlArray) {
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            this.addSilent(controlArray[i2]);
        }
        this.b = 0;
    }

    public final int getControlCount() {
        return this.a.size();
    }

    public final Control getControl(int n2) {
        Control control = this.a.get(n2);
        return control;
    }

    public final Control getControl(String string) {
        for (int i2 = 0; i2 < this.getControlCount(); ++i2) {
            Control control = this.getControl(i2);
            if (!control.getName().equals(string)) continue;
            if (control instanceof Initializable) {
                ((Initializable)((Object)control)).init();
            }
            return control;
        }
        return null;
    }

    public final int indexOf(Control control) {
        return this.a.indexOf(control);
    }

    public final boolean contains(Control control) {
        return this.indexOf(control) != -1;
    }

    public final Control getSelected() {
        if (this.b == -1) {
            return null;
        }
        return this.getControl(this.b);
    }

    public final void setSelected(Control control) {
        int n2 = this.a.indexOf(control);
        if (n2 != -1) {
            this.b = n2;
            control.select();
            this.firePropertyChange(PROPERTY_SELECTED, control);
        }
    }

    protected final void addSilent(Control control) {
        this.addSilent(this.a.size(), control);
    }

    protected final void addSilent(int n2, Control control) {
        this.a.add(n2, control);
        control.addPropertyChangeListener(this);
    }

    protected final Control removeSilent(Control control) {
        if (this.a.remove(control)) {
            control.removePropertyChangeListener(this);
            return control;
        }
        return null;
    }

    public final void add(Control control) {
        if (this.indexOf(control) != -1) {
            return;
        }
        this.addSilent(control);
        this.firePropertyChange(PROPERTY_ADD, control);
    }

    public final void add(int n2, Control control) {
        if (this.indexOf(control) != -1) {
            return;
        }
        this.addSilent(n2, control);
        this.firePropertyChange(PROPERTY_ADD, control, new Integer(n2));
    }

    public final Control remove(Control control) {
        if (this.indexOf(control) == -1) {
            return null;
        }
        try {
            Control control2 = this.removeSilent(control);
            return control2;
        }
        finally {
            this.firePropertyChange(PROPERTY_REMOVE, control);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.c.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.c.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeAllListenerReferences() {
        PropertyChangeListener[] propertyChangeListenerArray = this.c.getPropertyChangeListeners();
        Object object = propertyChangeListenerArray;
        object = propertyChangeListenerArray;
        int n2 = propertyChangeListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PropertyChangeListener propertyChangeListener = object[i2];
            this.c.removePropertyChangeListener(propertyChangeListener);
        }
        for (Control control : this.a) {
            control.removePropertyChangeListener(this);
        }
        this.a.clear();
    }

    private Object a(String string, Object object) {
        if ((string.equals(PROPERTY_SELECTED) || string.equals(PROPERTY_ADD) || string.equals(PROPERTY_REMOVE)) && object instanceof String) {
            string = (String)object;
            return this.getControl(string);
        }
        return object;
    }

    public final void firePropertyChange(String string, Object object) {
        if (string.equals(PROPERTY_STATUS) && object instanceof Message) {
            Message message = (Message)object;
            if (message.getType() == 1) {
                this.firePropertyChange(PROPERTY_COMMIT, VALUE_DISABLE);
            } else {
                this.firePropertyChange(PROPERTY_COMMIT, "ENABLE");
            }
        }
        this.c.firePropertyChange(string, null, this.a(string, object));
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.c.firePropertyChange(string, object2, this.a(string, object));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Object object2;
        if (propertyChangeEvent.getPropertyName().equals(PROPERTY_SELECTED)) {
            object2 = propertyChangeEvent.getNewValue();
            if (object2 instanceof String) {
                object = (String)object2;
                if ((object2 = this.getControl((String)object)) != null) {
                    this.setSelected((Control)object2);
                    return;
                }
                System.out.println("Control not found: " + (String)object);
            } else if (object2 instanceof Control) {
                if (this.indexOf((Control)object2) != -1) {
                    this.setSelected((Control)object2);
                    return;
                }
                System.out.println("Control index not found: " + object2);
            }
        }
        if (propertyChangeEvent.getPropertyName().equals(PROPERTY_COMMIT) && propertyChangeEvent.getNewValue().equals(VALUE_FIRE)) {
            if (this.commit()) {
                this.firePropertyChange(PROPERTY_CLOSE, VALUE_FIRE);
            }
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals(PROPERTY_ROLLBACK)) {
            if (propertyChangeEvent.getNewValue().equals(VALUE_FIRE) && this.rollback()) {
                this.firePropertyChange(PROPERTY_CLOSE, VALUE_FIRE);
            }
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals(PROPERTY_HELP)) {
            if (propertyChangeEvent.getNewValue().equals(VALUE_FIRE)) {
                object2 = this.help();
                this.firePropertyChange(PROPERTY_HELP, object2, propertyChangeEvent.getOldValue());
            }
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals(PROPERTY_APPLY) && propertyChangeEvent.getNewValue().equals(VALUE_FIRE)) {
            if (this.apply()) {
                this.firePropertyChange(PROPERTY_APPLY, VALUE_FIRE);
            }
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals(PROPERTY_VERIFY)) {
            object2 = (Control)propertyChangeEvent.getNewValue();
            object = object2 != null ? object2.verify(false) : this.verify(false);
            if (object != null && ((Message)object).getType() != -1) {
                this.firePropertyChange(PROPERTY_STATUS, object);
            } else {
                this.firePropertyChange(PROPERTY_STATUS, Message.NONE);
            }
        }
        if (propertyChangeEvent.getPropertyName().equals("ENABLE")) {
            object2 = propertyChangeEvent.getNewValue();
            boolean bl2 = (Boolean)propertyChangeEvent.getOldValue();
            if (object2 instanceof String) {
                object2 = (String)object2;
                if ((object2 = this.getControl((String)object2)) != null) {
                    object2.setControlEnabled(bl2);
                    return;
                }
            } else if (object2 instanceof Control && this.indexOf((Control)object2) != -1) {
                ((Control)object2).setControlEnabled(bl2);
                return;
            }
        }
        object2 = new PropertyChangeEvent(this, propertyChangeEvent.getPropertyName(), null, this.a(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue()));
        this.c.firePropertyChange((PropertyChangeEvent)object2);
    }

    public abstract boolean commit();

    public abstract boolean rollback();

    public abstract String help();

    public abstract Message verify(boolean var1);

    public abstract boolean apply();
}

