/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.control;

import com.inet.lib.swing.InetLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;

public class GlassButtonUI
extends BasicButtonUI {
    private static GlassButtonUI a = null;

    public GlassButtonUI(JComponent jComponent) {
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (a == null) {
            a = new GlassButtonUI(jComponent);
        }
        return a;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            Container container = abstractButton;
            container = abstractButton.getParent();
            if (container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar)) {
                jComponent.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                InetLookAndFeel.paintGradient(graphics, InetLookAndFeel.ILNF_BUTTON_COLOR, 0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent object) {
        AbstractButton abstractButton = (AbstractButton)object;
        ButtonModel buttonModel = abstractButton.getModel();
        Object object2 = new Rectangle();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Serializable serializable = ((JComponent)object).getInsets();
        ((Rectangle)object2).x = serializable.left;
        ((Rectangle)object2).y = serializable.top;
        ((Rectangle)object2).width = abstractButton.getWidth() - (serializable.right + ((Rectangle)object2).x);
        ((Rectangle)object2).height = abstractButton.getHeight() - (serializable.bottom + ((Rectangle)object2).y);
        rectangle.height = 0;
        rectangle.width = 0;
        rectangle.y = 0;
        rectangle.x = 0;
        rectangle2.height = 0;
        rectangle2.width = 0;
        rectangle2.y = 0;
        rectangle2.x = 0;
        serializable = ((Component)object).getFont();
        graphics.setFont((Font)serializable);
        object2 = SwingUtilities.layoutCompoundLabel((JComponent)object, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), (Rectangle)object2, rectangle2, rectangle, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        if (abstractButton.isEnabled()) {
            if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
                InetLookAndFeel.paintGradient(graphics, InetLookAndFeel.ILNF_BUTTON_FOCUSED_COLOR, 0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight());
            }
            if (buttonModel.isRollover()) {
                InetLookAndFeel.paintGradient(graphics, InetLookAndFeel.ILNF_BUTTON_ROLLOVER_COLOR, 0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight());
            }
            if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                InetLookAndFeel.paintGradient(graphics, InetLookAndFeel.ILNF_BUTTON_PRESSED_COLOR, 0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight());
            }
        } else {
            InetLookAndFeel.paintGradient(graphics, InetLookAndFeel.ILNF_BUTTON_DISABLED_COLOR, 0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight());
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, (JComponent)object, rectangle2);
        }
        if (object2 != null && !((String)object2).equals("")) {
            if ((object = (View)((JComponent)object).getClientProperty("html")) != null) {
                ((View)object).paint(graphics, rectangle);
                return;
            }
            this.paintText(graphics, abstractButton, rectangle, (String)object2);
        }
    }
}

